/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.ddloaders.multiview;

import org.netbeans.modules.j2ee.dd.api.ejb.CmrField;
import org.netbeans.modules.j2ee.dd.api.ejb.EjbRelation;
import org.netbeans.modules.j2ee.dd.api.ejb.EjbRelationshipRole;
import org.netbeans.modules.j2ee.dd.api.ejb.Relationships;

public class RelationshipHelper {
    private static final String MULTIPLICITY_MANY = "Many";
    private static final String MULTIPLICITY_ONE = "One";
    private final EjbRelation relation;
    public final RelationshipRoleHelper roleA;
    public final RelationshipRoleHelper roleB;

    public RelationshipHelper(EjbRelation ejbRelation) {
        this.relation = ejbRelation;
        this.roleA = new RelationshipRoleHelper(ejbRelation.getEjbRelationshipRole());
        this.roleB = new RelationshipRoleHelper(ejbRelation.getEjbRelationshipRole2());
    }

    public RelationshipHelper(Relationships relationships) {
        this.relation = relationships.newEjbRelation();
        EjbRelationshipRole ejbRelationshipRole = this.newRole();
        this.relation.setEjbRelationshipRole(ejbRelationshipRole);
        EjbRelationshipRole ejbRelationshipRole2 = this.newRole();
        this.relation.setEjbRelationshipRole2(ejbRelationshipRole2);
        relationships.addEjbRelation(this.relation);
        this.roleA = new RelationshipRoleHelper(ejbRelationshipRole);
        this.roleB = new RelationshipRoleHelper(ejbRelationshipRole2);
    }

    private EjbRelationshipRole newRole() {
        EjbRelationshipRole ejbRelationshipRole = this.relation.newEjbRelationshipRole();
        ejbRelationshipRole.setRelationshipRoleSource(ejbRelationshipRole.newRelationshipRoleSource());
        return ejbRelationshipRole;
    }

    public String getRelationName() {
        return this.relation.getEjbRelationName();
    }

    public void setRelationName(String string) {
        this.relation.setEjbRelationName(string);
    }

    public String getDescription() {
        return this.relation.getDefaultDescription();
    }

    public void setDescription(String string) {
        this.relation.setDescription(string);
    }

    public static class RelationshipRoleHelper {
        private final EjbRelationshipRole role;

        public RelationshipRoleHelper(EjbRelationshipRole ejbRelationshipRole) {
            this.role = ejbRelationshipRole;
        }

        public boolean isMultiple() {
            return RelationshipHelper.MULTIPLICITY_MANY.equals(this.role.getMultiplicity());
        }

        public void setMultiple(boolean bl) {
            this.role.setMultiplicity(bl ? RelationshipHelper.MULTIPLICITY_MANY : RelationshipHelper.MULTIPLICITY_ONE);
        }

        public String getEjbName() {
            return this.role.getRelationshipRoleSource().getEjbName();
        }

        public void setEjbName(String string) {
            this.role.getRelationshipRoleSource().setEjbName(string);
        }

        public String getRoleName() {
            return this.role.getEjbRelationshipRoleName();
        }

        public void setRoleName(String string) {
            this.role.setEjbRelationshipRoleName(string);
        }

        public String getFieldName() {
            CmrField cmrField = this.role.getCmrField();
            return cmrField == null ? null : cmrField.getCmrFieldName();
        }

        public String getFieldType() {
            CmrField cmrField = this.role.getCmrField();
            return cmrField == null ? null : cmrField.getCmrFieldType();
        }

        public boolean isCascadeDelete() {
            return this.role.isCascadeDelete();
        }

        public void setCascadeDelete(boolean bl) {
            this.role.setCascadeDelete(bl);
        }

        public CmrField getCmrField() {
            return this.role.getCmrField();
        }

        public void setCmrField(CmrField cmrField) {
            this.role.setCmrField(cmrField);
        }

        public void setCmrField(String string, String string2) {
            CmrField cmrField = this.role.getCmrField();
            if (cmrField == null) {
                cmrField = this.role.newCmrField();
                this.role.setCmrField(cmrField);
            }
            cmrField.setCmrFieldName(string);
            cmrField.setCmrFieldType(string2);
        }
    }
}

