/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.schema2beansdev;

import java.beans.Introspector;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.netbeans.modules.schema2beans.AttrProp;
import org.netbeans.modules.schema2beans.Common;
import org.netbeans.modules.schema2beans.ValidateException;
import org.netbeans.modules.schema2beansdev.BeanBuilder;
import org.netbeans.modules.schema2beansdev.DataEnumRestriction;
import org.netbeans.modules.schema2beansdev.DataListRestriction;
import org.netbeans.modules.schema2beansdev.DataTypeRestriction;
import org.netbeans.modules.schema2beansdev.GenBeans;
import org.netbeans.modules.schema2beansdev.GraphLink;
import org.netbeans.modules.schema2beansdev.GraphNode;
import org.netbeans.modules.schema2beansdev.PrefixGuesser;
import org.netbeans.modules.schema2beansdev.SchemaRep;
import org.netbeans.modules.schema2beansdev.TreeBuilder;
import org.netbeans.modules.schema2beansdev.XMLSchemaParser;
import org.netbeans.modules.schema2beansdev.gen.JavaUtil;
import org.netbeans.modules.schema2beansdev.gen.JavaWriter;
import org.netbeans.modules.schema2beansdev.metadd.MetaDD;
import org.netbeans.modules.schema2beansdev.metadd.MetaElement;
import org.netbeans.modules.schema2beansdev.metadd.MetaProperty;

public abstract class AbstractCodeGeneratorClass {
    protected GenBeans.Config config;
    protected String packageName;
    protected String className;
    protected String fullClassName;
    protected BeanBuilder.BeanElement beanElement;
    protected BeanBuilder.BeanElement rootBeanElement;
    private String defaultNamespace = null;
    protected MetaDD mdd;
    protected MetaElement metaElement;
    protected Map generatedNewMethods = new HashMap();
    protected ArrayList attrList;
    protected PrefixGuesser prefixGuesser;
    protected int HEADER_SECTION = 0;
    protected int DECL_SECTION = 1;
    protected int CONSTRUCTOR_SECTION = 2;
    protected int INITIALIZE_SECTION = 3;
    protected int ACCESS_SECTION = 4;
    protected int NEW_METHOD_SECTION = 5;
    protected int BODY_SECTION = 6;
    protected int EQUALS_SECTION = 7;
    protected int HASHCODE_SECTION = 8;
    protected int TRAILER_SECTION = 9;
    protected int MAXVALUE = 10;
    JavaWriter jw;
    private Map mutableTypes = new HashMap();
    private Map needToCallClone = new HashMap();
    protected static final int PUBLIC = 0;
    protected static final int PRIVATE = 1;
    protected static final int VOID = 2;
    protected static final int CLASS = 3;
    protected static final int IMPORT = 4;
    protected static final int PACKAGE = 5;
    protected static final int STRING = 6;
    protected static final int BOOLEAN = 7;
    protected static final int STATIC = 8;
    protected static final int FINAL = 9;
    protected static final int INT = 10;
    protected static final int PROTECTED = 11;
    protected static final String[] arrKeywords = new String[]{"public", "private", "void", "class", "import", "package", "String", "boolean", "static", "final", "int", "protected"};
    private transient String cachedRootClassName = null;
    public static final int MAX_DUMP_TREE_LINE_COUNT = 512;
    protected static final Signature.TypeOfMethod SETTER = Signature.TypeOfMethod.SETTER;
    protected static final Signature.TypeOfMethod SETTERINDEXED = Signature.TypeOfMethod.SETTERINDEXED;
    protected static final Signature.TypeOfMethod GETTER = Signature.TypeOfMethod.GETTER;
    protected static final Signature.TypeOfMethod GETTERLIST = Signature.TypeOfMethod.GETTERLIST;
    protected static final Signature.TypeOfMethod GETTERINDEXED = Signature.TypeOfMethod.GETTERINDEXED;
    protected static final Signature.TypeOfMethod SIZE = Signature.TypeOfMethod.SIZE;
    protected static final Signature.TypeOfMethod ADD = Signature.TypeOfMethod.ADD;
    protected static final Signature.TypeOfMethod REMOVE = Signature.TypeOfMethod.REMOVE;
    protected static final Signature.TypeOfMethod OTHER = Signature.TypeOfMethod.OTHER;

    protected void genInvalidName(String var) throws IOException {
        this.jw.writeEol("throw new IllegalArgumentException(", var, "+\" is not a valid property name for ", this.className + "\")");
    }

    protected boolean isMutableType(Property prop) {
        String type = prop.getType();
        Boolean mutable = (Boolean)this.mutableTypes.get(type);
        if (mutable == null) {
            mutable = prop.isBean ? Boolean.TRUE : (prop.isScalar() || JavaUtil.isImmutable(type) ? Boolean.FALSE : Boolean.TRUE);
            this.mutableTypes.put(type, mutable);
        }
        return mutable;
    }

    protected boolean isCloneCallNeededOnType(Property prop) {
        String type = prop.getType();
        Boolean callClone = (Boolean)this.needToCallClone.get(type);
        if (callClone == null) {
            callClone = prop.isBean || !this.isMutableType(prop) ? Boolean.FALSE : (JavaUtil.isCloneable(type) ? Boolean.TRUE : Boolean.FALSE);
            this.needToCallClone.put(type, callClone);
        }
        return callClone;
    }

    protected boolean genCopyWillCopy(Property a) {
        String type = a.getType();
        boolean mutable = this.isMutableType(a);
        boolean needToCallClone = this.isCloneCallNeededOnType(a);
        if ((mutable || needToCallClone) && !a.isBean && !JavaUtil.isInstantiable(type)) {
            mutable = false;
            needToCallClone = false;
        }
        if (type == "java.io.File") {
            return true;
        }
        if (needToCallClone) {
            return true;
        }
        return mutable;
    }

    protected void genCopy(String src, Property a, String justData) throws IOException {
        String type = a.getType().intern();
        String fullClassType = this.getTypeFullClassName(a);
        boolean mutable = this.isMutableType(a);
        boolean needToCallClone = this.isCloneCallNeededOnType(a);
        if ((mutable || needToCallClone) && !a.isBean && !JavaUtil.isInstantiable(type)) {
            mutable = false;
            needToCallClone = false;
        }
        if (type == "java.io.File") {
            this.jw.write("(", src, " == null) ? null : ");
            this.gen("new ");
            this.gen(fullClassType);
            this.PO();
            this.jw.write(src);
            this.jw.write(".getAbsolutePath()");
            this.PC();
        } else if (needToCallClone) {
            this.jw.write("(", src, " == null) ? null : ");
            this.PO();
            this.gen(fullClassType);
            this.PC();
            this.gen(src);
            this.gen(".clone()");
        } else if (mutable) {
            this.jw.write("(", src, " == null) ? null : ");
            String castSourceTo = null;
            if (a.isBean && this.hasDeepCopyConstructor()) {
                castSourceTo = a.getPropertyInterface();
                if (a.getPropertyInterface() != null && !type.equals(a.getPropertyInterface())) {
                    this.jw.write("(", type, ") ");
                }
                this.jw.write(this.genNewMethod(a.getPropertyInterface(), type));
            } else {
                this.gen("new ");
                this.gen(fullClassType);
            }
            this.PO();
            if (castSourceTo != null) {
                this.jw.write("(", castSourceTo, ") ");
            }
            this.jw.write(src);
            if (a.isBean) {
                if (this.config.isGenerateParentRefs()) {
                    this.jw.write(", this");
                }
                this.jw.write(", ", justData);
            }
            this.PC();
        } else {
            this.jw.write(src);
        }
    }

    protected boolean isTypeQName(String type) {
        if ((type = type.intern()) == "javax.xml.namespace.QName") {
            return true;
        }
        return type == "org.netbeans.modules.schema2beans.QName";
    }

    protected void init(BeanBuilder.BeanElement be, GenBeans.Config config) {
        this.config = config;
        this.beanElement = be;
        this.packageName = null;
        this.fullClassName = this.className = be.getClassType();
        this.attrList = new ArrayList();
        this.jw = new JavaWriter();
        this.HEADER_SECTION = this.jw.HEADER_SECTION;
        this.DECL_SECTION = this.jw.DECL_SECTION;
        this.CONSTRUCTOR_SECTION = this.jw.CONSTRUCTOR_SECTION;
        this.INITIALIZE_SECTION = this.jw.insertSectionAfter(this.jw.CONSTRUCTOR_SECTION);
        this.ACCESS_SECTION = this.jw.insertSectionAfter(this.INITIALIZE_SECTION);
        this.NEW_METHOD_SECTION = this.jw.insertSectionAfter(this.ACCESS_SECTION);
        this.BODY_SECTION = this.jw.BODY_SECTION;
        this.EQUALS_SECTION = this.jw.insertSectionAfter(this.BODY_SECTION);
        this.HASHCODE_SECTION = this.jw.insertSectionAfter(this.EQUALS_SECTION);
        this.resetGenBuffers();
    }

    protected void resetGenBuffers() {
        this.jw.reset();
        this.jw.select(this.HEADER_SECTION);
    }

    protected void printGenBuffers(OutputStream out) throws IOException {
        this.jw.writeTo(out);
    }

    public void setPackageName(String n) {
        if (n == null || "".equals(n)) {
            this.packageName = null;
            this.fullClassName = this.className;
        } else {
            this.packageName = n.replace('/', '.');
            this.fullClassName = this.packageName + "." + this.className;
        }
    }

    public void setDefaultNamespace(String ns) {
        this.defaultNamespace = ns;
    }

    public String getDefaultNamespace() {
        return this.defaultNamespace;
    }

    protected String getTypeFullClassName(Property a) {
        return a.getTypeFullClassName(this.packageName);
    }

    protected String getTypeFullClassName(Property a, String typeName) {
        return a.getTypeFullClassName(this.packageName, typeName);
    }

    public void setIndent(String indent) {
        this.jw.setIndent(indent);
    }

    public void setRootBeanElement(BeanBuilder.BeanElement element) {
        this.rootBeanElement = element;
    }

    protected String getRootClassName() {
        if (this.cachedRootClassName == null) {
            String rootClassName = this.rootBeanElement.getClassType();
            this.cachedRootClassName = this.packageName == null ? rootClassName : this.packageName + "." + rootClassName;
        }
        return this.cachedRootClassName;
    }

    protected void findAttributeOwners() {
        int size = this.attrList.size();
        for (int i = 0; i < size; ++i) {
            Property a = (Property)this.attrList.get(i);
            if (!a.isAttribute()) continue;
            Property attributeOwner = a;
            AttrProp attrProp = a.getAttrProp();
            block1: for (int propNum = 0; propNum < size; ++propNum) {
                Property prop = (Property)this.attrList.get(propNum);
                if (prop.attributes == null) continue;
                for (int attrNum = 0; attrNum < prop.attributes.length; ++attrNum) {
                    AttrProp propAttr = prop.attributes[attrNum];
                    if (propAttr != attrProp) continue;
                    attributeOwner = prop;
                    break block1;
                }
            }
            a.setAttributeOwner(attributeOwner);
            a.setIndexed(attributeOwner.isIndexed());
        }
    }

    protected Property findProperty(AttrProp attr) {
        int size = this.attrList.size();
        for (int j = 0; j < size; ++j) {
            Property p = (Property)this.attrList.get(j);
            if (p.getAttrProp() != attr) continue;
            return p;
        }
        return null;
    }

    protected void select(int o) {
        this.jw.select(o);
    }

    protected void gen(String s) {
        try {
            this.jw.write(s);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected void gen(StringBuffer s) {
        try {
            this.jw.write(s);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected void gen(String s1, String s2) {
        this.gen(s1);
        this.gen(s2);
    }

    protected void gen(String s1, String s2, String s3) {
        this.gen(s1);
        this.gen(s2);
        this.gen(s3);
    }

    protected void gen(int a) {
        this.gen(arrKeywords[a]);
    }

    protected void gen(int a, String s) {
        this.gen(a);
        this.sp();
        this.gen(s);
    }

    protected void gen(int a, String s, String s2) {
        this.gen(a, s);
        this.sp();
        this.gen(s2);
    }

    protected void gen(int a, int b, String s, String s2) {
        this.gen(a, b, s);
        this.gen(s2);
    }

    protected void gen(int a, int b, String s) {
        this.gen(a);
        this.sp();
        this.gen(b);
        this.sp();
        this.gen(s);
    }

    protected void gen(int a, int b, int c, String s) {
        this.gen(a);
        this.sp();
        this.gen(b);
        this.sp();
        this.gen(c);
        this.sp();
        this.gen(s);
    }

    protected void gen(int a, int b, int c, int d, String s) {
        this.gen(a);
        this.sp();
        this.gen(b);
        this.sp();
        this.gen(c);
        this.sp();
        this.gen(d);
        this.sp();
        this.gen(s);
    }

    protected void gencr(String s) {
        this.gen(s);
        this.cr();
    }

    protected void gencr(String s, String s2) {
        this.gen(s, s2);
        this.cr();
    }

    protected void gencr(int a, String s) {
        this.gen(a, s);
        this.cr();
    }

    protected void gencr(int a, String s, String s2) {
        this.gen(a, s, s2);
        this.cr();
    }

    protected void gencr(int a, int b, String s, String s2) {
        this.gen(a, b, s, s2);
        this.cr();
    }

    protected void gencr(int a, int b, String s) {
        this.gen(a, b, s);
        this.cr();
    }

    protected void gencr(int a, int b, int c, String s) {
        this.gen(a, b, c, s);
        this.cr();
    }

    protected void get(String s) {
        this.gen(" get");
        this.gen(s);
        this.PO();
        this.PC();
    }

    protected void geti(String s) {
        this.gen(" get");
        this.gen(s, "(int index)");
    }

    protected void getidx(String s, boolean b) {
        if (b) {
            this.geti(s);
        } else {
            this.get(s);
        }
    }

    protected void cr() {
        try {
            this.jw.cr();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected void geneol(String s) {
        this.gen(s);
        this.eol();
    }

    protected void PO() {
        this.gen("(");
    }

    protected void PC() {
        this.gen(")");
    }

    protected void begin() {
        try {
            this.jw.begin();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected void end() {
        this.end(true);
    }

    protected void end(boolean cr) {
        try {
            this.jw.end(cr);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected void comment() {
        this.gencr("//");
    }

    protected void gencrNoI18N(String s) {
        this.gen(s);
        this.noI18N();
    }

    protected void gencrNoI18N(String s, String s2) {
        this.gen(s);
        this.gen(s2);
        this.noI18N();
    }

    protected void beginNoI18N() {
        this.gencr("// BEGIN_NOI18N");
    }

    protected void endNoI18N() {
        this.gencr("// END_NOI18N");
    }

    protected void noI18N() {
        try {
            this.jw.noI18N();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected void comment(String s) {
        try {
            this.jw.comment(s);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected void comment(String s, String s2) {
        this.comment(s + s2);
    }

    protected void eol() {
        try {
            this.jw.eol();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected void eol(boolean cr) {
        this.gen(";");
        if (cr) {
            this.cr();
        }
    }

    protected void eolNoI18N() {
        try {
            this.jw.eolNoI18N();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected void sp() {
        this.gen(" ");
    }

    protected void genforprop() {
        this.gencr("for (int i=0; i<this.prop.length; i++)");
    }

    protected void gengetprop() {
        this.gencr("BeanProp p = this.beanProp();");
        this.gencr("if (p != null)");
    }

    protected void gengetpropbyname() {
        this.gencr("BeanProp p = this.beanProp(n);");
        this.gencr("if (p != null)");
    }

    protected void gensig1(String s) {
        this.gen("(", s, " l)");
        this.cr();
    }

    protected void gensig2(String s) {
        this.gen("(String n, ", s, " l)");
        this.cr();
    }

    protected void tabIn() {
        this.jw.indentOneLevel();
    }

    protected void gentab(int n) {
        for (int i = 0; i < n; ++i) {
            this.tabIn();
        }
    }

    protected void genSetValue(boolean isScalar, String classType) {
        this.gen(JavaUtil.toObject("value", classType, this.config.isForME()));
        this.gen(")");
    }

    protected void genSetValP(boolean b, String s1, String s2) {
        if (b) {
            this.gen(s1);
        } else {
            this.gen(s2);
        }
        this.gen(" value");
    }

    public Property addProperty(String name, String dtdName, String namespace, GraphNode node, GraphLink l, String classType, int nestedLevel, int eltInstance, int groupInstance, int type, boolean ored, AttrProp[] propAttributes, String constName, String defaultValue, boolean directChild, List extraData, boolean isUnion) {
        if (this.config.isTraceGen()) {
            this.config.messageOut.println("AbstractCodeGen.addProperty: name=" + name + " dtdName=" + dtdName + " classType=" + classType + " type=" + type + " eltInstance=" + eltInstance + " groupInstance=" + groupInstance + " isUnion=" + isUnion);
        }
        Property attr = new Property(name, dtdName, namespace, node, l, classType, eltInstance, groupInstance, nestedLevel, type, ored, propAttributes, constName, defaultValue, directChild, extraData, isUnion);
        this.attrList.add(attr);
        return attr;
    }

    public List getPropertyList() {
        return this.attrList;
    }

    public void generate(String filename, MetaDD mdd) throws IOException {
        this.mdd = mdd;
        if (this.className == null) {
            throw new NullPointerException();
        }
        this.metaElement = this.getMetaElement(this.beanElement);
        if (this.metaElement != null && this.metaElement.isSkipGeneration()) {
            this.config.messageOut.println("Skipping generation of class " + filename + " (as specified in the mdd file)");
            return;
        }
        this.config.messageOut.println("Generating class " + filename);
        FileOutputStream out = new FileOutputStream(filename);
        this.generate(out, mdd);
        ((OutputStream)out).close();
    }

    public abstract void generate(OutputStream var1, MetaDD var2) throws IOException;

    protected MetaElement getMetaElement(BeanBuilder.BeanElement be) {
        return this.getMetaElement(be.getDTDName(), be.getNamespace());
    }

    protected MetaElement getMetaElement(Property prop) {
        BeanBuilder.BeanElement be = prop.getBeanElement();
        if (be != null) {
            return this.getMetaElement(be);
        }
        return this.getMetaElement(prop.getDTDName(), prop.getNamespace());
    }

    protected MetaElement getMetaElement(String dtdName, String namespace) {
        if (this.mdd == null) {
            return null;
        }
        int size = this.mdd.sizeMetaElement();
        for (int i = 0; i < size; ++i) {
            MetaElement e = this.mdd.getMetaElement(i);
            if (e == null || namespace != null && !namespace.equals(e.getNamespace()) || !e.getDtdName().equals(dtdName)) continue;
            return e;
        }
        return null;
    }

    protected MetaProperty getMetaProperty(Property prop) {
        return this.getMetaProperty(prop.name);
    }

    protected MetaProperty getMetaProperty(String name) {
        MetaProperty ret = null;
        if (this.metaElement != null) {
            MetaProperty[] mp = this.metaElement.getMetaProperty();
            for (int i = 0; i < mp.length; ++i) {
                if (mp[i] == null || !mp[i].getBeanName().equals(name)) continue;
                ret = mp[i];
                break;
            }
        }
        return ret;
    }

    protected void printSchema() throws IOException {
        if (this.config.getFilename() == null) {
            return;
        }
        File f = this.config.getFilename();
        if (f.length() < 16384L) {
            FileInputStream fi = new FileInputStream(f);
            byte[] r = new byte[(int)f.length()];
            fi.read(r);
            this.cr();
            this.gencr("/*");
            this.gentab(2);
            this.gencr("The following schema file has been used for generation:");
            this.cr();
            this.gen(new String(r));
            fi.close();
            this.cr();
            this.gencr("*/");
        }
    }

    protected void printComment(String indent) throws IOException {
        String comment = (String)this.beanElement.node.getExtendedProperty("comment");
        if (comment == null) {
            return;
        }
        this.gen(indent);
        this.gencr("===============================================================");
        this.gen(indent);
        int length = comment.length();
        for (int i = 0; i < length; ++i) {
            char c = comment.charAt(i);
            if (c == '\n') {
                this.cr();
                this.gen(indent);
                continue;
            }
            if (c == '*' && i + 1 < length && comment.charAt(i + 1) == '/') {
                this.jw.write("* /");
                ++i;
                continue;
            }
            this.jw.write(c);
        }
        this.cr();
        this.gen(indent);
        this.gencr("===============================================================");
    }

    public void dumpBeanTree(Writer out, String indent, String indentBy) throws IOException {
        out.write(indent);
        out.write(Introspector.decapitalize(Common.convertName(this.beanElement.node.getName())));
        out.write(" <");
        out.write(this.beanElement.node.getName());
        out.write(">");
        out.write(" : ");
        out.write(this.className);
        if (!this.beanElement.node.getExtraData().isEmpty()) {
            out.write(" \t");
            out.write(this.beanElement.node.getExtraData().toString());
        }
        out.write("\n");
        StringBuffer str = new StringBuffer();
        int lineCount = 1;
        lineCount = this.dumpAttributes(this.beanElement.getGraphNode(), str, indent + indentBy, lineCount);
        lineCount = this.dumpBeanTree(this.beanElement, str, indent + indentBy, indentBy, lineCount);
        out.write(str.toString());
        if (lineCount >= 512) {
            out.write(indent);
            out.write("... etc ...\n");
        }
    }

    protected int dumpBeanTree(BeanBuilder.BeanElement be, StringBuffer str, String indent, String indentBy, int lineCount) {
        lineCount = this.beanTree(be.getGraphNode().getGraphLink(), str, indent, indentBy, lineCount);
        if (be.getExtension() != null) {
            lineCount = this.dumpBeanTree(be.getExtension(), str, indent, indentBy, lineCount);
        }
        return lineCount;
    }

    protected int dumpAttributes(GraphNode elt, StringBuffer str, String indent, int lineCount) {
        AttrProp[] attrList = elt.getAttributes();
        for (int i = 0; i < attrList.length; ++i) {
            AttrProp attr = attrList[i];
            str.append(indent + "[attr: " + attr + "]");
            if (!attr.getExtraData().isEmpty()) {
                str.append(" \t");
                str.append(attr.getExtraData().toString());
            }
            str.append("\n");
            ++lineCount;
        }
        return lineCount;
    }

    protected int beanTree(GraphLink l, StringBuffer str, String indent, String indentBy, int lineCount) {
        if (lineCount >= 512) {
            return lineCount;
        }
        while (l != null) {
            block15: {
                String groupInstance;
                block14: {
                    String nextIndent = indent + indentBy;
                    if (l.element == null) break block14;
                    BeanBuilder.BeanElement be = (BeanBuilder.BeanElement)l.element.getObject();
                    if (be == null) break block15;
                    Property prop = (Property)l.getObject();
                    String type = be.getClassType();
                    String name = l.name;
                    if ("#PCDATA".equals(l.name) && "String".equals(type)) break block15;
                    if (prop != null) {
                        type = prop.getType();
                        name = "EMPTY".equals(prop.dtdName) ? prop.dtdName : prop.beanIntrospectorName() + " <" + prop.dtdName + ">";
                    }
                    str.append(indent);
                    str.append(name);
                    str.append(" : ");
                    str.append(type);
                    str.append(TreeBuilder.instanceToString(l.getElementInstance(), true));
                    if (l.element.getMarked()) {
                        str.append("...");
                    }
                    if (!l.extraData.isEmpty()) {
                        str.append(" \t");
                        str.append(l.extraData.toString());
                    }
                    if (!be.node.getExtraData().isEmpty()) {
                        str.append(" \t");
                        str.append(be.node.getExtraData().toString());
                    }
                    str.append("\n");
                    ++lineCount;
                    if (this.config.isRespectExtension() && be.getExtension() != null) {
                        lineCount = this.dumpBeanTree(be.getExtension(), str, nextIndent, indentBy, lineCount);
                    }
                    lineCount = this.dumpAttributes(l.element, str, nextIndent, lineCount);
                    if (l.element.getGraphLink() != null && !l.element.getMarked()) {
                        l.element.setMarked(true);
                        lineCount = this.beanTree(l.element.getGraphLink(), str, nextIndent + TreeBuilder.instanceToString(l.getGroupInstance(), true) + (l.isSequenceOr() ? "| " : ""), indentBy, lineCount);
                        l.element.setMarked(false);
                    }
                }
                if (!"".equals(groupInstance = TreeBuilder.instanceToString(l.getGroupInstance(), true))) {
                    str.append(indent);
                    str.append("(\n");
                    ++lineCount;
                }
                if (l.getFirstChild() != null) {
                    lineCount = this.beanTree(l.getFirstChild(), str, indent + ("".equals(groupInstance) ? "" : "  ") + (l.isSequenceOr() ? "| " : ""), indentBy, lineCount);
                }
                if (!"".equals(groupInstance)) {
                    str.append(indent);
                    str.append(")");
                    str.append(groupInstance);
                    str.append("\n");
                    ++lineCount;
                }
            }
            l = l.getSibling();
        }
        return lineCount;
    }

    public String toString() {
        if (this.packageName == null) {
            return "Class " + this.className;
        }
        return "Class " + this.packageName + "." + this.className;
    }

    protected void gen(Signature sig) throws IOException {
        sig.writeMethod(this.jw);
    }

    protected Signatures getSignatures(Property a) {
        String firstInterface;
        MetaElement me;
        Signatures result = new Signatures();
        boolean indexed = a.isIndexed();
        boolean isScalar = a.isScalar();
        String type = this.getTypeFullClassName(a);
        String typeVariable = "value";
        if (a.isBean && this.config.isUseInterfaces() && (me = this.getMetaElement(a)) != null && (firstInterface = AbstractCodeGeneratorClass.firstInCommaSeparatedList(me.getImplements())) != null && !firstInterface.equals(this.config.getGenerateCommonInterface()) && !firstInterface.equals(this.packageName + "." + this.config.getGenerateCommonInterface())) {
            type = firstInterface;
            typeVariable = "valueInterface";
            a.setPropertyInterface(firstInterface);
        }
        String baseType = type;
        if (indexed) {
            type = baseType + "[]";
        }
        Signature sig = new Signature("void", "set" + a.name, SETTER);
        sig.addParameter(type, typeVariable);
        if (this.config.isVetoable()) {
            sig.addThrows("java.beans.PropertyVetoException");
        }
        result.add(sig);
        if (indexed) {
            sig = new Signature("void", "set" + a.name, SETTERINDEXED);
            sig.addParameter("int", "index");
            sig.addParameter(baseType, typeVariable);
            if (this.config.isVetoable()) {
                sig.addThrows("java.beans.PropertyVetoException");
            }
            result.add(sig);
        }
        String getterName = a.getReadMethod(false);
        result.add(new Signature(type, getterName, GETTER));
        if (indexed) {
            String returnType = "java.util.List";
            if (this.config.jdkTarget >= 150) {
                returnType = returnType + "<" + JavaUtil.toObjectType(baseType) + ">";
            }
            result.add(new Signature(returnType, "fetch" + a.name + "List", GETTERLIST));
            sig = new Signature(baseType, a.getReadMethod(true), GETTERINDEXED);
            sig.addParameter("int", "index");
            result.add(sig);
            result.add(new Signature("int", "size" + a.name, SIZE));
            sig = new Signature("int", "add" + a.name, ADD);
            sig.addParameter(baseType, typeVariable);
            if (this.config.isVetoable()) {
                sig.addThrows("java.beans.PropertyVetoException");
            }
            result.add(sig);
            sig = new Signature("int", "remove" + a.name, REMOVE);
            sig.addParameter(baseType, typeVariable);
            if (this.config.isVetoable()) {
                sig.addThrows("java.beans.PropertyVetoException");
            }
            result.add(sig);
        }
        return result;
    }

    public void generateDelegator(OutputStream out, MetaDD mdd, String delegatorClassName, String delegatorPackageName) throws IOException {
        Collection generatedMethods = this.jw.getStoredMethods();
        this.resetGenBuffers();
        this.select(this.HEADER_SECTION);
        this.jw.bigComment("Delegate for " + this.className + "\n\n@" + "Generated");
        this.jw.cr();
        if (delegatorPackageName != null) {
            this.jw.writePackage(delegatorPackageName);
            this.cr();
        }
        this.gen(0, 3, delegatorClassName);
        if (this.metaElement.getDelegatorExtends() != null) {
            this.jw.write(" extends ");
            this.jw.write(this.metaElement.getDelegatorExtends());
        }
        if (this.config.getGenerateCommonInterface() != null) {
            this.jw.write(" implements ");
            this.jw.write(this.config.getGenerateCommonInterface());
        }
        this.sp();
        this.begin();
        this.select(this.DECL_SECTION);
        String delegator = "_" + this.className;
        this.gen(11, this.fullClassName, delegator);
        this.eol();
        this.cr();
        this.generateDelegatorConstructors(delegatorClassName);
        LinkedList sortedMethods = new LinkedList(generatedMethods);
        Collections.sort(sortedMethods);
        for (JavaWriter.Method method : sortedMethods) {
            if (!method.isPublic()) continue;
            this.generateDelegator(method, delegatorClassName);
        }
        this.select(this.TRAILER_SECTION);
        this.end();
        this.printGenBuffers(out);
    }

    protected void generateDelegatorConstructors(String delegatorClassName) throws IOException {
        this.select(this.CONSTRUCTOR_SECTION);
        String delegator = "_" + this.className;
        this.gen(0, delegatorClassName);
        this.PO();
        this.gen(this.fullClassName);
        this.gen(" delegator");
        this.PC();
        this.sp();
        this.begin();
        this.geneol(delegator + " = delegator");
        this.end();
        this.cr();
    }

    protected void generateDelegator(JavaWriter.Method method, String delegatorClassName) throws IOException {
        if ("".equals(method.getReturnType())) {
            if (method.getParameters().indexOf(44) < 0 && (method.getParameters().startsWith(this.className + " ") || method.getParameters().startsWith(this.fullClassName + " "))) {
                return;
            }
            this.select(this.CONSTRUCTOR_SECTION);
            String delegator = "_" + this.className;
            this.jw.write("public ");
            this.jw.write(delegatorClassName);
            this.jw.write("(");
            this.jw.write(method.getParameters());
            this.jw.write(") ");
            if (method.getExceptions() != null) {
                this.jw.write("throws ", method.getExceptions(), " ");
            }
            this.jw.begin();
            this.jw.write(delegator, " = new ", this.fullClassName);
            this.jw.write("(");
            method.writeParametersNoTypes(this.jw);
            this.jw.writeEol(")");
            this.jw.end();
            this.jw.cr();
            return;
        }
        this.select(this.BODY_SECTION);
        boolean returnsDelegation = false;
        if (this.className.equals(method.getReturnType()) || this.fullClassName.equals(method.getReturnType())) {
            returnsDelegation = true;
        }
        this.jw.beginMethod(method.getName(), method.getParameters(), method.getExceptions(), returnsDelegation ? delegatorClassName : method.getReturnType(), method.getOptions());
        if (!"void".equals(method.getReturnType())) {
            this.gen("return ");
        }
        if (returnsDelegation) {
            this.jw.write("new ", delegatorClassName, "(");
        }
        if (!method.isStatic()) {
            this.jw.write("_", this.className);
        } else {
            this.jw.write(this.fullClassName);
        }
        this.jw.write(".");
        method.writeCall(this.jw);
        if (returnsDelegation) {
            this.jw.write(")");
        }
        this.jw.eol();
        this.jw.end();
        this.jw.cr();
    }

    protected void genWhiteSpaceRestriction(SchemaRep.WhiteSpace ws, String var, String type) throws IOException {
        if (!"String".equals(type) && !"java.lang.String".equals(type)) {
            return;
        }
        if (ws.isPreserve()) {
            return;
        }
        if (ws.isReplace()) {
            this.jw.beginIf(var + " != null");
            this.jw.comment("Whitespace Replace due to whitespace restriction.");
            this.jw.writeEol(var + " = " + var + ".replace('\\n', ' ').replace('\\t', ' ')");
            this.jw.end();
        } else if (ws.isCollapse()) {
            this.jw.beginIf(var + " != null");
            this.jw.comment("Whitespace Collapse due to whitespace restriction.");
            this.jw.writeEol(var + " = " + var + ".replace('\\n', ' ').replace('\\t', ' ').trim()");
            this.jw.beginFor("int pos = " + var + ".indexOf(\"  \")", "pos >= 0", "pos = " + var + ".indexOf(\"  \", pos)");
            this.jw.writeEol(var + " = " + var + ".substring(0, pos) + " + var + ".substring(pos+1, " + var + ".length())");
            this.jw.end();
            this.jw.end();
        }
    }

    protected void genRethrowExceptions(List exceps) {
        Iterator it = exceps.iterator();
        while (it.hasNext()) {
            this.gen("catch (");
            this.gen((String)it.next());
            this.gen(" e) ");
            this.begin();
            this.geneol("throw new java.lang.RuntimeException(e)");
            this.end();
        }
    }

    protected void genValidateProperties() throws IOException {
        this.jw.writeEol("boolean restrictionFailure = false");
        this.jw.writeEol("boolean restrictionPassed = false");
        HashSet<String> requiredPropertySet = new HashSet<String>();
        HashMap<String, Property> requiredProperty = new HashMap<String, Property>();
        int size = this.attrList.size();
        for (int i = 0; i < size; ++i) {
            Object extraData;
            Property a = (Property)this.attrList.get(i);
            boolean indexed = a.isIndexed();
            String attr = a.getReadMethod(false) + "()";
            String type = a.getType().intern();
            boolean mightBeNull = a.canBeNull();
            boolean isPrimitiveType = JavaUtil.isPrimitiveType(type);
            String propertyName = a.beanIntrospectorName();
            boolean hasDataEnumRestriction = false;
            String enumArray = "enumRestriction" + a.name;
            boolean checkOrCount = a.ored;
            if (checkOrCount && (a.getGroupInstance() == 48 || a.getGroupInstance() == 16)) {
                checkOrCount = false;
            }
            this.jw.comment("Validating property " + propertyName);
            if (a.isUnion()) {
                this.jw.writeEol("restrictionPassed = false");
            }
            if (!a.ored) {
                switch (a.elementInstance & 0xF0) {
                    case 32: {
                        if (isPrimitiveType || a.isNillable()) break;
                        this.genValidateIf(attr + " == null", propertyName, ValidateException.FailureType.NULL_VALUE, this.jw);
                        break;
                    }
                    case 16: {
                        break;
                    }
                    case 48: {
                        break;
                    }
                    case 64: {
                        this.genValidateIf("size" + a.name + "() == 0", propertyName, ValidateException.FailureType.NULL_VALUE, this.jw);
                    }
                }
            }
            if (indexed && a.isAttribute()) continue;
            int markedPosition = -1;
            if (indexed) {
                Iterator it = a.extraDataIterator();
                while (it.hasNext()) {
                    Object extraData2 = it.next();
                    if (!(extraData2 instanceof DataListRestriction)) continue;
                    DataListRestriction dlr = (DataListRestriction)extraData2;
                    dlr.genRestriction(this.jw, "size" + a.name + "()", a.getReadMethod(false), type, "restrictionFailure", false);
                    this.jw.beginIf("restrictionFailure");
                    this.genValidateFail(JavaUtil.instanceFrom("java.lang.String", attr + " " + dlr.toString()), propertyName, false, ValidateException.FailureType.DATA_RESTRICTION, this.jw);
                    this.jw.end();
                }
                markedPosition = this.jw.getCurrentPosition();
                this.jw.beginFor("int _index = 0", "_index < size" + a.name + "()", "++_index");
                this.jw.write(this.getTypeFullClassName(a));
                this.jw.write(" element = ");
                if (a.getPropertyInterface() != null) {
                    this.jw.write("(", this.getTypeFullClassName(a), ") ");
                }
                this.jw.writeEol(a.getReadMethod(true) + "(_index)");
                attr = "element";
            }
            if (mightBeNull) {
                if (markedPosition == -1) {
                    markedPosition = this.jw.getCurrentPosition();
                }
                this.jw.beginIf(attr + " != null");
            }
            int marked2Position = this.jw.getCurrentPosition();
            if (a.isBean) {
                if (a.getPropertyInterface() == null) {
                    if (!a.getGraphNode().isCreated()) {
                        this.jw.beginTry();
                        this.jw.comment("Catch and deal with any foreign validate exceptions.");
                    }
                    this.jw.writeEol(attr, ".validate()");
                    if (!a.getGraphNode().isCreated()) {
                        this.jw.endCatch("java.lang.Exception e");
                        this.jw.writeEol("throw new java.lang.RuntimeException(e)");
                        this.jw.end();
                    }
                } else {
                    this.jw.writeEol("((" + type + ")", attr, ").validate()");
                }
            }
            this.genForRestrictions(a, attr);
            Iterator it = a.extraDataIterator();
            while (it.hasNext()) {
                extraData = it.next();
                if (!(extraData instanceof DataTypeRestriction)) continue;
                DataTypeRestriction dtr = (DataTypeRestriction)extraData;
                dtr.genRestriction(this.jw, attr, type, "restrictionFailure", false);
                this.jw.beginIf("restrictionFailure");
                this.genValidateFail(JavaUtil.instanceFrom("java.lang.String", attr + " " + dtr.toString()), propertyName, false, ValidateException.FailureType.DATA_RESTRICTION, this.jw);
                this.jw.end();
            }
            it = a.extraDataIterator();
            while (it.hasNext()) {
                extraData = it.next();
                if (!(extraData instanceof DataEnumRestriction)) continue;
                DataEnumRestriction der = (DataEnumRestriction)extraData;
                if (!hasDataEnumRestriction) {
                    hasDataEnumRestriction = true;
                    this.jw.write("final " + type + "[] " + enumArray + " = {");
                } else {
                    this.jw.write(", ");
                }
                der.genRestriction(this.jw, type);
            }
            if (hasDataEnumRestriction) {
                this.jw.writeEol("}");
                this.jw.writeEol("restrictionFailure = true");
                this.jw.beginFor("int _index2 = 0", "_index2 < " + enumArray + ".length", "++_index2");
                this.jw.beginIf(JavaUtil.genEquals(type, enumArray + "[_index2]", attr, false));
                this.jw.writeEol("restrictionFailure = false");
                this.jw.writeEol("break");
                this.jw.end();
                this.jw.end();
                this.jw.beginIf("restrictionFailure");
                this.genValidateFail(JavaUtil.instanceFrom("java.lang.String", attr + " enumeration test"), propertyName, false, ValidateException.FailureType.ENUM_RESTRICTION, this.jw);
                this.jw.end();
            }
            if (marked2Position != this.jw.getCurrentPosition()) {
                if (mightBeNull) {
                    this.jw.end();
                }
                if (indexed) {
                    this.jw.end();
                }
            } else {
                if (markedPosition >= 0) {
                    this.jw.truncateAtPosition(markedPosition);
                }
                if (mightBeNull) {
                    this.jw.indentLeft();
                }
                if (indexed) {
                    this.jw.indentLeft();
                }
            }
            if (!checkOrCount) continue;
            GraphLink gl = a.getGraphLink();
            GraphLink parentgl = null;
            if (gl != null) {
                parentgl = gl.getParent();
            }
            ArrayList<String> requiredPropertyTest = new ArrayList<String>();
            this.jw.beginIf(this.testIfPropertySet(a));
            requiredPropertyTest.add(this.testIfPropertyNotSet(a));
            for (Property prop : a.getMutuallyExclusiveProperties()) {
                this.jw.beginIf(this.testIfPropertySet(prop));
                requiredPropertyTest.add(this.testIfPropertyNotSet(prop));
                this.genValidateFail("mutually exclusive properties: " + a.name + " and " + prop.name, prop.name, true, ValidateException.FailureType.MUTUALLY_EXCLUSIVE, this.jw);
                this.jw.end();
            }
            this.jw.end();
            Collections.sort(requiredPropertyTest);
            StringBuffer requiredExpr = new StringBuffer();
            boolean first = true;
            Iterator it2 = requiredPropertyTest.iterator();
            while (it2.hasNext()) {
                if (first) {
                    first = false;
                } else {
                    requiredExpr.append(" && ");
                }
                requiredExpr.append((String)it2.next());
            }
            String requiredExprString = requiredExpr.toString();
            requiredPropertySet.add(requiredExprString);
            requiredProperty.put(requiredExprString, a);
        }
        for (String required : requiredPropertySet) {
            Property prop = (Property)requiredProperty.get(required);
            this.jw.beginIf(required);
            this.genValidateFail("required properties: " + required, prop.name, true, ValidateException.FailureType.NULL_VALUE, this.jw);
            this.jw.end();
        }
    }

    protected void genForRestrictions(Property a, String attr) throws IOException {
        boolean isUnion = a.isUnion();
        String propertyName = a.beanIntrospectorName();
        String enumArray = "enumRestriction" + a.name;
        String type = a.getType().intern();
        SchemaRep.Restriction restrict = null;
        Iterator it = a.extraDataIterator();
        while (it.hasNext()) {
            DataTypeRestriction dtr;
            Object rType;
            boolean hasDataEnumRestriction = false;
            Object extraData = it.next();
            if (!(extraData instanceof SchemaRep.Restriction)) continue;
            restrict = (SchemaRep.Restriction)extraData;
            if (isUnion) {
                String tempType = restrict.getJavaTypeName();
                if (tempType != null) {
                    type = tempType.intern();
                }
                this.jw.write("{\n");
            }
            boolean firstPattern = true;
            Iterator itr = restrict.subElementsIterator();
            while (itr.hasNext()) {
                rType = itr.next();
                if (!(rType instanceof SchemaRep.Pattern)) continue;
                if (firstPattern) {
                    this.jw.write("{\n");
                    this.jw.writeEol("boolean patternPassed = false");
                    firstPattern = false;
                }
                dtr = (DataTypeRestriction)rType;
                dtr.genRestriction(this.jw, attr, type, "patternPassed", true);
            }
            if (!firstPattern) {
                this.jw.writeEol("restrictionFailure = !patternPassed");
                this.jw.write("}\n");
                if (!isUnion) {
                    this.jw.beginIf("restrictionFailure");
                    this.genValidateFail(JavaUtil.instanceFrom("java.lang.String", attr), propertyName, false, ValidateException.FailureType.DATA_RESTRICTION, this.jw);
                    this.jw.end();
                }
            }
            itr = restrict.subElementsIterator();
            while (itr.hasNext()) {
                rType = itr.next();
                if (rType instanceof DataListRestriction) {
                    DataListRestriction dlr = (DataListRestriction)rType;
                    dlr.genRestriction(this.jw, "size" + a.name + "()", a.getReadMethod(false), type, "restrictionFailure", false);
                    if (!isUnion) {
                        this.jw.beginIf("restrictionFailure");
                        this.genValidateFail(JavaUtil.instanceFrom("java.lang.String", attr + " " + dlr.toString()), propertyName, false, ValidateException.FailureType.DATA_RESTRICTION, this.jw);
                        this.jw.end();
                    }
                }
                if (!(rType instanceof DataTypeRestriction) || rType instanceof SchemaRep.Pattern) continue;
                dtr = (DataTypeRestriction)rType;
                String typeAttr = attr;
                if (isUnion) {
                    this.jw.beginTry();
                    typeAttr = "(" + JavaUtil.genParseText(type, attr) + ")";
                }
                dtr.genRestriction(this.jw, typeAttr, type, "restrictionFailure", false);
                if (isUnion) {
                    this.jw.endCatch("Exception e");
                    this.jw.writeEol("restrictionFailure = true");
                    this.jw.end();
                }
                if (isUnion) continue;
                this.jw.beginIf("restrictionFailure");
                this.genValidateFail(JavaUtil.instanceFrom("java.lang.String", attr + " " + dtr.toString()), propertyName, false, ValidateException.FailureType.DATA_RESTRICTION, this.jw);
                this.jw.end();
            }
            itr = restrict.subElementsIterator();
            while (itr.hasNext()) {
                rType = itr.next();
                if (!(rType instanceof DataEnumRestriction)) continue;
                DataEnumRestriction der = (DataEnumRestriction)rType;
                if (!hasDataEnumRestriction) {
                    hasDataEnumRestriction = true;
                    this.jw.write("final " + type + "[] " + enumArray + " = {");
                } else {
                    this.jw.write(", ");
                }
                der.genRestriction(this.jw, type);
            }
            if (hasDataEnumRestriction) {
                this.jw.writeEol("}");
                this.jw.writeEol("restrictionFailure = true");
                this.jw.beginFor("int _index2 = 0", "_index2 < " + enumArray + ".length", "++_index2");
                this.jw.beginIf(JavaUtil.genEquals(type, enumArray + "[_index2]", attr, false));
                this.jw.writeEol("restrictionFailure = false");
                this.jw.writeEol("break");
                this.jw.end();
                this.jw.end();
                if (!isUnion) {
                    this.jw.beginIf("restrictionFailure");
                    this.genValidateFail(JavaUtil.instanceFrom("java.lang.String", attr + " enumeration test"), propertyName, false, ValidateException.FailureType.ENUM_RESTRICTION, this.jw);
                    this.jw.end();
                }
            }
            if (!isUnion) continue;
            this.jw.beginIf("!restrictionPassed");
            this.jw.writeEol("restrictionPassed = !restrictionFailure");
            this.jw.end();
            this.jw.writeEol("restrictionFailure = false");
            this.jw.write("}\n");
        }
        if (isUnion) {
            this.jw.beginIf("!restrictionPassed");
            this.genValidateFail(JavaUtil.instanceFrom("java.lang.String", attr), propertyName, false, ValidateException.FailureType.ALL_RESTRICTIONS, this.jw);
            this.jw.end();
        }
    }

    protected void genValidateIf(String test, String name, ValidateException.FailureType ft, JavaWriter out) throws IOException {
        this.jw.beginIf(test);
        this.genValidateFail(test, name, true, ft, out);
        this.jw.end();
    }

    protected abstract void genValidateFail(String var1, String var2, boolean var3, ValidateException.FailureType var4, JavaWriter var5) throws IOException;

    public Collection getGeneratedMethods() {
        return this.jw.getStoredMethods();
    }

    protected void genDefaultsAccessable(Property a) throws IOException {
        boolean mustHaveOneInstance;
        String type = a.getType();
        boolean bl = mustHaveOneInstance = !a.ored && a.elementInstance == 32;
        if (this.config.isDefaultsAccessable() && !a.isIndexed() && (a.isScalar() || a.getDefaultValue() != null || mustHaveOneInstance)) {
            this.jw.beginMethod("fetchDefault" + a.name, "", null, type, 0);
            List exceps = JavaUtil.exceptionsFromParsingText(type, false);
            if (!exceps.isEmpty()) {
                this.jw.beginTry();
            }
            this.jw.write("return ");
            if (a.getDefaultValue() != null) {
                this.jw.write(JavaUtil.instanceFrom(type, a.getDefaultValue()));
            } else if (this.config.isMakeDefaults()) {
                this.jw.write(JavaUtil.genNewDefault(type));
            } else {
                this.jw.write(JavaUtil.nullValueForType(type));
            }
            this.jw.eol();
            if (!exceps.isEmpty()) {
                this.end();
                this.genRethrowExceptions(exceps);
            }
            this.jw.end();
            this.jw.cr();
        }
    }

    protected void generateSwitches() throws IOException {
        this.select(this.jw.BODY_SECTION);
        this.jw.bigComment("@return true if error, then should display help");
        this.jw.beginMethod("parseArguments", "String[] args", null, "boolean");
        this.jw.beginFor("int argNum = 0, size = args.length", "argNum < size", "++argNum");
        this.jw.writeEol("String arg = args[argNum].toLowerCase().intern()");
        int size = this.attrList.size();
        LinkedHashMap<String, Property> mandatoryProperties = new LinkedHashMap<String, Property>();
        StringBuffer helpParams = new StringBuffer();
        int lastHelpParamsPos = 0;
        StringBuffer helpText = new StringBuffer();
        for (int i = 0; i < size; ++i) {
            Property a = (Property)this.attrList.get(i);
            XMLSchemaParser.SwitchData sd = (XMLSchemaParser.SwitchData)a.searchExtraData(XMLSchemaParser.SwitchData.class);
            if (sd == null) continue;
            if (sd.isMandatory()) {
                mandatoryProperties.put(sd.getName(), a);
            }
            String sw = sd.getName();
            sw = sw.toLowerCase();
            String type = a.getType().intern();
            boolean indexed = a.isIndexed();
            String writeMethod = indexed ? a.getAddMethod() : a.getWriteMethod();
            this.jw.beginIf("arg == " + JavaUtil.instanceFrom("String", "-" + sw));
            boolean isBoolean = type == "boolean" || type == "Boolean" || type == "java.lang.Boolean";
            helpParams.append(" ");
            if (!sd.isMandatory()) {
                helpParams.append("[");
            }
            helpParams.append("-");
            if (isBoolean) {
                this.jw.writeEol(writeMethod + "(true)");
                helpParams.append(sd.getName());
            } else {
                this.jw.beginIf("argNum+1 >= size");
                this.jw.writeEol("missingArgument(args, arg)");
                this.jw.writeEol("continue");
                this.jw.end();
                this.jw.writeEol(writeMethod + "(" + JavaUtil.genParseText(type, "args[++argNum]", this.config.isForME()) + ")");
                helpParams.append(sd.getName());
                helpParams.append(" ");
                if (type == "java.io.File") {
                    helpParams.append("filename");
                } else {
                    helpParams.append(a.dtdName);
                }
            }
            if (!sd.isMandatory()) {
                helpParams.append("]");
            }
            this.jw.writeEol("continue");
            this.jw.end();
            helpText.append(" -");
            helpText.append(sd.getName());
            helpText.append("\t");
            if (sd.getHelp() != null) {
                helpText.append(sd.getHelp());
            } else {
                helpText.append(a.name);
            }
            helpText.append('\n');
            if (isBoolean) {
                this.jw.beginIf("arg == " + JavaUtil.instanceFrom("String", "-no" + sw));
                this.jw.writeEol(writeMethod + "(false)");
                this.jw.writeEol("continue");
                this.jw.end();
                helpParams.append(" [-no");
                helpParams.append(sd.getName());
                helpParams.append("]");
            }
            if (helpParams.length() - lastHelpParamsPos <= 63) continue;
            helpParams.append("\n");
            lastHelpParamsPos = helpParams.length();
        }
        this.jw.beginIf("arg == \"-help\" || arg == \"--help\"");
        this.jw.writeEol("return true");
        this.jw.end();
        this.jw.writeEol("argNum = unknownArgument(args, arg, argNum)");
        this.jw.end();
        for (String sw : mandatoryProperties.keySet()) {
            Property a = (Property)mandatoryProperties.get(sw);
            this.jw.beginIf(this.testIfPropertyNotSet(a));
            this.jw.writeEol("missingMandatoryArgument(", JavaUtil.instanceFrom("java.lang.String", "-" + sw), ")");
            this.jw.end();
        }
        this.jw.writeEol("return false");
        this.jw.end();
        this.jw.cr();
        this.jw.beginMethod("unknownArgument", "String[] args, String arg, int argNum", null, "int", 1);
        this.jw.writeEol("throw new IllegalArgumentException(\"Found unknown argument '\"+arg+\"'\")");
        this.jw.end();
        this.jw.cr();
        this.jw.beginMethod("missingArgument", "String[] args, String arg", null, "void", 1);
        this.jw.writeEol("throw new IllegalArgumentException(\"Not enough arguments.  Need 1 more for '\"+arg+\"'\")");
        this.jw.end();
        this.jw.cr();
        this.jw.beginMethod("missingMandatoryArgument", "String arg", null, "void", 1);
        this.jw.writeEol("throw new IllegalArgumentException(\"Missing argument '\"+arg+\"'\")");
        this.jw.end();
        this.jw.cr();
        this.jw.beginMethod("showHelp", "java.io.PrintStream out");
        if (helpParams.length() > 0) {
            if (lastHelpParamsPos < helpParams.length()) {
                helpParams.append("\n");
            }
            this.jw.writeEol("out.println(", JavaUtil.instanceFrom("java.lang.String", helpParams.toString()), ")");
        }
        if (helpText.length() > 0) {
            this.jw.writeEol("out.print(", JavaUtil.instanceFrom("java.lang.String", helpText.toString()), ")");
        }
        this.jw.end();
        this.jw.cr();
    }

    protected boolean isMutuallyExclusive(Property a) {
        return a.ored && !a.getMutuallyExclusiveProperties().isEmpty();
    }

    protected void genResetMutuallyExclusive(Property a, boolean genTest) throws IOException {
        if (this.isMutuallyExclusive(a)) {
            if (genTest) {
                if (a.isIndexed()) {
                    this.jw.beginIf("value != null && value.length > 0");
                } else {
                    this.jw.beginIf("value != " + JavaUtil.nullValueForType(a.getType()));
                }
            }
            this.jw.comment("It's a mutually exclusive property.");
            for (Property prop : a.getMutuallyExclusiveProperties()) {
                this.jw.writeEol(prop.getWriteMethod(), "(", prop.isIndexed() ? "null" : JavaUtil.nullValueForType(prop.getType()), ")");
            }
            if (genTest) {
                this.jw.end();
            }
        }
    }

    protected String commonBeanType() {
        String cb = "java.lang.Object";
        if (this.config.getGenerateCommonInterface() != null) {
            cb = this.packageName == null ? this.config.getGenerateCommonInterface() : this.packageName + "." + this.config.getGenerateCommonInterface();
        }
        return cb;
    }

    protected String parentBeanType() {
        if (this.config.isExtendBaseBean()) {
            return "org.netbeans.modules.schema2beans.BaseBean";
        }
        return this.commonBeanType();
    }

    protected static String firstInCommaSeparatedList(String lst) {
        if (lst == null) {
            return null;
        }
        int pos = lst.indexOf(44);
        if (pos < 0) {
            return lst;
        }
        return lst.substring(0, pos);
    }

    protected String genNewMethod(String abstractType, String concreteType) throws IOException {
        return this.genNewMethod(abstractType, concreteType, concreteType);
    }

    protected String genNewMethod(String abstractType, String concreteType, String concreteFullTypeName) throws IOException {
        String methodName;
        if (abstractType == null) {
            abstractType = concreteType;
        }
        abstractType = abstractType.trim();
        concreteType = concreteType.trim();
        String returnType = abstractType;
        boolean abstractConcreteSame = abstractType.equals(concreteType);
        if (abstractConcreteSame) {
            returnType = concreteFullTypeName;
        }
        if ((methodName = (String)this.generatedNewMethods.get(abstractType)) == null) {
            String base;
            methodName = abstractType.indexOf(46) >= 0 ? (this.generatedNewMethods.containsKey(base = JavaUtil.baseName(abstractType)) ? "new" + abstractType.replace('.', '_') : "new" + base) : "new" + abstractType;
            this.jw.pushSelect(this.NEW_METHOD_SECTION);
            this.jw.bigComment("Create a new bean using it's default constructor.\nThis does not add it to any bean graph.");
            this.jw.beginMethod(methodName, "", null, returnType, 0 | 0x100);
            this.jw.writeEol("return new ", concreteFullTypeName, "()");
            this.jw.endMethod();
            if (this.hasDeepCopyConstructor()) {
                this.jw.bigComment("Create a new bean, copying from another one.\nThis does not add it to any bean graph.");
                String formalParam = abstractType + " source";
                String actualParam = abstractConcreteSame ? "source" : "(" + concreteType + ") source";
                if (this.config.isGenerateParentRefs()) {
                    formalParam = formalParam + ", " + this.parentBeanType() + " parent";
                    actualParam = actualParam + ", parent";
                }
                formalParam = formalParam + ", boolean justData";
                actualParam = actualParam + ", justData";
                this.jw.beginMethod(methodName, formalParam, null, returnType, 0 | 0x100);
                this.jw.write("return new ", concreteFullTypeName);
                this.jw.writeEol("(", actualParam, ")");
                this.jw.endMethod();
            }
            this.jw.popSelect();
            this.generatedNewMethods.put(abstractType, methodName);
        }
        return methodName;
    }

    protected void genNewDefault(Property prop, boolean wantConcreteType) throws IOException {
        String type = prop.getType();
        if (prop.isBean) {
            String abstractType = prop.getPropertyInterface();
            String methodName = this.genNewMethod(abstractType, type, this.getTypeFullClassName(prop));
            if (wantConcreteType && abstractType != null && !type.equals(abstractType)) {
                this.jw.write("(", type, ") ");
            }
            this.jw.write(methodName, "()");
        } else {
            this.jw.write(JavaUtil.genNewDefault(type));
        }
    }

    protected boolean hasDeepCopyConstructor() {
        return false;
    }

    protected String testIfPropertySet(Property prop) {
        if (prop.isIndexed()) {
            return "size" + prop.name + "() > 0";
        }
        return prop.getReadMethod(false) + "() != " + JavaUtil.nullValueForType(prop.getType());
    }

    protected String testIfPropertyNotSet(Property prop) {
        if (prop.isIndexed()) {
            return "size" + prop.name + "() == 0";
        }
        return prop.getReadMethod(false) + "() == " + JavaUtil.nullValueForType(prop.getType());
    }

    protected int countNumberOfNonAttributeProperties() {
        int count = this.beanElement.getNonAttributePropertyCount();
        if (this.config.isRespectExtension()) {
            count += this.countNumberOfNonAttributePropertiesRecurse(this.beanElement.getExtension());
        }
        return count;
    }

    protected int countNumberOfNonAttributePropertiesRecurse(BeanBuilder.BeanElement be) {
        int count = 0;
        while (be != null) {
            count += be.getNonAttributePropertyCount();
            be = be.getExtension();
        }
        return count;
    }

    public void setPrefixGuesser(PrefixGuesser guesser) {
        if (guesser == null) {
            if (this.prefixGuesser == null) {
                this.prefixGuesser = new PrefixGuesser(){

                    @Override
                    public String guessPrefixFromURI(String uri) {
                        return SchemaRep.guessPrefix(uri);
                    }
                };
            }
        } else {
            this.prefixGuesser = guesser;
        }
    }

    protected static class Signatures {
        Map signatureTable = new HashMap();
        List others = new LinkedList();

        public void add(Signature sig) {
            if (sig.getMethodType() == OTHER) {
                this.others.add(sig);
            } else {
                this.signatureTable.put(sig.getMethodType(), sig);
            }
        }

        public Signature findSignature(Signature.TypeOfMethod methodType) {
            Signature sig = null;
            if (methodType == OTHER) {
                Iterator it = this.others.iterator();
                if (it.hasNext()) {
                    sig = (Signature)it.next();
                }
            } else {
                sig = (Signature)this.signatureTable.get(methodType);
            }
            if (sig == null) {
                throw new IllegalStateException("Unable to find " + methodType);
            }
            return sig;
        }

        public Iterator iterator() {
            return new SignaturesIterator();
        }

        public class SignaturesIterator
        implements Iterator {
            Iterator tableIterator;
            Iterator othersIterator;

            public SignaturesIterator() {
                this.tableIterator = Signatures.this.signatureTable.values().iterator();
                this.othersIterator = Signatures.this.others.iterator();
            }

            @Override
            public boolean hasNext() {
                if (this.tableIterator.hasNext()) {
                    return true;
                }
                return this.othersIterator.hasNext();
            }

            public Object next() {
                if (this.tableIterator.hasNext()) {
                    return this.tableIterator.next();
                }
                return this.othersIterator.next();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        }
    }

    protected static class Signature {
        private String returnType;
        private String methodName;
        private TypeOfMethod methodType;
        private List parameterTypes;
        private List parameterNames;
        private List throwTypes;
        private boolean _isStatic;

        public Signature(String returnType, String methodName, TypeOfMethod methodType) {
            this.returnType = returnType;
            this.methodName = methodName;
            this.methodType = methodType;
            this.parameterTypes = new LinkedList();
            this.parameterNames = new LinkedList();
            this.throwTypes = new LinkedList();
            this._isStatic = false;
        }

        public Signature(String returnType, String methodName) {
            this.returnType = returnType;
            this.methodName = methodName;
            this.methodType = OTHER;
            this.parameterTypes = new LinkedList();
            this.parameterNames = new LinkedList();
            this.throwTypes = new LinkedList();
            this._isStatic = false;
        }

        public String getMethodName() {
            return this.methodName;
        }

        public String getReturnType() {
            return this.returnType;
        }

        public TypeOfMethod getMethodType() {
            return this.methodType;
        }

        public boolean isStatic() {
            return this._isStatic;
        }

        public void setStatic() {
            this._isStatic = true;
        }

        public boolean isVoidReturnType() {
            return "void".equals(this.returnType);
        }

        public void addParameter(String type, String name) {
            this.parameterTypes.add(type);
            this.parameterNames.add(name);
        }

        public void addThrows(String type) {
            this.throwTypes.add(type);
        }

        public void writeMethod(JavaWriter jw) throws IOException {
            StringBuffer parameters = new StringBuffer();
            Iterator itTypes = this.parameterTypes.iterator();
            Iterator itNames = this.parameterNames.iterator();
            boolean first = true;
            while (itTypes.hasNext() && itNames.hasNext()) {
                if (first) {
                    first = false;
                } else {
                    parameters.append(", ");
                }
                parameters.append((String)itTypes.next());
                parameters.append(" ");
                parameters.append((String)itNames.next());
            }
            String exceptions = null;
            Iterator itThrows = this.throwTypes.iterator();
            if (itThrows.hasNext()) {
                exceptions = "";
                first = true;
                do {
                    if (first) {
                        first = false;
                    } else {
                        exceptions = exceptions + ", ";
                    }
                    exceptions = exceptions + (String)itThrows.next();
                } while (itThrows.hasNext());
            }
            int options = 0 | 0x100;
            if (this._isStatic) {
                options |= 0x10;
            }
            jw.writeMethod(this.methodName, parameters.toString(), exceptions, this.returnType, options);
        }

        public String toString() {
            StringBuffer str = new StringBuffer();
            if (this._isStatic) {
                str.append("static ");
            }
            str.append(this.returnType);
            str.append(" ");
            str.append(this.methodName);
            str.append("(");
            Iterator itTypes = this.parameterTypes.iterator();
            Iterator itNames = this.parameterNames.iterator();
            boolean first = true;
            while (itTypes.hasNext() && itNames.hasNext()) {
                if (first) {
                    first = false;
                } else {
                    str.append(", ");
                }
                str.append((String)itTypes.next());
                str.append(" ");
                str.append((String)itNames.next());
            }
            str.append(")");
            Iterator itThrows = this.throwTypes.iterator();
            if (itThrows.hasNext()) {
                str.append(" throws ");
                first = true;
                do {
                    if (first) {
                        first = false;
                    } else {
                        str.append(", ");
                    }
                    str.append((String)itThrows.next());
                } while (itThrows.hasNext());
            }
            return str.toString();
        }

        public String callMethod() {
            StringBuffer str = new StringBuffer();
            str.append(this.methodName);
            str.append("(");
            Iterator itTypes = this.parameterTypes.iterator();
            Iterator itNames = this.parameterNames.iterator();
            boolean first = true;
            while (itTypes.hasNext() && itNames.hasNext()) {
                if (first) {
                    first = false;
                } else {
                    str.append(", ");
                }
                str.append((String)itNames.next());
            }
            str.append(")");
            return str.toString();
        }

        public static class TypeOfMethod {
            private final String name;
            public static final TypeOfMethod SETTER = new TypeOfMethod("setter");
            public static final TypeOfMethod SETTERINDEXED = new TypeOfMethod("setterindexed");
            public static final TypeOfMethod GETTER = new TypeOfMethod("getter");
            public static final TypeOfMethod GETTERLIST = new TypeOfMethod("getterlist");
            public static final TypeOfMethod GETTERINDEXED = new TypeOfMethod("getterindexed");
            public static final TypeOfMethod SIZE = new TypeOfMethod("size");
            public static final TypeOfMethod ADD = new TypeOfMethod("add");
            public static final TypeOfMethod REMOVE = new TypeOfMethod("remove");
            public static final TypeOfMethod OTHER = new TypeOfMethod("other");

            private TypeOfMethod(String name) {
                this.name = name;
            }

            public String toString() {
                return "TypeOfMethod " + this.name;
            }
        }
    }

    class NamePropertyVisitor
    extends PropertyVisitor {
        protected String nameVar;

        public NamePropertyVisitor(String nameVar) {
            this.nameVar = nameVar;
        }

        @Override
        public void preGenerate() throws IOException {
            AbstractCodeGeneratorClass.this.jw.writeEol(this.nameVar + " = " + this.nameVar + ".intern()");
        }

        @Override
        public void preGenerateProp() throws IOException {
            if (this.curProp.name.equals(this.curProp.dtdName)) {
                AbstractCodeGeneratorClass.this.jw.beginIf(this.nameVar + " == " + this.curProp.constName);
            } else {
                AbstractCodeGeneratorClass.this.jw.beginIf(this.nameVar + " == " + this.curProp.constName + " || " + this.nameVar + " == \"" + this.curProp.dtdName + "\"");
            }
        }

        @Override
        public void postGenerateProp() throws IOException {
            AbstractCodeGeneratorClass.this.jw.endElse();
        }

        @Override
        public void postGenerate() throws IOException {
            AbstractCodeGeneratorClass.this.genInvalidName(this.nameVar);
        }
    }

    class PropertyVisitor {
        protected Property curProp;
        protected int propNum;
        protected int propCount;

        public void generate() throws IOException {
            this.propCount = AbstractCodeGeneratorClass.this.attrList.size();
            this.preGenerate();
            this.propNum = 0;
            while (this.propNum < this.propCount) {
                this.curProp = (Property)AbstractCodeGeneratorClass.this.attrList.get(this.propNum);
                if (!this.skip()) {
                    this.preGenerateProp();
                    this.generateProp();
                    this.postGenerateProp();
                }
                ++this.propNum;
            }
            this.postGenerate();
        }

        public void preGenerate() throws IOException {
        }

        public boolean skip() {
            return false;
        }

        public void preGenerateProp() throws IOException {
        }

        public void generateProp() throws IOException {
        }

        public void postGenerateProp() throws IOException {
        }

        public void postGenerate() throws IOException {
        }
    }

    static class Property {
        String dtdName;
        private String namespace;
        String name;
        String classType;
        int type;
        int elementInstance;
        int groupInstance;
        int level;
        boolean isBean;
        boolean ored;
        boolean isUnion = false;
        String constName;
        private boolean nillable;
        private boolean _isAttribute;
        private AttrProp attrProp;
        private Property attributeOwner = null;
        private String defaultValue;
        private boolean directChild;
        private GraphNode graphNode;
        private GraphLink graphLink;
        private List extraData;
        private boolean canBeEmpty = false;
        private String propertyInterface = null;
        private transient List mutuallyExclusiveProperties;
        private BeanBuilder.BeanElement beanElement;
        AttrProp[] attributes;

        Property(String propName, String dtdName, String namespace, GraphNode graphNode, GraphLink graphLink, String classType, int eInst, int gInst, int level, int type, boolean ored, AttrProp[] attrs, String constName, String defaultValue, boolean directChild, List extraData, boolean isUnion) {
            if (gInst == 48) {
                eInst = gInst;
            } else if (gInst == 64) {
                eInst = eInst == 16 ? 48 : 64;
            }
            this.name = propName;
            this.isUnion = isUnion;
            this.dtdName = dtdName;
            this.namespace = namespace;
            this.graphNode = graphNode;
            this.graphLink = graphLink;
            this.classType = classType;
            this.type = type;
            this.elementInstance = eInst;
            this.groupInstance = gInst;
            this.level = level;
            this.attributes = attrs;
            this.ored = ored;
            this.constName = constName;
            this.isBean = Common.isBean(type);
            if (this.isScalar()) {
                this.classType = Common.wrapperClass(type);
            }
            this.defaultValue = defaultValue;
            this.directChild = directChild;
            this.extraData = extraData;
        }

        public boolean isIndexed() {
            if (this.elementInstance == 64) {
                return true;
            }
            return this.elementInstance == 48;
        }

        public void setIndexed(boolean value) {
            if (this.isIndexed() == value) {
                return;
            }
            this.elementInstance = value ? 48 : 16;
        }

        public boolean isNillable() {
            return this.nillable;
        }

        public void setNillable(boolean value) {
            this.nillable = value;
        }

        public boolean isUnion() {
            return this.isUnion;
        }

        public void setUnion(boolean value) {
            this.isUnion = value;
        }

        public boolean isScalar() {
            return Common.isScalar(this.type);
        }

        public String getScalarType() {
            if (!this.isScalar()) {
                return null;
            }
            return Common.scalarType(this.type);
        }

        public String getType() {
            if (this.isScalar()) {
                return this.getScalarType();
            }
            return this.classType;
        }

        public void setAttribute(boolean value) {
            this._isAttribute = value;
        }

        public boolean isAttribute() {
            return this._isAttribute;
        }

        public void setAttrProp(AttrProp ap) {
            this.attrProp = ap;
            this.setAttribute(ap != null);
        }

        public AttrProp getAttrProp() {
            return this.attrProp;
        }

        public void setAttributeOwner(Property owner) {
            this.attributeOwner = owner;
        }

        public Property getAttributeOwner() {
            return this.attributeOwner;
        }

        public String getDefaultValue() {
            return this.defaultValue;
        }

        public boolean isDirectChild() {
            return this.directChild;
        }

        public int getGroupInstance() {
            return this.groupInstance;
        }

        public void setCanBeEmpty(boolean value) {
            this.canBeEmpty = value;
        }

        public boolean getCanBeEmpty() {
            return this.canBeEmpty;
        }

        public GraphNode getGraphNode() {
            return this.graphNode;
        }

        public GraphLink getGraphLink() {
            return this.graphLink;
        }

        public void setPropertyInterface(String iface) {
            this.propertyInterface = iface;
        }

        public String getPropertyInterface() {
            return this.propertyInterface;
        }

        public String getSignatureType(String packageName) {
            if (this.getPropertyInterface() == null) {
                return this.getTypeFullClassName(packageName);
            }
            return this.getPropertyInterface();
        }

        public String getTypeFullClassName(String packageName) {
            return this.getTypeFullClassName(packageName, this.getType());
        }

        public String getTypeFullClassName(String packageName, String typeName) {
            if (this.isBean && this.getGraphNode().isCreated() && packageName != null) {
                return packageName + "." + typeName;
            }
            return typeName;
        }

        public String getDTDName() {
            return this.dtdName;
        }

        public String getNamespace() {
            return this.namespace;
        }

        public BeanBuilder.BeanElement getBeanElement() {
            return this.beanElement;
        }

        public void setBeanElement(BeanBuilder.BeanElement be) {
            this.beanElement = be;
        }

        public String instanceOf() {
            String result = Introspector.decapitalize(this.name);
            while (JavaUtil.reservedWord(result)) {
                result = "a_" + result;
            }
            return result;
        }

        public String beanIntrospectorName() {
            return Introspector.decapitalize(this.name);
        }

        public String getEventName() {
            return this.name;
        }

        public String getReadMethod(boolean withIndexParameter) {
            if (!withIndexParameter && this.isIndexed()) {
                return "get" + this.name;
            }
            if (this.isScalar() && Common.isBoolean(this.type)) {
                return "is" + this.name;
            }
            return "get" + this.name;
        }

        public String getWriteMethod() {
            return "set" + this.name;
        }

        public String getAddMethod() {
            return "add" + this.name;
        }

        public String getRemoveMethod() {
            return "remove" + this.name;
        }

        public String getSizeMethod() {
            return "size" + this.name;
        }

        public String getScalarIsSet() {
            return "_isSet_" + this.name;
        }

        public List getMutuallyExclusiveProperties() {
            if (this.mutuallyExclusiveProperties == null && this.graphLink != null) {
                ArrayList mutuallyExclusiveGraphLinks = new ArrayList();
                this.graphLink.getMutuallyExclusiveLinks(mutuallyExclusiveGraphLinks);
                this.mutuallyExclusiveProperties = new ArrayList(mutuallyExclusiveGraphLinks.size());
                for (GraphLink l : mutuallyExclusiveGraphLinks) {
                    if (l.getObject() == null) continue;
                    this.mutuallyExclusiveProperties.add(l.getObject());
                }
            }
            return this.mutuallyExclusiveProperties;
        }

        public boolean canBeNull() {
            boolean canBeNull = false;
            boolean isPrimitiveType = JavaUtil.isPrimitiveType(this.getType());
            if (this.ored) {
                canBeNull = !isPrimitiveType;
            } else {
                switch (this.elementInstance & 0xF0) {
                    case 16: 
                    case 48: 
                    case 64: {
                        canBeNull = !isPrimitiveType;
                    }
                }
            }
            return canBeNull;
        }

        public Object searchExtraData(Class type) {
            for (Object o : this.extraData) {
                if (!type.isAssignableFrom(o.getClass())) continue;
                return o;
            }
            return null;
        }

        public Iterator extraDataIterator() {
            return this.extraData.iterator();
        }
    }
}

