/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.nativeexecution.api.execution;

import java.io.IOException;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import javax.swing.SwingUtilities;
import org.netbeans.api.extexecution.ExecutionDescriptor;
import org.netbeans.api.extexecution.ExecutionService;
import org.netbeans.modules.nativeexecution.api.NativeProcess;
import org.netbeans.modules.nativeexecution.api.NativeProcessBuilder;
import org.netbeans.modules.nativeexecution.api.execution.NativeExecutionDescriptor;
import org.netbeans.modules.nativeexecution.api.pty.PtySupport;
import org.netbeans.modules.nativeexecution.api.util.ProcessUtils;
import org.netbeans.modules.nativeexecution.support.Logger;
import org.netbeans.modules.nativeexecution.support.NativeTaskExecutorService;
import org.netbeans.modules.terminal.api.IOEmulation;
import org.netbeans.modules.terminal.api.IOTerm;
import org.openide.windows.InputOutput;

public final class NativeExecutionService {
    private final NativeProcessBuilder processBuilder;
    private final String displayName;
    private final NativeExecutionDescriptor descriptor;
    private static final Charset execCharset;

    private NativeExecutionService(NativeProcessBuilder processBuilder, String displayName, NativeExecutionDescriptor descriptor) {
        this.processBuilder = processBuilder;
        this.displayName = displayName;
        this.descriptor = descriptor;
    }

    public static NativeExecutionService newService(NativeProcessBuilder processBuilder, NativeExecutionDescriptor descriptor, String displayName) {
        return new NativeExecutionService(processBuilder, displayName, descriptor);
    }

    public Future<Integer> run() {
        if (IOTerm.isSupported((InputOutput)this.descriptor.inputOutput)) {
            return this.runTerm();
        }
        return this.runRegular();
    }

    private Future<Integer> runTerm() {
        this.processBuilder.setUsePty(true);
        if (IOEmulation.isSupported((InputOutput)this.descriptor.inputOutput)) {
            this.processBuilder.getEnvironment().put("TERM", IOEmulation.getEmulation((InputOutput)this.descriptor.inputOutput));
        } else {
            this.processBuilder.getEnvironment().put("TERM", "dumb");
        }
        final AtomicReference processRef = new AtomicReference();
        Callable<Integer> callable = new Callable<Integer>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Loose catch block
             */
            @Override
            public Integer call() throws Exception {
                NativeProcess process;
                Serializable serializable;
                block16: {
                    serializable = processRef;
                    synchronized (serializable) {
                        process = NativeExecutionService.this.processBuilder.call();
                        processRef.set(process);
                    }
                    if (((NativeExecutionService)NativeExecutionService.this).descriptor.frontWindow) {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                ((NativeExecutionService)NativeExecutionService.this).descriptor.inputOutput.select();
                            }
                        });
                    }
                    if (process.getState() != NativeProcess.State.ERROR) break block16;
                    ((NativeExecutionService)NativeExecutionService.this).descriptor.inputOutput.getErr().println(ProcessUtils.readProcessErrorLine(process));
                    serializable = Integer.valueOf(1);
                    try {
                        while (((NativeProcess)processRef.get()).getInputStream().available() != 0) {
                        }
                        ((NativeProcess)processRef.get()).getInputStream().close();
                    }
                    catch (IOException ex) {
                        // empty catch block
                    }
                    IOTerm.disconnect((InputOutput)((NativeExecutionService)NativeExecutionService.this).descriptor.inputOutput, (Runnable)new Runnable(){

                        @Override
                        public void run() {
                            if (((NativeExecutionService)NativeExecutionService.this).descriptor.postExecution != null) {
                                NativeTaskExecutorService.submit(new Runnable(){

                                    @Override
                                    public void run() {
                                        ((NativeExecutionService)NativeExecutionService.this).descriptor.postExecution.run();
                                        IOTerm.term((InputOutput)((NativeExecutionService)NativeExecutionService.this).descriptor.inputOutput).setReadOnly(true);
                                    }
                                }, NativeExecutionService.this.displayName + " postExecution");
                            }
                        }
                    });
                    return serializable;
                }
                PtySupport.connect(((NativeExecutionService)NativeExecutionService.this).descriptor.inputOutput, process);
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                    }
                });
                serializable = Integer.valueOf(process.waitFor());
                try {
                    while (((NativeProcess)processRef.get()).getInputStream().available() != 0) {
                    }
                    ((NativeProcess)processRef.get()).getInputStream().close();
                }
                catch (IOException ex) {
                    // empty catch block
                }
                IOTerm.disconnect((InputOutput)((NativeExecutionService)NativeExecutionService.this).descriptor.inputOutput, (Runnable)new /* invalid duplicate definition of identical inner class */);
                return serializable;
                catch (Throwable throwable) {
                    try {
                        while (((NativeProcess)processRef.get()).getInputStream().available() != 0) {
                        }
                        ((NativeProcess)processRef.get()).getInputStream().close();
                    }
                    catch (IOException ex) {
                        // empty catch block
                    }
                }
                IOTerm.disconnect((InputOutput)((NativeExecutionService)NativeExecutionService.this).descriptor.inputOutput, (Runnable)new /* invalid duplicate definition of identical inner class */);
                throw throwable;
            }
        };
        FutureTask<Integer> runTask = new FutureTask<Integer>((Callable)callable){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean cancel(boolean mayInterruptIfRunning) {
                AtomicReference atomicReference = processRef;
                synchronized (atomicReference) {
                    NativeProcess process = (NativeProcess)processRef.get();
                    if (process != null) {
                        process.destroy();
                    }
                    return true;
                }
            }
        };
        NativeTaskExecutorService.submit(runTask, "start process in term");
        return runTask;
    }

    private Future<Integer> runRegular() {
        Charset charset = this.descriptor.charset;
        if (charset == null) {
            charset = execCharset;
        }
        Logger.getInstance().log(Level.FINE, "Input stream charset: {0}", charset);
        ExecutionDescriptor descr = new ExecutionDescriptor().controllable(this.descriptor.controllable).frontWindow(this.descriptor.frontWindow).inputVisible(this.descriptor.inputVisible).inputOutput(this.descriptor.inputOutput).outLineBased(this.descriptor.outLineBased).showProgress(this.descriptor.showProgress).postExecution(this.descriptor.postExecution).noReset(this.descriptor.noReset).errConvertorFactory(this.descriptor.errConvertorFactory).outConvertorFactory(this.descriptor.outConvertorFactory).charset(charset);
        ExecutionService es = ExecutionService.newService((Callable)this.processBuilder, (ExecutionDescriptor)descr, (String)this.displayName);
        return es.run();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        String charsetName = System.getProperty("org.netbeans.modules.nativeexecution.execcharset", "UTF-8");
        Charset cs = null;
        try {
            cs = Charset.forName(charsetName);
        }
        catch (Exception ex) {
            cs = Charset.defaultCharset();
        }
        finally {
            execCharset = cs;
        }
    }
}

