/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.identity.profile.api.configurator.impl.file;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Vector;
import javax.xml.bind.JAXBElement;
import org.netbeans.modules.identity.profile.api.configurator.ServerProperties;
import org.netbeans.modules.identity.profile.api.configurator.impl.file.AMConfigManager;
import org.netbeans.modules.identity.profile.api.configurator.impl.file.jaxb.AMConfigType;
import org.netbeans.modules.identity.profile.api.configurator.impl.file.jaxb.CertificateSettingsType;
import org.netbeans.modules.identity.profile.api.configurator.impl.file.jaxb.ObjectFactory;
import org.netbeans.modules.identity.profile.api.configurator.impl.file.jaxb.ProviderConfigType;
import org.netbeans.modules.identity.profile.api.configurator.impl.file.jaxb.ResponseType;
import org.netbeans.modules.identity.profile.api.configurator.impl.file.jaxb.SecurityMechanismType;
import org.netbeans.modules.identity.profile.api.configurator.impl.file.jaxb.ServerConfigType;
import org.netbeans.modules.identity.profile.api.configurator.impl.file.jaxb.UserPassSettingsType;
import org.netbeans.modules.identity.profile.api.configurator.spi.ProviderConfig;
import org.netbeans.modules.identity.profile.api.configurator.spi.TrustAuthorityConfig;

public class ProviderConfigImpl
implements ProviderConfig {
    private String pName = null;
    private String pType = null;
    private JAXBElement<AMConfigType> amconfig = null;
    private ObjectFactory objFactory = null;
    private ProviderConfigType providerConfig = null;
    private String path;

    public ProviderConfigImpl(String providerName, String type, String path) {
        this.pName = providerName;
        this.pType = type;
        this.path = path;
        this.objFactory = new ObjectFactory();
        this.amconfig = AMConfigManager.getDefault().getAMConfig(path);
        for (ProviderConfigType p : ((AMConfigType)this.amconfig.getValue()).getProviderConfig()) {
            if (!p.getName().equals(providerName) || !p.getType().equals(type)) continue;
            this.providerConfig = p;
            break;
        }
        if (this.providerConfig == null) {
            this.providerConfig = this.objFactory.createProviderConfigType();
            ((AMConfigType)this.amconfig.getValue()).getProviderConfig().add(this.providerConfig);
            this.providerConfig.setName(providerName);
            this.providerConfig.setType(type);
        }
    }

    @Override
    public boolean isResponseSignEnabled() {
        ResponseType resType = this.providerConfig.getResponse();
        if (resType != null) {
            return resType.isSigned();
        }
        return false;
    }

    @Override
    public void setResponseSignEnabled(boolean flag) {
        ResponseType resType = this.providerConfig.getResponse();
        if (resType == null) {
            resType = this.objFactory.createResponseType();
            this.providerConfig.setResponse(resType);
        }
        resType.setSigned(flag);
    }

    @Override
    public String getKeyAlias() {
        CertificateSettingsType certType = this.providerConfig.getCertificateSettings();
        if (certType != null) {
            return certType.getKeyAlias();
        }
        return null;
    }

    @Override
    public void setKeyAlias(String keyAlias) {
        CertificateSettingsType certType = this.providerConfig.getCertificateSettings();
        if (certType == null) {
            certType = this.objFactory.createCertificateSettingsType();
            this.providerConfig.setCertificateSettings(certType);
        }
        certType.setKeyAlias(keyAlias);
    }

    @Override
    public String getKeyStoreFile() {
        CertificateSettingsType certType = this.providerConfig.getCertificateSettings();
        if (certType != null) {
            return certType.getKeystoreLocation();
        }
        return null;
    }

    @Override
    public String getKeyStorePassword() {
        CertificateSettingsType certType = this.providerConfig.getCertificateSettings();
        if (certType != null) {
            return certType.getKeystorePassword();
        }
        return null;
    }

    @Override
    public void setKeyStore(String location, String password, String keyPassword) {
        CertificateSettingsType certType = this.providerConfig.getCertificateSettings();
        if (certType == null) {
            certType = this.objFactory.createCertificateSettingsType();
            this.providerConfig.setCertificateSettings(certType);
        }
        certType.setKeystoreLocation(location);
        certType.setKeystorePassword(password);
        certType.setKeyPassword(keyPassword);
    }

    @Override
    public Object getProperty(String propName) {
        return null;
    }

    @Override
    public void setProperty(String propName, Object value) {
    }

    @Override
    public Collection<String> getSecurityMechanisms() {
        ArrayList<String> l = new ArrayList<String>();
        SecurityMechanismType secmechType = this.providerConfig.getSecurityMechanism();
        if (secmechType != null) {
            l.add(secmechType.getUri());
        }
        return l;
    }

    @Override
    public void setSecurityMechanisms(Collection<String> securityMechs) {
        if (securityMechs.size() == 0) {
            this.providerConfig.setSecurityMechanism(null);
        } else if (securityMechs.size() == 1) {
            SecurityMechanismType secmechType = this.providerConfig.getSecurityMechanism();
            if (secmechType == null) {
                secmechType = this.objFactory.createSecurityMechanismType();
                this.providerConfig.setSecurityMechanism(secmechType);
            }
            String uri = securityMechs.iterator().next();
            secmechType.setUri(uri);
        }
    }

    @Override
    public void saveProvider() {
        AMConfigManager.getDefault().saveAMConfig(this.amconfig, this.path);
    }

    @Override
    public void deleteProvider() {
        ArrayList<ProviderConfigType> tmp = new ArrayList<ProviderConfigType>();
        AMConfigType amconfigType = (AMConfigType)this.amconfig.getValue();
        List<ProviderConfigType> pConfig = amconfigType.getProviderConfig();
        for (ProviderConfigType p : pConfig) {
            if (p.getName().equals(this.pName) && p.getType().equals(this.pType)) {
                this.providerConfig = p;
                break;
            }
            tmp.add(p);
        }
        pConfig.clear();
        for (ProviderConfigType p : tmp) {
            pConfig.add(p);
        }
        this.saveProvider();
    }

    @Override
    public String getWSPEndpoint() {
        return null;
    }

    @Override
    public void setWSPEndpoint(String endpoint) {
    }

    @Override
    public boolean isProviderExists() {
        return true;
    }

    @Override
    public ServerProperties getServerProperties(String id) {
        ServerConfigType serverConfigType = ((AMConfigType)this.amconfig.getValue()).getServerConfig();
        ServerProperties properties = ServerProperties.getInstance(id);
        if (serverConfigType != null) {
            properties.setProperty("org.netbeans.modules.identity.profile.api.configurator.id", serverConfigType.getName());
            properties.setProperty("com.iplanet.am.server.host", serverConfigType.getHost());
            properties.setProperty("com.iplanet.am.server.port", serverConfigType.getPort());
            properties.setProperty("com.sun.identity.agents.app.username", serverConfigType.getUsername());
            properties.setProperty("com.iplanet.am.service.password", serverConfigType.getPassword());
        }
        return properties;
    }

    @Override
    public void setServerProperties(ServerProperties properties) {
        ServerConfigType serverConfigType = ((AMConfigType)this.amconfig.getValue()).getServerConfig();
        if (serverConfigType == null) {
            serverConfigType = this.objFactory.createServerConfigType();
            ((AMConfigType)this.amconfig.getValue()).setServerConfig(serverConfigType);
        }
        serverConfigType.setName(properties.getProperty("org.netbeans.modules.identity.profile.api.configurator.id"));
        serverConfigType.setHost(properties.getProperty("com.iplanet.am.server.host"));
        serverConfigType.setPort(properties.getProperty("com.iplanet.am.server.port"));
        serverConfigType.setUsername(properties.getProperty("com.sun.identity.agents.app.username"));
        serverConfigType.setPassword(properties.getProperty("com.iplanet.am.service.password"));
    }

    @Override
    public String getUserName() {
        UserPassSettingsType type = this.getUserPassSettings();
        return type.getUsername();
    }

    @Override
    public void setUserName(String userName) {
        UserPassSettingsType type = this.getUserPassSettings();
        type.setUsername(userName);
    }

    @Override
    public String getPassword() {
        UserPassSettingsType type = this.getUserPassSettings();
        return type.getPassword();
    }

    @Override
    public void setPassword(String password) {
        UserPassSettingsType type = this.getUserPassSettings();
        type.setPassword(password);
    }

    private UserPassSettingsType getUserPassSettings() {
        UserPassSettingsType type = this.providerConfig.getUserPassSettings();
        if (type == null) {
            type = this.objFactory.createUserPassSettingsType();
            this.providerConfig.setUserPassSettings(type);
        }
        return type;
    }

    @Override
    public void setUserNamePasswordPairs(Collection<Vector<String>> pairs) {
    }

    @Override
    public Collection<Vector<String>> getUserNamePasswordPairs() {
        String userName = this.getUserName();
        String password = this.getPassword();
        Vector<Vector<String>> pairs = new Vector<Vector<String>>();
        if (userName != null || password != null) {
            Vector<String> pair = new Vector<String>();
            pair.add(userName);
            pair.add(password);
            pairs.add(pair);
        }
        return pairs;
    }

    private boolean isServerPropExist(ServerProperties properties) {
        AMConfigType aType = (AMConfigType)this.amconfig.getValue();
        if (aType != null) {
            return aType.getServerConfig().getName().equals(properties.getProperty("org.netbeans.modules.identity.profile.api.configurator.id"));
        }
        return false;
    }

    @Override
    public Collection<String> getAllProviderNames() {
        List<ProviderConfigType> providerConfigs = ((AMConfigType)this.amconfig.getValue()).getProviderConfig();
        ArrayList<String> providerNames = new ArrayList<String>();
        for (ProviderConfigType providerConfig : providerConfigs) {
            if (!this.pType.equals(providerConfig.getType())) continue;
            providerNames.add(providerConfig.getName());
        }
        return providerNames;
    }

    @Override
    public void setServiceType(String serviceType) {
        this.providerConfig.setServiceType(serviceType);
    }

    @Override
    public void setDefaultKeyStore(boolean flag) {
        CertificateSettingsType certType = this.providerConfig.getCertificateSettings();
        if (certType == null) {
            certType = this.objFactory.createCertificateSettingsType();
            this.providerConfig.setCertificateSettings(certType);
        }
        certType.setDefaultKeystore(flag);
    }

    @Override
    public boolean useDefaultKeyStore() {
        CertificateSettingsType certType = this.providerConfig.getCertificateSettings();
        if (certType != null) {
            Boolean value = certType.isDefaultKeystore();
            return value != null ? value : true;
        }
        return true;
    }

    @Override
    public String getServiceType() {
        return this.providerConfig.getServiceType();
    }

    @Override
    public String getKeyPassword() {
        CertificateSettingsType certType = this.providerConfig.getCertificateSettings();
        if (certType != null) {
            return certType.getKeyPassword();
        }
        return null;
    }

    @Override
    public void setTrustAuthorityConfigList(List<TrustAuthorityConfig> trustAuthConfigs) {
    }

    @Override
    public void close() {
        AMConfigManager.getDefault().removeAMConfig(this.path);
    }
}

