/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import java.util.Random;
import org.jruby.CompatVersion;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyBignum;
import org.jruby.RubyClass;
import org.jruby.RubyFloat;
import org.jruby.RubyNumeric;
import org.jruby.RubyObject;
import org.jruby.RubyRange;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;

@JRubyClass(name={"Random"})
public class RubyRandom
extends RubyObject {
    private static final Random globalRandom = new Random();
    private static IRubyObject globalSeed;
    private final Random random = new Random();
    private IRubyObject seed;
    private static ObjectAllocator RANDOM_ALLOCATOR;

    public static RubyClass createRandomClass(Ruby runtime2) {
        RubyClass randomClass = runtime2.defineClass("Random", runtime2.getObject(), RANDOM_ALLOCATOR);
        runtime2.setRandomClass(randomClass);
        randomClass.defineAnnotatedMethods(RubyRandom.class);
        return randomClass;
    }

    private RubyRandom(Ruby runtime2, RubyClass rubyClass) {
        super(runtime2, rubyClass);
    }

    @JRubyMethod(name={"initialize"}, frame=true, visibility=Visibility.PRIVATE, compat=CompatVersion.RUBY1_9)
    public IRubyObject initialize(ThreadContext context) {
        Ruby runtime2 = context.getRuntime();
        long seedLong = this.random.nextLong();
        this.seed = RubyBignum.newBignum(runtime2, seedLong);
        this.random.setSeed(seedLong);
        return this;
    }

    @JRubyMethod(name={"initialize"}, required=1, frame=true, visibility=Visibility.PRIVATE, compat=CompatVersion.RUBY1_9)
    public IRubyObject initialize(ThreadContext context, IRubyObject arg2) {
        long seedLong;
        if (arg2 instanceof RubyFloat) {
            this.seed = RubyBignum.num2fix(((RubyFloat)arg2).truncate());
            seedLong = RubyNumeric.num2long(this.seed);
        } else if (arg2 instanceof RubyBignum) {
            this.seed = arg2;
            seedLong = new Double(RubyBignum.big2dbl((RubyBignum)arg2)).longValue();
        } else {
            this.seed = arg2.convertToInteger();
            seedLong = RubyNumeric.num2long(this.seed);
        }
        this.random.setSeed(seedLong);
        return this;
    }

    @JRubyMethod(name={"seed"}, compat=CompatVersion.RUBY1_9)
    public IRubyObject seed(ThreadContext context) {
        return this.seed;
    }

    @JRubyMethod(name={"rand"}, meta=true, optional=1, compat=CompatVersion.RUBY1_9)
    public static IRubyObject rand(ThreadContext context, IRubyObject recv2, IRubyObject[] args2) {
        IRubyObject arg2 = context.getRuntime().getNil();
        if (args2.length > 0) {
            arg2 = args2[0];
        }
        return RubyRandom.randCommon(context, arg2, globalRandom, false);
    }

    @JRubyMethod(name={"rand"}, backtrace=true, optional=1, compat=CompatVersion.RUBY1_9)
    public IRubyObject randObj(ThreadContext context, IRubyObject[] args2) {
        IRubyObject arg2 = context.getRuntime().getNil();
        if (args2.length > 0) {
            arg2 = args2[0];
        }
        return RubyRandom.randCommon(context, arg2, this.random, true);
    }

    private static IRubyObject randCommon(ThreadContext context, IRubyObject arg2, Random random, boolean raiseArgError) {
        Ruby runtime2 = context.getRuntime();
        if (arg2.isNil()) {
            return runtime2.newFloat(random.nextFloat());
        }
        if (arg2 instanceof RubyRange) {
            RubyRange range = (RubyRange)arg2;
            IRubyObject first2 = range.first();
            IRubyObject last2 = range.last();
            if (range.include_p19(context, last2).isTrue()) {
                last2 = last2.callMethod(context, "+", runtime2.newFixnum(1));
            }
            if (!(first2.respondsTo("-") && first2.respondsTo("+") && last2.respondsTo("-") && last2.respondsTo("+"))) {
                throw runtime2.newArgumentError("invalid argument - " + arg2.toString());
            }
            IRubyObject difference = last2.callMethod(context, "-", first2);
            int max2 = new Long(RubyNumeric.num2long(difference)).intValue();
            int rand2 = random.nextInt(max2);
            return RubyNumeric.num2fix(first2.callMethod(context, "+", runtime2.newFixnum(rand2)));
        }
        if (arg2 instanceof RubyFloat) {
            double max3 = RubyNumeric.num2dbl(arg2);
            if (max3 <= 0.0 && raiseArgError) {
                throw runtime2.newArgumentError("invalid argument - " + arg2.toString());
            }
            return runtime2.newFloat((double)random.nextFloat() * max3);
        }
        int max4 = 0;
        if (arg2 instanceof RubyBignum) {
            max4 = new Double(RubyBignum.big2dbl((RubyBignum)arg2)).intValue();
        } else {
            if (arg2.respondsTo("to_i")) {
                arg2 = arg2.callMethod(context, "to_i");
            }
            max4 = new Long(RubyNumeric.num2long(arg2)).intValue();
        }
        if (max4 <= 0 && raiseArgError) {
            throw runtime2.newArgumentError("invalid argument - " + arg2.toString());
        }
        int rand3 = random.nextInt(max4);
        if (arg2 instanceof RubyBignum) {
            return RubyBignum.newBignum(runtime2, rand3);
        }
        return runtime2.newFixnum(rand3);
    }

    @JRubyMethod(name={"srand"}, frame=true, meta=true, compat=CompatVersion.RUBY1_9)
    public static IRubyObject srand(ThreadContext context, IRubyObject recv2) {
        return RubyRandom.srand(context, recv2, context.getRuntime().getNil());
    }

    @JRubyMethod(name={"srand"}, frame=true, meta=true, compat=CompatVersion.RUBY1_9)
    public static IRubyObject srand(ThreadContext context, IRubyObject recv2, IRubyObject arg2) {
        Ruby runtime2 = context.getRuntime();
        IRubyObject newSeed2 = arg2;
        IRubyObject previousSeed = globalSeed;
        if (arg2.isNil() || RubyNumeric.num2int(arg2) == 0) {
            newSeed2 = RubyNumeric.int2fix(runtime2, System.currentTimeMillis() ^ (long)recv2.hashCode() ^ runtime2.incrementRandomSeedSequence() ^ (long)runtime2.getRandom().nextInt(Math.max(1, Math.abs((int)runtime2.getRandomSeed()))));
        }
        globalSeed = newSeed2;
        globalRandom.setSeed(RubyNumeric.fix2long(globalSeed));
        return previousSeed;
    }

    @JRubyMethod(name={"=="}, required=1, compat=CompatVersion.RUBY1_9)
    public IRubyObject op_equal_19(ThreadContext context, IRubyObject obj) {
        Ruby runtime2 = context.getRuntime();
        if (!(obj instanceof RubyRandom)) {
            return runtime2.getFalse();
        }
        RubyRandom r2 = (RubyRandom)obj;
        return this.seed(context).callMethod(context, "==", r2.seed(context));
    }

    @JRubyMethod(name={"marshal_dump"}, backtrace=true, compat=CompatVersion.RUBY1_9)
    public IRubyObject marshal_dump(ThreadContext context) {
        RubyArray dump2 = context.getRuntime().newArray(this.seed);
        if (this.hasVariables()) {
            dump2.syncVariables(this.getVariableList());
        }
        return dump2;
    }

    @JRubyMethod(name={"marshal_load"}, backtrace=true, compat=CompatVersion.RUBY1_9)
    public IRubyObject marshal_load(ThreadContext context, IRubyObject arg2) {
        RubyArray load2 = arg2.convertToArray();
        if (load2.size() > 0) {
            this.seed = load2.eltInternal(0);
            this.random.setSeed(this.seed.convertToInteger().getLongValue());
        }
        if (load2.hasVariables()) {
            this.syncVariables(load2.getVariableList());
        }
        return this;
    }

    @JRubyMethod(name={"bytes"}, frame=true, compat=CompatVersion.RUBY1_9)
    public IRubyObject bytes(ThreadContext context, IRubyObject arg2) {
        throw context.getRuntime().newNotImplementedError("Random#bytes is not implemented yet");
    }

    @JRubyMethod(name={"new_seed"}, frame=true, meta=true, compat=CompatVersion.RUBY1_9)
    public static IRubyObject newSeed(ThreadContext context, IRubyObject recv2) {
        Ruby runtime2 = context.getRuntime();
        long rand2 = RubyRandom.getRandomSeed(runtime2, recv2);
        return RubyBignum.newBignum(runtime2, rand2);
    }

    private static long getRandomSeed(Ruby runtime2, IRubyObject recv2) {
        return System.currentTimeMillis() ^ (long)recv2.hashCode() ^ runtime2.incrementRandomSeedSequence() ^ (long)runtime2.getRandom().nextInt(Math.max(1, Math.abs((int)runtime2.getRandomSeed())));
    }

    static {
        RANDOM_ALLOCATOR = new ObjectAllocator(){

            public IRubyObject allocate(Ruby runtime2, RubyClass klass) {
                return new RubyRandom(runtime2, klass);
            }
        };
    }
}

