/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import java.io.File;
import java.io.IOException;
import org.jruby.CompatVersion;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyEnumerator;
import org.jruby.RubyFile;
import org.jruby.RubyFixnum;
import org.jruby.RubyIO;
import org.jruby.RubyNumeric;
import org.jruby.RubyObject;
import org.jruby.RubyString;
import org.jruby.anno.JRubyMethod;
import org.jruby.exceptions.RaiseException;
import org.jruby.ext.posix.FileStat;
import org.jruby.ext.posix.util.Platform;
import org.jruby.runtime.Block;
import org.jruby.runtime.IAccessor;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ByteList;

public class RubyArgsFile {
    public static void setCurrentLineNumber(IRubyObject recv2, int newLineNumber) {
        ArgsFileData data = ArgsFileData.getDataFrom(recv2);
        if (data != null) {
            data.currentLineNumber = newLineNumber;
        }
    }

    public static void initArgsFile(final Ruby runtime2) {
        RubyObject argsFile = new RubyObject(runtime2, runtime2.getObject());
        runtime2.getEnumerable().extend_object(argsFile);
        runtime2.setArgsFile(argsFile);
        runtime2.getGlobalVariables().defineReadonly("$<", new IAccessor(){

            public IRubyObject getValue() {
                return runtime2.getArgsFile();
            }

            public IRubyObject setValue(IRubyObject newValue) {
                throw new UnsupportedOperationException("Not supported yet.");
            }
        });
        runtime2.defineGlobalConstant("ARGF", argsFile);
        RubyClass argfClass = argsFile.getMetaClass();
        argfClass.defineAnnotatedMethods(RubyArgsFile.class);
        runtime2.defineReadonlyVariable("$FILENAME", runtime2.newString("-"));
    }

    @JRubyMethod(name={"fileno", "to_i"})
    public static IRubyObject fileno(ThreadContext context, IRubyObject recv2) {
        return ((RubyIO)RubyArgsFile.getData((ThreadContext)context, (IRubyObject)recv2, (String)"no stream").currentFile).fileno(context);
    }

    @JRubyMethod(name={"to_io"})
    public static IRubyObject to_io(ThreadContext context, IRubyObject recv2) {
        return RubyArgsFile.getData((ThreadContext)context, (IRubyObject)recv2, (String)"no stream").currentFile;
    }

    private static IRubyObject argf_getline(ThreadContext context, IRubyObject recv2, IRubyObject[] args2) {
        ArgsFileData data = ArgsFileData.getDataFrom(recv2);
        boolean retry = true;
        IRubyObject line = null;
        while (retry) {
            retry = false;
            if (!data.next_argv(context)) {
                return context.getRuntime().getNil();
            }
            line = data.currentFile.callMethod(context, "gets", args2);
            if (!line.isNil() || data.next_p == -1) continue;
            RubyArgsFile.argf_close(context, data.currentFile);
            data.next_p = 1;
            retry = true;
        }
        if (!line.isNil()) {
            context.getRuntime().setCurrentLine(data.currentLineNumber);
        }
        return line;
    }

    @JRubyMethod(name={"gets"}, optional=1)
    public static IRubyObject gets(ThreadContext context, IRubyObject recv2, IRubyObject[] args2) {
        ArgsFileData data = ArgsFileData.getDataFrom(recv2);
        if (!data.next_argv(context)) {
            return context.getRuntime().getNil();
        }
        IRubyObject line = !(data.currentFile instanceof RubyIO) ? data.currentFile.callMethod(context, "gets", args2) : RubyArgsFile.argf_getline(context, recv2, args2);
        context.getCurrentScope().setLastLine(line);
        context.getRuntime().getGlobalVariables().set("$_", line);
        return line;
    }

    @JRubyMethod(name={"readline"}, optional=1)
    public static IRubyObject readline(ThreadContext context, IRubyObject recv2, IRubyObject[] args2) {
        IRubyObject line = RubyArgsFile.gets(context, recv2, args2);
        if (line.isNil()) {
            throw context.getRuntime().newEOFError();
        }
        return line;
    }

    @JRubyMethod(name={"readlines"}, optional=1, frame=true)
    public static IRubyObject readlines(ThreadContext context, IRubyObject recv2, IRubyObject[] args2) {
        IRubyObject line;
        ArgsFileData data = ArgsFileData.getDataFrom(recv2);
        Ruby runtime2 = context.getRuntime();
        if (!data.next_argv(context)) {
            return runtime2.is1_9() ? runtime2.newEmptyArray() : runtime2.getNil();
        }
        if (!(data.currentFile instanceof RubyIO)) {
            return data.currentFile.callMethod(context, "readlines", args2);
        }
        RubyArray ary = runtime2.newArray();
        while (!(line = RubyArgsFile.argf_getline(context, recv2, args2)).isNil()) {
            ary.append(line);
        }
        return ary;
    }

    @JRubyMethod(name={"to_a"}, optional=1, frame=true)
    public static IRubyObject to_a(ThreadContext context, IRubyObject recv2, IRubyObject[] args2) {
        IRubyObject line;
        ArgsFileData data = ArgsFileData.getDataFrom(recv2);
        Ruby runtime2 = context.getRuntime();
        if (!data.next_argv(context)) {
            return runtime2.is1_9() ? runtime2.newEmptyArray() : runtime2.getNil();
        }
        if (!(data.currentFile instanceof RubyIO)) {
            return data.currentFile.callMethod(context, "to_a", args2);
        }
        RubyArray ary = runtime2.newArray();
        while (!(line = RubyArgsFile.argf_getline(context, recv2, args2)).isNil()) {
            ary.append(line);
        }
        return ary;
    }

    public static IRubyObject each_byte(ThreadContext context, IRubyObject recv2, Block block) {
        IRubyObject bt;
        while (!(bt = RubyArgsFile.getc(context, recv2)).isNil()) {
            block.yield(context, bt);
        }
        return recv2;
    }

    @JRubyMethod(name={"each_byte"}, optional=1, frame=true)
    public static IRubyObject each_byte(ThreadContext context, IRubyObject recv2, IRubyObject[] args2, Block block) {
        return block.isGiven() ? RubyArgsFile.each_byte(context, recv2, block) : RubyEnumerator.enumeratorize(context.getRuntime(), recv2, "each_byte");
    }

    @JRubyMethod(name={"bytes"}, optional=1, frame=true)
    public static IRubyObject bytes(ThreadContext context, IRubyObject recv2, IRubyObject[] args2, Block block) {
        return block.isGiven() ? RubyArgsFile.each_byte(context, recv2, block) : RubyEnumerator.enumeratorize(context.getRuntime(), recv2, "bytes");
    }

    @JRubyMethod(name={"each_char"}, frame=true)
    public static IRubyObject each_char(ThreadContext context, IRubyObject recv2, Block block) {
        return block.isGiven() ? RubyArgsFile.each_charCommon(context, recv2, block) : RubyEnumerator.enumeratorize(context.getRuntime(), recv2, "each_char");
    }

    @JRubyMethod(name={"chars"}, frame=true)
    public static IRubyObject chars(ThreadContext context, IRubyObject recv2, Block block) {
        return block.isGiven() ? RubyArgsFile.each_charCommon(context, recv2, block) : RubyEnumerator.enumeratorize(context.getRuntime(), recv2, "chars");
    }

    public static IRubyObject each_charCommon(ThreadContext context, IRubyObject recv2, Block block) {
        IRubyObject ch;
        ArgsFileData data = ArgsFileData.getDataFrom(recv2);
        Ruby runtime2 = context.getRuntime();
        while (!(ch = RubyArgsFile.getc(context, recv2)).isNil()) {
            boolean cont = true;
            while (cont) {
                cont = false;
                byte c = (byte)RubyNumeric.fix2int(ch);
                int n = runtime2.getKCode().getEncoding().length(c);
                IRubyObject file2 = data.currentFile;
                RubyString str = runtime2.newString();
                str.setTaint(true);
                str.cat(c);
                while (--n > 0) {
                    ch = RubyArgsFile.getc(context, recv2);
                    if (ch.isNil()) {
                        block.yield(context, str);
                        return recv2;
                    }
                    if (data.currentFile != file2) {
                        block.yield(context, str);
                        cont = true;
                        continue;
                    }
                    c = (byte)RubyNumeric.fix2int(ch);
                    str.cat(c);
                }
                block.yield(context, str);
            }
        }
        return recv2;
    }

    @JRubyMethod(name={"each_line", "each"}, optional=1, frame=true)
    public static IRubyObject each_line(ThreadContext context, IRubyObject recv2, IRubyObject[] args2, Block block) {
        IRubyObject str;
        ArgsFileData data = ArgsFileData.getDataFrom(recv2);
        if (!data.next_argv(context)) {
            return context.getRuntime().getNil();
        }
        if (!(data.currentFile instanceof RubyIO)) {
            if (!data.next_argv(context)) {
                return recv2;
            }
            data.currentFile.callMethod(context, "each", new IRubyObject[0], block);
            data.next_p = 1;
        }
        while (!(str = RubyArgsFile.argf_getline(context, recv2, args2)).isNil()) {
            block.yield(context, str);
        }
        return recv2;
    }

    @JRubyMethod(name={"each_line"}, optional=1, frame=true, compat=CompatVersion.RUBY1_9)
    public static IRubyObject each_line19(ThreadContext context, IRubyObject recv2, IRubyObject[] args2, Block block) {
        return block.isGiven() ? RubyArgsFile.each_line(context, recv2, args2, block) : RubyEnumerator.enumeratorize(context.getRuntime(), recv2, "each_line", args2);
    }

    @JRubyMethod(name={"each"}, optional=1, frame=true, compat=CompatVersion.RUBY1_9)
    public static IRubyObject each19(ThreadContext context, IRubyObject recv2, IRubyObject[] args2, Block block) {
        return block.isGiven() ? RubyArgsFile.each_line(context, recv2, args2, block) : RubyEnumerator.enumeratorize(context.getRuntime(), recv2, "each", args2);
    }

    @JRubyMethod(name={"file"})
    public static IRubyObject file(ThreadContext context, IRubyObject recv2) {
        ArgsFileData data = ArgsFileData.getDataFrom(recv2);
        data.next_argv(context);
        return data.currentFile;
    }

    @JRubyMethod(name={"skip"})
    public static IRubyObject skip(IRubyObject recv2) {
        ArgsFileData data = ArgsFileData.getDataFrom(recv2);
        if (data.next_p != -1) {
            RubyArgsFile.argf_close(recv2.getRuntime().getCurrentContext(), data.currentFile);
            data.next_p = 1;
        }
        return recv2;
    }

    public static void argf_close(ThreadContext context, IRubyObject file2) {
        if (file2 instanceof RubyIO) {
            ((RubyIO)file2).close2(context.getRuntime());
        } else {
            file2.callMethod(context, "close");
        }
    }

    @JRubyMethod(name={"close"})
    public static IRubyObject close(ThreadContext context, IRubyObject recv2) {
        ArgsFileData data = ArgsFileData.getDataFrom(recv2);
        data.next_argv(context);
        if (RubyArgsFile.isClosed(context, data.currentFile)) {
            throw context.getRuntime().newIOError("closed stream");
        }
        RubyArgsFile.argf_close(context, data.currentFile);
        if (data.next_p != -1) {
            data.next_p = 1;
        }
        data.currentLineNumber = 0;
        return recv2;
    }

    @JRubyMethod(name={"closed?"})
    public static IRubyObject closed_p(ThreadContext context, IRubyObject recv2) {
        ArgsFileData data = ArgsFileData.getDataFrom(recv2);
        data.next_argv(context);
        return RubyBoolean.newBoolean(context.getRuntime(), RubyArgsFile.isClosed(context, data.currentFile));
    }

    private static boolean isClosed(ThreadContext context, IRubyObject currentFile) {
        boolean closed = false;
        closed = !(currentFile instanceof RubyIO) ? currentFile.callMethod(context, "closed?").isTrue() : ((RubyIO)currentFile).closed_p(context).isTrue();
        return closed;
    }

    @JRubyMethod(name={"binmode"})
    public static IRubyObject binmode(ThreadContext context, IRubyObject recv2) {
        ArgsFileData data = RubyArgsFile.getData(context, recv2, "no stream");
        ((RubyIO)data.currentFile).binmode();
        return recv2;
    }

    @JRubyMethod(name={"binmode?"}, compat=CompatVersion.RUBY1_9)
    public static IRubyObject op_binmode(ThreadContext context, IRubyObject recv2) {
        ArgsFileData data = RubyArgsFile.getData(context, recv2, "no stream");
        return ((RubyIO)data.currentFile).op_binmode(context);
    }

    @JRubyMethod(name={"lineno"})
    public static IRubyObject lineno(ThreadContext context, IRubyObject recv2) {
        return recv2.getRuntime().newFixnum(ArgsFileData.getDataFrom((IRubyObject)recv2).currentLineNumber);
    }

    @JRubyMethod(name={"lineno="})
    public static IRubyObject lineno_set(ThreadContext context, IRubyObject recv2, IRubyObject line) {
        ArgsFileData data = ArgsFileData.getDataFrom(recv2);
        data.currentLineNumber = RubyNumeric.fix2int(line);
        context.getRuntime().setCurrentLine(data.currentLineNumber);
        return recv2.getRuntime().getNil();
    }

    @JRubyMethod(name={"tell"}, alias={"pos"})
    public static IRubyObject tell(ThreadContext context, IRubyObject recv2) {
        ArgsFileData data = ArgsFileData.getDataFrom(recv2);
        if (!data.next_argv(context)) {
            throw context.getRuntime().newArgumentError("no stream to tell");
        }
        return ((RubyIO)data.currentFile).pos(context);
    }

    @JRubyMethod(name={"rewind"})
    public static IRubyObject rewind(ThreadContext context, IRubyObject recv2) {
        ArgsFileData data = RubyArgsFile.getData(context, recv2, "no stream to rewind");
        RubyFixnum retVal = ((RubyIO)data.currentFile).rewind(context);
        ((RubyIO)data.currentFile).lineno_set(context, context.getRuntime().newFixnum(0));
        data.minLineNumber = 0;
        data.currentLineNumber = 0;
        return retVal;
    }

    @JRubyMethod(name={"eof"})
    public static IRubyObject eof(ThreadContext context, IRubyObject recv2) {
        ArgsFileData data = ArgsFileData.getDataFrom(recv2);
        if (!data.inited) {
            return context.getRuntime().getTrue();
        }
        if (!(data.currentFile instanceof RubyIO)) {
            return data.currentFile.callMethod(context, "eof");
        }
        return ((RubyIO)data.currentFile).eof_p(context);
    }

    @JRubyMethod(name={"eof?"})
    public static IRubyObject eof_p(ThreadContext context, IRubyObject recv2) {
        ArgsFileData data = ArgsFileData.getDataFrom(recv2);
        if (!data.inited) {
            return context.getRuntime().getTrue();
        }
        if (!(data.currentFile instanceof RubyIO)) {
            return data.currentFile.callMethod(context, "eof?");
        }
        return ((RubyIO)data.currentFile).eof_p(context);
    }

    @JRubyMethod(name={"pos="}, required=1)
    public static IRubyObject set_pos(ThreadContext context, IRubyObject recv2, IRubyObject offset2) {
        ArgsFileData data = RubyArgsFile.getData(context, recv2, "no stream to set position");
        return ((RubyIO)data.currentFile).pos_set(context, offset2);
    }

    @JRubyMethod(name={"seek"}, required=1, optional=1)
    public static IRubyObject seek(ThreadContext context, IRubyObject recv2, IRubyObject[] args2) {
        ArgsFileData data = RubyArgsFile.getData(context, recv2, "no stream to seek");
        return ((RubyIO)data.currentFile).seek(context, args2);
    }

    @JRubyMethod(name={"readchar"})
    public static IRubyObject readchar(ThreadContext context, IRubyObject recv2) {
        IRubyObject c = RubyArgsFile.getc(context, recv2);
        if (c.isNil()) {
            throw context.getRuntime().newEOFError();
        }
        return c;
    }

    @JRubyMethod(name={"getc"})
    public static IRubyObject getc(ThreadContext context, IRubyObject recv2) {
        IRubyObject bt;
        ArgsFileData data = ArgsFileData.getDataFrom(recv2);
        while (true) {
            if (!data.next_argv(context)) {
                return context.getRuntime().getNil();
            }
            bt = !(data.currentFile instanceof RubyFile) ? data.currentFile.callMethod(context, "getc") : ((RubyIO)data.currentFile).getc();
            if (!bt.isNil()) break;
            data.next_p = 1;
        }
        return bt;
    }

    @JRubyMethod(name={"read"}, optional=2)
    public static IRubyObject read(ThreadContext context, IRubyObject recv2, IRubyObject[] args2) {
        IRubyObject str;
        IRubyObject length2;
        Ruby runtime2 = context.getRuntime();
        ArgsFileData data = ArgsFileData.getDataFrom(recv2);
        long len = 0L;
        if (args2.length > 0) {
            length2 = args2[0];
            str = args2.length > 1 ? args2[1] : runtime2.getNil();
        } else {
            length2 = runtime2.getNil();
            str = runtime2.getNil();
        }
        if (!length2.isNil()) {
            len = RubyNumeric.num2long(length2);
        }
        if (!str.isNil()) {
            str = str.convertToString();
            ((RubyString)str).modify();
            ((RubyString)str).getByteList().length(0);
            args2[1] = runtime2.getNil();
        }
        while (true) {
            if (!data.next_argv(context)) {
                return str;
            }
            IRubyObject tmp = !(data.currentFile instanceof RubyIO) ? data.currentFile.callMethod(context, "read", args2) : ((RubyIO)data.currentFile).read(args2);
            if (str.isNil()) {
                str = tmp;
            } else if (!tmp.isNil()) {
                ((RubyString)str).append(tmp);
            }
            if (tmp.isNil() || length2.isNil()) {
                if (data.next_p == -1) break;
                RubyArgsFile.argf_close(context, data.currentFile);
                data.next_p = 1;
                continue;
            }
            if (args2.length < 1 || (long)((RubyString)str).getByteList().length() >= len) break;
            args2[0] = runtime2.newFixnum(len -= (long)((RubyString)str).getByteList().length());
        }
        return str;
    }

    @JRubyMethod(name={"filename"}, alias={"path"})
    public static IRubyObject filename(ThreadContext context, IRubyObject recv2) {
        ArgsFileData data = ArgsFileData.getDataFrom(recv2);
        data.next_argv(context);
        return context.getRuntime().getGlobalVariables().get("$FILENAME");
    }

    @JRubyMethod(name={"to_s"})
    public static IRubyObject to_s(IRubyObject recv2) {
        return recv2.getRuntime().newString("ARGF");
    }

    private static ArgsFileData getData(ThreadContext context, IRubyObject recv2, String errorMessage) {
        ArgsFileData data = ArgsFileData.getDataFrom(recv2);
        if (!data.next_argv(context)) {
            throw context.getRuntime().newArgumentError(errorMessage);
        }
        return data;
    }

    private static final class ArgsFileData {
        private final Ruby runtime;
        public IRubyObject currentFile;
        public int currentLineNumber;
        public int minLineNumber;
        private boolean inited = false;
        public int next_p = 0;

        public ArgsFileData(Ruby runtime2) {
            this.runtime = runtime2;
            this.currentFile = runtime2.getNil();
        }

        /*
         * Enabled aggressive block sorting
         */
        public boolean next_argv(ThreadContext context) {
            RubyArray args2 = (RubyArray)this.runtime.getGlobalVariables().get("$*");
            if (!this.inited) {
                this.next_p = args2.getLength() > 0 ? 1 : -1;
                this.inited = true;
                this.currentLineNumber = 0;
            }
            if (this.next_p != 1) {
                if (this.next_p != -1) return true;
                this.currentFile = this.runtime.getGlobalVariables().get("$stdin");
                if (this.runtime.getGlobalVariables().get("$FILENAME").asJavaString().equals("-")) return true;
                this.runtime.defineReadonlyVariable("$FILENAME", this.runtime.newString("-"));
                return true;
            }
            this.next_p = 0;
            if (args2.getLength() <= 0) {
                this.next_p = 1;
                return false;
            }
            IRubyObject arg2 = args2.shift(context);
            RubyString filename2 = (RubyString)((RubyObject)arg2).to_s();
            ByteList filenameBytes = filename2.getByteList();
            if (!filename2.op_equal(context, (RubyString)this.runtime.getGlobalVariables().get("$FILENAME")).isTrue()) {
                this.runtime.defineReadonlyVariable("$FILENAME", filename2);
            }
            if (filenameBytes.length() == 1 && filenameBytes.get(0) == 45) {
                this.currentFile = this.runtime.getGlobalVariables().get("$stdin");
                return true;
            }
            this.currentFile = RubyFile.open(context, this.runtime.getFile(), new IRubyObject[]{filename2}, Block.NULL_BLOCK);
            String extension = this.runtime.getInstanceConfig().getInPlaceBackupExtention();
            if (extension != null) {
                if (Platform.IS_WINDOWS) {
                    this.inplaceEditWindows(context, filename2.asJavaString(), extension);
                } else {
                    this.inplaceEdit(context, filename2.asJavaString(), extension);
                }
            }
            this.minLineNumber = this.currentLineNumber;
            this.currentFile.callMethod(context, "lineno=", context.getRuntime().newFixnum(this.currentLineNumber));
            return true;
        }

        public static ArgsFileData getDataFrom(IRubyObject recv2) {
            ArgsFileData data = (ArgsFileData)recv2.dataGetStruct();
            if (data == null) {
                data = new ArgsFileData(recv2.getRuntime());
                recv2.dataWrapStruct(data);
            }
            return data;
        }

        private void createNewFile(File file2) {
            try {
                file2.createNewFile();
            }
            catch (IOException ex) {
                throw this.runtime.newIOErrorFromException(ex);
            }
        }

        private void inplaceEditWindows(ThreadContext context, String filename2, String extension) throws RaiseException {
            File file2 = new File(filename2);
            if (extension.equals("")) {
                throw this.runtime.newIOError("Windows doesn't support inplace editing without a backup");
            }
            String backup = filename2 + extension;
            File backupFile = new File(backup);
            ((RubyIO)this.currentFile).close();
            backupFile.delete();
            file2.renameTo(backupFile);
            this.currentFile = (RubyIO)RubyFile.open(context, this.runtime.getFile(), new IRubyObject[]{this.runtime.newString(backup)}, Block.NULL_BLOCK);
            this.createNewFile(file2);
            this.runtime.getGlobalVariables().set("$stdout", (RubyIO)RubyFile.open(context, this.runtime.getFile(), new IRubyObject[]{this.runtime.newString(filename2), this.runtime.newString("w")}, Block.NULL_BLOCK));
        }

        private void inplaceEdit(ThreadContext context, String filename2, String extension) throws RaiseException {
            File file2 = new File(filename2);
            FileStat stat2 = this.runtime.getPosix().stat(filename2);
            if (!extension.equals("")) {
                file2.renameTo(new File(filename2 + extension));
            } else {
                file2.delete();
            }
            this.createNewFile(file2);
            this.runtime.getPosix().chmod(filename2, stat2.mode());
            this.runtime.getPosix().chown(filename2, stat2.uid(), stat2.gid());
            this.runtime.getGlobalVariables().set("$stdout", (RubyIO)RubyFile.open(context, this.runtime.getFile(), new IRubyObject[]{this.runtime.newString(filename2), this.runtime.newString("w")}, Block.NULL_BLOCK));
        }
    }
}

