/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.css.gsf;

import java.util.HashMap;
import java.util.Map;
import org.netbeans.modules.csl.api.ColoringAttributes;
import org.netbeans.modules.csl.api.OccurrencesFinder;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.css.gsf.api.CssParserResult;
import org.netbeans.modules.css.parser.NodeVisitor;
import org.netbeans.modules.css.parser.SimpleNode;
import org.netbeans.modules.css.parser.SimpleNodeUtil;
import org.netbeans.modules.parsing.api.Snapshot;
import org.netbeans.modules.parsing.spi.Parser;
import org.netbeans.modules.parsing.spi.Scheduler;
import org.netbeans.modules.parsing.spi.SchedulerEvent;
import org.netbeans.modules.web.common.api.LexerUtils;

public class CssOccurancesFinder
extends OccurrencesFinder {
    private int caretDocumentPosition;
    private boolean cancelled;
    private Map<OffsetRange, ColoringAttributes> occurrences;

    public void setCaretPosition(int position) {
        this.caretDocumentPosition = position;
    }

    public Map<OffsetRange, ColoringAttributes> getOccurrences() {
        return this.occurrences;
    }

    public void cancel() {
        this.cancelled = true;
    }

    public void run(Parser.Result result, SchedulerEvent event) {
        this.occurrences = null;
        if (this.cancelled) {
            this.cancelled = false;
            return;
        }
        final Snapshot snapshot = result.getSnapshot();
        int astOffset = snapshot.getEmbeddedOffset(this.caretDocumentPosition);
        if (astOffset == -1) {
            return;
        }
        SimpleNode root = ((CssParserResult)result).root();
        if (root == null) {
            return;
        }
        final SimpleNode currentNode = SimpleNodeUtil.findDescendant(root, astOffset);
        if (currentNode == null) {
            return;
        }
        switch (currentNode.kind()) {
            case 23: 
            case 24: 
            case 27: 
            case 35: {
                break;
            }
            default: {
                return;
            }
        }
        final String currentNodeImage = SimpleNodeUtil.getNodeImage(currentNode);
        final HashMap<OffsetRange, ColoringAttributes> occurancesLocal = new HashMap<OffsetRange, ColoringAttributes>();
        SimpleNodeUtil.visitChildren(root, new NodeVisitor(){

            @Override
            public void visit(SimpleNode node) {
                if (CssOccurancesFinder.this.cancelled) {
                    CssOccurancesFinder.this.cancelled = false;
                    return;
                }
                if (currentNode.kind() == node.kind() && LexerUtils.equals((CharSequence)currentNodeImage.trim(), (CharSequence)SimpleNodeUtil.getNodeImage(node).trim(), (currentNode.kind() == 35 ? 1 : 0) != 0, (boolean)false)) {
                    OffsetRange trimmedNodeRange = SimpleNodeUtil.getTrimmedNodeRange(node);
                    int docFrom = snapshot.getOriginalOffset(trimmedNodeRange.getStart());
                    if (docFrom == -1 && (node.kind() == 23 || node.kind() == 27)) {
                        docFrom = snapshot.getOriginalOffset(trimmedNodeRange.getStart() + 1);
                    }
                    int docTo = snapshot.getOriginalOffset(trimmedNodeRange.getEnd());
                    if (docFrom == -1 || docTo == -1) {
                        return;
                    }
                    occurancesLocal.put(new OffsetRange(docFrom, docTo), ColoringAttributes.MARK_OCCURRENCES);
                }
            }
        });
        if (this.cancelled) {
            this.cancelled = false;
            return;
        }
        if (occurancesLocal.size() > 0) {
            this.occurrences = occurancesLocal;
        }
    }

    public int getPriority() {
        return 100;
    }

    public Class<? extends Scheduler> getSchedulerClass() {
        return null;
    }
}

