/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.apt.utils;

import java.io.File;
import java.util.Iterator;
import org.netbeans.modules.cnd.apt.debug.APTTraceFlags;
import org.netbeans.modules.cnd.apt.support.IncludeDirEntry;
import org.netbeans.modules.cnd.apt.support.ResolvedPath;
import org.netbeans.modules.cnd.utils.cache.CharSequenceUtils;
import org.netbeans.modules.cnd.utils.cache.CndFileUtils;
import org.netbeans.modules.cnd.utils.cache.FilePathCache;
import org.openide.util.Utilities;

public class APTIncludeUtils {
    private APTIncludeUtils() {
    }

    public static ResolvedPath resolveFilePath(String inclString, CharSequence baseFile) {
        String folder;
        File fileFromBasePath;
        if (baseFile != null && APTIncludeUtils.isExistingFile(fileFromBasePath = new File(folder = new File(((Object)baseFile).toString()).getParent(), inclString))) {
            String absolutePath = fileFromBasePath.getAbsolutePath();
            return new ResolvedPath(FilePathCache.getManager().getString((CharSequence)folder), APTIncludeUtils.normalize(absolutePath), absolutePath, true, 0);
        }
        return null;
    }

    public static ResolvedPath resolveAbsFilePath(String file) {
        File absFile;
        if (APTTraceFlags.APT_ABSOLUTE_INCLUDES && (absFile = new File(file)).isAbsolute() && APTIncludeUtils.isExistingFile(absFile)) {
            return new ResolvedPath(FilePathCache.getManager().getString((CharSequence)absFile.getParent()), APTIncludeUtils.normalize(file), file, false, 0);
        }
        return null;
    }

    public static ResolvedPath resolveFilePath(Iterator<IncludeDirEntry> searchPaths, String includedFile, int dirOffset) {
        if (Utilities.isWindows()) {
            includedFile = includedFile.replace('/', File.separatorChar);
        }
        while (searchPaths.hasNext()) {
            IncludeDirEntry dirPrefix = searchPaths.next();
            if (dirPrefix.isExistingDirectory()) {
                int i;
                String prefix = dirPrefix.getAsString();
                int len = prefix.length();
                String absolutePath = len > 0 && prefix.charAt(len - 1) == File.separatorChar ? prefix + includedFile : CharSequenceUtils.toString((CharSequence)prefix, (char)File.separatorChar, (CharSequence)includedFile);
                if (APTIncludeUtils.isExistingFile(absolutePath)) {
                    return new ResolvedPath(dirPrefix.getAsSharedCharSequence(), APTIncludeUtils.normalize(absolutePath), absolutePath, false, dirOffset);
                }
                if (dirPrefix.isFramework() && (i = includedFile.indexOf(47)) > 0 && APTIncludeUtils.isExistingFile(absolutePath = dirPrefix.getAsString() + "/" + includedFile.substring(0, i) + ".framework/Headers" + includedFile.substring(i))) {
                    return new ResolvedPath(dirPrefix.getAsSharedCharSequence(), APTIncludeUtils.normalize(absolutePath), absolutePath, false, dirOffset);
                }
            }
            ++dirOffset;
        }
        return null;
    }

    private static String normalize(String path) {
        return CndFileUtils.normalizeAbsolutePath((String)path);
    }

    private static boolean isExistingFile(File file) {
        return CndFileUtils.isExistingFile((File)file);
    }

    private static boolean isExistingFile(String filePath) {
        return CndFileUtils.isExistingFile((String)filePath);
    }
}

