/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.apt.impl.structure;

import java.io.Serializable;
import java.util.logging.Level;
import org.netbeans.modules.cnd.apt.impl.structure.APTTokenBasedNode;
import org.netbeans.modules.cnd.apt.structure.APT;
import org.netbeans.modules.cnd.apt.structure.APTFile;
import org.netbeans.modules.cnd.apt.support.APTToken;
import org.netbeans.modules.cnd.apt.support.APTTokenAbstact;
import org.netbeans.modules.cnd.apt.utils.APTTraceUtils;
import org.netbeans.modules.cnd.apt.utils.APTUtils;
import org.netbeans.modules.cnd.debug.DebugUtils;

public abstract class APTMacroBaseNode
extends APTTokenBasedNode
implements Serializable {
    private static final long serialVersionUID = 1315417078059538898L;
    private APTToken macroName = EMPTY_NAME;
    private static final NotHandledMacroName EMPTY_NAME = new NotHandledMacroName();

    APTMacroBaseNode(APTMacroBaseNode orig) {
        super(orig);
        this.macroName = orig.macroName;
    }

    protected APTMacroBaseNode() {
    }

    public APTMacroBaseNode(APTToken token) {
        super(token);
    }

    @Override
    public APT getFirstChild() {
        return null;
    }

    @Override
    public void setFirstChild(APT child) {
        assert (false) : "define/undef doesn't support children";
    }

    @Override
    public boolean accept(APTFile curFile, APTToken token) {
        if (APTUtils.isID(token)) {
            if (this.macroName != EMPTY_NAME) {
                if (DebugUtils.STANDALONE) {
                    System.err.printf("%s, line %d: warning: extra tokens at end of %s directive\n", APTTraceUtils.toFileString(curFile), this.getToken().getLine(), this.getToken().getText().trim());
                } else {
                    APTUtils.LOG.log(Level.WARNING, "{0}, line {1}: warning: extra tokens at end of {2} directive", new Object[]{APTTraceUtils.toFileString(curFile), this.getToken().getLine(), this.getToken().getText().trim()});
                }
            } else {
                this.macroName = token;
            }
        }
        return !APTUtils.isEndDirectiveToken(token.getType());
    }

    @Override
    public String getText() {
        assert (this.getToken() != null) : "must have valid preproc directive";
        assert (this.getName() != null) : "must have valid macro";
        String retValue = super.getText();
        if (this.getName() != null) {
            retValue = retValue + " MACRO{" + this.getName() + "}";
        }
        return retValue;
    }

    public APTToken getName() {
        return this.macroName;
    }

    private static final class NotHandledMacroName
    extends APTTokenAbstact {
        @Override
        public String getText() {
            return "<<DUMMY>>";
        }

        @Override
        public int hashCode() {
            return -1;
        }

        @Override
        public boolean equals(Object obj) {
            return this == obj;
        }
    }
}

