/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.xdm.xam;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.event.UndoableEditListener;
import javax.xml.namespace.QName;
import org.netbeans.modules.xml.xam.Model;
import org.netbeans.modules.xml.xam.dom.AbstractDocumentComponent;
import org.netbeans.modules.xml.xam.dom.AbstractDocumentModel;
import org.netbeans.modules.xml.xam.dom.DocumentModelAccess;
import org.netbeans.modules.xml.xam.dom.ElementIdentity;
import org.netbeans.modules.xml.xdm.XDMModel;
import org.netbeans.modules.xml.xdm.diff.NodeInfo;
import org.netbeans.modules.xml.xdm.nodes.Attribute;
import org.netbeans.modules.xml.xdm.nodes.Document;
import org.netbeans.modules.xml.xdm.nodes.Node;
import org.netbeans.modules.xml.xdm.nodes.NodeImpl;
import org.netbeans.modules.xml.xdm.nodes.Token;
import org.netbeans.modules.xml.xdm.visitor.NodeByPositionVisitor;
import org.netbeans.modules.xml.xdm.visitor.PathFromRootVisitor;
import org.netbeans.modules.xml.xdm.visitor.PositionFinderVisitor;
import org.netbeans.modules.xml.xdm.visitor.XPathFinder;
import org.netbeans.modules.xml.xdm.xam.XDMListener;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;

public class XDMAccess
extends DocumentModelAccess {
    private final XDMModel xdmModel;
    private final AbstractDocumentModel model;
    private final XDMListener xdmListener;

    public XDMAccess(AbstractDocumentModel model) {
        this.xdmModel = new XDMModel(model.getModelSource());
        this.xdmModel.setPretty(true);
        this.model = model;
        this.xdmListener = new XDMListener(this.model);
        this.xdmModel.setQNameValuedAttributes(model.getQNameValuedAttributes());
    }

    public org.w3c.dom.Document getDocumentRoot() {
        return this.getReferenceModel().getCurrentDocument();
    }

    public void removeUndoableEditListener(UndoableEditListener listener) {
        this.xdmModel.removeUndoableEditListener(listener);
    }

    public void addUndoableEditListener(UndoableEditListener listener) {
        this.xdmModel.addUndoableEditListener(listener);
    }

    public AbstractDocumentModel getModel() {
        return this.model;
    }

    public XDMModel getReferenceModel() {
        return this.xdmModel;
    }

    public void flush() {
        this.xdmModel.flush();
    }

    public void prepareForUndoRedo() {
        this.xdmListener.startSync();
    }

    public void finishUndoRedo() {
        this.xdmListener.endSync(true);
    }

    public void prepareSync() {
        this.xdmModel.prepareSync();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public Model.State sync() throws IOException {
        Model.State state;
        block15: {
            boolean error;
            if (this.model.getRootComponent() == null) {
                this.xdmModel.sync();
                if (this.xdmModel.getStatus() == XDMModel.Status.STABLE) {
                    org.netbeans.modules.xml.xdm.nodes.Element root = (org.netbeans.modules.xml.xdm.nodes.Element)org.netbeans.modules.xml.xdm.nodes.Element.class.cast(this.xdmModel.getDocument().getDocumentElement());
                    if (root == null) {
                        throw new IOException("Cannot create model from non-XML document");
                    }
                    if (this.model.createRootComponent((Element)root) == null) {
                        throw new IOException("Cannot create model with " + new QName(root.getNamespaceURI(), root.getLocalName()));
                    }
                }
            } else {
                block14: {
                    error = true;
                    this.xdmListener.startSync();
                    XDMModel xDMModel = this.xdmModel;
                    // MONITORENTER : xDMModel
                    Document oldDoc = this.xdmModel.getCurrentDocument();
                    this.xdmModel.sync();
                    if (this.xdmListener.xamModelHasRoot()) break block14;
                    this.xdmModel.setDocument(oldDoc);
                    Model.State state2 = Model.State.NOT_WELL_FORMED;
                    // MONITOREXIT : xDMModel
                    this.xdmListener.endSync(!error);
                    return state2;
                }
                // MONITOREXIT : xDMModel
                error = false;
                this.xdmListener.endSync(!error);
            }
            break block15;
            catch (IllegalArgumentException ex) {
                try {
                    IOException ioe = new IOException();
                    ioe.initCause(ex);
                    throw ioe;
                }
                catch (Throwable throwable) {
                    this.xdmListener.endSync(!error);
                    throw throwable;
                }
            }
        }
        if (this.xdmModel.getStatus() == XDMModel.Status.STABLE) {
            state = Model.State.VALID;
            return state;
        }
        state = Model.State.NOT_WELL_FORMED;
        return state;
    }

    public boolean areSameNodes(org.w3c.dom.Node node1, org.w3c.dom.Node node2) {
        if (!(node1 instanceof NodeImpl) || !(node2 instanceof NodeImpl)) {
            return false;
        }
        NodeImpl n1 = (NodeImpl)node1;
        NodeImpl n2 = (NodeImpl)node2;
        boolean areSameNodes = n1.isEquivalentNode(n2);
        return areSameNodes;
    }

    private boolean compareTokens(NodeImpl n1, NodeImpl n2) {
        List<Token> n1Tokens = n1.getTokens();
        List<Token> n2Tokens = n2.getTokens();
        if (n1Tokens.size() != n2Tokens.size()) {
            return false;
        }
        for (int i = 0; i < n1Tokens.size(); ++i) {
            if (n1Tokens.get(i).getValue().equals(n2Tokens.get(i).getValue())) continue;
            return false;
        }
        NamedNodeMap n1Attrs = n1.getAttributes();
        NamedNodeMap n2Attrs = n2.getAttributes();
        if (n1Attrs.getLength() != n2Attrs.getLength()) {
            return false;
        }
        for (int i = 0; i < n1Attrs.getLength(); ++i) {
            List<Token> n1AttrTokens = ((NodeImpl)n1Attrs.item(i)).getTokens();
            List<Token> n2AttrTokens = ((NodeImpl)n2Attrs.item(i)).getTokens();
            if (n1AttrTokens.size() != n2AttrTokens.size()) {
                return false;
            }
            for (int j = 0; j < n1AttrTokens.size(); ++j) {
                if (n1AttrTokens.get(j).getValue().equals(n2AttrTokens.get(j).getValue())) continue;
                return false;
            }
        }
        return true;
    }

    public int getElementIndexOf(org.w3c.dom.Node parent, Element child) {
        if (child == null) {
            return -1;
        }
        int elementIndex = -1;
        for (int i = 0; i < parent.getChildNodes().getLength(); ++i) {
            org.w3c.dom.Node n = parent.getChildNodes().item(i);
            if (!(n instanceof org.netbeans.modules.xml.xdm.nodes.Element)) continue;
            ++elementIndex;
            if (!this.areSameNodes(n, child)) continue;
            return elementIndex;
        }
        return -1;
    }

    private boolean noMutations() {
        return this.model.inSync() && !this.model.startedFiringEvents() || this.model.inUndoRedo();
    }

    public void setAttribute(Element element, String name, String value, DocumentModelAccess.NodeUpdater updater) {
        if (this.noMutations()) {
            return;
        }
        if (element instanceof Node) {
            org.netbeans.modules.xml.xdm.nodes.Element xdmElem = (org.netbeans.modules.xml.xdm.nodes.Element)element;
            if (xdmElem.isInTree()) {
                updater.updateReference(this.xdmModel.setAttribute(xdmElem, name, value));
            } else {
                xdmElem.setAttribute(name, value);
            }
        } else {
            throw new IllegalArgumentException();
        }
    }

    public void removeAttribute(Element element, String name, DocumentModelAccess.NodeUpdater updater) {
        if (this.noMutations()) {
            return;
        }
        if (element instanceof Node) {
            org.netbeans.modules.xml.xdm.nodes.Element xdmElem = (org.netbeans.modules.xml.xdm.nodes.Element)element;
            if (xdmElem.isInTree()) {
                updater.updateReference(this.xdmModel.removeAttribute(xdmElem, name));
            } else {
                xdmElem.removeAttribute(name);
            }
        } else {
            throw new IllegalArgumentException();
        }
    }

    public void appendChild(org.w3c.dom.Node node, org.w3c.dom.Node newChild, DocumentModelAccess.NodeUpdater updater) {
        if (this.noMutations()) {
            return;
        }
        if (node instanceof Node && newChild instanceof Node) {
            Node xdmNode = (Node)node;
            if (xdmNode.isInTree()) {
                updater.updateReference(this.xdmModel.append(xdmNode, (Node)newChild));
            } else {
                xdmNode.appendChild(newChild);
            }
        } else {
            throw new IllegalArgumentException();
        }
    }

    public void insertBefore(org.w3c.dom.Node node, org.w3c.dom.Node newChild, org.w3c.dom.Node refChild, DocumentModelAccess.NodeUpdater updater) {
        if (this.noMutations()) {
            return;
        }
        if (node instanceof Node && newChild instanceof Node && refChild instanceof Node) {
            Node xdmNode = (Node)node;
            if (xdmNode.isInTree()) {
                updater.updateReference(this.xdmModel.insertBefore(xdmNode, (Node)newChild, (Node)refChild));
            } else {
                xdmNode.insertBefore(newChild, refChild);
            }
        } else {
            throw new IllegalArgumentException();
        }
    }

    public void removeChild(org.w3c.dom.Node node, org.w3c.dom.Node child, DocumentModelAccess.NodeUpdater updater) {
        if (this.noMutations()) {
            return;
        }
        if (node instanceof Node && child instanceof Node) {
            Node xdmNode = (Node)node;
            if (xdmNode.isInTree()) {
                updater.updateReference(this.xdmModel.remove(xdmNode, (Node)child));
            } else {
                xdmNode.removeChild(child);
            }
        } else {
            throw new IllegalArgumentException();
        }
    }

    public void removeChildren(org.w3c.dom.Node node, Collection<org.w3c.dom.Node> children, DocumentModelAccess.NodeUpdater updater) {
        if (this.noMutations()) {
            return;
        }
        if (node instanceof Node) {
            ArrayList<Node> nodes = new ArrayList<Node>();
            for (org.w3c.dom.Node n : children) {
                if (n instanceof Node) {
                    nodes.add((Node)n);
                    continue;
                }
                throw new IllegalArgumentException();
            }
            Node xdmNode = (Node)node;
            if (xdmNode.isInTree()) {
                updater.updateReference(this.xdmModel.removeChildNodes(xdmNode, nodes));
            } else {
                for (Node child : nodes) {
                    xdmNode.removeChild(child);
                }
            }
        } else {
            throw new IllegalArgumentException();
        }
    }

    public void replaceChild(org.w3c.dom.Node node, org.w3c.dom.Node child, org.w3c.dom.Node newChild, DocumentModelAccess.NodeUpdater updater) {
        if (this.noMutations()) {
            return;
        }
        Node xdmNode = (Node)node;
        if (xdmNode.isInTree()) {
            updater.updateReference(this.xdmModel.replaceChild(xdmNode, (Node)child, (Node)newChild));
        } else {
            xdmNode.replaceChild(newChild, child);
        }
    }

    public void setText(Element element, String val, DocumentModelAccess.NodeUpdater updater) {
        if (this.noMutations()) {
            return;
        }
        org.netbeans.modules.xml.xdm.nodes.Element xdmElem = (org.netbeans.modules.xml.xdm.nodes.Element)element;
        if (xdmElem.isInTree()) {
            updater.updateReference(this.xdmModel.setTextValue(xdmElem, val));
        } else {
            while (xdmElem.hasChildNodes()) {
                xdmElem.removeChild(xdmElem.getLastChild());
            }
            xdmElem.appendChild(this.xdmModel.getCurrentDocument().createTextNode(val));
        }
    }

    public String getXmlFragment(Element element) {
        if (element instanceof org.netbeans.modules.xml.xdm.nodes.Element) {
            org.netbeans.modules.xml.xdm.nodes.Element xdmElem = (org.netbeans.modules.xml.xdm.nodes.Element)element;
            return xdmElem.getXmlFragmentText();
        }
        throw new IllegalArgumentException();
    }

    public void setXmlFragment(Element element, String val, DocumentModelAccess.NodeUpdater updater) throws IOException {
        if (this.noMutations()) {
            return;
        }
        org.netbeans.modules.xml.xdm.nodes.Element xdmElem = (org.netbeans.modules.xml.xdm.nodes.Element)element;
        if (xdmElem.isInTree()) {
            updater.updateReference(this.xdmModel.setXmlFragmentText(xdmElem, val));
        } else {
            xdmElem.setXmlFragmentText(val);
        }
    }

    public void setPrefix(Element element, String prefix) {
        if (this.noMutations()) {
            return;
        }
        org.netbeans.modules.xml.xdm.nodes.Element xdmElement = (org.netbeans.modules.xml.xdm.nodes.Element)element;
        if (!xdmElement.isInTree()) {
            xdmElement.setPrefix(prefix);
        }
    }

    public int findPosition(org.w3c.dom.Node node) {
        return new PositionFinderVisitor().findPosition(this.xdmModel.getDocument(), (Node)node);
    }

    public org.netbeans.modules.xml.xdm.nodes.Element getContainingElement(int position) {
        try {
            return new NodeByPositionVisitor(this.xdmModel.getDocument()).getContainingElement(position);
        }
        catch (Exception ex) {
            return null;
        }
    }

    public Element duplicate(Element element) {
        return (Element)((Object)((org.netbeans.modules.xml.xdm.nodes.Element)element).copy());
    }

    public Map<QName, String> getAttributeMap(Element element) {
        AttributeMap<QName, String> qValues = new AttributeMap<QName, String>();
        NamedNodeMap attributes = element.getAttributes();
        for (int i = 0; i < attributes.getLength(); ++i) {
            Attribute attr = (Attribute)attributes.item(i);
            if (attr.isXmlnsAttribute()) continue;
            QName q = AbstractDocumentComponent.getQName((org.w3c.dom.Node)attr);
            ((AttributeMap)qValues).addKey(q);
            qValues.put(q, attr.getValue());
        }
        return qValues;
    }

    public List<Element> getPathFromRoot(org.w3c.dom.Document root, Element node) {
        List<Node> pathToRoot = new PathFromRootVisitor().findPath(root, node);
        if (pathToRoot == null) {
            return null;
        }
        ArrayList<Element> pathFromRoot = new ArrayList<Element>();
        for (Node n : pathToRoot) {
            if (!(n instanceof org.netbeans.modules.xml.xdm.nodes.Element)) break;
            pathFromRoot.add(0, (org.netbeans.modules.xml.xdm.nodes.Element)n);
        }
        return pathFromRoot;
    }

    public String getXPath(org.w3c.dom.Document root, Element node) {
        return XPathFinder.getXpath((Document)root, (Node)((Object)node));
    }

    public org.w3c.dom.Node findNode(org.w3c.dom.Document root, String xpath) {
        return new XPathFinder().findNode((Document)root, xpath);
    }

    public List<org.w3c.dom.Node> findNodes(org.w3c.dom.Document root, String xpath) {
        return XDMListener.toDomNodes(new XPathFinder().findNodes((Document)root, xpath));
    }

    public XDMModel getXDMModel() {
        return this.xdmModel;
    }

    public ElementIdentity getElementIdentity() {
        return this.getXDMModel().getElementIdentity();
    }

    public void addMergeEventHandler(PropertyChangeListener l) {
        this.xdmModel.addPropertyChangeListener(l);
    }

    public void removeMergeEventHandler(PropertyChangeListener l) {
        this.xdmModel.removePropertyChangeListener(l);
    }

    public org.w3c.dom.Node getOldEventParentNode(PropertyChangeEvent event) {
        NodeInfo oldInfo = (NodeInfo)event.getOldValue();
        return oldInfo != null ? oldInfo.getParent() : null;
    }

    public org.w3c.dom.Node getOldEventNode(PropertyChangeEvent event) {
        NodeInfo oldInfo = (NodeInfo)event.getOldValue();
        return oldInfo != null ? oldInfo.getNode() : null;
    }

    public org.w3c.dom.Node getNewEventParentNode(PropertyChangeEvent event) {
        NodeInfo newInfo = (NodeInfo)event.getNewValue();
        return newInfo != null ? newInfo.getParent() : null;
    }

    public org.w3c.dom.Node getNewEventNode(PropertyChangeEvent event) {
        NodeInfo newInfo = (NodeInfo)event.getNewValue();
        return newInfo != null ? newInfo.getNode() : null;
    }

    public String getIndentation() {
        return this.xdmModel.getIndentation();
    }

    public void setIndentation(String indentation) {
        this.xdmModel.setIndentation(indentation);
    }

    public void reorderChildren(Element element, int[] permutation, DocumentModelAccess.NodeUpdater updater) {
        if (this.noMutations()) {
            return;
        }
        org.netbeans.modules.xml.xdm.nodes.Element xdmElem = (org.netbeans.modules.xml.xdm.nodes.Element)element;
        if (xdmElem.isInTree()) {
            updater.updateReference(this.xdmModel.reorderChildren(xdmElem, permutation));
        } else {
            xdmElem.reorderChildren(permutation);
        }
    }

    public String getCurrentDocumentText() {
        return this.xdmModel.getCurrentDocumentText();
    }

    public void addQNameValuedAttributes(Map<QName, List<QName>> attributesMap) {
        HashMap<QName, List<QName>> map = new HashMap<QName, List<QName>>(this.xdmModel.getQNameValuedAttributes());
        map.putAll(attributesMap);
        this.xdmModel.setQNameValuedAttributes(map);
    }

    public class AttributeKeySet<E>
    extends HashSet<E> {
        List<E> keys = new ArrayList();

        public AttributeKeySet(List<E> keys) {
            this.keys = keys;
        }

        @Override
        public boolean isEmpty() {
            return this.keys.isEmpty();
        }

        @Override
        public boolean contains(Object key) {
            return this.keys.contains(key);
        }

        @Override
        public Iterator iterator() {
            return this.keys.iterator();
        }

        @Override
        public int size() {
            return this.keys.size();
        }
    }

    public class AttributeMap<K, V>
    extends HashMap<K, V> {
        List<K> keys = new ArrayList<K>();

        @Override
        public AttributeKeySet<K> keySet() {
            return new AttributeKeySet<K>(this.keys);
        }

        private void addKey(K q) {
            this.keys.add(q);
        }
    }
}

