/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.ui.models;

import java.util.Vector;
import org.netbeans.api.debugger.Breakpoint;
import org.netbeans.api.debugger.jpda.ClassLoadUnloadBreakpoint;
import org.netbeans.api.debugger.jpda.ExceptionBreakpoint;
import org.netbeans.api.debugger.jpda.FieldBreakpoint;
import org.netbeans.api.debugger.jpda.JPDABreakpoint;
import org.netbeans.api.debugger.jpda.LineBreakpoint;
import org.netbeans.api.debugger.jpda.MethodBreakpoint;
import org.netbeans.api.debugger.jpda.ThreadBreakpoint;
import org.netbeans.modules.debugger.jpda.ui.EditorContextBridge;
import org.netbeans.modules.debugger.jpda.ui.models.BoldVariablesTableModelFilterFirst;
import org.netbeans.modules.debugger.jpda.ui.models.BreakpointsTreeModelFilter;
import org.netbeans.spi.viewmodel.ModelEvent;
import org.netbeans.spi.viewmodel.ModelListener;
import org.netbeans.spi.viewmodel.NodeModel;
import org.netbeans.spi.viewmodel.UnknownTypeException;
import org.openide.util.NbBundle;

public class BreakpointsNodeModel
implements NodeModel {
    public static final String BREAKPOINT = "org/netbeans/modules/debugger/resources/breakpointsView/NonLineBreakpoint";
    public static final String LINE_BREAKPOINT = "org/netbeans/modules/debugger/resources/breakpointsView/Breakpoint";
    public static final String CURRENT_BREAKPOINT = "org/netbeans/modules/debugger/resources/breakpointsView/NonLineBreakpointHit";
    public static final String CURRENT_LINE_BREAKPOINT = "org/netbeans/modules/debugger/resources/breakpointsView/BreakpointHit";
    public static final String DISABLED_BREAKPOINT = "org/netbeans/modules/debugger/resources/breakpointsView/DisabledNonLineBreakpoint";
    public static final String DISABLED_LINE_BREAKPOINT = "org/netbeans/modules/debugger/resources/breakpointsView/DisabledBreakpoint";
    public static final String DISABLED_CURRENT_BREAKPOINT = "org/netbeans/modules/debugger/resources/breakpointsView/DisabledNonLineBreakpointHit";
    public static final String DISABLED_CURRENT_LINE_BREAKPOINT = "org/netbeans/modules/debugger/resources/breakpointsView/DisabledBreakpointHit";
    public static final String LINE_CONDITIONAL_BREAKPOINT = "org/netbeans/modules/debugger/resources/breakpointsView/ConditionalBreakpoint";
    public static final String CURRENT_LINE_CONDITIONAL_BREAKPOINT = "org/netbeans/modules/debugger/resources/breakpointsView/ConditionalBreakpointHit";
    public static final String DISABLED_LINE_CONDITIONAL_BREAKPOINT = "org/netbeans/modules/debugger/resources/breakpointsView/DisabledConditionalBreakpoint";
    private Vector listeners = new Vector();
    private static final String ZEROS = "            ";
    private JPDABreakpoint currentBreakpoint;

    static int log10(int n) {
        int n2 = 1;
        while ((n /= 10) > 0) {
            ++n2;
        }
        return n2;
    }

    static String zeros(int n) {
        if (n < ZEROS.length()) {
            return ZEROS.substring(0, n);
        }
        String string = ZEROS;
        while (string.length() < n) {
            string = string + " ";
        }
        return string;
    }

    public String getDisplayName(Object object) throws UnknownTypeException {
        if (object instanceof LineBreakpoint) {
            int n;
            int n2;
            LineBreakpoint lineBreakpoint = (LineBreakpoint)object;
            int n3 = lineBreakpoint.getLineNumber();
            String string = Integer.toString(n3);
            Integer n4 = (Integer)BreakpointsTreeModelFilter.MAX_LINES.get(lineBreakpoint);
            if (n4 != null && (n2 = BreakpointsNodeModel.log10(n = n4.intValue()) - BreakpointsNodeModel.log10(n3)) > 0) {
                string = BreakpointsNodeModel.zeros(n2) + string;
            }
            return this.bold((JPDABreakpoint)lineBreakpoint, NbBundle.getMessage(BreakpointsNodeModel.class, (String)"CTL_Line_Breakpoint", (Object)EditorContextBridge.getFileName(lineBreakpoint), (Object)string));
        }
        if (object instanceof ThreadBreakpoint) {
            ThreadBreakpoint threadBreakpoint = (ThreadBreakpoint)object;
            if (threadBreakpoint.getBreakpointType() == 1) {
                return this.bold((JPDABreakpoint)threadBreakpoint, NbBundle.getMessage(BreakpointsNodeModel.class, (String)"CTL_Thread_Started_Breakpoint"));
            }
            if (threadBreakpoint.getBreakpointType() == 2) {
                return this.bold((JPDABreakpoint)threadBreakpoint, NbBundle.getMessage(BreakpointsNodeModel.class, (String)"CTL_Thread_Death_Breakpoint"));
            }
            return this.bold((JPDABreakpoint)threadBreakpoint, NbBundle.getMessage(BreakpointsNodeModel.class, (String)"CTL_Thread_Breakpoint"));
        }
        if (object instanceof FieldBreakpoint) {
            FieldBreakpoint fieldBreakpoint = (FieldBreakpoint)object;
            if (fieldBreakpoint.getBreakpointType() == 1) {
                return this.bold((JPDABreakpoint)fieldBreakpoint, NbBundle.getMessage(BreakpointsNodeModel.class, (String)"CTL_Field_Access_Breakpoint", (Object)BreakpointsNodeModel.getShort(fieldBreakpoint.getClassName()), (Object)fieldBreakpoint.getFieldName()));
            }
            if (fieldBreakpoint.getBreakpointType() == 2) {
                return this.bold((JPDABreakpoint)fieldBreakpoint, NbBundle.getMessage(BreakpointsNodeModel.class, (String)"CTL_Field_Modification_Breakpoint", (Object)BreakpointsNodeModel.getShort(fieldBreakpoint.getClassName()), (Object)fieldBreakpoint.getFieldName()));
            }
            return this.bold((JPDABreakpoint)fieldBreakpoint, NbBundle.getMessage(BreakpointsNodeModel.class, (String)"CTL_Field_Access_or_Modification_Breakpoint", (Object)BreakpointsNodeModel.getShort(fieldBreakpoint.getClassName()), (Object)fieldBreakpoint.getFieldName()));
        }
        if (object instanceof MethodBreakpoint) {
            MethodBreakpoint methodBreakpoint = (MethodBreakpoint)object;
            String string = "";
            String[] stringArray = methodBreakpoint.getClassFilters();
            if (stringArray.length > 0) {
                string = stringArray[0];
            }
            if ("".equals(methodBreakpoint.getMethodName())) {
                return this.bold((JPDABreakpoint)methodBreakpoint, NbBundle.getMessage(BreakpointsNodeModel.class, (String)"CTL_All_Methods_Breakpoint", (Object)BreakpointsNodeModel.getShort(string)));
            }
            return this.bold((JPDABreakpoint)methodBreakpoint, NbBundle.getMessage(BreakpointsNodeModel.class, (String)"CTL_Method_Breakpoint", (Object)BreakpointsNodeModel.getShort(string), (Object)methodBreakpoint.getMethodName()));
        }
        if (object instanceof ClassLoadUnloadBreakpoint) {
            ClassLoadUnloadBreakpoint classLoadUnloadBreakpoint = (ClassLoadUnloadBreakpoint)object;
            String string = "";
            String[] stringArray = classLoadUnloadBreakpoint.getClassFilters();
            if (stringArray.length > 0) {
                string = stringArray[0];
            } else {
                stringArray = classLoadUnloadBreakpoint.getClassExclusionFilters();
                if (stringArray.length > 0) {
                    string = stringArray[0];
                }
            }
            if (classLoadUnloadBreakpoint.getBreakpointType() == 1) {
                return this.bold((JPDABreakpoint)classLoadUnloadBreakpoint, NbBundle.getMessage(BreakpointsNodeModel.class, (String)"CTL_Class_Loaded_Breakpoint", (Object)BreakpointsNodeModel.getShort(string)));
            }
            if (classLoadUnloadBreakpoint.getBreakpointType() == 2) {
                return this.bold((JPDABreakpoint)classLoadUnloadBreakpoint, NbBundle.getMessage(BreakpointsNodeModel.class, (String)"CTL_Class_Unloaded_Breakpoint", (Object)BreakpointsNodeModel.getShort(string)));
            }
            return this.bold((JPDABreakpoint)classLoadUnloadBreakpoint, NbBundle.getMessage(BreakpointsNodeModel.class, (String)"CTL_Class_Breakpoint", (Object)BreakpointsNodeModel.getShort(string)));
        }
        if (object instanceof ExceptionBreakpoint) {
            ExceptionBreakpoint exceptionBreakpoint = (ExceptionBreakpoint)object;
            if (exceptionBreakpoint.getCatchType() == 1) {
                return this.bold((JPDABreakpoint)exceptionBreakpoint, NbBundle.getMessage(BreakpointsNodeModel.class, (String)"CTL_Exception_Catched_Breakpoint", (Object)BreakpointsNodeModel.getShort(exceptionBreakpoint.getExceptionClassName())));
            }
            if (exceptionBreakpoint.getCatchType() == 2) {
                return this.bold((JPDABreakpoint)exceptionBreakpoint, NbBundle.getMessage(BreakpointsNodeModel.class, (String)"CTL_Exception_Uncatched_Breakpoint", (Object)BreakpointsNodeModel.getShort(exceptionBreakpoint.getExceptionClassName())));
            }
            return this.bold((JPDABreakpoint)exceptionBreakpoint, NbBundle.getMessage(BreakpointsNodeModel.class, (String)"CTL_Exception_Breakpoint", (Object)BreakpointsNodeModel.getShort(exceptionBreakpoint.getExceptionClassName())));
        }
        throw new UnknownTypeException(object);
    }

    public String getShortDescription(Object object) throws UnknownTypeException {
        String string;
        String[] stringArray;
        String string2;
        String string3 = null;
        if (object instanceof Breakpoint) {
            boolean bl = false;
            boolean bl2 = false;
            string2 = null;
            stringArray = (String[])object;
            Breakpoint.VALIDITY vALIDITY = stringArray.getValidity();
            bl = vALIDITY == Breakpoint.VALIDITY.VALID;
            bl2 = vALIDITY == Breakpoint.VALIDITY.INVALID;
            string2 = stringArray.getValidityMessage();
            if (bl) {
                string3 = NbBundle.getMessage(BreakpointsNodeModel.class, (String)"CTL_APPEND_BP_Valid");
            }
            if (bl2) {
                string3 = string2 != null ? NbBundle.getMessage(BreakpointsNodeModel.class, (String)"CTL_APPEND_BP_Invalid_with_reason", (Object)string2) : NbBundle.getMessage(BreakpointsNodeModel.class, (String)"CTL_APPEND_BP_Invalid");
            }
        }
        if (object instanceof LineBreakpoint) {
            string = NbBundle.getMessage(BreakpointsNodeModel.class, (String)"CTL_Line_Breakpoint", (Object)EditorContextBridge.getFileName((LineBreakpoint)object), (Object)String.valueOf(((LineBreakpoint)object).getLineNumber()));
        } else if (object instanceof ThreadBreakpoint) {
            ThreadBreakpoint threadBreakpoint = (ThreadBreakpoint)object;
            string = threadBreakpoint.getBreakpointType() == 1 ? NbBundle.getMessage(BreakpointsNodeModel.class, (String)"CTL_Thread_Started_Breakpoint") : (threadBreakpoint.getBreakpointType() == 2 ? NbBundle.getMessage(BreakpointsNodeModel.class, (String)"CTL_Thread_Death_Breakpoint") : NbBundle.getMessage(BreakpointsNodeModel.class, (String)"CTL_Thread_Breakpoint"));
        } else if (object instanceof FieldBreakpoint) {
            FieldBreakpoint fieldBreakpoint = (FieldBreakpoint)object;
            string = fieldBreakpoint.getBreakpointType() == 1 ? NbBundle.getMessage(BreakpointsNodeModel.class, (String)"CTL_Field_Access_Breakpoint", (Object)fieldBreakpoint.getClassName(), (Object)fieldBreakpoint.getFieldName()) : (fieldBreakpoint.getBreakpointType() == 2 ? NbBundle.getMessage(BreakpointsNodeModel.class, (String)"CTL_Field_Modification_Breakpoint", (Object)fieldBreakpoint.getClassName(), (Object)fieldBreakpoint.getFieldName()) : NbBundle.getMessage(BreakpointsNodeModel.class, (String)"CTL_Field_Access_or_Modification_Breakpoint", (Object)fieldBreakpoint.getClassName(), (Object)fieldBreakpoint.getFieldName()));
        } else if (object instanceof MethodBreakpoint) {
            MethodBreakpoint methodBreakpoint = (MethodBreakpoint)object;
            string2 = "";
            stringArray = methodBreakpoint.getClassFilters();
            if (stringArray.length > 0) {
                string2 = stringArray[0];
            }
            string = "".equals(methodBreakpoint.getMethodName()) ? NbBundle.getMessage(BreakpointsNodeModel.class, (String)"CTL_All_Methods_Breakpoint", (Object)string2) : NbBundle.getMessage(BreakpointsNodeModel.class, (String)"CTL_Method_Breakpoint", (Object)string2, (Object)methodBreakpoint.getMethodName());
        } else if (object instanceof ClassLoadUnloadBreakpoint) {
            ClassLoadUnloadBreakpoint classLoadUnloadBreakpoint = (ClassLoadUnloadBreakpoint)object;
            string2 = "";
            stringArray = classLoadUnloadBreakpoint.getClassFilters();
            if (stringArray.length > 0) {
                string2 = stringArray[0];
            } else {
                stringArray = classLoadUnloadBreakpoint.getClassExclusionFilters();
                if (stringArray.length > 0) {
                    string2 = stringArray[0];
                }
            }
            string = classLoadUnloadBreakpoint.getBreakpointType() == 1 ? NbBundle.getMessage(BreakpointsNodeModel.class, (String)"CTL_Class_Loaded_Breakpoint", (Object)string2) : (classLoadUnloadBreakpoint.getBreakpointType() == 2 ? NbBundle.getMessage(BreakpointsNodeModel.class, (String)"CTL_Class_Unloaded_Breakpoint", (Object)string2) : NbBundle.getMessage(BreakpointsNodeModel.class, (String)"CTL_Class_Breakpoint", (Object)string2));
        } else if (object instanceof ExceptionBreakpoint) {
            ExceptionBreakpoint exceptionBreakpoint = (ExceptionBreakpoint)object;
            string = exceptionBreakpoint.getCatchType() == 1 ? NbBundle.getMessage(BreakpointsNodeModel.class, (String)"CTL_Exception_Catched_Breakpoint", (Object)exceptionBreakpoint.getExceptionClassName()) : (exceptionBreakpoint.getCatchType() == 2 ? NbBundle.getMessage(BreakpointsNodeModel.class, (String)"CTL_Exception_Uncatched_Breakpoint", (Object)exceptionBreakpoint.getExceptionClassName()) : NbBundle.getMessage(BreakpointsNodeModel.class, (String)"CTL_Exception_Breakpoint", (Object)exceptionBreakpoint.getExceptionClassName()));
        } else {
            throw new UnknownTypeException(object);
        }
        if (string3 != null) {
            string = string + " " + string3;
        }
        return string;
    }

    public String getIconBase(Object object) throws UnknownTypeException {
        boolean bl;
        boolean bl2 = this.currentBreakpoint == object;
        boolean bl3 = !((Breakpoint)object).isEnabled();
        boolean bl4 = bl = ((Breakpoint)object).getValidity() == Breakpoint.VALIDITY.INVALID;
        if (object instanceof LineBreakpoint) {
            boolean bl5;
            String string = ((LineBreakpoint)object).getCondition();
            boolean bl6 = bl5 = string != null && string.trim().length() > 0;
            String string2 = bl2 ? (bl3 ? (bl5 ? DISABLED_LINE_CONDITIONAL_BREAKPOINT : DISABLED_CURRENT_LINE_BREAKPOINT) : (bl5 ? CURRENT_LINE_CONDITIONAL_BREAKPOINT : CURRENT_LINE_BREAKPOINT)) : (bl3 ? (bl5 ? DISABLED_LINE_CONDITIONAL_BREAKPOINT : DISABLED_LINE_BREAKPOINT) : (bl5 ? LINE_CONDITIONAL_BREAKPOINT : LINE_BREAKPOINT));
            if (bl && !bl3) {
                string2 = string2 + "_broken";
            }
            return string2;
        }
        if (object instanceof ThreadBreakpoint || object instanceof FieldBreakpoint || object instanceof MethodBreakpoint || object instanceof ClassLoadUnloadBreakpoint || object instanceof ExceptionBreakpoint) {
            String string;
            if (bl2) {
                string = bl3 ? DISABLED_CURRENT_BREAKPOINT : CURRENT_BREAKPOINT;
            } else if (bl3) {
                string = DISABLED_BREAKPOINT;
            } else {
                string = BREAKPOINT;
                if (bl) {
                    string = string + "_broken";
                }
            }
            return string;
        }
        throw new UnknownTypeException(object);
    }

    public void addModelListener(ModelListener modelListener) {
        this.listeners.add(modelListener);
    }

    public void removeModelListener(ModelListener modelListener) {
        this.listeners.remove(modelListener);
    }

    private void fireNodeChanged(JPDABreakpoint jPDABreakpoint) {
        Vector vector = (Vector)this.listeners.clone();
        int n = vector.size();
        for (int i = 0; i < n; ++i) {
            ((ModelListener)vector.get(i)).modelChanged((ModelEvent)new ModelEvent.NodeChanged((Object)this, (Object)jPDABreakpoint));
        }
    }

    static String getShort(String string) {
        if (string.indexOf(42) >= 0) {
            return string;
        }
        int n = string.lastIndexOf(46);
        if (n < 0) {
            return string;
        }
        return string.substring(n + 1);
    }

    private String bold(JPDABreakpoint jPDABreakpoint, String string) {
        return jPDABreakpoint == this.currentBreakpoint ? BoldVariablesTableModelFilterFirst.toHTML(string, true, false, null) : string;
    }

    public void setCurrentBreakpoint(JPDABreakpoint jPDABreakpoint) {
        JPDABreakpoint jPDABreakpoint2 = this.currentBreakpoint;
        this.currentBreakpoint = jPDABreakpoint;
        if (jPDABreakpoint2 != null) {
            this.fireNodeChanged(jPDABreakpoint2);
        }
        if (jPDABreakpoint != null) {
            this.fireNodeChanged(jPDABreakpoint);
        }
    }
}

