/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.tomcat5.nodes.actions;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.netbeans.modules.tomcat5.nodes.TomcatWebModule;
import org.netbeans.modules.tomcat5.nodes.actions.RefreshWebModulesCookie;
import org.netbeans.modules.tomcat5.nodes.actions.TomcatWebModuleCookie;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.Parameters;
import org.openide.util.RequestProcessor;
import org.openide.util.actions.NodeAction;

public class UndeployAction
extends NodeAction {
    private static RequestProcessor rp;

    private static synchronized RequestProcessor rp() {
        if (rp == null) {
            rp = new RequestProcessor("Tomcat app undeployment", 1);
        }
        return rp;
    }

    public String getName() {
        return NbBundle.getMessage(UndeployAction.class, (String)"LBL_UndeployAction");
    }

    protected void performAction(Node[] nodeArray) {
        NodeRefreshTask nodeRefreshTask = new NodeRefreshTask(UndeployAction.rp());
        for (int i = 0; i < nodeArray.length; ++i) {
            TomcatWebModuleCookie tomcatWebModuleCookie = (TomcatWebModuleCookie)nodeArray[i].getCookie(TomcatWebModuleCookie.class);
            if (tomcatWebModuleCookie == null) continue;
            RequestProcessor.Task task = tomcatWebModuleCookie.undeploy();
            nodeRefreshTask.addPrerequisity(nodeArray[i].getParentNode(), task);
        }
        UndeployAction.rp().post((Runnable)nodeRefreshTask);
    }

    protected boolean asynchronous() {
        return false;
    }

    public HelpCtx getHelpCtx() {
        return null;
    }

    protected boolean enable(Node[] nodeArray) {
        for (int i = 0; i < nodeArray.length; ++i) {
            TomcatWebModule tomcatWebModule = (TomcatWebModule)nodeArray[i].getLookup().lookup(TomcatWebModule.class);
            if (tomcatWebModule == null || !"/manager".equals(tomcatWebModule.getTomcatModule().getPath())) continue;
            return false;
        }
        return true;
    }

    private static class NodeRefreshTask
    implements Runnable {
        private final RequestProcessor requestProcessor;
        private Map<Node, Set<RequestProcessor.Task>> taskMap = new HashMap<Node, Set<RequestProcessor.Task>>();

        public NodeRefreshTask(RequestProcessor requestProcessor) {
            Parameters.notNull((CharSequence)"requestProcessor", this.taskMap);
            this.requestProcessor = requestProcessor;
        }

        public synchronized void addPrerequisity(Node node, RequestProcessor.Task task) {
            Parameters.notNull((CharSequence)"node", (Object)node);
            Parameters.notNull((CharSequence)"task", (Object)task);
            Set<RequestProcessor.Task> set = this.taskMap.get(node);
            if (set == null) {
                set = new HashSet<RequestProcessor.Task>();
                this.taskMap.put(node, set);
            }
            set.add(task);
        }

        @Override
        public synchronized void run() {
            for (Map.Entry<Node, Set<RequestProcessor.Task>> entry : this.taskMap.entrySet()) {
                final Node node = entry.getKey();
                final Set<RequestProcessor.Task> set = entry.getValue();
                this.requestProcessor.post(new Runnable(){

                    @Override
                    public void run() {
                        for (RequestProcessor.Task task : set) {
                            task.waitFinished();
                        }
                        NodeRefreshTask.this.refresh(node);
                    }
                });
            }
        }

        private void refresh(Node node) {
            if (node == null) {
                return;
            }
            RefreshWebModulesCookie refreshWebModulesCookie = (RefreshWebModulesCookie)node.getLookup().lookup(RefreshWebModulesCookie.class);
            if (refreshWebModulesCookie != null) {
                refreshWebModulesCookie.refresh();
            }
        }
    }
}

