/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.tomcat5.nodes;

import java.util.Comparator;
import javax.enterprise.deploy.shared.CommandType;
import javax.enterprise.deploy.shared.StateType;
import javax.enterprise.deploy.spi.DeploymentManager;
import javax.enterprise.deploy.spi.TargetModuleID;
import javax.enterprise.deploy.spi.status.DeploymentStatus;
import javax.enterprise.deploy.spi.status.ProgressEvent;
import javax.enterprise.deploy.spi.status.ProgressListener;
import javax.enterprise.deploy.spi.status.ProgressObject;
import org.netbeans.modules.tomcat5.TomcatManager;
import org.netbeans.modules.tomcat5.TomcatModule;
import org.netbeans.modules.tomcat5.nodes.TomcatWebModuleNode;
import org.netbeans.modules.tomcat5.nodes.actions.TomcatWebModuleCookie;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.StatusDisplayer;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;
import org.openide.util.Parameters;
import org.openide.util.RequestProcessor;

public class TomcatWebModule
implements TomcatWebModuleCookie {
    public static final Comparator<TomcatWebModule> TOMCAT_WEB_MODULE_COMPARATOR = new Comparator<TomcatWebModule>(){

        @Override
        public int compare(TomcatWebModule tomcatWebModule, TomcatWebModule tomcatWebModule2) {
            return tomcatWebModule.getTomcatModule().getModuleID().compareTo(tomcatWebModule2.getTomcatModule().getModuleID());
        }
    };
    private final TomcatModule tomcatModule;
    private final TomcatManager manager;
    private volatile boolean isRunning;
    private Node node;
    private final TargetModuleID[] target;

    public TomcatWebModule(DeploymentManager deploymentManager, TomcatModule tomcatModule, boolean bl) {
        this.tomcatModule = tomcatModule;
        this.manager = (TomcatManager)deploymentManager;
        this.isRunning = bl;
        this.target = new TargetModuleID[]{tomcatModule};
    }

    public TomcatModule getTomcatModule() {
        return this.tomcatModule;
    }

    public void setRepresentedNode(Node node) {
        this.node = node;
    }

    public Node getRepresentedNode() {
        return this.node;
    }

    public DeploymentManager getDeploymentManager() {
        return this.manager;
    }

    @Override
    public RequestProcessor.Task undeploy() {
        return RequestProcessor.getDefault().post(new Runnable(){

            @Override
            public void run() {
                StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage(TomcatWebModule.class, (String)"MSG_START_UNDEPLOY", (Object[])new Object[]{TomcatWebModule.this.getTomcatModule().getPath()}));
                ProgressObject progressObject = TomcatWebModule.this.manager.undeploy(TomcatWebModule.this.target);
                TomcatProgressListener tomcatProgressListener = new TomcatProgressListener(progressObject);
                progressObject.addProgressListener((ProgressListener)tomcatProgressListener);
                tomcatProgressListener.updateState();
                CompletionWait completionWait = new CompletionWait(progressObject);
                completionWait.init();
                completionWait.waitFinished();
            }
        }, 0);
    }

    @Override
    public void start() {
        RequestProcessor.getDefault().post(new Runnable(){

            @Override
            public void run() {
                StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage(TomcatWebModule.class, (String)"MSG_START_STARTING", (Object[])new Object[]{TomcatWebModule.this.getTomcatModule().getPath()}));
                ProgressObject progressObject = TomcatWebModule.this.manager.start(TomcatWebModule.this.target);
                TomcatProgressListener tomcatProgressListener = new TomcatProgressListener(progressObject);
                progressObject.addProgressListener((ProgressListener)tomcatProgressListener);
                tomcatProgressListener.updateState();
            }
        }, 0);
    }

    @Override
    public void stop() {
        RequestProcessor.getDefault().post(new Runnable(){

            @Override
            public void run() {
                StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage(TomcatWebModule.class, (String)"MSG_START_STOPPING", (Object[])new Object[]{TomcatWebModule.this.getTomcatModule().getPath()}));
                ProgressObject progressObject = TomcatWebModule.this.manager.stop(TomcatWebModule.this.target);
                TomcatProgressListener tomcatProgressListener = new TomcatProgressListener(progressObject);
                progressObject.addProgressListener((ProgressListener)tomcatProgressListener);
                tomcatProgressListener.updateState();
            }
        }, 0);
    }

    @Override
    public boolean isRunning() {
        return this.isRunning;
    }

    private String constructDisplayName() {
        if (this.isRunning()) {
            return this.getTomcatModule().getPath();
        }
        return this.getTomcatModule().getPath() + " [" + NbBundle.getMessage(TomcatWebModuleNode.class, (String)"LBL_Stopped") + "]";
    }

    @Override
    public void openLog() {
        this.manager.logManager().openContextLog(this.tomcatModule);
    }

    @Override
    public boolean hasLogger() {
        return this.manager.logManager().hasContextLogger(this.tomcatModule);
    }

    private static class CompletionWait
    implements ProgressListener {
        private final ProgressObject progressObject;
        private boolean completed;

        public CompletionWait(ProgressObject progressObject) {
            Parameters.notNull((CharSequence)"progressObject", (Object)progressObject);
            this.progressObject = progressObject;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void init() {
            CompletionWait completionWait = this;
            synchronized (completionWait) {
                this.progressObject.addProgressListener((ProgressListener)this);
                this.handleProgressEvent(null);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handleProgressEvent(ProgressEvent progressEvent) {
            CompletionWait completionWait = this;
            synchronized (completionWait) {
                DeploymentStatus deploymentStatus = this.progressObject.getDeploymentStatus();
                if (deploymentStatus.isCompleted() || deploymentStatus.isFailed()) {
                    this.completed = true;
                    this.notifyAll();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void waitFinished() {
            CompletionWait completionWait = this;
            synchronized (completionWait) {
                if (this.completed) {
                    return;
                }
                while (!this.completed) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        }
    }

    private class TomcatProgressListener
    implements ProgressListener {
        private final ProgressObject progressObject;
        private boolean finished;

        public TomcatProgressListener(ProgressObject progressObject) {
            this.progressObject = progressObject;
        }

        public void handleProgressEvent(ProgressEvent progressEvent) {
            this.updateState();
        }

        public synchronized void updateState() {
            if (this.finished) {
                return;
            }
            DeploymentStatus deploymentStatus = this.progressObject.getDeploymentStatus();
            if (deploymentStatus == null) {
                return;
            }
            if (deploymentStatus.isCompleted() || deploymentStatus.isFailed()) {
                this.finished = true;
            }
            if (deploymentStatus.getState() == StateType.COMPLETED) {
                CommandType commandType = deploymentStatus.getCommand();
                if (commandType == CommandType.START || commandType == CommandType.STOP) {
                    StatusDisplayer.getDefault().setStatusText(deploymentStatus.getMessage());
                    if (commandType == CommandType.START) {
                        TomcatWebModule.this.isRunning = true;
                    } else {
                        TomcatWebModule.this.isRunning = false;
                    }
                    TomcatWebModule.this.node.setDisplayName(TomcatWebModule.this.constructDisplayName());
                } else if (commandType == CommandType.UNDEPLOY) {
                    StatusDisplayer.getDefault().setStatusText(deploymentStatus.getMessage());
                }
            } else if (deploymentStatus.getState() == StateType.FAILED) {
                NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)deploymentStatus.getMessage(), 0);
                DialogDisplayer.getDefault().notify((NotifyDescriptor)message);
                StatusDisplayer.getDefault().setStatusText(deploymentStatus.getMessage());
            }
        }
    }
}

