/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.hints;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.prefs.Preferences;
import javax.swing.JComponent;
import org.jrubyparser.ast.INameNode;
import org.jrubyparser.ast.IfNode;
import org.jrubyparser.ast.Node;
import org.jrubyparser.ast.NodeType;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Utilities;
import org.netbeans.modules.csl.api.EditList;
import org.netbeans.modules.csl.api.Hint;
import org.netbeans.modules.csl.api.HintSeverity;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.csl.api.PreviewableFix;
import org.netbeans.modules.csl.api.Rule;
import org.netbeans.modules.csl.api.RuleContext;
import org.netbeans.modules.csl.spi.ParserResult;
import org.netbeans.modules.parsing.spi.Parser;
import org.netbeans.modules.ruby.AstPath;
import org.netbeans.modules.ruby.AstUtilities;
import org.netbeans.modules.ruby.ParseTreeVisitor;
import org.netbeans.modules.ruby.ParseTreeWalker;
import org.netbeans.modules.ruby.RubyUtils;
import org.netbeans.modules.ruby.hints.infrastructure.RubyAstRule;
import org.netbeans.modules.ruby.hints.infrastructure.RubyRuleContext;
import org.netbeans.modules.ruby.lexer.LexUtilities;
import org.openide.util.NbBundle;

public class AccidentalAssignment
extends RubyAstRule {
    @Override
    public Set<NodeType> getKinds() {
        return Collections.singleton(NodeType.IFNODE);
    }

    @Override
    public void run(RubyRuleContext context, List<Hint> result) {
        Node node = context.node;
        AstPath path = context.path;
        ParserResult parserResult = context.parserResult;
        IfNode ifNode = (IfNode)node;
        Node condition = ifNode.getCondition();
        if (condition != null) {
            if (condition.getNodeType() == NodeType.NEWLINENODE) {
                List children = condition.childNodes();
                if (children.size() == 0) {
                    return;
                }
                condition = (Node)children.get(0);
            }
            if (condition.getNodeType() == NodeType.LOCALASGNNODE && !this.isFirstUsage(path, condition) || condition.getNodeType() == NodeType.ATTRASSIGNNODE) {
                String displayName = NbBundle.getMessage(AccidentalAssignment.class, (String)"AccidentalAssignment");
                OffsetRange range = AstUtilities.getRange((Node)condition);
                if ((range = LexUtilities.getLexerOffsets((Parser.Result)parserResult, (OffsetRange)range)) != OffsetRange.NONE) {
                    ArrayList<ConvertAssignmentFix> fixList = new ArrayList<ConvertAssignmentFix>(2);
                    fixList.add(new ConvertAssignmentFix(context, condition));
                    Hint desc = new Hint((Rule)this, displayName, RubyUtils.getFileObject((Parser.Result)parserResult), range, fixList, 600);
                    result.add(desc);
                }
            }
        }
    }

    private boolean isFirstUsage(AstPath path, Node node) {
        DeclarationFinder finder = new DeclarationFinder(node);
        Node method = AstUtilities.findLocalScope((Node)node, (AstPath)path);
        new ParseTreeWalker((ParseTreeVisitor)finder).walk(method);
        return finder.isDeclaration();
    }

    public String getId() {
        return "AccidentalAssignment";
    }

    public String getDescription() {
        return NbBundle.getMessage(AccidentalAssignment.class, (String)"AccidentalAssignmentDesc");
    }

    public boolean getDefaultEnabled() {
        return true;
    }

    public JComponent getCustomizer(Preferences node) {
        return null;
    }

    public boolean appliesTo(RuleContext context) {
        return true;
    }

    public String getDisplayName() {
        return NbBundle.getMessage(AccidentalAssignment.class, (String)"AccidentalAssignment");
    }

    public boolean showInTasklist() {
        return true;
    }

    public HintSeverity getDefaultSeverity() {
        return HintSeverity.WARNING;
    }

    public class DeclarationFinder
    implements ParseTreeVisitor {
        private Node target;
        private Set<String> names = new HashSet<String>();
        private boolean found;

        DeclarationFinder(Node target) {
            this.target = target;
        }

        public boolean isDeclaration() {
            return !this.found;
        }

        public boolean visit(Node node) {
            String name;
            if (node == this.target && this.names.contains(name = ((INameNode)node).getName())) {
                this.found = true;
                return true;
            }
            switch (node.getNodeType()) {
                case LOCALVARNODE: {
                    this.names.add(((INameNode)node).getName());
                    break;
                }
                case DVARNODE: {
                    this.names.add(((INameNode)node).getName());
                }
            }
            return false;
        }

        public boolean unvisit(Node node) {
            switch (node.getNodeType()) {
                case LOCALASGNNODE: {
                    this.names.add(((INameNode)node).getName());
                    break;
                }
                case DASGNNODE: {
                    this.names.add(((INameNode)node).getName());
                }
            }
            return node == this.target;
        }
    }

    private static class ConvertAssignmentFix
    implements PreviewableFix {
        private final RubyRuleContext context;
        private final Node assignment;

        public ConvertAssignmentFix(RubyRuleContext context, Node assignment) {
            this.context = context;
            this.assignment = assignment;
        }

        public String getDescription() {
            return NbBundle.getMessage(AccidentalAssignment.class, (String)"AccidentalAssignmentFix");
        }

        public void implement() throws Exception {
            EditList edits = this.getEditList();
            if (edits != null) {
                edits.apply();
            }
        }

        public EditList getEditList() throws Exception {
            int lineEnd;
            String line;
            int dashIndex;
            BaseDocument doc = this.context.doc;
            OffsetRange range = AstUtilities.getNameRange((Node)this.assignment);
            int endOffset = range.getEnd();
            if (this.assignment.getNodeType() == NodeType.ATTRASSIGNNODE) {
                endOffset = range.getStart();
            }
            if ((dashIndex = (line = doc.getText(endOffset, (lineEnd = Utilities.getRowEnd((BaseDocument)doc, (int)endOffset)) - endOffset)).indexOf(61)) != -1) {
                return new EditList(doc).replace(endOffset + dashIndex, 0, "=", false, 0);
            }
            return null;
        }

        public boolean isSafe() {
            return false;
        }

        public boolean isInteractive() {
            return false;
        }

        public boolean canPreview() {
            return true;
        }
    }
}

