/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.spi.editor.hints;

import java.util.List;
import javax.swing.text.Document;
import javax.swing.text.Position;
import org.netbeans.modules.editor.hints.HintsControllerImpl;
import org.netbeans.modules.editor.hints.StaticFixList;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.editor.hints.Fix;
import org.netbeans.spi.editor.hints.LazyFixList;
import org.netbeans.spi.editor.hints.Severity;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;

public class ErrorDescriptionFactory {
    private ErrorDescriptionFactory() {
    }

    public static ErrorDescription createErrorDescription(Severity severity, String description, Document doc, int lineNumber) {
        return ErrorDescriptionFactory.createErrorDescription(severity, description, new StaticFixList(), doc, lineNumber);
    }

    public static ErrorDescription createErrorDescription(Severity severity, String description, List<Fix> fixes, Document doc, int lineNumber) {
        return ErrorDescriptionFactory.createErrorDescription(severity, description, new StaticFixList(fixes), doc, lineNumber);
    }

    public static ErrorDescription createErrorDescription(Severity severity, String description, LazyFixList fixes, Document doc, int lineNumber) {
        DataObject od = (DataObject)doc.getProperty("stream");
        FileObject file = od != null ? od.getPrimaryFile() : null;
        return new ErrorDescription(file, description, severity, fixes, HintsControllerImpl.fullLine(doc, lineNumber));
    }

    public static ErrorDescription createErrorDescription(Severity severity, String description, Document doc, Position start, Position end) {
        return ErrorDescriptionFactory.createErrorDescription(severity, description, (LazyFixList)new StaticFixList(), doc, start, end);
    }

    public static ErrorDescription createErrorDescription(Severity severity, String description, List<Fix> fixes, Document doc, Position start, Position end) {
        return ErrorDescriptionFactory.createErrorDescription(severity, description, (LazyFixList)new StaticFixList(fixes), doc, start, end);
    }

    public static ErrorDescription createErrorDescription(Severity severity, String description, LazyFixList fixes, Document doc, Position start, Position end) {
        DataObject od = (DataObject)doc.getProperty("stream");
        FileObject file = od != null ? od.getPrimaryFile() : null;
        return new ErrorDescription(file, description, severity, fixes, HintsControllerImpl.linePart(doc, start, end));
    }

    public static ErrorDescription createErrorDescription(Severity severity, String description, FileObject file, int start, int end) {
        return ErrorDescriptionFactory.createErrorDescription(severity, description, (LazyFixList)new StaticFixList(), file, start, end);
    }

    public static ErrorDescription createErrorDescription(Severity severity, String description, List<Fix> fixes, FileObject file, int start, int end) {
        return ErrorDescriptionFactory.createErrorDescription(severity, description, (LazyFixList)new StaticFixList(fixes), file, start, end);
    }

    public static ErrorDescription createErrorDescription(Severity severity, String description, LazyFixList fixes, FileObject file, int start, int end) {
        return new ErrorDescription(file, description, severity, fixes, HintsControllerImpl.linePart(file, start, end));
    }

    public static LazyFixList lazyListForFixes(List<Fix> fixes) {
        return new StaticFixList(fixes);
    }

    public static LazyFixList lazyListForDelegates(List<LazyFixList> delegates) {
        return new HintsControllerImpl.CompoundLazyFixList(delegates);
    }

    public static Fix attachSubfixes(Fix to, Iterable<? extends Fix> subfixes) {
        HintsControllerImpl.attachSubfixes(to, subfixes);
        return to;
    }
}

