/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.utils;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import org.netbeans.modules.profiler.projectsupport.utilities.SourceUtils;
import org.netbeans.modules.profiler.ui.ProfilerDialogs;
import org.netbeans.modules.profiler.utils.ProjectsRootNode;
import org.openide.DialogDescriptor;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.ExplorerUtils;
import org.openide.explorer.view.BeanTreeView;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;

public final class Utilities {
    private static final String SELECT_CLASS_BUTTON_OK_TEXT = NbBundle.getMessage(Utilities.class, (String)"Utilities_SelectClass-ButtonOKText");
    private static final String SELECT_CLASS_DIALOG_CAPTION = NbBundle.getMessage(Utilities.class, (String)"Utilities_SelectClass-DialogCaption");
    private static final String EXPLORER_TREE_ACCESS_NAME = NbBundle.getMessage(Utilities.class, (String)"Utilities_ExplorerTreeAccessName");
    private static final String EXPLORER_TREE_ACCESS_DESCR = NbBundle.getMessage(Utilities.class, (String)"Utilities_ExplorerTreeAccessDescr");
    private static SelectClassPanel selectClassPanel;
    private static JButton okButton;

    public static Node[] selectClass(boolean bl) {
        okButton = new JButton(SELECT_CLASS_BUTTON_OK_TEXT);
        selectClassPanel = new SelectClassPanel(okButton, bl);
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)selectClassPanel, SELECT_CLASS_DIALOG_CAPTION, true, new Object[]{okButton, DialogDescriptor.CANCEL_OPTION}, (Object)okButton, 0, null, null);
        Dialog dialog = ProfilerDialogs.createDialog(dialogDescriptor);
        dialog.setVisible(true);
        if (dialogDescriptor.getValue() == okButton) {
            selectClassPanel.deactivate();
            return selectClassPanel.getSelectedClassElements();
        }
        selectClassPanel.deactivate();
        selectClassPanel = null;
        return null;
    }

    private static final class SelectClassPanel
    extends JPanel
    implements PropertyChangeListener,
    ExplorerManager.Provider {
        private BeanTreeView explorerTree;
        private ExplorerManager manager;
        private JButton okButton;
        private boolean allowMultiple;

        public SelectClassPanel() {
        }

        private SelectClassPanel(JButton jButton, boolean bl) {
            this.manager = new ExplorerManager();
            this.manager.setRootContext((Node)new ProjectsRootNode());
            this.manager.addPropertyChangeListener((PropertyChangeListener)this);
            this.okButton = jButton;
            this.allowMultiple = bl;
            jButton.setEnabled(false);
            this.setBorder(new EmptyBorder(12, 12, 12, 12));
            this.setLayout(new BorderLayout());
            this.explorerTree = new BeanTreeView();
            this.explorerTree.getAccessibleContext().setAccessibleName(EXPLORER_TREE_ACCESS_NAME);
            this.explorerTree.getAccessibleContext().setAccessibleDescription(EXPLORER_TREE_ACCESS_DESCR);
            this.explorerTree.setDefaultActionAllowed(false);
            this.explorerTree.setPopupAllowed(false);
            this.explorerTree.setBorder(UIManager.getBorder("ScrollPane.border"));
            this.add((Component)this.explorerTree, "Center");
        }

        public ExplorerManager getExplorerManager() {
            return this.manager;
        }

        public Node[] getSelectedClassElements() {
            return this.getExplorerManager().getSelectedNodes();
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            Node[] nodeArray = this.getExplorerManager().getSelectedNodes();
            boolean bl = false;
            if (this.allowMultiple) {
                if (nodeArray.length > 0) {
                    for (int i = 0; i < nodeArray.length; ++i) {
                        if (nodeArray[i].getCookie(DataObject.class) != null || !SourceUtils.isJavaClass((Node)nodeArray[i])) continue;
                        bl = false;
                        break;
                    }
                }
            } else if (nodeArray.length == 1 && nodeArray[0].getCookie(DataObject.class) != null && SourceUtils.isJavaClass((Node)nodeArray[0])) {
                bl = true;
            }
            this.okButton.setEnabled(bl);
        }

        void activate() {
            ExplorerUtils.activateActions((ExplorerManager)this.manager, (boolean)true);
        }

        void deactivate() {
            ExplorerUtils.activateActions((ExplorerManager)this.manager, (boolean)false);
        }
    }
}

