/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.utils;

import java.text.MessageFormat;
import java.util.Collection;
import org.netbeans.api.project.Project;
import org.netbeans.lib.profiler.ProfilerLogger;
import org.netbeans.lib.profiler.common.Profiler;
import org.netbeans.modules.profiler.projectsupport.utilities.ProjectUtilities;
import org.netbeans.modules.profiler.spi.GoToSourceProvider;
import org.netbeans.modules.profiler.utils.JavaSourceLocation;
import org.openide.awt.StatusDisplayer;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public final class GoToSourceHelper {
    public static boolean openSource(Project project, JavaSourceLocation javaSourceLocation) {
        ProfilerLogger.debug((String)("Open Source: Project: " + (project == null ? "null" : ProjectUtilities.getProjectName((Project)project))));
        ProfilerLogger.debug((String)("Open Source: Class name: " + javaSourceLocation.className));
        ProfilerLogger.debug((String)("Open Source: Method name: " + javaSourceLocation.methodName));
        ProfilerLogger.debug((String)("Open Source: Method sig: " + javaSourceLocation.signature));
        Collection collection = Lookup.getDefault().lookupAll(GoToSourceProvider.class);
        String string = MessageFormat.format(NbBundle.getMessage(GoToSourceHelper.class, (String)"OpeningSourceMsg"), javaSourceLocation.className);
        String string2 = string + " ...";
        StatusDisplayer.getDefault().setStatusText(string2);
        for (GoToSourceProvider goToSourceProvider : collection) {
            try {
                if (!goToSourceProvider.openSource(project, javaSourceLocation.className, javaSourceLocation.methodName, javaSourceLocation.signature, javaSourceLocation.line)) continue;
                return true;
            }
            catch (Exception exception) {
                ProfilerLogger.log((Exception)exception);
            }
        }
        Profiler.getDefault().displayError(MessageFormat.format(NbBundle.getMessage(GoToSourceHelper.class, (String)"NoSourceFoundMessage"), javaSourceLocation.className));
        return false;
    }
}

