/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.ui.stp;

import java.awt.Dimension;
import java.awt.FlowLayout;
import java.io.IOException;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectInformation;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.lib.profiler.common.AttachSettings;
import org.netbeans.lib.profiler.common.ProfilingSettings;
import org.netbeans.modules.profiler.NetBeansProfiler;
import org.netbeans.modules.profiler.attach.AttachWizard;
import org.netbeans.modules.profiler.spi.ProjectTypeProfiler;
import org.netbeans.modules.profiler.ui.stp.DefaultSettingsConfigurator;
import org.netbeans.modules.profiler.ui.stp.SelectProfilingTask;
import org.netbeans.modules.profiler.utils.ProjectUtilities;

public class Utils {
    public static Dimension DIMENSION_SMALLEST = new Dimension(0, 0);
    private static int defaultSpinnerHeight = -1;

    public static AttachSettings getAttachSettings(Project project) {
        AttachSettings attachSettings = null;
        try {
            attachSettings = NetBeansProfiler.loadAttachSettings(project);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return attachSettings;
    }

    public static boolean isCPUSettings(ProfilingSettings profilingSettings) {
        if (profilingSettings == null) {
            return false;
        }
        return Utils.isCPUSettings(profilingSettings.getProfilingType());
    }

    public static boolean isCPUSettings(int n) {
        return n == 8 || n == 16 || n == 32;
    }

    public static int getDefaultSpinnerHeight() {
        if (defaultSpinnerHeight == -1) {
            defaultSpinnerHeight = new JTextField().getPreferredSize().height;
        }
        return defaultSpinnerHeight;
    }

    public static boolean isMemorySettings(ProfilingSettings profilingSettings) {
        if (profilingSettings == null) {
            return false;
        }
        return Utils.isMemorySettings(profilingSettings.getProfilingType());
    }

    public static boolean isMemorySettings(int n) {
        return n == 2 || n == 4;
    }

    public static boolean isMonitorSettings(ProfilingSettings profilingSettings) {
        if (profilingSettings == null) {
            return false;
        }
        return Utils.isMonitorSettings(profilingSettings.getProfilingType());
    }

    public static boolean isMonitorSettings(int n) {
        return n == 1;
    }

    public static String getProjectName(Project project) {
        if (project == null) {
            return SelectProfilingTask.EXTERNAL_APPLICATION_STRING;
        }
        ProjectInformation projectInformation = ProjectUtils.getInformation((Project)project);
        return projectInformation.getDisplayName();
    }

    public static SelectProfilingTask.SettingsConfigurator getSettingsConfigurator(Project project) {
        ProjectTypeProfiler projectTypeProfiler = ProjectUtilities.getProjectTypeProfiler(project);
        SelectProfilingTask.SettingsConfigurator settingsConfigurator = projectTypeProfiler.getSettingsConfigurator();
        if (settingsConfigurator == null) {
            return DefaultSettingsConfigurator.SHARED_INSTANCE;
        }
        return settingsConfigurator;
    }

    public static JPanel createFillerPanel() {
        JPanel jPanel = new JPanel(new FlowLayout(0, 0, 3)){

            @Override
            public Dimension getPreferredSize() {
                return DIMENSION_SMALLEST;
            }
        };
        jPanel.setOpaque(false);
        return jPanel;
    }

    public static JSeparator createHorizontalSeparator() {
        JSeparator jSeparator = new JSeparator(){

            @Override
            public Dimension getMinimumSize() {
                return this.getPreferredSize();
            }
        };
        return jSeparator;
    }

    public static AttachSettings selectAttachSettings(Project project) {
        AttachSettings attachSettings = Utils.getAttachSettings(project);
        if (attachSettings == null) {
            attachSettings = new AttachSettings();
        }
        return AttachWizard.getDefault().configure(attachSettings);
    }
}

