/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.ui.stp;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.File;
import java.lang.ref.WeakReference;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.modules.profiler.actions.JavaPlatformSelector;
import org.netbeans.modules.profiler.ui.HyperlinkLabel;
import org.netbeans.modules.profiler.ui.stp.DefaultSettingsPanel;
import org.netbeans.modules.profiler.ui.stp.Utils;
import org.openide.awt.Mnemonics;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class MonitorSettingsAdvancedPanel
extends DefaultSettingsPanel
implements HelpCtx.Provider {
    private static final String DO_NOT_OVERRIDE_STRING = NbBundle.getMessage(MonitorSettingsAdvancedPanel.class, (String)"MonitorSettingsAdvancedPanel_DoNotOverrideString");
    private static final String CHOOSE_WORKDIR_DIALOG_CAPTION = NbBundle.getMessage(MonitorSettingsAdvancedPanel.class, (String)"MonitorSettingsAdvancedPanel_ChooseWorkDirDialogCaption");
    private static final String GLOBAL_SETTINGS_CAPTION = NbBundle.getMessage(MonitorSettingsAdvancedPanel.class, (String)"MonitorSettingsAdvancedPanel_GlobalSettingsCaption");
    private static final String OVERRIDE_SETTINGS_CHECKBOX_TEXT = NbBundle.getMessage(MonitorSettingsAdvancedPanel.class, (String)"MonitorSettingsAdvancedPanel_OverrideSettingsCheckboxText");
    private static final String WORKDIR_LABEL_TEXT = NbBundle.getMessage(MonitorSettingsAdvancedPanel.class, (String)"MonitorSettingsAdvancedPanel_WorkDirLabelText");
    private static final String CHOOSE_WORKDIR_LINK_TEXT = NbBundle.getMessage(MonitorSettingsAdvancedPanel.class, (String)"MonitorSettingsAdvancedPanel_ChooseWorkDirLinkText");
    private static final String JAVA_PLATFORM_LABEL_TEXT = NbBundle.getMessage(MonitorSettingsAdvancedPanel.class, (String)"MonitorSettingsAdvancedPanel_JavaPlatformLabelText");
    private static final String JVM_ARGUMENTS_LABEL_TEXT = NbBundle.getMessage(MonitorSettingsAdvancedPanel.class, (String)"MonitorSettingsAdvancedPanel_JvmArgumentsLabelText");
    private static final String STP_OVERRIDE_TOOLTIP = NbBundle.getMessage(MonitorSettingsAdvancedPanel.class, (String)"StpOverrideTooltip");
    private static final String STP_WORKDIR_TOOLTIP = NbBundle.getMessage(MonitorSettingsAdvancedPanel.class, (String)"StpWorkDirTooltip");
    private static final String STP_JPLATFORM_TOOLTIP = NbBundle.getMessage(MonitorSettingsAdvancedPanel.class, (String)"StpJPlatformTooltip");
    private static final String STP_VMARGS_TOOLTIP = NbBundle.getMessage(MonitorSettingsAdvancedPanel.class, (String)"StpVmArgsTooltip");
    private static final String HELP_CTX_KEY = "MonitorSettings.Advanced.HelpCtx";
    private static final HelpCtx HELP_CTX = new HelpCtx("MonitorSettings.Advanced.HelpCtx");
    private HyperlinkLabel workingDirectorySelectLink;
    private JCheckBox overrideSettingsCheckbox;
    private JComboBox javaPlatformCombo;
    private JLabel javaPlatformLabel;
    private JLabel vmArgumentsLabel;
    private JLabel workingDirectoryLabel;
    private JPanel globalSettingsPanel;
    private JTextField vmArgumentsTextField;
    private JTextField workingDirectoryTextField;
    private WeakReference<JFileChooser> workingDirectoryChooserReference;

    public MonitorSettingsAdvancedPanel() {
        this.initComponents();
    }

    public HelpCtx getHelpCtx() {
        return HELP_CTX;
    }

    public void setJavaPlatformName(String javaPlatformName) {
        this.updateJavaPlatformCombo(javaPlatformName);
    }

    public String getJavaPlatformName() {
        int selIndex = this.javaPlatformCombo.getSelectedIndex();
        if (selIndex == 0) {
            return null;
        }
        return this.javaPlatformCombo.getSelectedItem().toString();
    }

    public void setOverrideAvailable(boolean enableOverride) {
        this.overrideSettingsCheckbox.setEnabled(enableOverride);
        this.workingDirectoryLabel.setEnabled(enableOverride);
        this.workingDirectoryTextField.setEnabled(enableOverride);
        this.workingDirectorySelectLink.setEnabled(enableOverride);
        this.javaPlatformLabel.setEnabled(enableOverride);
        this.javaPlatformCombo.setEnabled(enableOverride);
        this.vmArgumentsLabel.setEnabled(enableOverride);
        this.vmArgumentsTextField.setEnabled(enableOverride);
    }

    public void setOverrideSettings(boolean override) {
        this.overrideSettingsCheckbox.setSelected(override);
        this.updateEnabling();
    }

    public boolean getOverrideSettings() {
        return this.overrideSettingsCheckbox.isSelected();
    }

    public void setVMArguments(String vmArguments) {
        this.vmArgumentsTextField.setText(vmArguments);
    }

    public String getVMArguments() {
        return this.vmArgumentsTextField.getText().trim();
    }

    public void setWorkingDirectory(String workingDirectory) {
        this.workingDirectoryTextField.setText(workingDirectory);
    }

    public String getWorkingDirectory() {
        return this.workingDirectoryTextField.getText().trim();
    }

    public void disableAll() {
        this.overrideSettingsCheckbox.setEnabled(false);
        this.workingDirectoryLabel.setEnabled(false);
        this.workingDirectoryTextField.setEnabled(false);
        this.workingDirectorySelectLink.setEnabled(false);
        this.javaPlatformLabel.setEnabled(false);
        this.javaPlatformCombo.setEnabled(false);
        this.vmArgumentsLabel.setEnabled(false);
        this.vmArgumentsTextField.setEnabled(false);
    }

    public void enableAll() {
        this.overrideSettingsCheckbox.setEnabled(true);
        this.workingDirectoryLabel.setEnabled(true);
        this.workingDirectoryTextField.setEnabled(true);
        this.workingDirectorySelectLink.setEnabled(true);
        this.javaPlatformLabel.setEnabled(true);
        this.javaPlatformCombo.setEnabled(true);
        this.vmArgumentsLabel.setEnabled(true);
        this.vmArgumentsTextField.setEnabled(true);
    }

    public static void main(String[] args) {
        try {
            UIManager.setLookAndFeel("com.sun.java.swing.plaf.windows.WindowsLookAndFeel");
        }
        catch (Exception e) {
            // empty catch block
        }
        JFrame frame = new JFrame("Tester Frame");
        MonitorSettingsAdvancedPanel contents = new MonitorSettingsAdvancedPanel();
        contents.setPreferredSize(new Dimension(375, 255));
        frame.getContentPane().add(contents);
        frame.setDefaultCloseOperation(3);
        frame.pack();
        frame.setVisible(true);
    }

    private JFileChooser getFileChooser() {
        JFileChooser chooser;
        if (this.workingDirectoryChooserReference == null || this.workingDirectoryChooserReference.get() == null) {
            chooser = new JFileChooser();
            chooser.setFileSelectionMode(1);
            chooser.setMultiSelectionEnabled(false);
            chooser.setAcceptAllFileFilterUsed(false);
            chooser.setDialogType(0);
            chooser.setDialogTitle(CHOOSE_WORKDIR_DIALOG_CAPTION);
            this.workingDirectoryChooserReference = new WeakReference<JFileChooser>(chooser);
        } else {
            chooser = (JFileChooser)this.workingDirectoryChooserReference.get();
        }
        return chooser;
    }

    private void initComponents() {
        this.setLayout(new GridBagLayout());
        this.globalSettingsPanel = new JPanel(new GridBagLayout());
        this.globalSettingsPanel.setOpaque(false);
        this.globalSettingsPanel.setBorder(BorderFactory.createTitledBorder(GLOBAL_SETTINGS_CAPTION));
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.gridwidth = 0;
        constraints.fill = 2;
        constraints.anchor = 18;
        constraints.insets = new Insets(0, 5, 0, 5);
        this.add((Component)this.globalSettingsPanel, constraints);
        this.overrideSettingsCheckbox = new JCheckBox();
        Mnemonics.setLocalizedText((AbstractButton)this.overrideSettingsCheckbox, (String)OVERRIDE_SETTINGS_CHECKBOX_TEXT);
        this.overrideSettingsCheckbox.setToolTipText(STP_OVERRIDE_TOOLTIP);
        this.overrideSettingsCheckbox.setOpaque(false);
        this.overrideSettingsCheckbox.setSelected(true);
        this.overrideSettingsCheckbox.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                MonitorSettingsAdvancedPanel.this.updateEnabling();
            }
        });
        constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.gridwidth = 0;
        constraints.fill = 0;
        constraints.anchor = 17;
        constraints.insets = new Insets(2, 7, 0, 0);
        this.globalSettingsPanel.add((Component)this.overrideSettingsCheckbox, constraints);
        this.workingDirectoryLabel = new JLabel();
        Mnemonics.setLocalizedText((JLabel)this.workingDirectoryLabel, (String)WORKDIR_LABEL_TEXT);
        this.workingDirectoryLabel.setToolTipText(STP_WORKDIR_TOOLTIP);
        this.workingDirectoryLabel.setOpaque(false);
        constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 1;
        constraints.gridwidth = 1;
        constraints.fill = 0;
        constraints.anchor = 17;
        constraints.insets = new Insets(5, 19, 0, 0);
        this.globalSettingsPanel.add((Component)this.workingDirectoryLabel, constraints);
        this.workingDirectoryTextField = new JTextField(){

            @Override
            public Dimension getMinimumSize() {
                return this.getPreferredSize();
            }
        };
        this.workingDirectoryLabel.setLabelFor(this.workingDirectoryTextField);
        this.workingDirectoryTextField.setToolTipText(STP_WORKDIR_TOOLTIP);
        this.workingDirectoryTextField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                MonitorSettingsAdvancedPanel.this.checkWorkingDirectory();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                MonitorSettingsAdvancedPanel.this.checkWorkingDirectory();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                MonitorSettingsAdvancedPanel.this.checkWorkingDirectory();
            }
        });
        constraints = new GridBagConstraints();
        constraints.gridx = 1;
        constraints.gridy = 1;
        constraints.gridwidth = 1;
        constraints.weightx = 1.0;
        constraints.fill = 2;
        constraints.anchor = 17;
        constraints.insets = new Insets(5, 5, 0, 0);
        this.globalSettingsPanel.add((Component)this.workingDirectoryTextField, constraints);
        Color linkColor = Color.RED;
        String colorText = "rgb(" + linkColor.getRed() + "," + linkColor.getGreen() + "," + linkColor.getBlue() + ")";
        this.workingDirectorySelectLink = new HyperlinkLabel("<a href='#'>" + CHOOSE_WORKDIR_LINK_TEXT + "</a>", "<a href='#' color=\"" + colorText + "\">" + CHOOSE_WORKDIR_LINK_TEXT + "</a>", new Runnable(){

            @Override
            public void run() {
                JFileChooser chooser = MonitorSettingsAdvancedPanel.this.getFileChooser();
                chooser.setCurrentDirectory(new File(MonitorSettingsAdvancedPanel.this.workingDirectoryTextField.getText().trim()));
                if (chooser.showOpenDialog(null) == 0) {
                    MonitorSettingsAdvancedPanel.this.workingDirectoryTextField.setText(chooser.getSelectedFile().getAbsolutePath());
                }
            }
        });
        this.workingDirectorySelectLink.setOpaque(false);
        constraints = new GridBagConstraints();
        constraints.gridx = 2;
        constraints.gridy = 1;
        constraints.gridwidth = 1;
        constraints.fill = 0;
        constraints.anchor = 17;
        constraints.insets = new Insets(5, 4, 0, 3);
        this.globalSettingsPanel.add((Component)((Object)this.workingDirectorySelectLink), constraints);
        this.javaPlatformLabel = new JLabel();
        Mnemonics.setLocalizedText((JLabel)this.javaPlatformLabel, (String)JAVA_PLATFORM_LABEL_TEXT);
        this.javaPlatformLabel.setToolTipText(STP_JPLATFORM_TOOLTIP);
        this.javaPlatformLabel.setOpaque(false);
        constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 2;
        constraints.gridwidth = 1;
        constraints.fill = 0;
        constraints.anchor = 17;
        constraints.insets = new Insets(5, 19, 0, 0);
        this.globalSettingsPanel.add((Component)this.javaPlatformLabel, constraints);
        this.javaPlatformCombo = new JComboBox(new Object[]{DO_NOT_OVERRIDE_STRING}){

            @Override
            public Dimension getMinimumSize() {
                return this.getPreferredSize();
            }
        };
        this.javaPlatformLabel.setLabelFor(this.javaPlatformCombo);
        this.javaPlatformCombo.setToolTipText(STP_JPLATFORM_TOOLTIP);
        constraints = new GridBagConstraints();
        constraints.gridx = 1;
        constraints.gridy = 2;
        constraints.gridwidth = 1;
        constraints.fill = 2;
        constraints.anchor = 17;
        constraints.insets = new Insets(5, 5, 0, 0);
        this.globalSettingsPanel.add((Component)this.javaPlatformCombo, constraints);
        this.vmArgumentsLabel = new JLabel();
        Mnemonics.setLocalizedText((JLabel)this.vmArgumentsLabel, (String)JVM_ARGUMENTS_LABEL_TEXT);
        this.vmArgumentsLabel.setToolTipText(STP_VMARGS_TOOLTIP);
        this.vmArgumentsLabel.setOpaque(false);
        constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 3;
        constraints.gridwidth = 1;
        constraints.fill = 0;
        constraints.anchor = 17;
        constraints.insets = new Insets(5, 19, 8, 0);
        this.globalSettingsPanel.add((Component)this.vmArgumentsLabel, constraints);
        this.vmArgumentsTextField = new JTextField(){

            @Override
            public Dimension getMinimumSize() {
                return this.getPreferredSize();
            }
        };
        this.vmArgumentsLabel.setLabelFor(this.vmArgumentsTextField);
        this.vmArgumentsTextField.setToolTipText(STP_VMARGS_TOOLTIP);
        constraints = new GridBagConstraints();
        constraints.gridx = 1;
        constraints.gridy = 3;
        constraints.gridwidth = 1;
        constraints.weightx = 1.0;
        constraints.fill = 2;
        constraints.anchor = 17;
        constraints.insets = new Insets(5, 5, 8, 0);
        this.globalSettingsPanel.add((Component)this.vmArgumentsTextField, constraints);
        constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.gridwidth = 0;
        constraints.fill = 1;
        constraints.anchor = 18;
        constraints.insets = new Insets(0, 0, 0, 0);
        this.add((Component)Utils.createFillerPanel(), constraints);
    }

    private void updateEnabling() {
        boolean enableOverride = this.overrideSettingsCheckbox.isSelected() && this.overrideSettingsCheckbox.isEnabled();
        this.workingDirectoryLabel.setEnabled(enableOverride);
        this.workingDirectoryTextField.setEnabled(enableOverride);
        this.workingDirectorySelectLink.setEnabled(enableOverride);
        this.javaPlatformLabel.setEnabled(enableOverride);
        this.javaPlatformCombo.setEnabled(enableOverride);
        this.vmArgumentsLabel.setEnabled(enableOverride);
        this.vmArgumentsTextField.setEnabled(enableOverride);
    }

    private void checkWorkingDirectory() {
        String workDir = this.workingDirectoryTextField.getText().trim();
        if (workDir.length() == 0 || new File(workDir).exists()) {
            this.workingDirectoryTextField.setForeground(UIManager.getColor("TextField.foreground"));
        } else {
            this.workingDirectoryTextField.setForeground(Color.RED);
        }
    }

    private void updateJavaPlatformCombo(String platformNameToSelect) {
        List supportedPlatforms = JavaPlatformSelector.getSupportedPlatforms();
        String[] supportedPlatformNames = new String[supportedPlatforms.size() + 1];
        supportedPlatformNames[0] = DO_NOT_OVERRIDE_STRING;
        for (int i = 1; i < supportedPlatformNames.length; ++i) {
            supportedPlatformNames[i] = ((JavaPlatform)supportedPlatforms.get(i - 1)).getDisplayName();
        }
        this.javaPlatformCombo.setModel(new DefaultComboBoxModel<String>(supportedPlatformNames));
        if (platformNameToSelect != null) {
            this.javaPlatformCombo.setSelectedItem(platformNameToSelect);
        } else {
            this.javaPlatformCombo.setSelectedIndex(0);
        }
    }
}

