/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.categories;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.netbeans.lib.profiler.marker.Mark;
import org.netbeans.modules.profiler.categories.CategoryDefinition;
import org.netbeans.modules.profiler.categories.CategoryDefinitionProcessor;
import org.netbeans.modules.profiler.utilities.Visitable;
import org.netbeans.modules.profiler.utilities.Visitor;

public abstract class Category
implements Visitable<Category> {
    private String id;
    private String label;
    private Set<CategoryDefinition> definitions;
    private Mark assignedMark;
    public static final Category DEFAULT = new Category("DEFAULT", "Default Category", new Mark(0)){

        public <R, P> R accept(Visitor<Visitable<Category>, R, P> visitor, P parameter) {
            return null;
        }

        @Override
        public Set<Category> getSubcategories() {
            return Collections.EMPTY_SET;
        }
    };

    public Category(String id, String label, Mark mark) {
        this.id = id;
        this.label = label;
        this.definitions = new HashSet<CategoryDefinition>();
        this.assignedMark = mark;
    }

    public Category(String id, String label) {
        this(id, label, new Mark());
    }

    public String getLabel() {
        return this.label;
    }

    public String getId() {
        return this.id;
    }

    public Mark getAssignedMark() {
        return this.assignedMark;
    }

    public Set<CategoryDefinition> getDefinitions() {
        return this.definitions;
    }

    public Category getValue() {
        return this;
    }

    public abstract Set<Category> getSubcategories();

    void processDefinitionsWith(CategoryDefinitionProcessor processor) {
        for (CategoryDefinition def : this.definitions) {
            def.processWith(processor);
        }
    }
}

