/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.gsf.testrunner.api;

import java.util.Collections;
import java.util.Set;
import org.netbeans.modules.gsf.testrunner.api.Report;
import org.netbeans.modules.gsf.testrunner.api.Status;
import org.netbeans.modules.gsf.testrunner.api.Testcase;
import org.openide.nodes.Children;
import org.openide.nodes.Node;

final class TestsuiteNodeChildren
extends Children.Keys<Testcase> {
    private static final Node[] EMPTY_NODE_ARRAY = new Node[0];
    private final Report report;
    private boolean filtered;
    private boolean live = true;

    TestsuiteNodeChildren(Report report, boolean filtered) {
        this.report = report;
        this.filtered = filtered;
    }

    protected void addNotify() {
        super.addNotify();
        if (this.live) {
            this.setKeys(this.report.getTests());
        }
    }

    protected void removeNotify() {
        super.removeNotify();
        Set emptySet = Collections.emptySet();
        this.setKeys(emptySet);
    }

    protected Node[] createNodes(Testcase testcase) {
        if (this.filtered && !Status.isFailure(testcase.getStatus())) {
            return EMPTY_NODE_ARRAY;
        }
        return new Node[]{testcase.getSession().getNodeFactory().createTestMethodNode(testcase, this.report.getProject())};
    }

    void setFiltered(boolean filtered) {
        if (filtered == this.filtered) {
            return;
        }
        this.filtered = filtered;
        if (this.report.getErrors() + this.report.getFailures() == this.report.getTotalTests()) {
            return;
        }
        if (this.isInitialized()) {
            for (Testcase testcase : this.report.getTests()) {
                if (Status.isFailure(testcase.getStatus())) continue;
                this.refreshKey(testcase);
            }
        }
    }
}

