/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.ui.cpu;

import java.awt.Dimension;
import java.awt.image.BufferedImage;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import org.netbeans.lib.profiler.TargetAppRunner;
import org.netbeans.lib.profiler.global.ProfilingSessionStatus;
import org.netbeans.lib.profiler.results.ExportDataDumper;
import org.netbeans.lib.profiler.results.cpu.FlatProfileContainer;
import org.netbeans.lib.profiler.results.cpu.FlatProfileProvider;
import org.netbeans.lib.profiler.ui.LiveResultsPanel;
import org.netbeans.lib.profiler.ui.UIUtils;
import org.netbeans.lib.profiler.ui.components.FilterComponent;
import org.netbeans.lib.profiler.ui.cpu.CPUResUserActionsHandler;
import org.netbeans.lib.profiler.ui.cpu.CPUSelectionHandler;
import org.netbeans.lib.profiler.ui.cpu.FlatProfilePanel;

public class LiveFlatProfileCollectorPanel
extends FlatProfilePanel
implements LiveResultsPanel {
    private JPopupMenu popup;
    private TargetAppRunner runner = null;
    private boolean firstTime = true;
    private boolean updateResultsInProgress = false;
    private boolean updateResultsPending = false;

    public LiveFlatProfileCollectorPanel(TargetAppRunner runner, CPUResUserActionsHandler actionsHandler, CPUSelectionHandler selectionHandler) {
        super(actionsHandler, selectionHandler);
        this.runner = runner;
        this.addFilterListener(new FilterComponent.FilterListener(){

            @Override
            public void filterChanged() {
                if (LiveFlatProfileCollectorPanel.this.flatProfileContainer != null) {
                    LiveFlatProfileCollectorPanel.this.setDataToDisplay(LiveFlatProfileCollectorPanel.this.flatProfileContainer);
                }
            }
        });
        this.initComponents();
    }

    public void setDataToDisplay(FlatProfileContainer fpc) {
        this.threadId = -1;
        this.flatProfileContainer = fpc;
        this.collectingTwoTimeStamps = this.flatProfileContainer.isCollectingTwoTimeStamps();
        this.flatProfileContainer.filterOriginalData(FilterComponent.getFilterStrings(this.filterString), this.filterType, this.valueFilterValue);
        this.prepareResults(this.firstTime);
        this.firstTime = false;
        this.setResultsAvailable(this.hasData());
    }

    @Override
    public BufferedImage getViewImage(boolean onlyVisibleArea) {
        if (onlyVisibleArea) {
            return UIUtils.createScreenshot(this.jScrollPane);
        }
        return UIUtils.createScreenshot(this.resTable);
    }

    @Override
    public String getViewName() {
        return "cpu-live";
    }

    @Override
    public boolean fitsVisibleArea() {
        return !this.jScrollPane.getVerticalScrollBar().isEnabled();
    }

    @Override
    public void handleRemove() {
    }

    @Override
    public void handleShutdown() {
        if (this.popup != null && this.popup.isVisible()) {
            this.updateResultsPending = false;
            this.popup.setVisible(false);
        }
    }

    public boolean hasData() {
        return this.flatProfileContainer != null && this.flatProfileContainer.getNRows() > 0;
    }

    @Override
    public boolean hasView() {
        return this.resTable != null;
    }

    @Override
    public void prepareResults() {
        super.prepareResults();
    }

    @Override
    public boolean supports(int instrumentationType) {
        return instrumentationType == 2 || instrumentationType == 3;
    }

    @Override
    public void updateLiveResults() {
        FlatProfileProvider flatProvider;
        if (this.popup != null && this.popup.isVisible()) {
            this.updateResultsPending = true;
            return;
        }
        if (this.updateResultsInProgress) {
            return;
        }
        this.updateResultsInProgress = true;
        String selectedRowString = null;
        if (this.resTable != null) {
            int selectedRowIndex = this.resTable.getSelectedRow();
            if (selectedRowIndex >= this.resTable.getRowCount()) {
                selectedRowIndex = -1;
                this.resTable.clearSelection();
            }
            if (selectedRowIndex != -1) {
                selectedRowString = this.resTable.getValueAt(selectedRowIndex, 0).toString();
            }
        }
        if ((flatProvider = this.getFlatProfileProvider()) != null) {
            FlatProfileContainer fpc = flatProvider.createFlatProfile();
            int retryCounter = 2;
            boolean doRetry = false;
            do {
                doRetry = false;
                if (fpc != null) {
                    this.setDataToDisplay(fpc);
                    if (selectedRowString != null) {
                        this.resTable.selectRowByContents(selectedRowString, 0, false);
                    }
                } else {
                    doRetry = true;
                }
                if (!doRetry) continue;
                try {
                    Thread.sleep(200L);
                }
                catch (InterruptedException e) {
                    doRetry = false;
                }
            } while (--retryCounter > 0 && doRetry);
        }
        this.updateResultsInProgress = false;
    }

    public FlatProfileProvider getFlatProfileProvider() {
        return this.runner.getProfilerClient().getFlatProfileProvider();
    }

    @Override
    protected String[] getMethodClassNameAndSig(int methodId, int currentView) {
        ProfilingSessionStatus status = this.runner.getProfilingSessionStatus();
        String className = status.getInstrMethodClasses()[methodId];
        if (currentView == 0) {
            String methodName = status.getInstrMethodNames() != null ? status.getInstrMethodNames()[methodId] : null;
            String methodSig = status.getInstrMethodSignatures() != null ? status.getInstrMethodSignatures()[methodId] : null;
            return new String[]{className, methodName, methodSig};
        }
        return new String[]{className, null, null};
    }

    @Override
    protected JPopupMenu createPopupMenu() {
        if (this.popup == null) {
            this.popup = super.createPopupMenu();
        }
        this.popup.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuCanceled(PopupMenuEvent e) {
            }

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (LiveFlatProfileCollectorPanel.this.updateResultsPending) {
                            LiveFlatProfileCollectorPanel.this.updateLiveResults();
                            LiveFlatProfileCollectorPanel.this.updateResultsPending = false;
                        }
                    }
                });
            }
        });
        return this.popup;
    }

    @Override
    protected void obtainResults() {
        if (!this.collectingTwoTimeStamps && this.sortBy == 3) {
            this.sortBy = 2;
        }
        this.flatProfileContainer.filterOriginalData(FilterComponent.getFilterStrings(this.filterString), this.filterType, this.valueFilterValue);
        this.flatProfileContainer.sortBy(this.sortBy, this.sortOrder);
    }

    @Override
    protected void showReverseCallGraph(int threadId, int methodId, int currentView, int sortingColumn, boolean sortingOrder) {
        throw new IllegalStateException();
    }

    @Override
    protected boolean supportsReverseCallGraph() {
        return false;
    }

    @Override
    protected boolean supportsSubtreeCallGraph() {
        return false;
    }

    void setSelectedRowString(String rowString) {
        if (rowString != null) {
            this.resTable.selectRowByContents(rowString, 0, false);
        }
    }

    String getSelectedRowString() {
        String selectedRowString = null;
        if (this.resTable != null) {
            int selectedRowIndex = this.resTable.getSelectedRow();
            if (selectedRowIndex >= this.resTable.getRowCount()) {
                selectedRowIndex = -1;
                this.resTable.clearSelection();
            }
            if (selectedRowIndex != -1) {
                selectedRowString = this.resTable.getValueAt(selectedRowIndex, 0).toString();
            }
        }
        return selectedRowString;
    }

    private void initComponents() {
        this.setPreferredSize(new Dimension(800, 600));
    }

    public void exportData(int exportedFileType, ExportDataDumper eDD, String viewName) {
        this.percentFormat.setMaximumFractionDigits(2);
        this.percentFormat.setMinimumFractionDigits(2);
        switch (exportedFileType) {
            case 1: {
                this.exportCSV(",", eDD);
                break;
            }
            case 2: {
                this.exportCSV(";", eDD);
                break;
            }
            case 3: {
                this.exportXML(eDD, viewName);
                break;
            }
            case 4: {
                this.exportHTML(eDD, viewName);
            }
        }
        this.percentFormat.setMaximumFractionDigits(1);
        this.percentFormat.setMinimumFractionDigits(0);
    }

    private void exportHTML(ExportDataDumper eDD, String viewName) {
        int i;
        StringBuffer result = new StringBuffer("<HTML><HEAD><meta http-equiv=\"Content-type\" content=\"text/html; charset=utf-8\" /><TITLE>" + viewName + "</TITLE></HEAD><BODY><TABLE border=\"1\"><tr>");
        for (i = 0; i < this.columnCount; ++i) {
            result.append("<th>" + this.columnNames[i] + "</th>");
        }
        result.append("</tr>");
        eDD.dumpData(result);
        for (i = 0; i < this.flatProfileContainer.getNRows(); ++i) {
            result = new StringBuffer("<tr><td>" + this.replaceHTMLCharacters(this.flatProfileContainer.getMethodNameAtRow(i)) + "</td>");
            result.append("<td align=\"right\">" + this.percentFormat.format(this.flatProfileContainer.getPercentAtRow(i) / 100.0f) + (this.flatProfileContainer.getTimeInMcs0AtRow(i) % 10L == 0L ? (this.flatProfileContainer.getTimeInMcs0AtRow(i) % 100L == 0L ? (this.flatProfileContainer.getTimeInMcs0AtRow(i) % 1000L == 0L ? "    " : "  ") : " ") : "") + "</td>");
            result.append("<td align=right>" + (double)this.flatProfileContainer.getTimeInMcs0AtRow(i) / 1000.0 + " ms</td>");
            result.append("<td align=\"right\">" + this.flatProfileContainer.getNInvocationsAtRow(i) + "</td></tr>");
            eDD.dumpData(result);
        }
        eDD.dumpDataAndClose(new StringBuffer(" </TABLE></BODY></HTML>"));
    }

    private void exportXML(ExportDataDumper eDD, String viewName) {
        int i;
        String newline = System.getProperty("line.separator");
        StringBuffer result = new StringBuffer("<?xml version=\"1.0\" encoding=\"UTF-8\"?>" + newline + "<ExportedView Name=\"" + viewName + "\" type=\"table\">" + newline + " <TableData NumRows=\"" + this.flatProfileContainer.getNRows() + "\" NumColumns=\"4\">" + newline + "  <TableHeader>");
        for (i = 0; i < this.columnCount; ++i) {
            result.append("   <TableColumn><![CDATA[" + this.columnNames[i] + "]]></TableColumn>" + newline);
        }
        result.append("  </TableHeader>" + newline + "  <TableBody>" + newline);
        eDD.dumpData(result);
        for (i = 0; i < this.flatProfileContainer.getNRows(); ++i) {
            result = new StringBuffer("   <TableRow>" + newline + "    <TableColumn><![CDATA[" + this.flatProfileContainer.getMethodNameAtRow(i) + "]]></TableColumn>" + newline);
            result.append("    <TableColumn><![CDATA[" + this.percentFormat.format(this.flatProfileContainer.getPercentAtRow(i) / 100.0f) + "]]></TableColumn>" + newline);
            result.append("    <TableColumn><![CDATA[" + (double)this.flatProfileContainer.getTimeInMcs0AtRow(i) / 1000.0 + " ms]]></TableColumn>" + newline);
            result.append("    <TableColumn><![CDATA[" + this.flatProfileContainer.getNInvocationsAtRow(i) + "]]></TableColumn>" + newline + "  </TableRow>" + newline);
            eDD.dumpData(result);
        }
        eDD.dumpDataAndClose(new StringBuffer("  </TableBody> </TableData>" + newline + "</ExportedView>"));
    }

    private void exportCSV(String separator, ExportDataDumper eDD) {
        int i;
        StringBuffer result = new StringBuffer();
        String newLine = "\r\n";
        String quote = "\"";
        for (i = 0; i < this.columnCount; ++i) {
            result.append(quote + this.columnNames[i] + quote + separator);
        }
        result.deleteCharAt(result.length() - 1);
        result.append(newLine);
        eDD.dumpData(result);
        for (i = 0; i < this.flatProfileContainer.getNRows(); ++i) {
            result = new StringBuffer();
            result.append(quote + this.flatProfileContainer.getMethodNameAtRow(i) + quote + separator);
            result.append(quote + this.flatProfileContainer.getPercentAtRow(i) + quote + separator);
            result.append(quote + (double)this.flatProfileContainer.getTimeInMcs0AtRow(i) / 1000.0 + " ms" + quote + separator);
            result.append(quote + this.flatProfileContainer.getNInvocationsAtRow(i) + quote + newLine);
            eDD.dumpData(result);
        }
        eDD.close();
    }

    private String replaceHTMLCharacters(String s) {
        StringBuffer sb = new StringBuffer();
        int len = s.length();
        block6: for (int i = 0; i < len; ++i) {
            char c = s.charAt(i);
            switch (c) {
                case '<': {
                    sb.append("&lt;");
                    continue block6;
                }
                case '>': {
                    sb.append("&gt;");
                    continue block6;
                }
                case '&': {
                    sb.append("&amp;");
                    continue block6;
                }
                case '\"': {
                    sb.append("&quot;");
                    continue block6;
                }
                default: {
                    sb.append(c);
                }
            }
        }
        return sb.toString();
    }
}

