/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.ruby.platform.RubyPlatform;
import org.netbeans.api.ruby.platform.RubyPlatformManager;
import org.netbeans.modules.csl.api.ElementKind;
import org.netbeans.modules.parsing.spi.Parser;
import org.netbeans.modules.parsing.spi.indexing.support.IndexResult;
import org.netbeans.modules.parsing.spi.indexing.support.QuerySupport;
import org.netbeans.modules.ruby.ActiveRecordQueryIndexer;
import org.netbeans.modules.ruby.DatabasePropertiesIndexer;
import org.netbeans.modules.ruby.RubyIndexer;
import org.netbeans.modules.ruby.RubyType;
import org.netbeans.modules.ruby.RubyUtils;
import org.netbeans.modules.ruby.elements.IndexedClass;
import org.netbeans.modules.ruby.elements.IndexedConstant;
import org.netbeans.modules.ruby.elements.IndexedElement;
import org.netbeans.modules.ruby.elements.IndexedField;
import org.netbeans.modules.ruby.elements.IndexedMethod;
import org.netbeans.modules.ruby.elements.IndexedVariable;
import org.netbeans.modules.ruby.platform.gems.GemManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.URLMapper;
import org.openide.modules.InstalledFileLocator;
import org.openide.util.Exceptions;

public final class RubyIndex {
    private static final Logger LOGGGER = Logger.getLogger(RubyIndex.class.getName());
    public static final String UNKNOWN_CLASS = "<Unknown>";
    public static final String OBJECT = "Object";
    private static final String CLASS = "Class";
    private static final String MODULE = "Module";
    private static final String CLUSTER_URL = "cluster:";
    private static final String RUBYHOME_URL = "ruby:";
    private static final String GEM_URL = "gem:";
    private static String clusterUrl = null;
    private static final RubyIndex EMPTY = new RubyIndex(null);
    private FileObject context;
    private final QuerySupport querySupport;
    private static final Map<FileObject, RubyIndex> CACHE = new WeakHashMap<FileObject, RubyIndex>(1);
    static final String ACTIVE_RECORD_BASE = "ActiveRecord::Base";
    static final String ACTIVE_RECORD_RELATION = "ActiveRecord::Relation";

    private RubyIndex(QuerySupport querySupport) {
        this.querySupport = querySupport;
    }

    public static RubyIndex get(Collection<FileObject> roots) {
        try {
            return new RubyIndex(QuerySupport.forRoots((String)"ruby", (int)9, (FileObject[])roots.toArray(new FileObject[roots.size()])));
        }
        catch (IOException ioe) {
            LOGGGER.log(Level.WARNING, null, ioe);
            return EMPTY;
        }
    }

    public static RubyIndex get(Parser.Result result) {
        return RubyIndex.get(RubyUtils.getFileObject(result));
    }

    public static RubyIndex get(FileObject fo) {
        RubyIndex result = CACHE.get(fo);
        if (result != null) {
            return result;
        }
        result = fo == null ? null : RubyIndex.get(QuerySupport.findRoots((FileObject)fo, Collections.singleton("ruby/classpath/source"), Collections.singleton("ruby/classpath/boot"), Collections.emptySet()));
        CACHE.clear();
        CACHE.put(fo, result);
        return result;
    }

    public static void resetCache() {
        CACHE.clear();
    }

    public Collection<? extends IndexResult> query(String fieldName, String fieldValue, QuerySupport.Kind kind, String ... fieldsToLoad) {
        if (this.querySupport != null) {
            try {
                return this.querySupport.query(fieldName, fieldValue, kind, fieldsToLoad);
            }
            catch (IOException ioe) {
                LOGGGER.log(Level.WARNING, null, ioe);
            }
        }
        return Collections.emptySet();
    }

    private boolean search(String key, String name, QuerySupport.Kind kind, Collection<IndexResult> result, String ... fieldsToLoad) {
        try {
            result.addAll(this.querySupport.query(key, name, kind, fieldsToLoad));
            return true;
        }
        catch (IOException ioe) {
            Exceptions.printStackTrace((Throwable)ioe);
            return false;
        }
    }

    FileObject getContext() {
        return this.context;
    }

    Set<IndexedClass> getClasses(String name, QuerySupport.Kind kind, boolean includeAll, boolean skipClasses, boolean skipModules) {
        return this.getClasses(name, kind, includeAll, skipClasses, skipModules, null);
    }

    public Set<IndexedClass> getClasses(String name, QuerySupport.Kind kind, boolean includeAll, boolean skipClasses, boolean skipModules, Set<String> uniqueClasses) {
        String field;
        String classFqn = null;
        if (name != null) {
            if (name.indexOf("::") != -1) {
                int p = name.lastIndexOf("::");
                classFqn = name.substring(0, p);
                name = name.substring(p + 2);
            } else if (name.endsWith(":")) {
                classFqn = name.substring(0, name.length() - 1);
                name = "";
            }
        }
        HashSet<IndexResult> result = new HashSet<IndexResult>();
        switch (kind) {
            case EXACT: 
            case PREFIX: 
            case CAMEL_CASE: 
            case REGEXP: {
                field = "class";
                break;
            }
            case CASE_INSENSITIVE_PREFIX: 
            case CASE_INSENSITIVE_REGEXP: {
                field = "class-ig";
                break;
            }
            default: {
                throw new UnsupportedOperationException(kind.toString());
            }
        }
        this.search(field, name, kind, result, RubyIndexer.CLASS_FIELDS);
        if (includeAll) {
            uniqueClasses = null;
        } else if (uniqueClasses == null) {
            uniqueClasses = new HashSet<String>();
        }
        HashSet<IndexedClass> classes = new HashSet<IndexedClass>();
        for (IndexResult map : result) {
            String clz = map.getValue("class");
            if (clz == null || kind == QuerySupport.Kind.PREFIX && !clz.startsWith(name) || kind == QuerySupport.Kind.CASE_INSENSITIVE_PREFIX && !clz.regionMatches(true, 0, name, 0, name.length())) continue;
            if (classFqn != null) {
                if (kind == QuerySupport.Kind.CASE_INSENSITIVE_PREFIX || kind == QuerySupport.Kind.CASE_INSENSITIVE_REGEXP) {
                    if (!classFqn.equalsIgnoreCase(map.getValue("in"))) {
                        continue;
                    }
                } else if (kind == QuerySupport.Kind.CAMEL_CASE) {
                    int idx;
                    String in = map.getValue("in");
                    if (in == null) continue;
                    StringBuilder sb = new StringBuilder();
                    int lastIndex = 0;
                    do {
                        int nextUpper = -1;
                        for (int i = lastIndex + 1; i < classFqn.length(); ++i) {
                            if (!Character.isUpperCase(classFqn.charAt(i))) continue;
                            nextUpper = i;
                            break;
                        }
                        String token = classFqn.substring(lastIndex, (idx = nextUpper) == -1 ? classFqn.length() : idx);
                        sb.append(token);
                        sb.append(idx != -1 ? "[\\p{javaLowerCase}\\p{Digit}_\\$]*" : ".*");
                        lastIndex = idx;
                    } while (idx != -1);
                    Pattern pattern = Pattern.compile(sb.toString());
                    if (!pattern.matcher(in).matches()) {
                        continue;
                    }
                } else if (!classFqn.equals(map.getValue("in"))) continue;
            }
            String attrs = map.getValue("attrs");
            boolean isClass = true;
            if (attrs != null) {
                int flags = IndexedElement.stringToFlag(attrs, 0);
                boolean bl = isClass = (flags & 0x40) == 0;
            }
            if (skipClasses && isClass || skipModules && !isClass) continue;
            String fqn = map.getValue("fqn");
            if (!includeAll) {
                if (uniqueClasses.contains(fqn)) {
                    boolean isDocumented;
                    boolean replaced = false;
                    int flags = 0;
                    if (attrs != null) {
                        flags = IndexedElement.stringToFlag(attrs, 0);
                    }
                    boolean bl = isDocumented = flags & true;
                    if (isDocumented) {
                        int length = 0;
                        int documentedAt = attrs.indexOf(59);
                        if (documentedAt != -1) {
                            int end = attrs.indexOf(59, documentedAt + 1);
                            if (end == -1) {
                                end = attrs.length();
                            }
                            length = Integer.parseInt(attrs.substring(documentedAt + 1, end));
                        }
                        for (IndexedClass c : classes) {
                            if (!c.getSignature().equals(fqn) || length <= c.getDocumentationLength()) continue;
                            classes.remove(c);
                            replaced = true;
                            break;
                        }
                    }
                    if (!replaced) {
                        continue;
                    }
                } else {
                    uniqueClasses.add(fqn);
                }
            }
            classes.add(this.createClass(fqn, clz, map));
        }
        return classes;
    }

    public Set<IndexedClass> getSubClasses(String name, String fqn, QuerySupport.Kind kind) {
        Collection<? extends IndexResult> result = this.query("extends", fqn, QuerySupport.Kind.EXACT, "extends");
        HashSet<IndexedClass> classes = new HashSet<IndexedClass>();
        for (IndexResult indexResult : result) {
            String clz = indexResult.getValue("class");
            if (clz == null || kind == QuerySupport.Kind.PREFIX && !clz.startsWith(name) || kind == QuerySupport.Kind.CASE_INSENSITIVE_PREFIX && !clz.regionMatches(true, 0, name, 0, name.length())) continue;
            String cfqn = indexResult.getValue("fqn");
            classes.add(this.createClass(cfqn, clz, indexResult));
        }
        return classes;
    }

    public Set<IndexedMethod> getMethods(String name, String clz, QuerySupport.Kind kind) {
        if (clz == null) {
            return this.getMethods(name, (Collection<String>)null, kind);
        }
        return this.getMethods(name, Collections.singleton(clz), kind);
    }

    Set<IndexedMethod> getMethods(String name, QuerySupport.Kind kind) {
        return this.getMethods(name, (String)null, kind);
    }

    public Set<IndexedMethod> getMethods(String name, Collection<String> classes, QuerySupport.Kind kind) {
        boolean inherited = classes == null;
        HashSet<IndexResult> result = new HashSet<IndexResult>();
        QuerySupport.Kind originalKind = kind;
        if (kind == QuerySupport.Kind.EXACT) {
            kind = QuerySupport.Kind.PREFIX;
        }
        this.search("method", name, kind, result, new String[0]);
        this.search("attribute", name, kind, result, new String[0]);
        HashSet<IndexedMethod> methods = new HashSet<IndexedMethod>();
        for (IndexResult map : result) {
            String[] attributes;
            String fqn;
            if (classes != null && !classes.contains(fqn = map.getValue("fqn"))) continue;
            String[] signatures = map.getValues("method");
            if (signatures != null) {
                for (String signature : signatures) {
                    block12: {
                        if ((name == null || name.length() == 0) && !Character.isLowerCase(signature.charAt(0)) || kind == QuerySupport.Kind.PREFIX && !signature.startsWith(name) || kind == QuerySupport.Kind.CASE_INSENSITIVE_PREFIX && !signature.regionMatches(true, 0, name, 0, name.length())) continue;
                        if (kind == QuerySupport.Kind.CASE_INSENSITIVE_REGEXP) {
                            int len = signature.length();
                            int end = signature.indexOf(40);
                            if (end == -1 && (end = signature.indexOf(59)) == -1) {
                                end = len;
                            }
                            String n = end != len ? signature.substring(0, end) : signature;
                            try {
                                if (!n.matches(name)) {
                                    continue;
                                }
                                break block12;
                            }
                            catch (Exception e) {
                                break block12;
                            }
                        }
                        if (originalKind == QuerySupport.Kind.EXACT && signature.length() > name.length() && signature.charAt(name.length()) != '(' && signature.charAt(name.length()) != ';') continue;
                    }
                    assert (map != null);
                    methods.add(this.createMethod(signature, map, inherited));
                }
            }
            if ((attributes = map.getValues("attribute")) == null) continue;
            for (String signature : attributes) {
                if ((name == null || name.length() == 0) && !Character.isLowerCase(signature.charAt(0)) || kind == QuerySupport.Kind.PREFIX && !signature.startsWith(name) || kind == QuerySupport.Kind.CASE_INSENSITIVE_PREFIX && !signature.regionMatches(true, 0, name, 0, name.length()) || kind == QuerySupport.Kind.CASE_INSENSITIVE_REGEXP && !signature.matches(name) || originalKind == QuerySupport.Kind.EXACT && signature.length() > name.length() && signature.charAt(name.length()) != ';') continue;
                assert (map != null);
                methods.add(this.createMethod(signature, map, inherited));
            }
        }
        return methods;
    }

    public IndexedMethod createMethod(String signature, IndexResult ir, boolean inherited) {
        String clz = ir.getValue("class");
        String module = ir.getValue("in");
        if (clz == null) {
            clz = module;
        } else if (module != null && module.length() > 0) {
            clz = module + "::" + clz;
        }
        String fqn = ir.getValue("fqn");
        String require = ir.getValue("require");
        int attributeIndex = signature.indexOf(59);
        String attributes = null;
        int flags = 0;
        if (attributeIndex != -1) {
            flags = IndexedElement.stringToFlag(signature, attributeIndex + 1);
            if (signature.length() > attributeIndex + 1) {
                attributes = signature.substring(attributeIndex + 1, signature.length());
            }
            signature = signature.substring(0, attributeIndex);
        }
        IndexedMethod m = IndexedMethod.create(this, signature, fqn, clz, ir.getFile(), require, attributes, flags, this.context);
        m.setInherited(inherited);
        return m;
    }

    public IndexedField createField(String signature, IndexResult ir, boolean isInstance, boolean inherited) {
        String clz = ir.getValue("class");
        String module = ir.getValue("in");
        if (clz == null) {
            clz = module;
        } else if (module != null && module.length() > 0) {
            clz = module + "::" + clz;
        }
        String fqn = ir.getValue("fqn");
        String require = ir.getValue("require");
        int attributeIndex = signature.indexOf(59);
        String attributes = null;
        int flags = 0;
        if (attributeIndex != -1) {
            flags = IndexedElement.stringToFlag(signature, attributeIndex + 1);
            if (signature.length() > attributeIndex + 1) {
                attributes = signature.substring(attributeIndex + 1, signature.length());
            }
            signature = signature.substring(0, attributeIndex);
        }
        IndexedField m = IndexedField.create(this, signature, fqn, clz, ir, require, attributes, flags, this.context);
        m.setInherited(inherited);
        return m;
    }

    private static boolean isEmptyOrNull(String str) {
        return str == null || "".equals(str.trim());
    }

    public IndexedConstant createConstant(String signature, IndexResult ir) {
        String classFQN = ir.getValue("fqn");
        String require = ir.getValue("require");
        int typeIndex = signature.indexOf(59);
        String name = typeIndex == -1 ? signature : signature.substring(0, typeIndex);
        int flags = 0;
        String type = typeIndex == -1 ? null : signature.substring(typeIndex + 1);
        RubyType rubyType = RubyIndex.isEmptyOrNull(type) ? RubyType.unknown() : RubyType.create(type);
        IndexedConstant m = IndexedConstant.create(this, name, classFQN, ir, require, flags, this.context, rubyType);
        return m;
    }

    public IndexedClass createClass(String fqn, String clz, IndexResult ir) {
        String require = ir.getValue("require");
        if (clz == null) {
            clz = ir.getValue("class");
        }
        String attrs = ir.getValue("attrs");
        int flags = 0;
        if (attrs != null) {
            flags = IndexedElement.stringToFlag(attrs, 0);
        }
        IndexedClass c = IndexedClass.create(this, clz, fqn, ir, require, attrs, flags, this.context);
        return c;
    }

    public Set<String[]> getRequires(String name, QuerySupport.Kind kind) {
        HashSet<IndexResult> result = new HashSet<IndexResult>();
        String field = "require";
        this.search(field, name, kind, result, "require", "fqn");
        HashMap<String, String> fqns = new HashMap<String, String>();
        for (IndexResult map : result) {
            String[] r = map.getValues(field);
            if (r == null) continue;
            for (String require : r) {
                if (kind == QuerySupport.Kind.PREFIX && !require.startsWith(name) || kind == QuerySupport.Kind.CASE_INSENSITIVE_PREFIX && !require.regionMatches(true, 0, name, 0, name.length())) continue;
                assert (map != null);
                String fqn = map.getValue("fqn");
                String there = (String)fqns.get(require);
                if (fqn == null || there != null && (there == null || there.length() >= fqn.length())) continue;
                fqns.put(require, fqn);
            }
        }
        HashSet<String[]> requires = new HashSet<String[]>();
        for (String require : fqns.keySet()) {
            String fqn = (String)fqns.get(require);
            String[] item = new String[]{require, fqn};
            requires.add(item);
        }
        return requires;
    }

    public Set<String> getRequiresTransitively(Set<String> requires) {
        return requires;
    }

    public Set<String> getClassesIn(String require) {
        HashSet<IndexResult> result = new HashSet<IndexResult>();
        String field = "require";
        this.search(field, require, QuerySupport.Kind.EXACT, result, "require", "fqn");
        HashSet<String> fqns = new HashSet<String>();
        for (IndexResult map : result) {
            String fqn = map.getValue("fqn");
            if (fqn == null) continue;
            fqns.add(fqn);
        }
        return fqns;
    }

    public List<IndexedClass> getSuperClasses(String fqn) {
        ArrayList<IndexedClass> superClasses = new ArrayList<IndexedClass>();
        IndexedClass superClass = this.getSuperclass(fqn);
        while (superClass != null) {
            superClasses.add(superClass);
            superClass = this.getSuperclass(superClass.getName());
        }
        return superClasses;
    }

    public IndexedClass getSuperclass(String fqn) {
        HashSet<IndexResult> result = new HashSet<IndexResult>();
        QuerySupport.Kind kind = QuerySupport.Kind.EXACT;
        String field = "fqn";
        this.search(field, fqn, kind, result, RubyIndexer.CLASS_FIELDS);
        for (IndexResult map : result) {
            assert (fqn.equals(map.getValue("fqn")));
            String extendsClass = map.getValue("extends");
            if (extendsClass == null) continue;
            result.clear();
            if (!this.search(field, extendsClass, kind, result, RubyIndexer.CLASS_FIELDS)) {
                return null;
            }
            if (result.size() > 0) {
                IndexResult superMap = (IndexResult)result.iterator().next();
                String superFqn = superMap.getValue("fqn");
                return this.createClass(superFqn, extendsClass, superMap);
            }
            return null;
        }
        return null;
    }

    private boolean addSubclasses(String classFqn, Set<IndexedClass> classes, Set<String> seenClasses, Set<String> scannedClasses, boolean directOnly) {
        boolean foundIt;
        if (scannedClasses.contains(classFqn)) {
            return false;
        }
        scannedClasses.add(classFqn);
        String searchField = "extends";
        HashSet<IndexResult> result = new HashSet<IndexResult>();
        this.search(searchField, classFqn, QuerySupport.Kind.EXACT, result, RubyIndexer.CLASS_FIELDS);
        boolean bl = foundIt = result.size() > 0;
        if (!foundIt) {
            return foundIt;
        }
        for (IndexResult map : result) {
            String fqn = map.getValue("fqn");
            if (seenClasses.contains(fqn)) continue;
            IndexedClass clz = this.createClass(fqn, null, map);
            classes.add(clz);
            seenClasses.add(fqn);
            if (directOnly) continue;
            this.addSubclasses(fqn, classes, seenClasses, scannedClasses, directOnly);
        }
        return foundIt;
    }

    public Set<IndexedClass> getSubClasses(String fqn, String possibleFqn, String name, boolean directOnly) {
        LinkedHashSet<IndexedClass> classes = new LinkedHashSet<IndexedClass>();
        HashSet<String> scannedClasses = new HashSet<String>();
        HashSet<String> seenClasses = new HashSet<String>();
        if (fqn != null) {
            this.addSubclasses(fqn, classes, seenClasses, scannedClasses, directOnly);
        } else {
            fqn = possibleFqn;
            while (classes.size() == 0 && fqn.length() > 0) {
                boolean found = this.addSubclasses(fqn + "::" + name, classes, seenClasses, scannedClasses, directOnly);
                if (found) {
                    return classes;
                }
                int f = fqn.lastIndexOf("::");
                if (f == -1) break;
                fqn = fqn.substring(0, f);
            }
            if (classes.size() == 0) {
                this.addSubclasses(name, classes, seenClasses, scannedClasses, directOnly);
            }
        }
        return classes;
    }

    public IndexedMethod getSuperMethod(String className, String methodName, boolean closest) {
        return this.getSuperMethod(className, methodName, closest, true);
    }

    IndexedMethod getSuperMethod(String className, String methodName, boolean closest, boolean includeSelf) {
        Set<IndexedMethod> methods = this.getInheritedMethods(className, methodName, QuerySupport.Kind.EXACT);
        List<IndexedClass> superClasses = this.getSuperClasses(className);
        if (!closest) {
            Collections.reverse(superClasses);
        }
        for (IndexedClass superClass : superClasses) {
            for (IndexedMethod method : methods) {
                String clz = method.getIn();
                if (!superClass.getName().equals(clz) || clz.equals(className)) continue;
                return method;
            }
        }
        if (!includeSelf) {
            return null;
        }
        return !methods.isEmpty() ? methods.iterator().next() : null;
    }

    public Set<IndexedMethod> getOverridingMethods(String methodName, String className) {
        return this.getOverridingMethods(methodName, className, false);
    }

    Set<IndexedMethod> getOverridingMethods(String methodName, String className, boolean excludeSelf) {
        HashSet<IndexedMethod> result = new HashSet<IndexedMethod>();
        Set<IndexedMethod> methods = this.getMethods(methodName, className, QuerySupport.Kind.EXACT);
        for (IndexedMethod method : methods) {
            Set<IndexedClass> subClasses = this.getSubClasses(method.getIn(), null, null, false);
            HashSet<String> subClassNames = new HashSet<String>(subClasses.size());
            for (IndexedClass subClass : subClasses) {
                if (excludeSelf && className.equals(subClass.getIn())) continue;
                subClassNames.add(subClass.getName());
            }
            if (subClassNames.isEmpty()) continue;
            result.addAll(this.getMethods(method.getName(), subClassNames, QuerySupport.Kind.EXACT));
        }
        return result;
    }

    public Set<IndexedMethod> getAllOverridingMethodsInHierachy(String methodName, String className) {
        IndexedMethod superMethod = this.getSuperMethod(className, methodName, false);
        if (superMethod == null) {
            return Collections.emptySet();
        }
        HashSet<IndexedMethod> result = new HashSet<IndexedMethod>();
        result.add(superMethod);
        result.addAll(this.getOverridingMethods(superMethod.getName(), superMethod.getIn()));
        return result;
    }

    Set<IndexedMethod> getInheritedMethods(RubyType receiverType, String prefix, QuerySupport.Kind kind) {
        HashSet<IndexedMethod> methods = new HashSet<IndexedMethod>();
        for (String realType : receiverType.getRealTypes()) {
            methods.addAll(this.getInheritedMethods(realType, prefix, kind));
        }
        return methods;
    }

    public Set<IndexedMethod> getInheritedMethods(String classFqn, String prefix, QuerySupport.Kind kind) {
        return this.getInheritedMethods(classFqn, prefix, kind, false);
    }

    private Set<IndexedMethod> getInheritedMethods(String classFqn, String prefix, QuerySupport.Kind kind, boolean includeDynamicMethods) {
        boolean haveRedirected = false;
        if (classFqn == null || classFqn.equals(OBJECT)) {
            classFqn = CLASS;
            haveRedirected = true;
        } else if (MODULE.equals(classFqn) || CLASS.equals(classFqn)) {
            haveRedirected = true;
        }
        HashSet<IndexedMethod> methods = new HashSet<IndexedMethod>();
        HashSet<String> scannedClasses = new HashSet<String>();
        HashSet<String> seenSignatures = new HashSet<String>();
        if (prefix == null) {
            prefix = "";
        }
        this.addMethodsFromClass(prefix, kind, classFqn, methods, seenSignatures, scannedClasses, haveRedirected, false, includeDynamicMethods);
        return methods;
    }

    Set<IndexedMethod> getInheritedMethods(String classFqn, String prefix, QuerySupport.Kind kind, boolean includeSelf, boolean includeDynamic) {
        Set<IndexedMethod> inherited = this.getInheritedMethods(classFqn, prefix, kind, includeDynamic);
        if (includeSelf) {
            return inherited;
        }
        HashSet<IndexedMethod> result = new HashSet<IndexedMethod>(inherited.size());
        for (IndexedMethod each : inherited) {
            if (classFqn.equals(each.getClz())) continue;
            result.add(each);
        }
        return result;
    }

    private boolean addMethodsFromClass(String prefix, QuerySupport.Kind kind, String classFqn, Set<IndexedMethod> methods, Set<String> seenSignatures, Set<String> scannedClasses, boolean haveRedirected, boolean inheriting, boolean includeDynamic) {
        boolean foundIt;
        if (scannedClasses.contains(classFqn)) {
            return false;
        }
        scannedClasses.add(classFqn);
        LinkedHashSet<IndexResult> result = new LinkedHashSet<IndexResult>();
        this.search("fqn", classFqn, QuerySupport.Kind.EXACT, result, new String[0]);
        boolean bl = foundIt = result.size() > 0;
        if (!foundIt) {
            return foundIt;
        }
        String extendsClass = null;
        String classIn = null;
        int fqnIndex = classFqn.lastIndexOf("::");
        if (fqnIndex != -1) {
            classIn = classFqn.substring(0, fqnIndex);
        }
        for (IndexResult map : result) {
            String[] attributes;
            IndexedMethod method;
            String extendWith;
            String includes;
            assert (map != null);
            if (extendsClass == null) {
                extendsClass = map.getValue("extends");
            }
            if ((includes = map.getValue("includes")) != null) {
                String[] in;
                for (String include : in = includes.split(",")) {
                    boolean isQualified = false;
                    if (classIn != null) {
                        isQualified = this.addMethodsFromClass(prefix, kind, classIn + "::" + include, methods, seenSignatures, scannedClasses, haveRedirected, true, includeDynamic);
                    }
                    if (isQualified) continue;
                    this.addMethodsFromClass(prefix, kind, include, methods, seenSignatures, scannedClasses, haveRedirected, true, includeDynamic);
                }
            }
            if ((extendWith = map.getValue("extendWith")) != null) {
                boolean isQualified = false;
                HashSet<IndexedMethod> extendWithMethods = new HashSet<IndexedMethod>();
                if (classIn != null) {
                    isQualified = this.addMethodsFromClass(prefix, kind, classIn + "::" + extendWith, extendWithMethods, seenSignatures, scannedClasses, haveRedirected, true, includeDynamic);
                }
                if (!isQualified) {
                    this.addMethodsFromClass(prefix, kind, extendWith, extendWithMethods, seenSignatures, scannedClasses, haveRedirected, true, includeDynamic);
                }
                for (IndexedMethod each : extendWithMethods) {
                    each.setStatic(true);
                }
                methods.addAll(extendWithMethods);
            }
            String[] signatures = map.getValues("method");
            String className = map.getValue("class");
            if (className == null) {
                className = "";
            }
            if (signatures != null) {
                for (String signature : signatures) {
                    String seenSignature;
                    if (prefix.length() == 0 && !Character.isLowerCase(signature.charAt(0)) || seenSignatures.contains(seenSignature = signature + ";" + className) || !signature.startsWith(prefix)) continue;
                    if (kind == QuerySupport.Kind.EXACT) {
                        if (signature.length() > prefix.length() && signature.charAt(prefix.length()) != '(' && signature.charAt(prefix.length()) != ';') {
                            continue;
                        }
                    } else assert (kind == QuerySupport.Kind.PREFIX || kind == QuerySupport.Kind.CASE_INSENSITIVE_PREFIX);
                    seenSignatures.add(seenSignature);
                    method = this.createMethod(signature, map, inheriting);
                    method.setSmart(!haveRedirected);
                    methods.add(method);
                }
            }
            if ((attributes = map.getValues("attribute")) == null) continue;
            for (String attribute : attributes) {
                if (prefix.length() == 0 && !Character.isLowerCase(attribute.charAt(0)) || seenSignatures.contains(attribute) || !attribute.startsWith(prefix)) continue;
                if (kind == QuerySupport.Kind.EXACT) {
                    if (attribute.length() > prefix.length() && attribute.charAt(prefix.length()) != '(' && attribute.charAt(prefix.length()) != ';') {
                        continue;
                    }
                } else assert (kind == QuerySupport.Kind.PREFIX || kind == QuerySupport.Kind.CASE_INSENSITIVE_PREFIX);
                seenSignatures.add(attribute);
                method = this.createMethod(attribute, map, inheriting);
                method.setSmart(!haveRedirected);
                method.setMethodType(IndexedMethod.MethodType.ATTRIBUTE);
                methods.add(method);
            }
        }
        if (classFqn.equals(OBJECT)) {
            return foundIt;
        }
        if (ACTIVE_RECORD_RELATION.equals(classFqn)) {
            this.addQueryMethods(prefix, kind, classFqn, methods);
        }
        if (extendsClass == null) {
            if (haveRedirected) {
                this.addMethodsFromClass(prefix, kind, OBJECT, methods, seenSignatures, scannedClasses, true, true, includeDynamic);
            } else {
                this.addMethodsFromClass(prefix, kind, CLASS, methods, seenSignatures, scannedClasses, true, true, includeDynamic);
            }
        } else {
            if (ACTIVE_RECORD_BASE.equals(extendsClass)) {
                this.addDatabaseProperties(prefix, kind, classFqn, methods, includeDynamic);
                if (includeDynamic && scannedClasses.contains(ACTIVE_RECORD_RELATION) || !this.getClasses(ACTIVE_RECORD_RELATION, QuerySupport.Kind.EXACT, false, false, true).isEmpty()) {
                    this.addQueryMethods(prefix, kind, classFqn, methods);
                }
            }
            if (!this.addMethodsFromClass(prefix, kind, extendsClass, methods, seenSignatures, scannedClasses, haveRedirected, true, includeDynamic)) {
                int f;
                for (String fqn = classIn; fqn != null && !this.addMethodsFromClass(prefix, kind, fqn + "::" + extendsClass, methods, seenSignatures, scannedClasses, haveRedirected, true, includeDynamic) && (f = fqn.lastIndexOf("::")) != -1; fqn = fqn.substring(0, f)) {
                }
            }
        }
        return foundIt;
    }

    private void addDatabaseProperties(String prefix, QuerySupport.Kind kind, String classFqn, Set<IndexedMethod> methods, boolean includeDynamic) {
        DatabasePropertiesIndexer.indexDatabaseProperties(this, prefix, kind, classFqn, methods, includeDynamic);
    }

    private void addQueryMethods(String prefix, QuerySupport.Kind kind, String classFqn, Set<IndexedMethod> methods) {
        ActiveRecordQueryIndexer.indexQueryMehods(this, prefix, kind, classFqn, methods);
    }

    public Set<String> getDatabaseTables(String prefix, QuerySupport.Kind kind) {
        String searchField = "dbtable";
        HashSet<IndexResult> result = new HashSet<IndexResult>();
        this.search(searchField, prefix, kind, result, "dbtable");
        HashSet<String> tables = new HashSet<String>();
        for (IndexResult map : result) {
            assert (map != null);
            String tableName = map.getValue("dbtable");
            if (tableName == null) continue;
            tables.add(tableName);
        }
        return tables;
    }

    public Set<IndexedVariable> getGlobals(String prefix, QuerySupport.Kind kind) {
        String searchField = "global";
        HashSet<IndexResult> result = new HashSet<IndexResult>();
        this.search(searchField, prefix, kind, result, "global");
        HashSet<IndexedVariable> globals = new HashSet<IndexedVariable>();
        for (IndexResult ir : result) {
            assert (ir != null);
            String[] names = ir.getValues("global");
            if (names == null) continue;
            for (String name : names) {
                int flags = 0;
                IndexedVariable var = IndexedVariable.create(this, name, name, null, ir, null, name, flags, ElementKind.GLOBAL, this.context);
                globals.add(var);
            }
        }
        return globals;
    }

    public Set<? extends IndexedConstant> getConstants(String constantFqn) {
        String[] parts = RubyUtils.parseConstantName(constantFqn);
        return this.getConstants(parts[0], parts[1]);
    }

    public Set<? extends IndexedConstant> getConstants(RubyType classFqn, String prefix) {
        HashSet<IndexedConstant> constants = new HashSet<IndexedConstant>();
        for (String realType : classFqn.getRealTypes()) {
            constants.addAll(this.getConstants(realType, prefix));
            for (String parentModule : RubyUtils.getParentModules(realType)) {
                constants.addAll(this.getConstants(parentModule, prefix));
            }
        }
        return constants;
    }

    public Set<? extends IndexedConstant> getConstants(String classFqn, String prefix) {
        boolean haveRedirected = false;
        if (classFqn == null || classFqn.equals(OBJECT)) {
            classFqn = CLASS;
            haveRedirected = true;
        } else if (MODULE.equals(classFqn) || CLASS.equals(classFqn)) {
            haveRedirected = true;
        }
        HashSet constants = new HashSet();
        if (prefix == null) {
            prefix = "";
        }
        this.addConstantsFromClass(prefix, classFqn, constants, haveRedirected);
        return constants;
    }

    private boolean addConstantsFromClass(String prefix, String classFqn, Set<? super IndexedConstant> constants, boolean haveRedirected) {
        String searchField = "fqn";
        HashSet<IndexResult> result = new HashSet<IndexResult>();
        this.search(searchField, classFqn, QuerySupport.Kind.EXACT, result, RubyUtils.addToArray(RubyIndexer.CLASS_FIELDS, "constant"));
        if (result.size() <= 0) {
            return false;
        }
        for (IndexResult map : result) {
            assert (map != null);
            String[] indexedConstants = map.getValues("constant");
            if (indexedConstants == null) continue;
            for (String constant : indexedConstants) {
                if (prefix.length() != 0 && !constant.startsWith(prefix)) continue;
                IndexedConstant c = this.createConstant(constant, map);
                c.setSmart(!haveRedirected);
                constants.add(c);
            }
        }
        return true;
    }

    public Set<IndexedField> getInheritedFields(String classFqn, String prefix, QuerySupport.Kind kind, boolean inherited) {
        boolean haveRedirected = false;
        if (classFqn == null || classFqn.equals(OBJECT)) {
            classFqn = CLASS;
            haveRedirected = true;
        } else if (MODULE.equals(classFqn) || CLASS.equals(classFqn)) {
            haveRedirected = true;
        }
        HashSet<IndexedField> members = new HashSet<IndexedField>();
        HashSet<String> scannedClasses = new HashSet<String>();
        HashSet<String> seenSignatures = new HashSet<String>();
        boolean instanceVars = true;
        if (prefix == null) {
            prefix = "";
        } else if (prefix.startsWith("@@")) {
            instanceVars = false;
            prefix = prefix.substring(2);
        } else if (prefix.startsWith("@")) {
            prefix = prefix.substring(1);
        }
        this.addFieldsFromClass(prefix, kind, classFqn, members, seenSignatures, scannedClasses, haveRedirected, instanceVars, inherited);
        return members;
    }

    private boolean addFieldsFromClass(String prefix, QuerySupport.Kind kind, String classFqn, Set<IndexedField> methods, Set<String> seenSignatures, Set<String> scannedClasses, boolean haveRedirected, boolean instanceVars, boolean inheriting) {
        boolean foundIt;
        if (scannedClasses.contains(classFqn)) {
            return false;
        }
        scannedClasses.add(classFqn);
        String searchField = "fqn";
        HashSet<IndexResult> result = new HashSet<IndexResult>();
        this.search(searchField, classFqn, QuerySupport.Kind.EXACT, result, RubyUtils.addToArray(RubyIndexer.CLASS_FIELDS, "field"));
        boolean bl = foundIt = result.size() > 0;
        if (!foundIt) {
            return foundIt;
        }
        String extendsClass = null;
        String classIn = null;
        int fqnIndex = classFqn.lastIndexOf("::");
        if (fqnIndex != -1) {
            classIn = classFqn.substring(0, fqnIndex);
        }
        for (IndexResult map : result) {
            String[] fields;
            String extendWith;
            String includes;
            assert (map != null);
            if (extendsClass == null) {
                extendsClass = map.getValue("extends");
            }
            if ((includes = map.getValue("includes")) != null) {
                String[] in;
                for (String include : in = includes.split(",")) {
                    boolean isQualified = false;
                    if (classIn != null) {
                        isQualified = this.addFieldsFromClass(prefix, kind, classIn + "::" + include, methods, seenSignatures, scannedClasses, haveRedirected, instanceVars, true);
                    }
                    if (isQualified) continue;
                    this.addFieldsFromClass(prefix, kind, include, methods, seenSignatures, scannedClasses, haveRedirected, instanceVars, true);
                }
            }
            if ((extendWith = map.getValue("extendWith")) != null) {
                boolean isQualified = false;
                if (classIn != null) {
                    isQualified = this.addFieldsFromClass(prefix, kind, classIn + "::" + extendWith, methods, seenSignatures, scannedClasses, haveRedirected, instanceVars, true);
                }
                if (!isQualified) {
                    this.addFieldsFromClass(prefix, kind, extendWith, methods, seenSignatures, scannedClasses, haveRedirected, instanceVars, true);
                }
            }
            if ((fields = map.getValues("field")) == null) continue;
            for (String field : fields) {
                if (prefix.length() == 0 && !Character.isLowerCase(field.charAt(0)) || seenSignatures.contains(field)) continue;
                boolean isInstance = true;
                int signatureIndex = field.indexOf(59);
                if (signatureIndex != -1) {
                    int flags = IndexedElement.stringToFlag(field, signatureIndex + 1);
                    boolean bl2 = isInstance = (flags & 0x10) == 0;
                }
                if (isInstance != instanceVars || !field.startsWith(prefix)) continue;
                if (kind == QuerySupport.Kind.EXACT) {
                    if (field.length() > prefix.length() && field.charAt(prefix.length()) != '(' && field.charAt(prefix.length()) != ';') {
                        continue;
                    }
                } else assert (kind == QuerySupport.Kind.PREFIX || kind == QuerySupport.Kind.CASE_INSENSITIVE_PREFIX);
                seenSignatures.add(field);
                IndexedField f = this.createField(field, map, isInstance, inheriting);
                f.setSmart(!haveRedirected);
                methods.add(f);
            }
        }
        if (classFqn.equals(OBJECT)) {
            return foundIt;
        }
        if (extendsClass == null) {
            if (haveRedirected) {
                this.addFieldsFromClass(prefix, kind, OBJECT, methods, seenSignatures, scannedClasses, true, instanceVars, true);
            } else {
                this.addFieldsFromClass(prefix, kind, CLASS, methods, seenSignatures, scannedClasses, true, instanceVars, true);
            }
        } else if (!this.addFieldsFromClass(prefix, kind, extendsClass, methods, seenSignatures, scannedClasses, haveRedirected, instanceVars, true)) {
            int f;
            for (String fqn = classIn; fqn != null && !this.addFieldsFromClass(prefix, kind, fqn + "::" + extendsClass, methods, seenSignatures, scannedClasses, haveRedirected, instanceVars, true) && (f = fqn.lastIndexOf("::")) != -1; fqn = fqn.substring(0, f)) {
            }
        }
        return foundIt;
    }

    public Set<? extends IndexedElement> getDocumented(String fqn) {
        assert (fqn != null && fqn.length() > 0);
        int hashIndex = fqn.indexOf(35);
        if (hashIndex == -1) {
            return this.getDocumentedClasses(fqn);
        }
        String clz = fqn.substring(0, hashIndex);
        String method = fqn.substring(hashIndex + 1);
        return this.getDocumentedMethods(clz, method);
    }

    private Set<IndexedClass> getDocumentedClasses(String fqn) {
        HashSet<IndexResult> result = new HashSet<IndexResult>();
        String field = "fqn";
        this.search(field, fqn, QuerySupport.Kind.EXACT, result, RubyIndexer.CLASS_FIELDS);
        HashSet<IndexedClass> matches = new HashSet<IndexedClass>();
        for (IndexResult map : result) {
            int flags;
            assert (map != null);
            String attributes = map.getValue("attrs");
            if (attributes == null || ((flags = IndexedElement.stringToFlag(attributes, 0)) & 1) == 0) continue;
            matches.add(this.createClass(fqn, null, map));
        }
        return matches;
    }

    private Set<IndexedMethod> getDocumentedMethods(String fqn, String method) {
        HashSet<IndexResult> result = new HashSet<IndexResult>();
        String field = "fqn";
        this.search(field, fqn, QuerySupport.Kind.EXACT, result, new String[0]);
        HashSet<IndexedMethod> matches = new HashSet<IndexedMethod>();
        for (IndexResult map : result) {
            String[] attribs;
            String[] signatures = map.getValues("method");
            if (signatures != null) {
                for (String signature : signatures) {
                    int flags;
                    int attributes;
                    if ((method == null || method.length() == 0) && !Character.isLowerCase(signature.charAt(0)) || !signature.startsWith(method) || signature.length() > method.length() && signature.charAt(method.length()) != '(' && signature.charAt(method.length()) != ';' || (attributes = signature.indexOf(59, method.length())) == -1 || ((flags = IndexedElement.stringToFlag(signature, attributes + 1)) & 1) == 0) continue;
                    assert (map != null);
                    matches.add(this.createMethod(signature, map, false));
                }
            }
            if ((attribs = map.getValues("attribute")) == null) continue;
            for (String signature : attribs) {
                if ((method == null || method.length() == 0) && !Character.isLowerCase(signature.charAt(0)) || !signature.startsWith(method) || signature.length() > method.length() && signature.charAt(method.length()) != ';') continue;
                assert (map != null);
                matches.add(this.createMethod(signature, map, false));
            }
        }
        return matches;
    }

    public FileObject getRequiredFile(String require) {
        HashSet<IndexResult> result = new HashSet<IndexResult>();
        String field = "require";
        this.search(field, require, QuerySupport.Kind.EXACT, result, "require");
        for (IndexResult ir : result) {
            FileObject file = ir.getFile();
            if (file == null) continue;
            return file;
        }
        return null;
    }

    static String getClusterUrl() {
        if (clusterUrl == null) {
            File f = InstalledFileLocator.getDefault().locate("modules/org-netbeans-modules-ruby.jar", null, false);
            if (f == null) {
                throw new RuntimeException("Can't find cluster");
            }
            f = new File(f.getParentFile().getParentFile().getAbsolutePath());
            try {
                f = f.getCanonicalFile();
                clusterUrl = f.toURI().toURL().toExternalForm();
            }
            catch (IOException ioe) {
                Exceptions.printStackTrace((Throwable)ioe);
            }
        }
        return clusterUrl;
    }

    public static void setClusterUrl(String url) {
        clusterUrl = url;
    }

    static String getPreindexUrl(String url) {
        return RubyIndex.getPreindexUrl(url, null);
    }

    static String getPreindexUrl(String url, FileObject context) {
        String s;
        RubyPlatform platform = RubyPlatformManager.getDefaultPlatform();
        if (platform != null) {
            s = RubyIndex.getGemHomeURL(platform);
            if (s != null && url.startsWith(s)) {
                return GEM_URL + url.substring(s.length());
            }
            s = platform.getHomeUrl();
            if (url.startsWith(s)) {
                url = RUBYHOME_URL + url.substring(s.length());
                return url;
            }
        }
        if (url.startsWith(s = RubyIndex.getClusterUrl())) {
            return CLUSTER_URL + url.substring(s.length());
        }
        return url;
    }

    public static FileObject getFileObject(String url) {
        return RubyIndex.getFileObject(url, null);
    }

    public static FileObject getFileObject(String url, FileObject context) {
        try {
            if (url.startsWith(RUBYHOME_URL)) {
                RubyPlatform platform;
                Project project;
                Iterator<RubyPlatform> it = null;
                if (context != null && (project = FileOwnerQuery.getOwner((FileObject)context)) != null && (platform = RubyPlatform.platformFor((Project)project)) != null) {
                    it = Collections.singleton(platform).iterator();
                }
                if (it == null) {
                    it = RubyPlatformManager.platformIterator();
                }
                while (it.hasNext()) {
                    RubyPlatform platform2 = (RubyPlatform)it.next();
                    String u = platform2.getHomeUrl() + url.substring(RUBYHOME_URL.length());
                    FileObject fo = URLMapper.findFileObject((URL)new URL(u));
                    if (fo == null) continue;
                    return fo;
                }
                return null;
            }
            if (url.startsWith(GEM_URL)) {
                RubyPlatform platform;
                Project project;
                Iterator<RubyPlatform> it = null;
                if (context != null && (project = FileOwnerQuery.getOwner((FileObject)context)) != null && (platform = RubyPlatform.platformFor((Project)project)) != null) {
                    it = Collections.singleton(platform).iterator();
                }
                if (it == null) {
                    it = RubyPlatformManager.platformIterator();
                }
                while (it.hasNext()) {
                    String u;
                    FileObject fo;
                    GemManager gemManager;
                    RubyPlatform platform3 = (RubyPlatform)it.next();
                    if (!platform3.hasRubyGemsInstalled() || (gemManager = platform3.getGemManager()) == null || (fo = URLMapper.findFileObject((URL)new URL(u = gemManager.getGemHomeUrl() + url.substring(GEM_URL.length())))) == null) continue;
                    return fo;
                }
                return null;
            }
            if (url.startsWith(CLUSTER_URL)) {
                url = RubyIndex.getClusterUrl() + url.substring(CLUSTER_URL.length());
            }
            return URLMapper.findFileObject((URL)new URL(url));
        }
        catch (MalformedURLException mue) {
            Exceptions.printStackTrace((Throwable)mue);
            return null;
        }
    }

    private static String getGemHomeURL(RubyPlatform platform) {
        return platform.hasRubyGemsInstalled() ? platform.getGemManager().getGemHomeUrl() : null;
    }
}

