/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby;

import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jrubyparser.ast.Node;
import org.netbeans.modules.csl.api.DeclarationFinder;
import org.netbeans.modules.csl.api.ElementHandle;
import org.netbeans.modules.csl.api.HtmlFormatter;
import org.netbeans.modules.csl.spi.ParserResult;
import org.netbeans.modules.parsing.spi.Parser;
import org.netbeans.modules.ruby.AstUtilities;
import org.netbeans.modules.ruby.RubyDeclarationFinder;
import org.netbeans.modules.ruby.RubyUtils;
import org.netbeans.modules.ruby.elements.AstElement;
import org.netbeans.modules.ruby.elements.IndexedElement;
import org.netbeans.modules.ruby.elements.IndexedMethod;
import org.netbeans.modules.ruby.lexer.LexUtilities;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

abstract class RubyDeclarationFinderHelper {
    protected static final boolean CHOOSE_ONE_DECLARATION = Boolean.getBoolean("ruby.choose_one_decl");

    RubyDeclarationFinderHelper() {
    }

    protected static DeclarationFinder.DeclarationLocation fix(DeclarationFinder.DeclarationLocation location, ParserResult result) {
        if (location != DeclarationFinder.DeclarationLocation.NONE && location.getFileObject() == null && location.getUrl() == null) {
            return new DeclarationFinder.DeclarationLocation(RubyUtils.getFileObject((Parser.Result)result), location.getOffset(), location.getElement());
        }
        return location;
    }

    protected static DeclarationFinder.DeclarationLocation getLocation(ParserResult result, Node node) {
        AstElement element = AstElement.create(result, node);
        int lexOffset = LexUtilities.getLexerOffset((Parser.Result)result, node.getPosition().getStartOffset());
        return new DeclarationFinder.DeclarationLocation(null, lexOffset, (ElementHandle)element);
    }

    static class RubyAltLocation
    implements DeclarationFinder.AlternativeLocation {
        private IndexedElement element;
        private boolean isPreferred;
        private String cachedDisplayItem;

        RubyAltLocation(IndexedElement element, boolean isPreferred) {
            this.element = element;
            this.isPreferred = isPreferred;
        }

        public String getDisplayHtml(HtmlFormatter formatter) {
            formatter.setMaxLength(120);
            if (this.cachedDisplayItem == null) {
                formatter.reset();
                boolean nodoc = this.element.isNoDoc();
                boolean documented = this.element.isDocumented();
                if (this.isPreferred) {
                    formatter.emphasis(true);
                } else if (nodoc) {
                    formatter.deprecated(true);
                }
                if (this.element instanceof IndexedMethod) {
                    if (this.element.getFqn() != null) {
                        formatter.appendText(this.element.getFqn());
                        formatter.appendText(".");
                    }
                    formatter.appendText(this.element.getName());
                    IndexedMethod method = (IndexedMethod)this.element;
                    List<String> parameters = method.getParameters();
                    if (parameters != null && parameters.size() > 0) {
                        formatter.appendText("(");
                        Iterator it = parameters.iterator();
                        while (it.hasNext()) {
                            formatter.parameters(true);
                            formatter.appendText((String)it.next());
                            formatter.parameters(false);
                            if (!it.hasNext()) continue;
                            formatter.appendText(", ");
                        }
                        formatter.appendText(")");
                    }
                } else {
                    formatter.appendText(this.element.getFqn());
                }
                String filename = null;
                String url = this.element.getFileUrl();
                if (url != null) {
                    if (RubyUtils.isRubyStubsURL(url)) {
                        String stub;
                        int stubStart;
                        filename = NbBundle.getMessage(RubyDeclarationFinder.class, (String)"RubyLib");
                        if (url.indexOf("/stub_") == -1 && (stubStart = url.indexOf(stub = "rubystubs/1.8.7-p72")) != -1) {
                            filename = filename + ": " + url.substring(stubStart);
                        }
                    } else {
                        int gemIndex;
                        int gemEnd;
                        FileObject fo = this.element.getFileObject();
                        if (fo != null) {
                            filename = fo.getNameExt();
                        } else {
                            int lastIndex = url.lastIndexOf(47);
                            if (lastIndex != -1) {
                                String s = url.substring(0, lastIndex);
                                int almostLastIndex = s.lastIndexOf(47);
                                if (almostLastIndex != -1 && url.length() - almostLastIndex < 40) {
                                    filename = url.substring(almostLastIndex + 1);
                                    if (filename.indexOf(58) != -1) {
                                        filename = url.substring(lastIndex + 1);
                                    }
                                } else {
                                    filename = url.substring(lastIndex + 1);
                                }
                            }
                        }
                        Pattern p = Pattern.compile("lib/ruby/gems/\\d+\\.\\d+/gems/");
                        Matcher m = p.matcher(url);
                        if (m.find() && (gemEnd = url.indexOf(47, gemIndex = m.end())) != -1) {
                            filename = url.substring(gemIndex, gemEnd) + ": " + filename;
                        }
                    }
                }
                if (filename != null) {
                    formatter.appendText(" ");
                    formatter.appendText(NbBundle.getMessage(RubyDeclarationFinder.class, (String)"In"));
                    formatter.appendText(" ");
                    formatter.appendText(filename);
                }
                if (documented) {
                    formatter.appendText(" ");
                    formatter.appendText(NbBundle.getMessage(RubyDeclarationFinder.class, (String)"Documented"));
                } else if (nodoc) {
                    formatter.appendText(" ");
                    formatter.appendText(NbBundle.getMessage(RubyDeclarationFinder.class, (String)"NoDoced"));
                }
                if (this.isPreferred) {
                    formatter.emphasis(false);
                } else if (nodoc) {
                    formatter.deprecated(false);
                }
                this.cachedDisplayItem = formatter.getText();
            }
            return this.cachedDisplayItem;
        }

        public DeclarationFinder.DeclarationLocation getLocation() {
            Node node = AstUtilities.getForeignNode(this.element);
            int lineOffset = node != null ? node.getPosition().getStartOffset() : -1;
            DeclarationFinder.DeclarationLocation loc = new DeclarationFinder.DeclarationLocation(this.element.getFileObject(), lineOffset, (ElementHandle)this.element);
            return loc;
        }

        public ElementHandle getElement() {
            return this.element;
        }

        public int compareTo(DeclarationFinder.AlternativeLocation alternative) {
            String thatIn;
            RubyAltLocation alt = (RubyAltLocation)alternative;
            if (this.isPreferred) {
                return -1;
            }
            if (alt.isPreferred) {
                return 1;
            }
            if (this.element.isNoDoc() != alt.element.isNoDoc()) {
                return this.element.isNoDoc() ? 1 : -1;
            }
            if (this.element.isDocumented() != alt.element.isDocumented()) {
                return this.element.isDocumented() ? -1 : 1;
            }
            String thisIn = this.element.getIn() != null ? this.element.getIn() : "";
            int cmp = thisIn.compareTo(thatIn = alt.element.getIn() != null ? alt.element.getIn() : "");
            if (cmp != 0) {
                return cmp;
            }
            String thisFile = this.element.getFileObject() != null ? this.element.getFileObject().getNameExt() : "";
            String thatFile = alt.element.getFileObject() != null ? alt.element.getFileObject().getNameExt() : "";
            cmp = thisFile.compareTo(thatFile);
            return cmp;
        }
    }
}

