/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.jrubyparser.SourcePosition;
import org.jrubyparser.ast.ArgsNode;
import org.jrubyparser.ast.ArgumentNode;
import org.jrubyparser.ast.ClassNode;
import org.jrubyparser.ast.INameNode;
import org.jrubyparser.ast.IScopingNode;
import org.jrubyparser.ast.ListNode;
import org.jrubyparser.ast.LocalAsgnNode;
import org.jrubyparser.ast.MethodDefNode;
import org.jrubyparser.ast.Node;
import org.jrubyparser.ast.NodeType;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenId;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Utilities;
import org.netbeans.modules.csl.api.CodeCompletionContext;
import org.netbeans.modules.csl.api.CodeCompletionHandler;
import org.netbeans.modules.csl.api.CodeCompletionResult;
import org.netbeans.modules.csl.api.CompletionProposal;
import org.netbeans.modules.csl.api.DeclarationFinder;
import org.netbeans.modules.csl.api.ElementHandle;
import org.netbeans.modules.csl.api.ElementKind;
import org.netbeans.modules.csl.api.ParameterInfo;
import org.netbeans.modules.csl.spi.DefaultCompletionResult;
import org.netbeans.modules.csl.spi.ParserResult;
import org.netbeans.modules.parsing.api.Snapshot;
import org.netbeans.modules.parsing.api.Source;
import org.netbeans.modules.parsing.spi.Parser;
import org.netbeans.modules.parsing.spi.indexing.support.QuerySupport;
import org.netbeans.modules.ruby.AstPath;
import org.netbeans.modules.ruby.AstUtilities;
import org.netbeans.modules.ruby.CompletionRequest;
import org.netbeans.modules.ruby.FindersHelper;
import org.netbeans.modules.ruby.RDocFormatter;
import org.netbeans.modules.ruby.RubyClassCompleter;
import org.netbeans.modules.ruby.RubyClassDeclarationFinder;
import org.netbeans.modules.ruby.RubyCompletionItem;
import org.netbeans.modules.ruby.RubyConstantCompleter;
import org.netbeans.modules.ruby.RubyDeclarationFinder;
import org.netbeans.modules.ruby.RubyDynamicFindersCompleter;
import org.netbeans.modules.ruby.RubyHttpStatusCodeCompleter;
import org.netbeans.modules.ruby.RubyIndex;
import org.netbeans.modules.ruby.RubyKeywordCompleter;
import org.netbeans.modules.ruby.RubyMethodCompleter;
import org.netbeans.modules.ruby.RubyParser;
import org.netbeans.modules.ruby.RubyStringCompleter;
import org.netbeans.modules.ruby.RubyType;
import org.netbeans.modules.ruby.RubyUtils;
import org.netbeans.modules.ruby.elements.AstElement;
import org.netbeans.modules.ruby.elements.AstFieldElement;
import org.netbeans.modules.ruby.elements.AstNameElement;
import org.netbeans.modules.ruby.elements.CommentElement;
import org.netbeans.modules.ruby.elements.Element;
import org.netbeans.modules.ruby.elements.IndexedClass;
import org.netbeans.modules.ruby.elements.IndexedElement;
import org.netbeans.modules.ruby.elements.IndexedField;
import org.netbeans.modules.ruby.elements.IndexedMethod;
import org.netbeans.modules.ruby.elements.IndexedVariable;
import org.netbeans.modules.ruby.elements.KeywordElement;
import org.netbeans.modules.ruby.elements.RubyElement;
import org.netbeans.modules.ruby.lexer.Call;
import org.netbeans.modules.ruby.lexer.LexUtilities;
import org.netbeans.modules.ruby.lexer.RubyStringTokenId;
import org.netbeans.modules.ruby.lexer.RubyTokenId;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class RubyCodeCompleter
implements CodeCompletionHandler {
    private static final String KEY_REQUIRE = "require";
    private static final String KEY_INSTANCEOF = "instanceof";
    private static final String ATTR_UNUSEDLOCAL = "unusedlocal";
    private static final String KEY_PIPE = "pipe";
    private static final String KEY_METHOD = "method";
    private static final String KEY_METHOD_FQN = "methodfqn";
    private static final String KEY_CLASS = "class";
    private static final String KEY_CLASS_FQN = "classfqn";
    private static final String KEY_SUPERCLASS = "superclass";
    private static final String KEY_FILE = "file";
    private static final String KEY_PATH = "path";
    private static final String ATTR_DEFAULTS = "defaults";
    private static final Set<String> selectionTemplates = new HashSet<String>();
    private boolean caseSensitive;
    private int anchor;

    static boolean startsWith(String theString, String prefix, boolean caseSensitive) {
        if (prefix.length() == 0) {
            return true;
        }
        return caseSensitive ? theString.startsWith(prefix) : theString.toLowerCase().startsWith(prefix.toLowerCase());
    }

    private boolean startsWith(String theString, String prefix) {
        return RubyCodeCompleter.startsWith(theString, prefix, this.caseSensitive);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getPrefix(ParserResult info, int lexOffset, boolean upToOffset) {
        try {
            BaseDocument doc = RubyUtils.getDocument((Parser.Result)info);
            if (doc == null) {
                return null;
            }
            TokenHierarchy th = TokenHierarchy.get((Document)doc);
            doc.readLock();
            try {
                String prefix;
                int lineOffset;
                int doubleQuotedOffset;
                String tokenText;
                Token token;
                int requireStart = LexUtilities.getRequireStringOffset(lexOffset, (TokenHierarchy<Document>)th);
                if (requireStart != -1) {
                    String string = doc.getText(requireStart, lexOffset - requireStart);
                    return string;
                }
                TokenSequence ts = LexUtilities.getRubyTokenSequence((TokenHierarchy<Document>)th, lexOffset);
                if (ts == null) {
                    String string = null;
                    return string;
                }
                ts.move(lexOffset);
                if (!ts.moveNext() && !ts.movePrevious()) {
                    String string = null;
                    return string;
                }
                if (ts.offset() == lexOffset) {
                    ts.movePrevious();
                }
                if ((token = ts.token()) != null) {
                    int currOffset;
                    TokenId id = token.id();
                    if (id == RubyTokenId.EMBEDDED_RUBY) {
                        ts = ts.embedded();
                        assert (ts != null);
                        ts.move(lexOffset);
                        if (!ts.moveNext() && !ts.movePrevious()) {
                            String string = null;
                            return string;
                        }
                        token = ts.token();
                        id = token.id();
                    }
                    tokenText = ((Object)token.text()).toString();
                    if ((id == RubyTokenId.STRING_BEGIN || id == RubyTokenId.QUOTED_STRING_BEGIN || id == RubyTokenId.ERROR && tokenText.equals("%")) && (currOffset = ts.offset()) == lexOffset - 1 && tokenText.length() > 0 && tokenText.charAt(0) == '%') {
                        String string = "%";
                        return string;
                    }
                }
                if ((doubleQuotedOffset = LexUtilities.getDoubleQuotedStringOffset(lexOffset, (TokenHierarchy<Document>)th)) != -1) {
                    String text;
                    if (doubleQuotedOffset == lexOffset) {
                        tokenText = "";
                        return tokenText;
                    }
                    if (doubleQuotedOffset >= lexOffset) {
                        text = "";
                        return text;
                    }
                    text = doc.getText(doubleQuotedOffset, lexOffset - doubleQuotedOffset);
                    TokenHierarchy hi = TokenHierarchy.create((CharSequence)text, RubyStringTokenId.languageDouble());
                    TokenSequence seq = hi.tokenSequence();
                    seq.move(lexOffset - doubleQuotedOffset);
                    if (!seq.moveNext() && !seq.movePrevious()) {
                        String string = "";
                        return string;
                    }
                    TokenId id = seq.token().id();
                    String s = ((Object)seq.token().text()).toString();
                    if (id == RubyStringTokenId.STRING_ESCAPE || id == RubyStringTokenId.STRING_INVALID) {
                        String string = s;
                        return string;
                    }
                    if (s.startsWith("\\")) {
                        String string = s;
                        return string;
                    }
                    String string = "";
                    return string;
                }
                int singleQuotedOffset = LexUtilities.getSingleQuotedStringOffset(lexOffset, (TokenHierarchy<Document>)th);
                if (singleQuotedOffset != -1) {
                    if (singleQuotedOffset == lexOffset) {
                        String hi = "";
                        return hi;
                    }
                    if (singleQuotedOffset >= lexOffset) {
                        String text = "";
                        return text;
                    }
                    String text = doc.getText(singleQuotedOffset, lexOffset - singleQuotedOffset);
                    TokenHierarchy hi = TokenHierarchy.create((CharSequence)text, RubyStringTokenId.languageSingle());
                    TokenSequence seq = hi.tokenSequence();
                    seq.move(lexOffset - singleQuotedOffset);
                    if (!seq.moveNext() && !seq.movePrevious()) {
                        String s = "";
                        return s;
                    }
                    TokenId id = seq.token().id();
                    String s = ((Object)seq.token().text()).toString();
                    if (id == RubyStringTokenId.STRING_ESCAPE || id == RubyStringTokenId.STRING_INVALID) {
                        String string = s;
                        return string;
                    }
                    if (s.startsWith("\\")) {
                        String string = s;
                        return string;
                    }
                    String string = "";
                    return string;
                }
                int regexpOffset = LexUtilities.getRegexpOffset(lexOffset, (TokenHierarchy<Document>)th);
                if (regexpOffset != -1 && regexpOffset <= lexOffset) {
                    String tokenText2 = ((Object)token.text()).toString();
                    int index = lexOffset - ts.offset();
                    if (index > 0 && index <= tokenText2.length() && tokenText2.charAt(index - 1) == '\\') {
                        String id = "\\";
                        return id;
                    }
                    String id = "";
                    return id;
                }
                int lineBegin = Utilities.getRowStart((BaseDocument)doc, (int)lexOffset);
                if (lineBegin == -1) return null;
                int lineEnd = Utilities.getRowEnd((BaseDocument)doc, (int)lexOffset);
                String line = doc.getText(lineBegin, lineEnd - lineBegin);
                int start = lineOffset = lexOffset - lineBegin;
                if (lineOffset > 0) {
                    char c;
                    int i = lineOffset - 1;
                    while (i >= 0 && RubyUtils.isIdentifierChar(c = line.charAt(i))) {
                        start = i--;
                    }
                }
                if (upToOffset) {
                    prefix = line.substring(start, lineOffset);
                } else if (lineOffset == line.length()) {
                    prefix = line.substring(start);
                } else {
                    char d;
                    int n = line.length();
                    int end = lineOffset;
                    for (int j = lineOffset; j < n && RubyUtils.isStrictIdentifierChar(d = line.charAt(j)); ++j) {
                        end = j + 1;
                    }
                    prefix = line.substring(start, end);
                }
                if (prefix.length() <= 0) return null;
                if (prefix.endsWith("::")) {
                    String n = "";
                    return n;
                }
                if (prefix.endsWith(":") && prefix.length() > 1) {
                    String n = null;
                    return n;
                }
                int q = prefix.lastIndexOf("::");
                if (q != -1) {
                    prefix = prefix.substring(q + 2);
                }
                if (prefix.length() == 1) {
                    char c = prefix.charAt(0);
                    if (!Character.isJavaIdentifierPart(c) && c != '@' && c != '$' && c != ':') {
                        String j = null;
                        return j;
                    }
                } else {
                    for (int i = prefix.length() - 2; i >= 0; --i) {
                        char c = prefix.charAt(i);
                        if (i == 0 && c == ':' || Character.isJavaIdentifierPart(c) || c == '@' || c == '$') continue;
                        prefix = prefix.substring(i + 1);
                        break;
                    }
                }
                String string = prefix;
                return string;
            }
            finally {
                doc.readUnlock();
            }
        }
        catch (BadLocationException ble) {
            // empty catch block
        }
        return null;
    }

    private boolean completeDefOrInclude(List<CompletionProposal> proposals, CompletionRequest request, String fqn) {
        RubyIndex index = request.index;
        String prefix = request.prefix;
        int lexOffset = request.lexOffset;
        TokenHierarchy<Document> th = request.th;
        QuerySupport.Kind kind = request.kind;
        TokenSequence<? extends RubyTokenId> ts = LexUtilities.getRubyTokenSequence(th, lexOffset);
        if (index != null && ts != null) {
            Token token;
            ts.move(lexOffset);
            if (!ts.moveNext() && !ts.movePrevious()) {
                return false;
            }
            if (ts.offset() == lexOffset) {
                ts.movePrevious();
            }
            if ((token = ts.token()) != null) {
                TokenId id = token.id();
                if (id == RubyTokenId.IDENTIFIER || id == RubyTokenId.CONSTANT || id.primaryCategory().equals("keyword")) {
                    if (!ts.movePrevious()) {
                        return false;
                    }
                    token = ts.token();
                    id = token.id();
                }
                if (id != RubyTokenId.WHITESPACE) {
                    return false;
                }
                while (ts.movePrevious() && (token = ts.token()).id() == RubyTokenId.WHITESPACE) {
                }
                if (token.id() == RubyTokenId.DEF) {
                    Set<IndexedMethod> methods = index.getInheritedMethods(fqn, prefix, kind);
                    for (IndexedMethod method : methods) {
                        if (prefix.length() > 0 && !method.getName().startsWith(prefix) || fqn != null && fqn.equals(method.getClz()) || method.isNoDoc()) continue;
                        RubyCompletionItem.MethodItem item = new RubyCompletionItem.MethodItem(method, this.anchor, request);
                        item.setSmart(method.isSmart());
                        proposals.add((CompletionProposal)item);
                    }
                    return true;
                }
                if (token.id() == RubyTokenId.IDENTIFIER && "include".equals(((Object)token.text()).toString())) {
                    Set<IndexedClass> classes = index.getClasses(prefix, kind, false, true, false);
                    for (IndexedClass clz : classes) {
                        if (clz.isNoDoc()) continue;
                        RubyCompletionItem.ClassItem item = new RubyCompletionItem.ClassItem(clz, this.anchor, request);
                        item.setSmart(true);
                        proposals.add((CompletionProposal)item);
                    }
                    return true;
                }
            }
        }
        return false;
    }

    private void completeGlobals(List<CompletionProposal> proposals, CompletionRequest request, boolean showSymbols) {
        RubyIndex index = request.index;
        String prefix = request.prefix;
        QuerySupport.Kind kind = request.kind;
        Set<IndexedVariable> globals = index.getGlobals(prefix, kind);
        for (IndexedVariable global : globals) {
            RubyCompletionItem item = new RubyCompletionItem(global, this.anchor, request);
            item.setSmart(true);
            if (showSymbols) {
                item.setSymbol(true);
            }
            proposals.add((CompletionProposal)item);
        }
    }

    private boolean addParameters(List<CompletionProposal> proposals, CompletionRequest request) {
        List<String> params;
        ParserResult info = request.parserResult;
        int lexOffset = request.lexOffset;
        int astOffset = request.astOffset;
        IndexedMethod[] methodHolder = new IndexedMethod[1];
        int[] paramIndexHolder = new int[1];
        int[] anchorOffsetHolder = new int[1];
        Set[] alternatesHolder = new Set[1];
        if (!RubyMethodCompleter.computeMethodCall((Parser.Result)info, lexOffset, astOffset, methodHolder, paramIndexHolder, anchorOffsetHolder, alternatesHolder, request.kind)) {
            return false;
        }
        IndexedMethod targetMethod = methodHolder[0];
        int index = paramIndexHolder[0];
        RubyCompletionItem.CallItem callItem = new RubyCompletionItem.CallItem(targetMethod, index, this.anchor, request);
        proposals.add((CompletionProposal)callItem);
        if (alternatesHolder[0] != null) {
            HashSet<String> signatures = new HashSet<String>();
            signatures.add(targetMethod.getSignature().substring(targetMethod.getSignature().indexOf(35) + 1));
            for (IndexedMethod m : alternatesHolder[0]) {
                String sig;
                if (m == targetMethod || !m.isDocumented() || m.isNoDoc() || signatures.contains(sig = m.getSignature().substring(m.getSignature().indexOf(35) + 1))) continue;
                RubyCompletionItem.CallItem item = new RubyCompletionItem.CallItem(m, index, this.anchor, request);
                proposals.add((CompletionProposal)item);
                signatures.add(sig);
            }
        }
        if ((params = targetMethod.getParameters()) == null || params.isEmpty()) {
            return false;
        }
        if (params.size() <= index) {
            index = params.size() - 1;
        }
        boolean isLastArg = index < params.size() - 1;
        String attrs = targetMethod.getEncodedAttributes();
        if (attrs != null && attrs.length() > 0) {
            String currentName;
            int offset = -1;
            for (int i = 0; i < 3 && (offset = attrs.indexOf(59, offset + 1)) != -1; ++i) {
            }
            if (offset == -1) {
                IndexedElement match;
                Node root = null;
                if (info != null) {
                    root = AstUtilities.getRoot((Parser.Result)info);
                }
                if ((match = RubyCodeCompleter.findDocumentationEntry(root, targetMethod)) == targetMethod || !(match instanceof IndexedMethod)) {
                    return false;
                }
                targetMethod = (IndexedMethod)match;
                attrs = targetMethod.getEncodedAttributes();
                if (attrs != null && attrs.length() > 0) {
                    offset = -1;
                    for (int i = 0; i < 3 && (offset = attrs.indexOf(59, offset + 1)) != -1; ++i) {
                    }
                }
            }
            if ((currentName = params.get(index)).startsWith("*")) {
                currentName = currentName.substring(1);
            } else if (currentName.startsWith("&")) {
                currentName = currentName.substring(1);
            }
            if (offset != -1) {
                String[] argEntries;
                if ((attrs = attrs.substring(offset + 1)).length() == 0) {
                    return false;
                }
                for (String entry : argEntries = attrs.split(",")) {
                    int parenIndex = entry.indexOf(40);
                    assert (parenIndex != -1) : attrs;
                    String name = entry.substring(0, parenIndex);
                    if (!currentName.equals(name)) continue;
                    int endIndex = entry.indexOf(41, parenIndex);
                    assert (endIndex != -1);
                    String data = entry.substring(parenIndex + 1, endIndex);
                    if (data.length() > 0 && data.charAt(0) == '-') {
                        if ("-table".equals(data)) {
                            this.completeDbTables(proposals, targetMethod, request, isLastArg);
                            continue;
                        }
                        if ("-column".equals(data)) {
                            this.completeDbColumns(proposals, targetMethod, request, isLastArg);
                            continue;
                        }
                        if (!"-model".equals(data)) continue;
                        this.completeModels(proposals, targetMethod, request, isLastArg);
                        continue;
                    }
                    if (data.startsWith("=>")) {
                        this.completeHash(proposals, request, targetMethod, data, isLastArg);
                        continue;
                    }
                    this.completeFixed(proposals, request, targetMethod, data, isLastArg);
                }
            }
        }
        return true;
    }

    private boolean completeHash(List<CompletionProposal> proposals, CompletionRequest request, IndexedMethod target, String data, boolean isLastArg) {
        int typeIndex;
        assert (data.startsWith("=>"));
        data = data.substring(2);
        String prefix = request.prefix;
        boolean inValue = false;
        TokenSequence<? extends RubyTokenId> ts = LexUtilities.getRubyTokenSequence(request.doc, this.anchor);
        if (ts == null) {
            return false;
        }
        ts.move(this.anchor);
        String line = null;
        while (ts.movePrevious()) {
            Token token = ts.token();
            if (token.id() == RubyTokenId.WHITESPACE) continue;
            if (token.id() != RubyTokenId.NONUNARY_OP || !((Object)token.text()).toString().equals("=>")) break;
            inValue = true;
            try {
                BaseDocument doc = request.doc;
                int lineStart = Utilities.getRowStart((BaseDocument)doc, (int)ts.offset());
                line = doc.getText(lineStart, ts.offset() - lineStart).trim();
            }
            catch (BadLocationException ble) {
                return false;
            }
        }
        ArrayList<String> suggestions = new ArrayList<String>();
        String key = null;
        String[] values = data.split("\\|");
        if (inValue) {
            for (String value : values) {
                String name;
                typeIndex = value.indexOf(58);
                if (typeIndex == -1 || !line.endsWith(name = value.substring(0, typeIndex))) continue;
                key = name;
                String type = value.substring(typeIndex + 1);
                if ("nil".equals(type)) {
                    suggestions.add("nil");
                    continue;
                }
                if ("bool".equals(type)) {
                    suggestions.add("true");
                    suggestions.add("false");
                    continue;
                }
                if ("submitmethod".equals(type)) {
                    suggestions.add("post");
                    suggestions.add("get");
                    continue;
                }
                if ("validationactive".equals(type)) {
                    suggestions.add(":save");
                    suggestions.add(":create");
                    suggestions.add(":update");
                    continue;
                }
                if ("string".equals(type)) {
                    suggestions.add("\"");
                    continue;
                }
                if ("hash".equals(type)) {
                    suggestions.add("{");
                    continue;
                }
                if ("controller".equals(type)) {
                    List<String> controllers = RubyUtils.getControllerNames(request.fileObject, true);
                    for (String n : controllers) {
                        suggestions.add("'" + n + "'");
                    }
                    continue;
                }
                if ("action".equals(type)) {
                    List<String> actions = this.getActionNames(request);
                    for (String n : actions) {
                        suggestions.add("'" + n + "'");
                    }
                    continue;
                }
                if (!"status".equals(type)) continue;
                return RubyHttpStatusCodeCompleter.complete(proposals, request, this.anchor, this.caseSensitive, target);
            }
        } else {
            for (String value : values) {
                typeIndex = value.indexOf(58);
                if (typeIndex != -1) {
                    value = value.substring(0, typeIndex);
                }
                value = ":" + value + " => ";
                suggestions.add(value);
            }
        }
        String colonPrefix = ":" + prefix;
        for (String suggestion : suggestions) {
            if (!this.startsWith(suggestion, prefix) && !this.startsWith(suggestion, colonPrefix)) continue;
            String insert = suggestion;
            String desc = null;
            if (inValue) {
                if (!isLastArg) {
                    insert = insert + ", ";
                }
                if (key != null) {
                    desc = ":" + key + " = " + suggestion;
                }
            }
            RubyCompletionItem.ParameterItem item = new RubyCompletionItem.ParameterItem(target, suggestion, desc, insert, this.anchor, request);
            item.setSymbol(true);
            item.setSmart(true);
            proposals.add((CompletionProposal)item);
        }
        return true;
    }

    private List<String> getActionNames(CompletionRequest request) {
        FileObject file = request.fileObject;
        FileObject controllerFile = null;
        controllerFile = file.getNameExt().endsWith("_controller.rb") ? file : RubyUtils.getRailsControllerFor(file);
        if (controllerFile == null) {
            return Collections.emptyList();
        }
        String controllerClass = RubyUtils.getControllerClass(controllerFile);
        if (controllerClass != null) {
            String prefix = request.prefix;
            Set<IndexedMethod> methods = request.index.getMethods(prefix, controllerClass, request.kind);
            ArrayList<String> actions = new ArrayList<String>();
            for (IndexedMethod method : methods) {
                if ((!method.isPublic() || method.getArgs() != null) && method.getArgs().length != 0) continue;
                actions.add(method.getName());
            }
            return actions;
        }
        return Collections.emptyList();
    }

    private void completeFixed(List<CompletionProposal> proposals, CompletionRequest request, IndexedMethod target, String data, boolean isLastArg) {
        String[] values = data.split("\\|");
        String prefix = request.prefix;
        String colonPrefix = ":" + prefix;
        for (String value : values) {
            if (!this.startsWith(value, prefix) && !this.startsWith(value, colonPrefix)) continue;
            String insert = isLastArg ? value : value + ", ";
            RubyCompletionItem.ParameterItem item = new RubyCompletionItem.ParameterItem(target, value, null, insert, this.anchor, request);
            item.setSymbol(true);
            item.setSmart(true);
            proposals.add((CompletionProposal)item);
        }
    }

    private void completeDbTables(List<CompletionProposal> proposals, IndexedMethod target, CompletionRequest request, boolean isLastArg) {
        String p;
        String colonPrefix = p = request.prefix;
        if (":".equals(p)) {
            p = "";
        } else {
            colonPrefix = ":" + p;
        }
        Set<String> tables = request.index.getDatabaseTables(p, request.kind);
        String prefix = request.prefix;
        for (String table : tables) {
            String tableName = ":" + table;
            if (!this.startsWith(tableName, prefix) && !this.startsWith(tableName, colonPrefix)) continue;
            String insert = isLastArg ? tableName : tableName + ", ";
            RubyCompletionItem.ParameterItem item = new RubyCompletionItem.ParameterItem(target, tableName, null, insert, this.anchor, request);
            item.setSymbol(true);
            item.setSmart(true);
            proposals.add((CompletionProposal)item);
        }
    }

    private void completeModels(List<CompletionProposal> proposals, IndexedMethod target, CompletionRequest request, boolean isLastArg) {
        Set<IndexedClass> clz = request.index.getSubClasses(request.prefix, "ActiveRecord::Base", request.kind);
        String prefix = request.prefix;
        String colonPrefix = ":" + prefix;
        for (IndexedClass c : clz) {
            String name = c.getName();
            String symbol = ":" + RubyUtils.camelToUnderlinedName(name);
            if (!this.startsWith(symbol, prefix) && !this.startsWith(symbol, colonPrefix)) continue;
            String insert = isLastArg ? symbol : symbol + ", ";
            RubyCompletionItem.ParameterItem item = new RubyCompletionItem.ParameterItem(target, symbol, name, insert, this.anchor, request);
            item.setSymbol(true);
            item.setSmart(true);
            proposals.add((CompletionProposal)item);
        }
    }

    private void completeDbColumns(List<CompletionProposal> proposals, IndexedMethod target, CompletionRequest request, boolean isLastArg) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CodeCompletionResult complete(CodeCompletionContext context) {
        ParserResult ir = context.getParserResult();
        int lexOffset = context.getCaretOffset();
        String prefix = context.getPrefix();
        QuerySupport.Kind kind = context.isPrefixMatch() ? QuerySupport.Kind.PREFIX : QuerySupport.Kind.EXACT;
        CodeCompletionHandler.QueryType queryType = context.getQueryType();
        this.caseSensitive = context.isCaseSensitive();
        int astOffset = AstUtilities.getAstOffset((Parser.Result)ir, lexOffset);
        if (astOffset == -1) {
            return null;
        }
        if (prefix == null) {
            prefix = "";
        }
        List<CompletionProposal> proposals = new ArrayList<CompletionProposal>();
        DefaultCompletionResult completionResult = new DefaultCompletionResult(proposals, false);
        this.anchor = lexOffset - prefix.length();
        RubyIndex index = RubyIndex.get((Parser.Result)ir);
        BaseDocument document = RubyUtils.getDocument((Parser.Result)ir);
        if (document == null) {
            return CodeCompletionResult.NONE;
        }
        lexOffset = AstUtilities.boundCaretOffset(ir, lexOffset);
        TokenHierarchy th = TokenHierarchy.get((Document)document);
        BaseDocument doc = document;
        FileObject fileObject = RubyUtils.getFileObject((Parser.Result)ir);
        boolean showLower = true;
        boolean showUpper = true;
        boolean showSymbols = false;
        char first = '\u0000';
        doc.readLock();
        try {
            AstElement co;
            Node node;
            Object f;
            String fqn;
            Node closest;
            AstPath path;
            int astLineEnd;
            int astLineBegin;
            CompletionRequest request;
            if (prefix.length() > 0) {
                first = prefix.charAt(0);
                int qualifier = prefix.lastIndexOf("::");
                if (qualifier != -1 && qualifier < prefix.length() - 2) {
                    first = prefix.charAt(qualifier + 2);
                }
                showLower = Character.isLowerCase(first);
                showUpper = Character.isUpperCase(first);
                if (first == ':') {
                    showSymbols = true;
                    if (prefix.length() > 1) {
                        char second = prefix.charAt(1);
                        prefix = prefix.substring(1);
                        showLower = Character.isLowerCase(second);
                        showUpper = Character.isUpperCase(second);
                    }
                }
            }
            if (RubyStringCompleter.complete(proposals, request = new CompletionRequest(completionResult, (TokenHierarchy<Document>)th, ir, lexOffset, astOffset, doc, prefix, index, kind, queryType, fileObject), this.anchor, this.caseSensitive)) {
                completionResult.setFilterable(false);
                DefaultCompletionResult second = completionResult;
                return second;
            }
            Call call = Call.getCallType(doc, (TokenHierarchy<Document>)th, lexOffset);
            Node root = AstUtilities.getRoot((Parser.Result)ir);
            if (root == null) {
                RubyKeywordCompleter.complete(proposals, request, this.anchor, this.caseSensitive, showSymbols);
                DefaultCompletionResult defaultCompletionResult = completionResult;
                return defaultCompletionResult;
            }
            try {
                astLineBegin = AstUtilities.getAstOffset((Parser.Result)ir, Utilities.getRowStart((BaseDocument)doc, (int)lexOffset));
                astLineEnd = AstUtilities.getAstOffset((Parser.Result)ir, Utilities.getRowEnd((BaseDocument)doc, (int)lexOffset));
            }
            catch (BadLocationException ble) {
                CodeCompletionResult codeCompletionResult = CodeCompletionResult.NONE;
                doc.readUnlock();
                return codeCompletionResult;
            }
            request.path = path = new AstPath(root, astOffset);
            HashMap<String, Node> variables = new HashMap<String, Node>();
            HashMap fields = new HashMap();
            HashMap globals = new HashMap();
            HashMap constants = new HashMap();
            request.target = closest = path.leaf();
            if (call.getLhs() == null) {
                if (showLower && closest != null) {
                    List<Node> applicableBlocks = AstUtilities.getApplicableBlocks(path, false);
                    for (Node block : applicableBlocks) {
                        RubyCodeCompleter.addDynamic(block, variables);
                    }
                    Node method = AstUtilities.findLocalScope(closest, path);
                    List list2 = method.childNodes();
                    for (Node child : list2) {
                        if (child.isInvisible()) continue;
                        RubyCodeCompleter.addLocals(child, variables);
                    }
                }
                boolean inAttrCall = this.isInAttr(closest, path);
                if (prefix.length() == 0 || first == '@' || showSymbols || inAttrCall) {
                    fqn = AstUtilities.getFqnName(path);
                    if (fqn == null || fqn.length() == 0) {
                        String fileName = RubyUtils.getFileObject((Parser.Result)context.getParserResult()).getName();
                        fqn = fileName.endsWith("_spec") ? RubyUtils.underlinedNameToCamel(fileName) : "Object";
                    }
                    if (RubyUtils.isRhtmlFile(fileObject) || RubyUtils.isMarkabyFile(fileObject)) {
                        f = new HashSet<IndexedField>();
                        this.addActionViewFields((Set<IndexedField>)f, fileObject, index, prefix, kind);
                    } else {
                        f = inAttrCall && first == ':' && prefix.length() == 1 ? index.getInheritedFields(fqn, "", kind, false) : index.getInheritedFields(fqn, prefix, kind, false);
                    }
                    for (IndexedField field : f) {
                        String insertPrefix = inAttrCall ? ":" : null;
                        RubyCompletionItem.FieldItem item = new RubyCompletionItem.FieldItem(field, this.anchor, request, insertPrefix);
                        item.setSmart(field.isSmart());
                        if (showSymbols) {
                            item.setSymbol(true);
                        }
                        proposals.add((CompletionProposal)item);
                    }
                    if (inAttrCall) {
                        Iterator<Object> i$ = completionResult;
                        return i$;
                    }
                }
                if ((prefix.length() == 0 || first == '$' || showSymbols) && (prefix.startsWith("$") || showSymbols)) {
                    this.completeGlobals(proposals, request, showSymbols);
                    RubyKeywordCompleter.complete(proposals, request, this.anchor, this.caseSensitive, showSymbols);
                    if (!showSymbols) {
                        fqn = completionResult;
                        return fqn;
                    }
                }
            }
            if (call.isConstantExpected()) {
                RubyConstantCompleter.complete(proposals, request, this.anchor, this.caseSensitive, call);
                RubyClassCompleter.complete(proposals, request, this.anchor, this.caseSensitive, call, showSymbols);
                RubyType type = call.getType();
                if (type.isKnown() && type.isSingleton()) {
                    RubyMethodCompleter.complete(proposals, request, type.first(), call, this.anchor, this.caseSensitive);
                }
                fqn = completionResult;
                return fqn;
            }
            boolean inCall = this.addParameters(proposals, request);
            if (index != null) {
                if (showLower || showSymbols) {
                    fqn = AstUtilities.getFqnName(path);
                    if (fqn == null || fqn.length() == 0) {
                        fqn = "Object";
                    }
                    if (fqn != null && queryType == CodeCompletionHandler.QueryType.COMPLETION && this.completeDefOrInclude(proposals, request, fqn)) {
                        f = completionResult;
                        return f;
                    }
                    if (fqn != null && RubyMethodCompleter.complete(proposals, request, fqn, call, this.anchor, this.caseSensitive)) {
                        f = completionResult;
                        return f;
                    }
                    if (call.getLhs() == null) {
                        Set<IndexedMethod> inheritedMethods = index.getInheritedMethods(fqn, prefix, kind);
                        inheritedMethods = RubyDynamicFindersCompleter.proposeDynamicMethods(inheritedMethods, proposals, request, this.anchor);
                        if (RubyUtils.isRhtmlFile(fileObject) || RubyUtils.isMarkabyFile(fileObject)) {
                            this.addActionViewMethods(inheritedMethods, fileObject, index, prefix, kind);
                        } else if (fileObject.getName().endsWith("_spec")) {
                            String[] includes;
                            for (String fqns : includes = new String[]{"Spec::Matchers", "Spec::Expectations::ObjectExpectations", "Spec::DSL::BehaviourEval::InstanceMethods"}) {
                                Set<IndexedMethod> helper = index.getInheritedMethods(fqns, prefix, kind);
                                inheritedMethods.addAll(helper);
                            }
                        }
                        for (IndexedMethod method : inheritedMethods) {
                            if (prefix.length() > 0 && !method.getName().startsWith(prefix) || method.isNoDoc()) continue;
                            RubyCompletionItem.MethodItem item = new RubyCompletionItem.MethodItem(method, this.anchor, request);
                            item.setSmart(method.isSmart());
                            if (showSymbols) {
                                item.setSymbol(true);
                            }
                            proposals.add((CompletionProposal)item);
                        }
                    }
                }
                if (showUpper && queryType == CodeCompletionHandler.QueryType.COMPLETION && this.completeDefOrInclude(proposals, request, "")) {
                    fqn = completionResult;
                    return fqn;
                }
                if (showUpper && (prefix != null && prefix.length() > 0 || !call.isMethodExpected() && call.getLhs() != null && call.getLhs().length() > 0) || showSymbols && !inCall) {
                    RubyConstantCompleter.complete(proposals, request, this.anchor, this.caseSensitive, call);
                    RubyClassCompleter.complete(proposals, request, this.anchor, this.caseSensitive, call, showSymbols);
                }
            }
            assert (kind == QuerySupport.Kind.PREFIX || kind == QuerySupport.Kind.CASE_INSENSITIVE_PREFIX || kind == QuerySupport.Kind.EXACT);
            for (String variable : variables.keySet()) {
                if ((kind != QuerySupport.Kind.EXACT || !prefix.equals(variable)) && (kind == QuerySupport.Kind.EXACT || !this.startsWith(variable, prefix)) || this.overlapsLine(node = (Node)variables.get(variable), astLineBegin, astLineEnd)) continue;
                co = new AstNameElement(ir, node, variable, ElementKind.VARIABLE);
                RubyCompletionItem item = new RubyCompletionItem(co, this.anchor, request);
                item.setSmart(true);
                if (showSymbols) {
                    item.setSymbol(true);
                }
                proposals.add((CompletionProposal)item);
            }
            for (String field : fields.keySet()) {
                if ((kind != QuerySupport.Kind.EXACT || !prefix.equals(field)) && (kind == QuerySupport.Kind.EXACT || !this.startsWith(field, prefix)) || this.overlapsLine(node = (Node)fields.get(field), astLineBegin, astLineEnd)) continue;
                co = new AstFieldElement(ir, node);
                RubyCompletionItem.FieldItem item = new RubyCompletionItem.FieldItem(co, this.anchor, request);
                item.setSmart(true);
                if (showSymbols) {
                    item.setSymbol(true);
                }
                proposals.add((CompletionProposal)item);
            }
            for (String variable : globals.keySet()) {
                if (!this.startsWith(variable, prefix) && (!showSymbols || !this.startsWith(variable.substring(1), prefix)) || this.overlapsLine(node = (Node)globals.get(variable), astLineBegin, astLineEnd)) continue;
                co = new AstNameElement(ir, node, variable, ElementKind.VARIABLE);
                RubyCompletionItem item = new RubyCompletionItem(co, this.anchor, request);
                item.setSmart(true);
                if (showSymbols) {
                    item.setSymbol(true);
                }
                proposals.add((CompletionProposal)item);
            }
            for (String variable : constants.keySet()) {
                if ((kind != QuerySupport.Kind.EXACT || !prefix.equals(variable)) && (kind == QuerySupport.Kind.EXACT || !this.startsWith(variable, prefix)) || this.overlapsLine(node = (Node)constants.get(variable), astLineBegin, astLineEnd)) continue;
                co = new AstNameElement(ir, node, variable, ElementKind.VARIABLE);
                RubyCompletionItem item = new RubyCompletionItem(co, this.anchor, request);
                item.setSmart(true);
                if (showSymbols) {
                    item.setSymbol(true);
                }
                proposals.add((CompletionProposal)item);
            }
            if (RubyKeywordCompleter.complete(proposals, request, this.anchor, this.caseSensitive, showSymbols)) {
                DefaultCompletionResult defaultCompletionResult = completionResult;
                return defaultCompletionResult;
            }
            if (queryType == CodeCompletionHandler.QueryType.DOCUMENTATION) {
                proposals = this.filterDocumentation(proposals, root, doc, ir, astOffset, lexOffset, prefix, path, index);
            }
        }
        finally {
            doc.readUnlock();
        }
        return completionResult;
    }

    private boolean isInAttr(Node closest, AstPath path) {
        if (closest != null) {
            for (Node child : closest.childNodes()) {
                if (!AstUtilities.isAttr(child)) continue;
                return true;
            }
            if (AstUtilities.isAttr(path.leafParent()) || AstUtilities.isAttr(path.leafGrandParent())) {
                return true;
            }
        }
        return false;
    }

    private void addActionViewMethods(Set<IndexedMethod> inheritedMethods, FileObject fileObject, RubyIndex index, String prefix, QuerySupport.Kind kind) {
        boolean isMarkaby = RubyUtils.isMarkabyFile(fileObject);
        if (isMarkaby) {
            Set<IndexedMethod> actionView = index.getInheritedMethods("ActionView::Base", prefix, kind);
            inheritedMethods.addAll(actionView);
        }
        if (RubyUtils.isRhtmlFile(fileObject) || isMarkaby) {
            String controllerName = null;
            for (FileObject f = fileObject.getParent(); f != null && !f.getName().equals("views"); f = f.getParent()) {
                String n = RubyUtils.underlinedNameToCamel(f.getName());
                controllerName = controllerName == null ? n : n + "::" + controllerName;
            }
            HashSet<String> helperNames = new HashSet<String>();
            helperNames.add(RubyUtils.helperName(controllerName));
            for (IndexedClass superClass : index.getSuperClasses(RubyUtils.controllerName(controllerName))) {
                if ("ActionController::Base".equals(superClass.getFqn())) break;
                helperNames.add(RubyUtils.helperName(superClass.getFqn()));
            }
            for (String helper : helperNames) {
                inheritedMethods.addAll(index.getInheritedMethods(helper, prefix, kind));
            }
            index.getSuperClasses(controllerName);
        }
    }

    private void addActionViewFields(Set<IndexedField> inheritedFields, FileObject fileObject, RubyIndex index, String prefix, QuerySupport.Kind kind) {
        boolean isMarkaby = RubyUtils.isMarkabyFile(fileObject);
        if (isMarkaby) {
            Set<IndexedField> actionView = index.getInheritedFields("ActionView::Base", prefix, kind, true);
            inheritedFields.addAll(actionView);
        }
        if (RubyUtils.isRhtmlFile(fileObject) || isMarkaby) {
            String controllerName = null;
            for (FileObject f = fileObject.getParent(); f != null && !f.getName().equals("views"); f = f.getParent()) {
                String n = RubyUtils.underlinedNameToCamel(f.getName());
                controllerName = controllerName == null ? n : n + "::" + controllerName;
            }
            String fqn = controllerName + "Controller";
            Set<IndexedField> controllerFields = index.getInheritedFields(fqn, prefix, kind, true);
            for (IndexedField field : controllerFields) {
                if ("ActionController::Base".equals(field.getIn())) continue;
                inheritedFields.add(field);
            }
        }
    }

    private List<CompletionProposal> filterDocumentation(List<CompletionProposal> proposals, Node root, BaseDocument doc, ParserResult parserResult, int astOffset, int lexOffset, String name, AstPath path, RubyIndex index) {
        CompletionProposal proposal2;
        ArrayList<CompletionProposal> candidates = new ArrayList<CompletionProposal>();
        FileObject fo = RubyUtils.getFileObject((Parser.Result)parserResult);
        HashMap<IndexedElement, CompletionProposal> elementMap = new HashMap<IndexedElement, CompletionProposal>();
        HashSet<IndexedMethod> methods = new HashSet<IndexedMethod>();
        HashSet<IndexedClass> classes = new HashSet<IndexedClass>();
        for (CompletionProposal proposal2 : proposals) {
            RubyElement e = (RubyElement)proposal2.getElement();
            if (!(e instanceof IndexedElement)) continue;
            IndexedElement ie = (IndexedElement)e;
            if (ie instanceof IndexedClass) {
                classes.add((IndexedClass)ie);
                elementMap.put(ie, proposal2);
            } else if (ie instanceof IndexedMethod) {
                methods.add((IndexedMethod)ie);
                elementMap.put(ie, proposal2);
            }
            if (ie.getFileObject() != fo) continue;
            candidates.add(proposal2);
        }
        for (CompletionProposal candidate : candidates) {
            IndexedElement e;
            String signature;
            Node node;
            RubyElement re = (RubyElement)candidate.getElement();
            if (!(re instanceof IndexedElement) || (node = AstUtilities.findBySignature(root, signature = (e = (IndexedElement)re).getSignature())) == null) continue;
            SourcePosition pos = node.getPosition();
            int startPos = LexUtilities.getLexerOffset((Parser.Result)parserResult, pos.getStartOffset());
            try {
                List<String> rdoc;
                int lineBegin = AstUtilities.getAstOffset((Parser.Result)parserResult, Utilities.getRowFirstNonWhite((BaseDocument)doc, (int)startPos));
                int lineEnd = AstUtilities.getAstOffset((Parser.Result)parserResult, Utilities.getRowEnd((BaseDocument)doc, (int)startPos));
                if (astOffset < lineBegin || astOffset > lineEnd || (rdoc = AstUtilities.gatherDocumentation(parserResult.getSnapshot(), node)) == null || rdoc.isEmpty()) continue;
                return Collections.singletonList(candidate);
            }
            catch (BadLocationException ble) {
            }
        }
        IndexedMethod candidate = null;
        if (!classes.isEmpty()) {
            RubyClassDeclarationFinder cdf = new RubyClassDeclarationFinder(parserResult, null, path, index, path.leaf());
            candidate = (IndexedMethod)cdf.findBestElementMatch(classes);
        } else if (!methods.isEmpty()) {
            RubyDeclarationFinder finder = new RubyDeclarationFinder();
            candidate = finder.findBestMethodMatch(name, methods, doc, astOffset, lexOffset, path, path.leaf(), index);
        }
        if (candidate != null && (proposal2 = (CompletionProposal)elementMap.get(candidate)) != null) {
            return Collections.singletonList(proposal2);
        }
        return proposals;
    }

    private boolean overlapsLine(Node node, int lineBegin, int lineEnd) {
        SourcePosition pos = node.getPosition();
        return pos.getStartOffset() >= lineBegin && pos.getStartOffset() <= lineEnd;
    }

    static void addLocals(Node node, Map<String, Node> variables) {
        switch (node.getNodeType()) {
            case LOCALASGNNODE: {
                String name = ((INameNode)node).getName();
                if (variables.containsKey(name)) break;
                variables.put(name, node);
                break;
            }
            case ARGSNODE: {
                String name;
                ArgsNode an = (ArgsNode)node;
                if (an.getRequiredCount() > 0) {
                    List args = an.childNodes();
                    for (Node arg : args) {
                        if (!(arg instanceof ListNode)) continue;
                        List args2 = arg.childNodes();
                        for (Node arg2 : args2) {
                            if (arg2 instanceof ArgumentNode) {
                                variables.put(((ArgumentNode)arg2).getName(), arg2);
                                continue;
                            }
                            if (!(arg2 instanceof LocalAsgnNode)) continue;
                            variables.put(((INameNode)arg2).getName(), arg2);
                        }
                    }
                }
                if (an.getRest() != null) {
                    name = an.getRest().getName();
                    variables.put(name, (Node)an.getRest());
                }
                if (an.getBlock() == null) break;
                name = an.getBlock().getName();
                variables.put(name, (Node)an.getBlock());
                break;
            }
        }
        List list = node.childNodes();
        block9: for (Node child : list) {
            if (child.isInvisible()) continue;
            switch (child.getNodeType()) {
                case DEFNNODE: 
                case DEFSNODE: 
                case CLASSNODE: 
                case SCLASSNODE: 
                case MODULENODE: {
                    continue block9;
                }
            }
            RubyCodeCompleter.addLocals(child, variables);
        }
    }

    static void addDynamic(Node node, Map<String, Node> variables) {
        String name;
        if (node.getNodeType() == NodeType.DASGNNODE && !variables.containsKey(name = ((INameNode)node).getName())) {
            variables.put(name, node);
        }
        List list = node.childNodes();
        block3: for (Node child : list) {
            if (child.isInvisible()) continue;
            switch (child.getNodeType()) {
                case DEFNNODE: 
                case DEFSNODE: 
                case CLASSNODE: 
                case SCLASSNODE: 
                case MODULENODE: 
                case ITERNODE: {
                    continue block3;
                }
            }
            RubyCodeCompleter.addDynamic(child, variables);
        }
    }

    private void addConstants(Node node, Map<String, Node> constants) {
        if (node.getNodeType() == NodeType.CONSTDECLNODE) {
            constants.put(((INameNode)node).getName(), node);
        }
        List list = node.childNodes();
        for (Node child : list) {
            if (child.isInvisible()) continue;
            this.addConstants(child, constants);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String loadResource(String basename) {
        InputStream is = null;
        StringBuilder sb = new StringBuilder();
        try {
            int c2;
            is = new BufferedInputStream(RubyCodeCompleter.class.getResourceAsStream("resources/" + basename));
            while ((c2 = is.read()) != -1) {
                sb.append((char)c2);
            }
            if (sb.length() > 0) {
                String c2 = sb.toString();
                return c2;
            }
        }
        catch (IOException ie) {
            Exceptions.printStackTrace((Throwable)ie);
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException ie) {
                Exceptions.printStackTrace((Throwable)ie);
            }
        }
        return null;
    }

    private String getKeywordHelp(String keyword) {
        if (keyword.equals("if") || keyword.equals("elsif") || keyword.equals("else") || keyword.equals("then") || keyword.equals("unless")) {
            return this.loadResource("ifelse.html");
        }
        if (keyword.equals("case") || keyword.equals("when") || keyword.equals("else")) {
            return this.loadResource("case.html");
        }
        if (keyword.equals("rescue") || keyword.equals("ensure")) {
            return this.loadResource("rescue.html");
        }
        if (keyword.equals("yield")) {
            return this.loadResource("yield.html");
        }
        return null;
    }

    static IndexedElement findDocumentationEntry(Node root, IndexedElement obj) {
        HashSet<? extends IndexedElement> candidates;
        String fqn = obj.getSignature();
        Set<? extends IndexedElement> result = obj.getIndex().getDocumented(fqn);
        if (result == null || result.isEmpty()) {
            return null;
        }
        if (result.size() == 1) {
            return result.iterator().next();
        }
        if (root != null) {
            candidates = new HashSet<IndexedElement>();
            Set<String> requires = AstUtilities.getRequires(root);
            for (IndexedElement indexedElement : result) {
                String require = indexedElement.getRequire();
                if (!requires.contains(require)) continue;
                candidates.add(indexedElement);
            }
            if (candidates.size() == 1) {
                return (IndexedElement)candidates.iterator().next();
            }
            if (!candidates.isEmpty()) {
                result = candidates;
            }
        }
        candidates = new HashSet();
        for (IndexedElement indexedElement : result) {
            String string = indexedElement.getFileUrl();
            if (!RubyUtils.isRubyStubsURL(string)) continue;
            candidates.add(indexedElement);
        }
        if (candidates.size() == 1) {
            return (IndexedElement)candidates.iterator().next();
        }
        if (!candidates.isEmpty()) {
            result = candidates;
        }
        return result.iterator().next();
    }

    static List<String> getComments(ParserResult info, Element element) {
        Snapshot snapshot;
        assert (info != null || element instanceof IndexedElement);
        if (element == null) {
            return null;
        }
        Node node = null;
        if (element instanceof AstElement) {
            node = ((AstElement)element).getNode();
        } else if (element instanceof IndexedElement) {
            IndexedElement match;
            IndexedElement com = (IndexedElement)element;
            Node root = null;
            if (info != null) {
                root = AstUtilities.getRoot((Parser.Result)info);
            }
            if ((match = RubyCodeCompleter.findDocumentationEntry(root, com)) != null) {
                com = match;
                element = com;
            }
            if ((node = AstUtilities.getForeignNode(com)) == null) {
                return null;
            }
        } else {
            assert (false) : element;
            return null;
        }
        if (element instanceof IndexedElement) {
            FileObject f = ((IndexedElement)element).getFileObject();
            snapshot = Source.create((FileObject)f).createSnapshot();
        } else if (info != null) {
            snapshot = info.getSnapshot();
        } else {
            return null;
        }
        List<String> comments = null;
        if (node instanceof ClassNode && !(element instanceof IndexedElement)) {
            ClassNode clz;
            String name;
            String className = AstUtilities.getClassOrModuleName((IScopingNode)((ClassNode)node));
            List<ClassNode> classes = AstUtilities.getClasses(AstUtilities.getRoot((Parser.Result)info));
            for (int i = classes.size() - 1; i >= 0 && (!(name = AstUtilities.getClassOrModuleName((IScopingNode)(clz = classes.get(i)))).equals(className) || (comments = AstUtilities.gatherDocumentation(snapshot, (Node)clz)) == null || comments.isEmpty()); --i) {
            }
        } else {
            comments = AstUtilities.gatherDocumentation(snapshot, node);
        }
        if (comments == null || comments.isEmpty()) {
            return null;
        }
        return comments;
    }

    public String document(ParserResult info, ElementHandle handle) {
        RDocFormatter formatter;
        RubyElement element = null;
        if (handle instanceof ElementHandle.UrlHandle) {
            String url = ((ElementHandle.UrlHandle)handle).getUrl();
            DeclarationFinder.DeclarationLocation loc = new RubyDeclarationFinder().findLinkedMethod(info, url);
            if (loc != DeclarationFinder.DeclarationLocation.NONE) {
                ElementHandle h = loc.getElement();
                if (handle != null && (element = RubyParser.resolveHandle(info, h)) == null) {
                    return null;
                }
            }
        } else {
            element = RubyParser.resolveHandle(info, handle);
        }
        if (element == null) {
            return null;
        }
        if (element instanceof KeywordElement) {
            return this.getKeywordHelp(((KeywordElement)element).getName());
        }
        if (element instanceof CommentElement) {
            String[] comments;
            String comment = element.getName();
            formatter = new RDocFormatter();
            for (String text : comments = comment.split("\n")) {
                int n = text.length();
                for (int i = 0; i < n; ++i) {
                    char c = text.charAt(i);
                    if (c == '#') {
                        if (i <= 0) continue;
                        text = text.substring(i);
                        break;
                    }
                    if (!Character.isWhitespace(c)) break;
                }
                formatter.appendLine(text);
            }
            return formatter.toHtml();
        }
        List<String> comments = RubyCodeCompleter.getComments(info, element);
        if (comments == null) {
            if (FindersHelper.isFinderMethod(element.getName(), false)) {
                return new RDocFormatter().getSignature(element) + NbBundle.getMessage(RubyCodeCompleter.class, (String)"DynamicMethod");
            }
            String html = new RDocFormatter().getSignature(element) + "\n<hr>\n<i>" + NbBundle.getMessage(RubyCodeCompleter.class, (String)"NoCommentFound") + "</i>";
            return html;
        }
        formatter = new RDocFormatter();
        String name = element.getName();
        if (name != null && name.length() > 0) {
            formatter.setSeqName(name);
        }
        for (String text : comments) {
            formatter.appendLine(text);
        }
        String html = formatter.toHtml();
        if (!formatter.wroteSignature()) {
            html = formatter.getSignature(element) + "\n<hr>\n" + html;
        }
        return html;
    }

    public ElementHandle resolveLink(String link, ElementHandle elementHandle) {
        if (elementHandle == null) {
            return null;
        }
        if (link.indexOf(35) != -1 && elementHandle.getMimeType().equals("text/x-ruby")) {
            RubyElement surrounding;
            if (link.startsWith("#") && (surrounding = RubyParser.resolveHandle(null, elementHandle)) != null && surrounding.getKind() != ElementKind.KEYWORD) {
                String name = surrounding.getName();
                ElementKind kind = surrounding.getKind();
                if (kind != ElementKind.CLASS && kind != ElementKind.MODULE) {
                    int index;
                    String in = surrounding.getIn();
                    if (in != null && in.length() > 0) {
                        name = in;
                    } else if (name != null && (index = name.indexOf(35)) > 0) {
                        name = name.substring(0, index);
                    }
                }
                if (name != null) {
                    link = name + link;
                }
            }
            return new ElementHandle.UrlHandle(link);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public Set<String> getApplicableTemplates(ParserResult info, int selectionBegin, int selectionEnd) {
        valid = false;
        if (selectionEnd != -1) {
            doc = RubyUtils.getDocument((Parser.Result)info);
            if (doc == null) {
                return Collections.emptySet();
            }
            try {
                doc.readLock();
                if (selectionBegin == selectionEnd) {
                    var6_6 = Collections.emptySet();
                    return var6_6;
                }
                if (selectionEnd < selectionBegin) {
                    temp = selectionBegin;
                    selectionBegin = selectionEnd;
                    selectionEnd = temp;
                }
                startLineIsEmpty = Utilities.isRowEmpty((BaseDocument)doc, (int)selectionBegin);
                endLineIsEmpty = Utilities.isRowEmpty((BaseDocument)doc, (int)selectionEnd);
                if (!startLineIsEmpty && selectionBegin > Utilities.getRowFirstNonWhite((BaseDocument)doc, (int)selectionBegin) || !endLineIsEmpty && selectionEnd <= Utilities.getRowLastNonWhite((BaseDocument)doc, (int)selectionEnd)) ** GOTO lbl32
                text = doc.getText(selectionBegin, selectionEnd - selectionBegin);
                for (i = 0; i < text.length(); ++i) {
                    if (Character.isWhitespace(text.charAt(i))) continue;
                    token = LexUtilities.getToken(doc, selectionBegin);
                    if (token == null || (id = token.id()) == RubyTokenId.STRING_LITERAL || id == RubyTokenId.LINE_COMMENT || id == RubyTokenId.QUOTED_STRING_LITERAL || id == RubyTokenId.REGEXP_LITERAL || id == RubyTokenId.DOCUMENTATION) break;
                    valid = true;
                }
            }
            catch (BadLocationException ble) {
            }
            finally {
                doc.readUnlock();
            }
        } else {
            valid = true;
        }
lbl32:
        // 6 sources

        if (valid) {
            return RubyCodeCompleter.selectionTemplates;
        }
        return Collections.emptySet();
    }

    private String suggestName(ParserResult info, int caretOffset, String prefix, Map params) {
        caretOffset = AstUtilities.boundCaretOffset(info, caretOffset);
        Node root = AstUtilities.getRoot((Parser.Result)info);
        if (root == null) {
            return null;
        }
        AstPath path = new AstPath(root, caretOffset);
        Node closest = path.leaf();
        if (closest == null) {
            return null;
        }
        if (prefix.startsWith("$")) {
            return null;
        }
        if (prefix.startsWith("@@")) {
            return null;
        }
        if (prefix.startsWith("@")) {
            return null;
        }
        if (closest != null) {
            Node method = AstUtilities.findLocalScope(closest, path);
            HashMap<String, Node> variables = new HashMap<String, Node>();
            RubyCodeCompleter.addLocals(method, variables);
            List<Node> applicableBlocks = AstUtilities.getApplicableBlocks(path, false);
            for (Node block : applicableBlocks) {
                RubyCodeCompleter.addDynamic(block, variables);
            }
            String suggestions = (String)params.get(ATTR_DEFAULTS);
            if (suggestions != null && suggestions.length() > 0) {
                String[] names;
                for (String suggestion : names = suggestions.split(",")) {
                    if (variables.containsKey(suggestion)) continue;
                    return suggestion;
                }
                for (String suggestion : names) {
                    for (int number = 2; number < 5; ++number) {
                        String name = suggestion + number;
                        if (name.length() <= 0 || variables.containsKey(name)) continue;
                        return name;
                    }
                }
            }
            if (prefix.length() > 0 && !variables.containsKey(prefix)) {
                return prefix;
            }
            if (prefix.length() == 0) {
                prefix = "var";
            }
            for (int number = 1; number < 15; ++number) {
                String name;
                String string = name = number == 1 ? prefix : prefix + number;
                if (name.length() <= 0 || variables.containsKey(name)) continue;
                return name;
            }
        }
        return null;
    }

    public String resolveTemplateVariable(String variable, ParserResult result, int caretOffset, String name, Map params) {
        if (variable.equals(KEY_PIPE)) {
            return "||";
        }
        if (variable.equals(ATTR_UNUSEDLOCAL)) {
            return this.suggestName(result, caretOffset, name, params);
        }
        if (params != null && params.containsKey(ATTR_UNUSEDLOCAL)) {
            return this.suggestName(result, caretOffset, name, params);
        }
        if (!(variable.equals(KEY_METHOD) || variable.equals(KEY_METHOD_FQN) || variable.equals(KEY_CLASS) || variable.equals(KEY_CLASS_FQN) || variable.equals(KEY_SUPERCLASS) || variable.equals(KEY_PATH) || variable.equals(KEY_FILE))) {
            return null;
        }
        caretOffset = AstUtilities.boundCaretOffset(result, caretOffset);
        Node root = AstUtilities.getRoot((Parser.Result)result);
        if (root == null) {
            return null;
        }
        AstPath path = new AstPath(root, caretOffset);
        if (variable.equals(KEY_METHOD)) {
            MethodDefNode node = AstUtilities.findMethod(path);
            if (node != null) {
                return AstUtilities.getDefName((Node)node);
            }
        } else if (variable.equals(KEY_METHOD_FQN)) {
            MethodDefNode node = AstUtilities.findMethod(path);
            if (node != null) {
                String ctx = AstUtilities.getFqnName(path);
                String methodName = AstUtilities.getDefName((Node)node);
                if (ctx != null && ctx.length() > 0) {
                    return ctx + "#" + methodName;
                }
                return methodName;
            }
        } else if (variable.equals(KEY_CLASS)) {
            ClassNode node = AstUtilities.findClass(path);
            if (node != null) {
                return node.getCPath().getName();
            }
        } else if (variable.equals(KEY_SUPERCLASS)) {
            ClassNode node = AstUtilities.findClass(path);
            if (node != null) {
                IndexedClass cls;
                RubyIndex index = RubyIndex.get((Parser.Result)result);
                if (index != null && (cls = index.getSuperclass(AstUtilities.getFqnName(path))) != null) {
                    return cls.getFqn();
                }
                String superCls = AstUtilities.getSuperclass(node);
                if (superCls != null) {
                    return superCls;
                }
                return "Object";
            }
        } else {
            if (variable.equals(KEY_CLASS_FQN)) {
                return AstUtilities.getFqnName(path);
            }
            if (variable.equals(KEY_FILE)) {
                return FileUtil.toFile((FileObject)result.getSnapshot().getSource().getFileObject()).getName();
            }
            if (variable.equals(KEY_PATH)) {
                return FileUtil.toFile((FileObject)RubyUtils.getFileObject((Parser.Result)result)).getPath();
            }
        }
        return null;
    }

    public ParameterInfo parameters(ParserResult info, int lexOffset, CompletionProposal proposal) {
        IndexedMethod[] methodHolder = new IndexedMethod[1];
        int[] paramIndexHolder = new int[1];
        int[] anchorOffsetHolder = new int[1];
        int astOffset = AstUtilities.getAstOffset((Parser.Result)info, lexOffset);
        if (!RubyMethodCompleter.computeMethodCall((Parser.Result)info, lexOffset, astOffset, methodHolder, paramIndexHolder, anchorOffsetHolder, null, QuerySupport.Kind.PREFIX)) {
            return ParameterInfo.NONE;
        }
        IndexedMethod method = methodHolder[0];
        if (method == null) {
            return ParameterInfo.NONE;
        }
        int index = paramIndexHolder[0];
        int astAnchorOffset = anchorOffsetHolder[0];
        int anchorOffset = LexUtilities.getLexerOffset((Parser.Result)info, astAnchorOffset);
        List<String> params = method.getParameters();
        if (params != null && !params.isEmpty()) {
            return new ParameterInfo(params, index, anchorOffset);
        }
        return ParameterInfo.NONE;
    }

    public CodeCompletionHandler.QueryType getAutoQuery(JTextComponent component, String typedText) {
        char c = typedText.charAt(0);
        if (c == '\n' || c == '(' || c == '[' || c == '{') {
            return CodeCompletionHandler.QueryType.STOP;
        }
        if (c != '.' && c != ':') {
            return CodeCompletionHandler.QueryType.NONE;
        }
        int offset = component.getCaretPosition();
        BaseDocument doc = (BaseDocument)component.getDocument();
        if (".".equals(typedText)) {
            TokenSequence<? extends RubyTokenId> ts = LexUtilities.getRubyTokenSequence(doc, offset);
            if (ts == null) {
                return CodeCompletionHandler.QueryType.NONE;
            }
            ts.move(offset);
            if (!ts.moveNext() && !ts.movePrevious()) {
                return CodeCompletionHandler.QueryType.NONE;
            }
            if (ts.offset() == offset && !ts.movePrevious()) {
                return CodeCompletionHandler.QueryType.NONE;
            }
            Token token = ts.token();
            TokenId id = token.id();
            if (id == RubyTokenId.RANGE) {
                return CodeCompletionHandler.QueryType.NONE;
            }
            if ("comment".equals(id.primaryCategory()) || "string".equals(id.primaryCategory()) || "regexp".equals(id.primaryCategory())) {
                return CodeCompletionHandler.QueryType.NONE;
            }
            return CodeCompletionHandler.QueryType.COMPLETION;
        }
        if (":".equals(typedText)) {
            int dot = component.getSelectionStart();
            try {
                if (dot > 1 && component.getText(dot - 2, 1).charAt(0) == ':' && RubyCodeCompleter.isRubyContext(doc, dot - 1)) {
                    return CodeCompletionHandler.QueryType.COMPLETION;
                }
            }
            catch (BadLocationException ble) {
                // empty catch block
            }
        }
        return CodeCompletionHandler.QueryType.NONE;
    }

    public static boolean isRubyContext(BaseDocument doc, int offset) {
        TokenSequence<? extends RubyTokenId> ts = LexUtilities.getRubyTokenSequence(doc, offset);
        if (ts == null) {
            return false;
        }
        ts.move(offset);
        if (!ts.movePrevious() && !ts.moveNext()) {
            return true;
        }
        TokenId id = ts.token().id();
        return !"comment".equals(id.primaryCategory()) && !"string".equals(id.primaryCategory()) && !"regexp".equals(id.primaryCategory());
    }

    static {
        selectionTemplates.add("begin");
        selectionTemplates.add("do");
        selectionTemplates.add("doc");
        selectionTemplates.add("if");
        selectionTemplates.add("ife");
    }
}

