/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.netbeans.modules.parsing.spi.indexing.support.IndexResult;
import org.netbeans.modules.parsing.spi.indexing.support.QuerySupport;
import org.netbeans.modules.ruby.FindersHelper;
import org.netbeans.modules.ruby.Inflector;
import org.netbeans.modules.ruby.RailsMigrationTypeMapper;
import org.netbeans.modules.ruby.RubyIndex;
import org.netbeans.modules.ruby.elements.IndexedElement;
import org.netbeans.modules.ruby.elements.IndexedMethod;
import org.openide.filesystems.FileObject;

final class DatabasePropertiesIndexer {
    private final RubyIndex index;
    private final String prefix;
    private final QuerySupport.Kind kind;
    private final String classFqn;
    private final Set<IndexedMethod> methods;
    private final boolean includeDynamicFinders;

    private DatabasePropertiesIndexer(RubyIndex index, String prefix, QuerySupport.Kind kind, String classFqn, Set<IndexedMethod> methods, boolean includeDynamicFinders) {
        this.index = index;
        this.prefix = prefix;
        this.kind = kind;
        this.classFqn = classFqn;
        this.methods = methods;
        this.includeDynamicFinders = includeDynamicFinders;
    }

    static void indexDatabaseProperties(RubyIndex index, String prefix, QuerySupport.Kind kind, String classFqn, Set<IndexedMethod> methods, boolean includeDynamicFinders) {
        DatabasePropertiesIndexer indexer = new DatabasePropertiesIndexer(index, prefix, kind, classFqn, methods, includeDynamicFinders);
        indexer.addDatabaseProperties();
    }

    private void addDatabaseProperties() {
        IndexResult result;
        String tableName = null;
        Collection<? extends IndexResult> classes = this.index.query("fqn", this.classFqn, QuerySupport.Kind.EXACT, new String[0]);
        Iterator<? extends IndexResult> i$ = classes.iterator();
        while (i$.hasNext() && (tableName = (result = i$.next()).getValue("explicit-dbtable")) == null) {
        }
        if (tableName == null) {
            Inflector inflector = Inflector.getDefault();
            tableName = inflector.tableize(inflector.demodulize(this.classFqn));
        }
        Collection<? extends IndexResult> result2 = this.index.query("dbtable", tableName, QuerySupport.Kind.EXACT, new String[0]);
        ArrayList<TableDefinition> tableDefs = new ArrayList<TableDefinition>();
        TableDefinition schema = null;
        for (IndexResult indexResult : result2) {
            assert (indexResult != null);
            String version = indexResult.getValue("dbversion");
            assert (tableName.equals(indexResult.getValue("dbtable")));
            TableDefinition def = new TableDefinition(tableName, version, indexResult.getFile());
            tableDefs.add(def);
            String[] columns = indexResult.getValues("dbcolumn");
            if (columns != null) {
                for (String column : columns) {
                    def.addColumn(column);
                }
            }
            if (!"schema".equals(version)) continue;
            schema = def;
            break;
        }
        if (tableDefs.size() > 0) {
            HashMap<String, String> columnDefs = new HashMap<String, String>();
            HashMap<String, FileObject> hashMap = new HashMap<String, FileObject>();
            HashSet<String> currentCols = new HashSet<String>();
            if (schema != null) {
                this.addColumnsFromSchema(schema, columnDefs, hashMap, currentCols);
            } else {
                this.addColumnsFromMigrations(tableDefs, columnDefs, hashMap, currentCols);
            }
            this.createMethodsForColumns(tableName, columnDefs, hashMap, currentCols);
            if (this.includeDynamicFinders) {
                this.createDynamicFinders(tableName, columnDefs, hashMap, currentCols);
            }
        }
    }

    private void addColumnsFromMigrations(List<TableDefinition> tableDefs, Map<String, String> columnDefs, Map<String, FileObject> fileUrls, Set<String> currentCols) {
        Collections.sort(tableDefs);
        for (TableDefinition def : tableDefs) {
            List<String> cols = def.getColumns();
            if (cols == null) continue;
            for (String col : cols) {
                int typeIndex = col.indexOf(59);
                if (typeIndex != -1) {
                    String name = col.substring(0, typeIndex);
                    if (typeIndex < col.length() - 1 && col.charAt(typeIndex + 1) == '-') {
                        currentCols.remove(name);
                        continue;
                    }
                    currentCols.add(name);
                    fileUrls.put(col, def.getFileUrl());
                    columnDefs.put(name, col);
                    continue;
                }
                currentCols.add(col);
                columnDefs.put(col, col);
                fileUrls.put(col, def.getFileUrl());
            }
        }
    }

    private void addColumnsFromSchema(TableDefinition schema, Map<String, String> columnDefs, Map<String, FileObject> fileUrls, Set<String> currentCols) {
        List<String> cols = schema.getColumns();
        if (cols != null) {
            for (String col : cols) {
                int typeIndex = col.indexOf(59);
                if (typeIndex != -1) {
                    String name = col.substring(0, typeIndex);
                    if (typeIndex < col.length() - 1 && col.charAt(typeIndex + 1) == '-') {
                        currentCols.remove(col);
                        continue;
                    }
                    currentCols.add(name);
                    fileUrls.put(col, schema.getFileUrl());
                    columnDefs.put(name, col);
                    continue;
                }
                currentCols.add(col);
                columnDefs.put(col, col);
                fileUrls.put(col, schema.getFileUrl());
            }
        }
    }

    private void createMethodsForColumns(String tableName, Map<String, String> columnDefs, Map<String, FileObject> fileUrls, Set<String> currentCols) {
        for (String column : currentCols) {
            if (!column.startsWith(this.prefix)) continue;
            if (this.kind == QuerySupport.Kind.EXACT) {
                if (column.length() > this.prefix.length()) {
                    continue;
                }
            } else assert (this.kind == QuerySupport.Kind.PREFIX || this.kind == QuerySupport.Kind.CASE_INSENSITIVE_PREFIX);
            String c = columnDefs.get(column);
            String type = tableName;
            int semicolonIndex = c.indexOf(59);
            if (semicolonIndex != -1) {
                type = c.substring(semicolonIndex + 1);
            }
            FileObject fileUrl = fileUrls.get(column);
            String signature = column;
            String fqn = tableName + "#" + column;
            String clz = type;
            String require = null;
            String attributes = "";
            int flags = 0;
            IndexedMethod method = IndexedMethod.create(this.index, signature, fqn, clz, fileUrl, require, attributes, flags, this.index.getContext());
            method.setMethodType(IndexedMethod.MethodType.DBCOLUMN);
            method.setType(RailsMigrationTypeMapper.getMappedType(type));
            method.setSmart(true);
            this.methods.add(method);
        }
    }

    private void createDynamicFinders(String tableName, Map<String, String> columnDefs, Map<String, FileObject> fileUrls, Set<String> currentCols) {
        if (this.kind == QuerySupport.Kind.EXACT) {
            return;
        }
        ArrayList<FindersHelper.FinderMethod> finders = new ArrayList<FindersHelper.FinderMethod>(FindersHelper.getFinderSignatures(this.prefix, currentCols));
        for (FindersHelper.FinderMethod finder : finders) {
            String methodName = finder.getName();
            String methodSignature = finder.getSignature();
            if (!methodName.startsWith(this.prefix) || this.prefix.length() > methodName.length()) continue;
            String column = finder.getColumn();
            FileObject fileUrl = fileUrls.get(column);
            String clz = this.classFqn;
            String require = null;
            int flags = 16;
            String attributes = IndexedElement.flagToString(flags) + ";;;" + "options(:first|:all),args(=>conditions|order|group|limit|offset|joins|readonly:bool|include|select|from|readonly:bool|lock:bool)";
            String fqn = tableName + "#" + methodSignature;
            IndexedMethod method = IndexedMethod.create(this.index, methodSignature, fqn, clz, fileUrl, require, attributes, flags, this.index.getContext());
            method.setMethodType(IndexedMethod.MethodType.DYNAMIC_FINDER);
            method.setInherited(false);
            method.setSmart(true);
            this.methods.add(method);
        }
    }

    private static class TableDefinition
    implements Comparable<TableDefinition> {
        private String version;
        private String table;
        private FileObject fileUrl;
        private List<String> cols;

        TableDefinition(String table, String version, FileObject fileUrl) {
            this.table = table;
            this.version = version;
            this.fileUrl = fileUrl;
        }

        @Override
        public int compareTo(TableDefinition o) {
            if (this.version.length() != o.version.length()) {
                return this.version.length() - o.version.length();
            }
            return this.version.compareTo(o.version);
        }

        FileObject getFileUrl() {
            return this.fileUrl;
        }

        void addColumn(String column) {
            if (this.cols == null) {
                this.cols = new ArrayList<String>();
            }
            this.cols.add(column);
        }

        List<String> getColumns() {
            return this.cols;
        }
    }
}

