/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.nb.javascript.xml;

import org.mozilla.nb.javascript.Context;
import org.mozilla.nb.javascript.Ref;
import org.mozilla.nb.javascript.ScriptRuntime;
import org.mozilla.nb.javascript.Scriptable;
import org.mozilla.nb.javascript.ScriptableObject;

public abstract class XMLLib {
    private static final Object XML_LIB_KEY = new Object();

    public static XMLLib extractFromScopeOrNull(Scriptable scriptable) {
        ScriptableObject scriptableObject = ScriptRuntime.getLibraryScopeOrNull(scriptable);
        if (scriptableObject == null) {
            return null;
        }
        ScriptableObject.getProperty((Scriptable)scriptableObject, "XML");
        return (XMLLib)scriptableObject.getAssociatedValue(XML_LIB_KEY);
    }

    public static XMLLib extractFromScope(Scriptable scriptable) {
        XMLLib xMLLib = XMLLib.extractFromScopeOrNull(scriptable);
        if (xMLLib != null) {
            return xMLLib;
        }
        String string = ScriptRuntime.getMessage0("msg.XML.not.available");
        throw Context.reportRuntimeError(string);
    }

    protected final XMLLib bindToScope(Scriptable scriptable) {
        ScriptableObject scriptableObject = ScriptRuntime.getLibraryScopeOrNull(scriptable);
        if (scriptableObject == null) {
            throw new IllegalStateException();
        }
        return (XMLLib)scriptableObject.associateValue(XML_LIB_KEY, this);
    }

    public abstract boolean isXMLName(Context var1, Object var2);

    public abstract Ref nameRef(Context var1, Object var2, Scriptable var3, int var4);

    public abstract Ref nameRef(Context var1, Object var2, Object var3, Scriptable var4, int var5);

    public abstract String escapeAttributeValue(Object var1);

    public abstract String escapeTextValue(Object var1);

    public abstract Object toDefaultXmlNamespace(Context var1, Object var2);

    public static abstract class Factory {
        public static Factory create(final String string) {
            return new Factory(){

                @Override
                public String getImplementationClassName() {
                    return string;
                }
            };
        }

        public abstract String getImplementationClassName();
    }
}

