/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.saas.codegen.util;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.text.Document;
import javax.swing.text.StyledDocument;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Unmarshaller;
import javax.xml.transform.stream.StreamSource;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.websvc.saas.codegen.Constants;
import org.netbeans.modules.websvc.saas.codegen.SaasClientCodeGenerator;
import org.netbeans.modules.websvc.saas.codegen.model.ParameterInfo;
import org.netbeans.modules.websvc.saas.codegen.model.RestClientSaasBean;
import org.netbeans.modules.websvc.saas.codegen.model.SaasBean;
import org.netbeans.modules.websvc.saas.codegen.model.SoapClientOperationInfo;
import org.netbeans.modules.websvc.saas.codegen.ui.CodeSetupPanel;
import org.netbeans.modules.websvc.saas.codegen.ui.ProgressDialog;
import org.netbeans.modules.websvc.saas.codegen.util.Inflector;
import org.netbeans.modules.websvc.saas.model.wadl.Application;
import org.netbeans.modules.websvc.saas.model.wadl.Method;
import org.netbeans.modules.websvc.saas.model.wadl.RepresentationType;
import org.netbeans.modules.websvc.saas.model.wadl.Resource;
import org.netbeans.modules.websvc.saas.util.SaasUtil;
import org.netbeans.modules.xml.wsdl.model.Binding;
import org.netbeans.modules.xml.wsdl.model.BindingInput;
import org.netbeans.modules.xml.wsdl.model.BindingOperation;
import org.netbeans.modules.xml.wsdl.model.Definitions;
import org.netbeans.modules.xml.wsdl.model.WSDLModel;
import org.netbeans.modules.xml.wsdl.model.extensions.soap.SOAPBinding;
import org.netbeans.modules.xml.wsdl.model.extensions.soap.SOAPBody;
import org.netbeans.modules.xml.wsdl.model.extensions.soap.SOAPMessageBase;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public class Util {
    public static final String TYPE_DOC_ROOT = "doc_root";
    public static final String AT = "@";
    public static final String APATH = "@Path";
    public static final String AGET = "@GET";
    public static final String APOST = "@POST";
    public static final String APUT = "@PUT";
    public static final String ADELETE = "@DELETE";
    public static final String SCANNING_IN_PROGRESS = "ScanningInProgress";
    public static final String BUILD_XML_PATH = "build.xml";
    public static final String VAR_NAMES_RESULT = "result";
    public static final String WIZARD_PANEL_CONTENT_DATA = "WizardPanel_contentData";
    public static final String WIZARD_PANEL_CONTENT_SELECTED_INDEX = "WizardPanel_contentSelectedIndex";
    private static Map<String, Class> primitiveTypes;
    private static Map<String, Class> primitiveClassTypes;
    private static HashSet<String> keywords;

    public static boolean isJsp(Document doc) {
        if (doc == null) {
            return false;
        }
        Object mimeType = doc.getProperty("mimeType");
        return mimeType != null && "text/x-jsp".equals(mimeType);
    }

    public static boolean isJava(Document doc) {
        if (doc == null) {
            return false;
        }
        Object mimeType = doc.getProperty("mimeType");
        return mimeType != null && "text/x-java".equals(mimeType);
    }

    public static void changeLabelInComponent(JComponent component, String oldLabel, String newLabel) {
        JLabel label = Util.findLabel(component, oldLabel);
        if (label != null) {
            label.setText(newLabel);
        }
    }

    public static void hideLabelAndLabelFor(JComponent component, String lab) {
        JLabel label = Util.findLabel(component, lab);
        if (label != null) {
            label.setVisible(false);
            Component c = label.getLabelFor();
            if (c != null) {
                c.setVisible(false);
            }
        }
    }

    public static void getAllComponents(Component[] components, Collection allComponents) {
        for (int i = 0; i < components.length; ++i) {
            if (components[i] == null) continue;
            allComponents.add(components[i]);
            if (((Container)components[i]).getComponentCount() == 0) continue;
            Util.getAllComponents(((Container)components[i]).getComponents(), allComponents);
        }
    }

    public static JLabel findLabel(JComponent comp, String labelText) {
        Vector allComponents = new Vector();
        Util.getAllComponents(comp.getComponents(), allComponents);
        for (Component c : allComponents) {
            JLabel label;
            if (!(c instanceof JLabel) || !(label = (JLabel)c).getText().equals(labelText)) continue;
            return label;
        }
        return null;
    }

    public static String getClassName(String fqClassName) {
        int dot = fqClassName.lastIndexOf(".");
        if (dot >= 0 && dot < fqClassName.length() - 1) {
            return fqClassName.substring(dot + 1);
        }
        return fqClassName;
    }

    public static String getPackageName(String fqClassName) {
        int dot = fqClassName.lastIndexOf(".");
        if (dot >= 0 && dot < fqClassName.length() - 1) {
            return fqClassName.substring(0, dot);
        }
        return "";
    }

    public static String lowerFirstChar(String name) {
        if (name.length() == 0) {
            return name;
        }
        StringBuilder sb = new StringBuilder(name);
        sb.setCharAt(0, Character.toLowerCase(name.charAt(0)));
        return sb.toString();
    }

    public static String upperFirstChar(String name) {
        if (name.length() == 0) {
            return name;
        }
        StringBuilder sb = new StringBuilder(name);
        sb.setCharAt(0, Character.toUpperCase(name.charAt(0)));
        return sb.toString();
    }

    public static String deriveResourceClassName(String resourceName) {
        return Util.upperFirstChar(resourceName) + "Resource";
    }

    public static String deriveUri(String resourceName, String currentUri) {
        if (resourceName.length() == 0 || currentUri == null || currentUri.length() == 0 || currentUri.charAt(0) != '/') {
            return currentUri;
        }
        resourceName = Util.lowerFirstChar(resourceName);
        resourceName = Util.pluralize(resourceName);
        String root = currentUri;
        String params = null;
        int lastIndex = currentUri.indexOf(123);
        if (lastIndex > -1) {
            params = root.substring(lastIndex - 1);
            if ((root = root.substring(0, lastIndex - 1)).length() == 0) {
                return currentUri;
            }
        }
        if ((lastIndex = root.lastIndexOf(47)) == -1) {
            return currentUri;
        }
        root = root.substring(0, lastIndex);
        String ret = root + "/" + resourceName;
        if (params != null) {
            ret = ret + params;
        }
        return ret;
    }

    public static String deriveContainerClassName(String resourceName) {
        return Util.deriveResourceClassName(Inflector.getInstance().pluralize(resourceName));
    }

    public static String singularize(String name) {
        String plural;
        if (name.endsWith("ss") && !name.equals(plural = Inflector.getInstance().pluralize(name))) {
            return name;
        }
        return Inflector.getInstance().singularize(name);
    }

    public static String pluralize(String name) {
        return Inflector.getInstance().pluralize(Util.singularize(name));
    }

    public static String camelize(String name, boolean lower) {
        return Inflector.getInstance().camelize(name.replace('-', '_'), lower);
    }

    public static String[] ensureTypes(String[] types) {
        if (types == null || types.length == 0 || types[0].length() == 0) {
            types = new String[]{String.class.getName()};
        }
        return types;
    }

    public static Class getType(Project project, String typeName) {
        ArrayList classPaths = new ArrayList();
        if (classPaths.size() == 0) {
            try {
                Class ret = Util.getPrimitiveClassType(typeName);
                if (ret != null) {
                    return ret;
                }
                return Class.forName(typeName);
            }
            catch (ClassNotFoundException ex) {
                return Object.class;
            }
        }
        for (ClassPath cp : classPaths) {
            try {
                Class ret = Util.getPrimitiveType(typeName);
                if (ret != null) {
                    return ret;
                }
                ClassLoader cl = cp.getClassLoader(true);
                ret = Util.getGenericRawType(typeName, cl);
                if (ret != null) {
                    return ret;
                }
                if (cl == null) continue;
                return cl.loadClass(typeName);
            }
            catch (ClassNotFoundException ex) {
            }
        }
        return null;
    }

    public static Class getPrimitiveClassType(String type) {
        if (primitiveClassTypes == null) {
            primitiveClassTypes = new HashMap<String, Class>();
            primitiveClassTypes.put("int", Integer.TYPE);
            primitiveClassTypes.put("boolean", Boolean.TYPE);
            primitiveClassTypes.put("byte", Byte.TYPE);
            primitiveClassTypes.put("char", Character.TYPE);
            primitiveClassTypes.put("double", Double.TYPE);
            primitiveClassTypes.put("float", Float.TYPE);
            primitiveClassTypes.put("long", Long.TYPE);
            primitiveClassTypes.put("short", Short.TYPE);
        }
        return primitiveClassTypes.get(type);
    }

    public static Class getPrimitiveType(String typeName) {
        if (primitiveTypes == null) {
            primitiveTypes = new HashMap<String, Class>();
            primitiveTypes.put("int", Integer.TYPE);
            primitiveTypes.put("int[]", int[].class);
            primitiveTypes.put("boolean", Boolean.TYPE);
            primitiveTypes.put("boolean[]", boolean[].class);
            primitiveTypes.put("byte", Byte.TYPE);
            primitiveTypes.put("byte[]", byte[].class);
            primitiveTypes.put("char", Character.TYPE);
            primitiveTypes.put("char[]", char[].class);
            primitiveTypes.put("double", Double.TYPE);
            primitiveTypes.put("double[]", double[].class);
            primitiveTypes.put("float", Float.TYPE);
            primitiveTypes.put("float[]", float[].class);
            primitiveTypes.put("long", Long.TYPE);
            primitiveTypes.put("long[]", long[].class);
            primitiveTypes.put("short", Short.TYPE);
            primitiveTypes.put("short[]", short[].class);
        }
        return primitiveTypes.get(typeName);
    }

    public static boolean isKeyword(String name) {
        if (keywords == null) {
            keywords = new HashSet();
            keywords.add("abstract");
            keywords.add("assert");
            keywords.add("boolean");
            keywords.add("break");
            keywords.add("byte");
            keywords.add("case");
            keywords.add("catch");
            keywords.add("char");
            keywords.add("class");
            keywords.add("const");
            keywords.add("continue");
            keywords.add("default");
            keywords.add("do");
            keywords.add("double");
            keywords.add("else");
            keywords.add("enum");
            keywords.add("extends");
            keywords.add("final");
            keywords.add("finally");
            keywords.add("float");
            keywords.add("for");
            keywords.add("goto");
            keywords.add("if");
            keywords.add("implements");
            keywords.add("import");
            keywords.add("instanceof");
            keywords.add("int");
            keywords.add("interface");
            keywords.add("long");
            keywords.add("native");
            keywords.add("new");
            keywords.add("package");
            keywords.add("private");
            keywords.add("protected");
            keywords.add("public");
            keywords.add("return");
            keywords.add("short");
            keywords.add("static");
            keywords.add("strictfp");
            keywords.add("super");
            keywords.add("switch");
            keywords.add("synchronized");
            keywords.add("this");
            keywords.add("throw");
            keywords.add("throws");
            keywords.add("transient");
            keywords.add("try");
            keywords.add("void");
            keywords.add("volatile");
            keywords.add("while");
        }
        return keywords.contains(name);
    }

    public static Class getGenericRawType(String typeName, ClassLoader loader) {
        int i = typeName.indexOf(60);
        if (i < 1) {
            return null;
        }
        String raw = typeName.substring(0, i);
        try {
            return loader.loadClass(raw);
        }
        catch (ClassNotFoundException ex) {
            Logger.global.log(Level.INFO, "", ex);
            return null;
        }
    }

    public static boolean isValidPackageName(String packageName) {
        String[] segments;
        if (packageName == null || packageName.endsWith(".")) {
            return false;
        }
        for (String s : segments = packageName.split("\\.")) {
            if (Utilities.isJavaIdentifier((String)s)) continue;
            return false;
        }
        return true;
    }

    public static String stripPackageName(String name) {
        int index = name.lastIndexOf(".");
        if (index > 0) {
            return name.substring(index + 1);
        }
        return name;
    }

    public static Collection<String> sortKeys(Collection<String> keys) {
        TreeSet<String> sortedKeys = new TreeSet<String>(new Comparator<String>(){

            @Override
            public int compare(String str1, String str2) {
                return str1.compareTo(str2);
            }
        });
        sortedKeys.addAll(keys);
        return sortedKeys;
    }

    public static java.lang.reflect.Method getValueOfMethod(Class type) {
        try {
            java.lang.reflect.Method method = type.getDeclaredMethod("valueOf", String.class);
            if (method == null || !Modifier.isStatic(method.getModifiers())) {
                return null;
            }
            return method;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Constructor getConstructorWithStringParam(Class type) {
        try {
            return type.getConstructor(String.class);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Project[] getProjectsFromLookup(Lookup lookup) {
        HashSet<Project> result = new HashSet<Project>();
        for (Project p : lookup.lookupAll(Project.class)) {
            result.add(p);
        }
        for (DataObject dObj : lookup.lookupAll(DataObject.class)) {
            FileObject fObj = dObj.getPrimaryFile();
            Project p = FileOwnerQuery.getOwner((FileObject)fObj);
            if (p == null) continue;
            result.add(p);
        }
        Project[] projectsArray = result.toArray(new Project[result.size()]);
        return projectsArray;
    }

    public static FileObject findBuildXml(Project project) {
        return project.getProjectDirectory().getFileObject(BUILD_XML_PATH);
    }

    public static DataObject createDataObjectFromTemplate(String template, FileObject targetFolder, String targetName) throws IOException {
        FileObject targetFO;
        assert (template != null);
        assert (targetFolder != null);
        FileObject templateFO = FileUtil.getConfigFile((String)template);
        DataObject templateDO = DataObject.find((FileObject)templateFO);
        DataFolder dataFolder = DataFolder.findFolder((FileObject)targetFolder);
        String fileName = targetName;
        if (fileName == null) {
            fileName = templateFO.getName();
        }
        if ((targetFO = targetFolder.getFileObject(fileName, templateFO.getExt())) != null) {
            return DataFolder.find((FileObject)targetFO);
        }
        return templateDO.createFromTemplate(dataFolder, targetName);
    }

    public static String deriveResourceName(String name) {
        String resourceName = Inflector.getInstance().camelize(Util.normailizeName(name) + "Resource");
        return resourceName.substring(0, 1).toUpperCase() + resourceName.substring(1);
    }

    public static String deriveMethodName(String name) {
        return Inflector.getInstance().camelize(Util.normailizeName(name), true);
    }

    public static String deriveUriTemplate(String name) {
        return Inflector.getInstance().camelize(Util.normailizeName(name), true) + "/";
    }

    public static Constants.MimeType[] deriveMimeTypes(SoapClientOperationInfo[] operations) {
        if (String.class.getName().equals(operations[operations.length - 1].getOperation().getReturnTypeName())) {
            return new Constants.MimeType[]{Constants.MimeType.HTML};
        }
        return new Constants.MimeType[]{Constants.MimeType.XML};
    }

    public static String normailizeName(String name) {
        return SaasUtil.toValidJavaName((String)name);
    }

    public static List<ParameterInfo> filterParametersByAuth(Constants.SaasAuthenticationType authType, SaasBean.SaasAuthentication auth, List<ParameterInfo> params) {
        ArrayList<ParameterInfo> filterParams = new ArrayList<ParameterInfo>();
        if (params != null) {
            for (ParameterInfo param : params) {
                if (authType == Constants.SaasAuthenticationType.API_KEY) {
                    SaasBean.ApiKeyAuthentication apiKey = (SaasBean.ApiKeyAuthentication)auth;
                    if (param.getName().equals(apiKey.getApiKeyName())) {
                        continue;
                    }
                } else if (authType == Constants.SaasAuthenticationType.SESSION_KEY) {
                    SaasBean.SessionKeyAuthentication sessionKey = (SaasBean.SessionKeyAuthentication)auth;
                    if (param.getName().equals(sessionKey.getApiKeyName()) || param.getName().equals(sessionKey.getSessionKeyName()) || param.getName().equals(sessionKey.getSigKeyName())) {
                        continue;
                    }
                } else if (authType == Constants.SaasAuthenticationType.SIGNED_URL) {
                    SaasBean.SignedUrlAuthentication signedUrl = (SaasBean.SignedUrlAuthentication)auth;
                    if (param.getName().equals(signedUrl.getSigKeyName())) continue;
                }
                filterParams.add(param);
            }
        }
        return filterParams;
    }

    public static List<ParameterInfo> filterParameters(List<ParameterInfo> params, ParameterInfo.ParamFilter[] filters) {
        ArrayList<ParameterInfo> filterParams = new ArrayList<ParameterInfo>();
        if (params != null) {
            for (ParameterInfo param : params) {
                for (ParameterInfo.ParamFilter filter : filters) {
                    if (filter == ParameterInfo.ParamFilter.FIXED && param.getFixed() != null) continue;
                    filterParams.add(param);
                }
            }
        }
        return filterParams;
    }

    public static ParameterInfo findParameter(List<ParameterInfo> params, String paramName) {
        for (ParameterInfo p : params) {
            if (!p.getName().equals(paramName)) continue;
            return p;
        }
        return null;
    }

    public static String createSessionKeyLoginBodyForWeb(SaasBean bean, String groupName, String paramVariableName) throws IOException {
        SaasBean.SaasAuthentication.UseGenerator.Login login;
        String methodBody = "";
        if (bean.getAuthenticationType() != Constants.SaasAuthenticationType.SESSION_KEY) {
            return null;
        }
        SaasBean.SessionKeyAuthentication sessionKey = (SaasBean.SessionKeyAuthentication)bean.getAuthentication();
        SaasBean.SaasAuthentication.UseGenerator useGenerator = sessionKey.getUseGenerator();
        if (useGenerator != null && (login = useGenerator.getLogin()) != null) {
            String methodName = null;
            SaasBean.SaasAuthentication.UseGenerator.Method method = login.getMethod();
            if (method != null) {
                methodName = method.getHref();
                if (methodName == null) {
                    return methodBody;
                }
                methodName = methodName.startsWith("#") ? methodName.substring(1) : methodName;
            }
            String tokenName = Util.getTokenName(useGenerator);
            String tokenMethodName = Util.getTokenMethodName(useGenerator);
            methodBody = methodBody + "    try {\n";
            methodBody = methodBody + "        javax.servlet.http.HttpSession session = request.getSession(true);\n";
            methodBody = methodBody + "        if (" + Util.getVariableName(sessionKey.getSessionKeyName()) + " != null) \n";
            methodBody = methodBody + "            return;\n";
            methodBody = methodBody + "        String " + tokenName + " = " + tokenMethodName + "(" + Util.getLoginArgumentsForWeb() + ");\n";
            methodBody = methodBody + "        if (" + tokenName + " != null) {\n";
            methodBody = methodBody + "           session.removeAttribute(\"" + groupName + "_auth_token\");\n";
            HashMap<String, String> tokenMap = new HashMap<String, String>();
            methodBody = methodBody + Util.getLoginBody(login, bean, groupName, tokenMap);
            for (Map.Entry e : tokenMap.entrySet()) {
                String name = (String)e.getKey();
                String val = (String)e.getValue();
                methodBody = methodBody + "              session.setAttribute(\"" + groupName + "_" + val + "\", " + name + ");\n";
            }
            methodBody = methodBody + "              String returnUrl = (String) session.getAttribute(\"" + groupName + "_return_url\");\n";
            methodBody = methodBody + "              if (returnUrl != null) {\n";
            methodBody = methodBody + "                session.removeAttribute(\"" + groupName + "_return_url\");\n";
            methodBody = methodBody + "                response.sendRedirect(returnUrl);\n";
            methodBody = methodBody + "              }\n";
            methodBody = methodBody + "            } else {\n";
            methodBody = methodBody + "                session.setAttribute(\"" + groupName + "_return_url\", request.getRequestURI());\n";
            methodBody = methodBody + "                response.sendRedirect(\"" + groupName + "Login\");\n";
            methodBody = methodBody + "            }\n";
            methodBody = methodBody + "        } catch (IOException ex) {\n";
            methodBody = methodBody + "            Logger.getLogger(" + groupName + "Authenticator" + ".class.getName()).log(Level.SEVERE, null, ex);\n";
            methodBody = methodBody + "        }\n\n";
        }
        return methodBody;
    }

    public static String getLoginBody(SaasBean.SaasAuthentication.UseGenerator.Login login, SaasBean bean, String groupName, Map<String, String> tokenMap) throws IOException {
        List<ParameterInfo> signParams;
        SaasBean.SaasAuthentication.UseGenerator.Method method = login.getMethod();
        String methodName = null;
        if (method != null) {
            methodName = method.getHref();
            if (methodName == null) {
                return "";
            }
            methodName = methodName.startsWith("#") ? methodName.substring(1) : methodName;
        }
        String methodBody = "";
        methodBody = methodBody + "                    String method = \"" + methodName + "\";\n";
        methodBody = methodBody + "                    String v = \"1.0\";\n\n";
        String sigId = "sig";
        if (login.getSignId() != null) {
            sigId = login.getSignId();
        }
        if ((signParams = login.getParameters()) != null && signParams.size() > 0) {
            String paramStr = "";
            paramStr = paramStr + "        String " + sigId + " = sign(secret, \n";
            paramStr = paramStr + Util.getSignParamUsage(signParams, groupName, bean.isDropTargetWeb());
            paramStr = paramStr + ");\n\n";
            methodBody = methodBody + paramStr;
        }
        String queryParamsCode = "";
        if (method != null) {
            Application app;
            Method wadlMethod;
            String href;
            String id = method.getId();
            if (id != null) {
                String[] tokens;
                for (String token : tokens = id.split(",")) {
                    String[] tokenElem = token.split("=");
                    if (tokenElem.length != 2) continue;
                    String val = tokenElem[1];
                    if (val.startsWith("{")) {
                        val = val.substring(1);
                    }
                    if (val.endsWith("{")) {
                        val = val.substring(val.length() - 1);
                    }
                    tokenMap.put(Util.getVariableName(tokenElem[0]), val);
                }
            }
            if ((href = method.getHref()) != null && bean instanceof RestClientSaasBean && (wadlMethod = SaasUtil.wadlMethodFromIdRef((Application)(app = ((RestClientSaasBean)bean).getMethod().getSaas().getWadlModel()), (String)href)) != null) {
                ArrayList<ParameterInfo> params = ((RestClientSaasBean)bean).findWadlParams(wadlMethod);
                Resource parentResource = SaasUtil.getParentResource((Application)app, (Method)wadlMethod);
                if (parentResource != null) {
                    RestClientSaasBean cfr_ignored_0 = (RestClientSaasBean)bean;
                    RestClientSaasBean.findWadlParams(params, parentResource.getParam());
                }
                if (params != null && params.size() > 0) {
                    queryParamsCode = Util.getHeaderOrParameterDefinition(params, "queryParams", false);
                }
            }
        }
        methodBody = methodBody + "        " + queryParamsCode;
        String url = "";
        if (bean instanceof RestClientSaasBean) {
            url = ((RestClientSaasBean)bean).getUrl();
        }
        methodBody = methodBody + "             RestConnection conn = new RestConnection(\"" + url + "\"";
        if (!queryParamsCode.trim().equals("")) {
            methodBody = methodBody + ", queryParams";
        }
        methodBody = methodBody + ");\n";
        methodBody = methodBody + "                    String result = conn.get();\n";
        for (Map.Entry<String, String> e : tokenMap.entrySet()) {
            String name = e.getKey();
            String val = e.getValue();
            methodBody = methodBody + "                    " + name + " = result.substring(result.indexOf(\"<" + val + ">\") + 13,\n";
            methodBody = methodBody + "                            result.indexOf(\"</" + val + ">\"));\n\n";
        }
        return methodBody;
    }

    public static String getSignParamUsage(List<ParameterInfo> signParams, String groupName, boolean isDropTargetWeb) {
        String paramStr = "                new String[][] {\n";
        for (ParameterInfo p : signParams) {
            String name = p.getName();
            String varName = Util.getVariableName(name);
            String[] pIds = Util.getParamIds(p, groupName, isDropTargetWeb);
            if (pIds != null) {
                varName = pIds[1];
            }
            paramStr = paramStr + "                    {\"" + name + "\", " + varName + "},\n";
        }
        paramStr = paramStr + "        }\n";
        return paramStr;
    }

    public static String[] getParamIds(ParameterInfo p, String groupName, boolean isDropTargetWeb) {
        String[] pElems;
        if (p.getId() != null && (pElems = p.getId().split("=")).length == 2) {
            String val = pElems[1];
            if (val.startsWith("{")) {
                val = val.substring(1);
            }
            if (val.endsWith("}")) {
                val = val.substring(0, val.length() - 1);
            }
            val = Util.getVariableName(val);
            val = Util.getAuthenticatorClassName(groupName) + "." + "get" + val.substring(0, 1).toUpperCase() + val.substring(1);
            val = isDropTargetWeb ? val + "(request, response)" : val + "()";
            return new String[]{pElems[0], val};
        }
        return null;
    }

    public static String getAuthenticatorClassName(String groupName) {
        return groupName + "Authenticator";
    }

    public static String getAuthorizationFrameClassName(String groupName) {
        return groupName + "AuthorizationFrame";
    }

    public static String createSessionKeyTokenBodyForWeb(SaasBean bean, String groupName, String paramVariableName, String saasServicePackageName) throws IOException {
        String methodBody = "";
        methodBody = methodBody + "        javax.servlet.http.HttpSession session = request.getSession(true);\n";
        methodBody = methodBody + "        return (String) session.getAttribute(\"" + groupName + "_auth_token\");\n";
        return methodBody;
    }

    public static String getTokenMethodName(SaasBean.SaasAuthentication.UseGenerator useGenerator) {
        String methodName = Util.getTokenName(useGenerator);
        methodName = "get" + methodName.substring(0, 1).toUpperCase() + methodName.substring(1);
        return methodName;
    }

    public static String getTokenName(SaasBean.SaasAuthentication.UseGenerator useGenerator) {
        String methodName = "token";
        SaasBean.SaasAuthentication.UseGenerator.Token token = useGenerator.getToken();
        if (token != null && token.getId() != null) {
            methodName = token.getId();
        }
        return Util.getVariableName(methodName);
    }

    public static String getHeaderOrParameterUsage(List<ParameterInfo> params) {
        String paramUsage = "";
        for (ParameterInfo param : params) {
            String name = Util.getParameterName(param, true, true, true);
            paramUsage = paramUsage + name + ", ";
        }
        if (params.size() > 0) {
            paramUsage = paramUsage.substring(0, paramUsage.length() - 2);
        }
        return paramUsage;
    }

    public static String getHeaderOrParameterDefinition(List<ParameterInfo> params, String varName, boolean evaluate, Constants.HttpMethodType httpMethod) {
        String part = Util.getHeaderOrParameterDefinitionPart(params, evaluate);
        if (!(httpMethod != Constants.HttpMethodType.PUT && httpMethod != Constants.HttpMethodType.POST || Util.isContains(params, new ParameterInfo("Content-Type", String.class)))) {
            part = part + ", {\"Content-Type\", " + Util.getVariableName("Content-Type") + "}";
        }
        String paramCode = "";
        paramCode = paramCode + "             String[][] " + varName + " = new String[][]{\n";
        paramCode = paramCode + "                 " + part + "\n";
        paramCode = paramCode + "             };\n";
        return paramCode;
    }

    public static String getHeaderOrParameterDefinition(List<ParameterInfo> params, String varName, boolean evaluate) {
        String paramCode = "";
        paramCode = paramCode + "             String[][] " + varName + " = new String[][]{\n";
        paramCode = paramCode + "                 " + Util.getHeaderOrParameterDefinitionPart(params, evaluate) + "\n";
        paramCode = paramCode + "             };\n";
        return paramCode;
    }

    public static String getHeaderOrParameterDefinitionPart(List<ParameterInfo> params, boolean evaluate) {
        String paramsStr = null;
        StringBuffer sb = new StringBuffer();
        for (ParameterInfo param : params) {
            String paramName = Util.getParameterName(param);
            String paramVal = null;
            if (evaluate || param.isApiKey()) {
                paramVal = Util.findParamValue(param);
                if (param.getType() != String.class) {
                    sb.append("{\"" + paramName + "\", " + paramVal + ".toString()},\n");
                    continue;
                }
                if (paramVal != null) {
                    sb.append("{\"" + paramName + "\", \"" + paramVal + "\"},\n");
                    continue;
                }
                sb.append("{\"" + paramName + "\", null},\n");
                continue;
            }
            if (param.getType() != String.class) {
                sb.append("{\"" + paramName + "\", " + Util.getVariableName(param.getName()) + ".toString()},\n");
                continue;
            }
            sb.append("{\"" + paramName + "\", " + Util.getVariableName(param.getName()) + "},\n");
        }
        paramsStr = sb.toString();
        if (params.size() > 0) {
            paramsStr = paramsStr.substring(0, paramsStr.length() - 2);
        }
        return paramsStr;
    }

    public static String getParameterName(ParameterInfo param) {
        return param.getName();
    }

    public static String getParameterName(ParameterInfo param, boolean camelize, boolean normalize) {
        return Util.getParameterName(param, camelize, normalize, false);
    }

    public static String getParameterName(ParameterInfo param, boolean camelize, boolean normalize, boolean trimBraces) {
        String name = param.getName();
        if (Util.isKeyword(name)) {
            name = name + "Param";
        }
        if (trimBraces && param.getStyle() == ParameterInfo.ParamStyle.TEMPLATE && name.startsWith("{") && name.endsWith("}")) {
            name = name.substring(0, name.length() - 1);
        }
        return Util.getParameterName(name, camelize, normalize);
    }

    public static String getParameterName(String name, boolean camelize, boolean normalize) {
        if (normalize) {
            name = Util.normailizeName(name);
        }
        if (camelize) {
            name = Inflector.getInstance().camelize(name, true);
        }
        return name;
    }

    public static String getVariableName(String name) {
        return Util.getVariableName(name, true, true, true);
    }

    public static String getVariableName(String name, boolean camelize, boolean normalize, boolean trimBraces) {
        String varName = name;
        if (trimBraces && varName.startsWith("{") && varName.endsWith("}")) {
            varName = varName.substring(0, varName.length() - 1);
        }
        if (normalize) {
            varName = Util.normailizeName(varName);
        }
        if (camelize) {
            varName = Inflector.getInstance().camelize(varName, true);
        }
        if (Util.isKeyword(varName)) {
            varName = varName + "Param";
        }
        return varName;
    }

    public static String findParamValue(ParameterInfo param) {
        String paramVal = null;
        if (param.isApiKey()) {
            paramVal = "\"+apiKey+\"";
        } else if (param.getStyle() == ParameterInfo.ParamStyle.TEMPLATE) {
            paramVal = param.getDefaultValue() != null ? param.getDefaultValue().toString() : "";
        } else if (param.getStyle() == ParameterInfo.ParamStyle.HEADER) {
            paramVal = param.isFixed() ? param.getFixed() : (param.getDefaultValue() != null ? param.getDefaultValue().toString() : "");
        } else if (param.isFixed()) {
            paramVal = param.getFixed();
        } else {
            if (param.isRequired()) {
                paramVal = "";
            }
            if (param.getDefaultValue() != null) {
                paramVal = param.getDefaultValue().toString();
            }
        }
        return paramVal;
    }

    public static String getServletLoginBody(SaasBean bean, String groupName) throws IOException {
        String methodBody = "";
        SaasBean.SessionKeyAuthentication sessionKey = (SaasBean.SessionKeyAuthentication)bean.getAuthentication();
        SaasBean.SaasAuthentication.UseGenerator useGenerator = sessionKey.getUseGenerator();
        if (useGenerator != null) {
            SaasBean.SaasAuthentication.UseGenerator.Token token = useGenerator.getToken();
            SaasBean.SaasAuthentication.UseGenerator.Token.Prompt prompt = token.getPrompt();
            String url = prompt.getWebUrl();
            String tokenName = "authToken";
            String tokenId = "auth_token";
            if (token != null) {
                tokenName = Util.getTokenName(useGenerator);
                tokenId = token.getId() != null ? token.getId() : tokenId;
            }
            methodBody = methodBody + "        response.setContentType(\"text/html;charset=UTF-8\");\n";
            methodBody = methodBody + "        PrintWriter out = response.getWriter();\n";
            methodBody = methodBody + "        try {\n";
            methodBody = methodBody + "            out.println(\"<html>\");\n";
            methodBody = methodBody + "            out.println(\"<head>\");\n";
            methodBody = methodBody + "            out.println(\"<title>Servlet " + groupName + "Login</title>\");\n";
            methodBody = methodBody + "            out.println(\"</head>\");\n";
            methodBody = methodBody + "            out.println(\"<body>\");\n";
            methodBody = methodBody + "            out.println(\"<h1>Servlet " + groupName + "Login at \" + request.getContextPath() + \"</h1>\");\n";
            methodBody = methodBody + "            HttpSession session = request.getSession(true);\n";
            methodBody = methodBody + "            String " + tokenName + " = (String) session.getAttribute(\"" + groupName + "_" + tokenId + "\");\n";
            methodBody = methodBody + "            if (" + tokenName + " != null) {\n";
            methodBody = methodBody + "                out.println(\"<p>Already logged in.</b>\");\n";
            methodBody = methodBody + "            } else {\n";
            String apiKeyName = Util.getVariableName(sessionKey.getApiKeyName());
            methodBody = methodBody + "                String apiKey = " + groupName + "Authenticator" + ".get" + apiKeyName.substring(0, 1).toUpperCase() + apiKeyName.substring(1) + "();\n";
            methodBody = methodBody + "                String loginUrl = \"<a href=" + Util.getTokenPromptUrl(token, url) + ">" + groupName + " Login</a>\";\n";
            methodBody = methodBody + "                out.println(loginUrl);\n";
            methodBody = methodBody + "            }\n";
            methodBody = methodBody + "            out.println(\"</body>\");\n";
            methodBody = methodBody + "            out.println(\"</html>\");\n";
            methodBody = methodBody + "        } finally {\n";
            methodBody = methodBody + "            out.close();\n";
            methodBody = methodBody + "        }\n";
        }
        return methodBody;
    }

    public static String getServletCallbackBody(SaasBean bean, String groupName) throws IOException {
        String methodBody = "";
        SaasBean.SessionKeyAuthentication sessionKey = (SaasBean.SessionKeyAuthentication)bean.getAuthentication();
        String sessionKeyName = Util.getVariableName(sessionKey.getSessionKeyName());
        String tokenName = "authToken";
        String tokenId = "auth_token";
        SaasBean.SaasAuthentication.UseGenerator useGenerator = sessionKey.getUseGenerator();
        if (useGenerator != null) {
            SaasBean.SaasAuthentication.UseGenerator.Token token = useGenerator.getToken();
            if (token != null) {
                tokenName = Util.getTokenName(useGenerator);
                tokenId = token.getId() != null ? token.getId() : tokenId;
            }
            String name = Util.getParameterName(sessionKey.getSessionKeyName(), true, true);
            methodBody = methodBody + "        response.setContentType(\"text/html;charset=UTF-8\");\n";
            methodBody = methodBody + "        PrintWriter out = response.getWriter();\n";
            methodBody = methodBody + "        try {\n";
            methodBody = methodBody + "            HttpSession session = request.getSession(true);\n";
            methodBody = methodBody + "            String " + tokenName + " = request.getParameter(\"" + tokenId + "\");\n";
            methodBody = methodBody + "            session.setAttribute(\"" + groupName + "_" + tokenId + "\", " + tokenName + ");\n";
            methodBody = methodBody + "            " + groupName + "Authenticator" + ".login(" + Util.getLoginArgumentsForWeb() + ");\n";
            methodBody = methodBody + "            String " + sessionKeyName + " = " + groupName + "Authenticator" + "." + Util.getSessionKeyMethodName(name) + "();\n";
            methodBody = methodBody + "            out.println(\"<html>\");\n";
            methodBody = methodBody + "            out.println(\"<head>\");\n";
            methodBody = methodBody + "            out.println(\"<title>Servlet " + groupName + "Callback</title>\");\n";
            methodBody = methodBody + "            out.println(\"</head>\");\n";
            methodBody = methodBody + "            out.println(\"<body>\");\n";
            methodBody = methodBody + "            out.println(\"<h1>Servlet " + groupName + "Callback at \" + request.getContextPath() + \"</h1>\");\n";
            methodBody = methodBody + "            out.println(\"<p> Your Session Key is \" + " + sessionKeyName + " + \"</p>\");\n";
            methodBody = methodBody + "            out.println(\"</body>\");\n";
            methodBody = methodBody + "            out.println(\"</html>\");\n";
            methodBody = methodBody + "        } finally {\n";
            methodBody = methodBody + "            out.close();\n";
            methodBody = methodBody + "        }\n";
        }
        return methodBody;
    }

    public static String getSessionKeyMethodName(String name) {
        String methodName = Util.getVariableName(name);
        methodName = "get" + methodName.substring(0, 1).toUpperCase() + methodName.substring(1);
        return methodName;
    }

    public static String getTokenPromptUrl(SaasBean.SaasAuthentication.UseGenerator.Token token, String url) {
        String loginUrl = "";
        if (token.getPrompt() != null) {
            String[] tokens;
            int index = url.indexOf("?");
            loginUrl = url.substring(0, index + 1);
            String params = url.substring(index + 1);
            for (String tokenE : tokens = params.split("&")) {
                String[] tokenElem = tokenE.split("=");
                if (tokenElem.length != 2) continue;
                String paramVal = tokenElem[1];
                if (paramVal.startsWith("{")) {
                    paramVal = paramVal.substring(1);
                }
                if (paramVal.endsWith("}")) {
                    paramVal = paramVal.substring(0, paramVal.length() - 1);
                }
                loginUrl = paramVal.indexOf(":") != -1 ? loginUrl + tokenElem[0] + "=" + Util.getVariableName(paramVal.substring(paramVal.indexOf(":") + 1)) + "&" : loginUrl + tokenElem[0] + "=\"+" + Util.getVariableName(paramVal) + "+\"&";
            }
            if (loginUrl.endsWith("+\"&")) {
                loginUrl = loginUrl.substring(0, loginUrl.length() - 3);
            } else if (loginUrl.endsWith("&")) {
                loginUrl = loginUrl.substring(0, loginUrl.length() - 1);
            }
        }
        return loginUrl;
    }

    public static List<ParameterInfo> getAuthenticatorMethodParametersForWeb() {
        ArrayList<ParameterInfo> params = new ArrayList<ParameterInfo>();
        params.add(new ParameterInfo("request", Object.class, "HttpServletRequest"));
        params.add(new ParameterInfo("response", Object.class, "HttpServletResponse"));
        return params;
    }

    public static List<ParameterInfo> getServiceMethodParametersForWeb(RestClientSaasBean bean) {
        ArrayList<ParameterInfo> params = new ArrayList<ParameterInfo>();
        params.addAll(Util.getAuthenticatorMethodParametersForWeb());
        params.addAll(bean.filterParametersByAuth(bean.filterParameters(new ParameterInfo.ParamFilter[]{ParameterInfo.ParamFilter.FIXED})));
        return params;
    }

    public static String getLoginArgumentsForWeb() {
        return Util.getHeaderOrParameterUsage(Util.getAuthenticatorMethodParametersForWeb());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> getJaxBClassImports() {
        ArrayList<String> imports = new ArrayList<String>();
        ClassLoader orig = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(Util.class.getClassLoader());
        try {
            imports.add(JAXBContext.class.getName());
            imports.add(Unmarshaller.class.getName());
            imports.add(StreamSource.class.getName());
            imports.add(StringReader.class.getName());
        }
        finally {
            Thread.currentThread().setContextClassLoader(orig);
        }
        return imports;
    }

    public static boolean isContains(List<ParameterInfo> params, ParameterInfo pInfo) {
        boolean found = false;
        String name = Util.getVariableName(pInfo.getName());
        for (ParameterInfo p : params) {
            if (!Util.getVariableName(p.getName()).equals(name)) continue;
            found = true;
            break;
        }
        return found;
    }

    public static void showUnsupportedDropMessage(Object[] args) {
        String message = NbBundle.getMessage(CodeSetupPanel.class, (String)"WARN_UnsupportedDropTarget", (Object[])args);
        NotifyDescriptor.Message desc = new NotifyDescriptor.Message((Object)message, 2);
        DialogDisplayer.getDefault().notify((NotifyDescriptor)desc);
    }

    public static String createPrintStatement(List<String> pkgs, List<String> typeNames, Constants.DropFileType dropFileType, Constants.HttpMethodType methodType, boolean canGenerateJaxb, String indent) {
        return Util.createPrintStatement(pkgs, typeNames, dropFileType, methodType, canGenerateJaxb, VAR_NAMES_RESULT, indent);
    }

    public static String createPrintStatement(List<String> pkgs, List<String> typeNames, Constants.DropFileType dropFileType, Constants.HttpMethodType methodType, boolean canGenerateJaxb, String resultVarName, String indent) {
        String methodBody = "";
        String commentStr = "//";
        if (canGenerateJaxb) {
            for (int i = 0; i < typeNames.size(); ++i) {
                String rht;
                String lft;
                String resultClass;
                String pkg = pkgs.get(i);
                String typeName = typeNames.get(i);
                if (i > 0) {
                    methodBody = methodBody + "else ";
                }
                if (!Util.isPrimitive(typeName)) {
                    lft = resultClass = pkg + "." + Util.camelize(typeName, false);
                    rht = resultVarName + ".getDataAsObject(" + resultClass + ".class)";
                    methodBody = methodBody + indent + "if(" + rht + " instanceof " + lft + ") {\n";
                    methodBody = methodBody + indent + "    " + lft + " " + resultVarName + "Obj = " + rht + ";\n}\n";
                    continue;
                }
                lft = resultClass = Util.camelize(typeName, false);
                rht = resultVarName + ".getDataAsObject(" + resultClass + ".class, \"java.lang\")";
                methodBody = methodBody + indent + "if(" + rht + " instanceof " + lft + ") {\n";
                methodBody = methodBody + indent + resultClass + " " + resultVarName + "Obj = " + rht + ";\n}\n";
            }
        }
        methodBody = methodBody + indent + "//TODO - Uncomment the print Statement below to print result.\n";
        methodBody = methodBody + indent + commentStr + dropFileType.getPrintWriterType() + ".println(\"The SaasService returned: \"+" + resultVarName + ".getDataAsString());\n";
        return methodBody;
    }

    private static boolean isPrimitive(String typeName) {
        return typeName.equals("integer") || typeName.equals("string") || typeName.equals("boolean") || typeName.equals("float") || typeName.equals("long");
    }

    public static String[] getParamNames(List<ParameterInfo> params) {
        ArrayList<String> results = new ArrayList<String>();
        for (ParameterInfo param : params) {
            results.add(Util.getParameterName(param, true, true, true));
        }
        return results.toArray(new String[results.size()]);
    }

    public static String[] getParamTypeNames(List<ParameterInfo> params) {
        ArrayList<String> results = new ArrayList<String>();
        for (ParameterInfo param : params) {
            results.add(param.getTypeName());
        }
        return results.toArray(new String[results.size()]);
    }

    public static Object[] getParamValues(List<ParameterInfo> params) {
        ArrayList<Object> results = new ArrayList<Object>();
        for (ParameterInfo param : params) {
            results.add(Util.getParamValue(param));
        }
        return results.toArray(new Object[results.size()]);
    }

    public static Object getParamValue(ParameterInfo p) {
        Object defaultValue = null;
        if (p.getStyle() != ParameterInfo.ParamStyle.QUERY) {
            defaultValue = p.getDefaultValue();
        }
        return defaultValue;
    }

    public static String getSignParamDeclaration(SaasBean bean, List<ParameterInfo> signParams, List<ParameterInfo> filterParams) {
        String paramStr = "";
        for (ParameterInfo p : signParams) {
            String[] pIds = Util.getParamIds(p, bean.getSaasName(), bean.isDropTargetWeb());
            if (pIds != null) {
                paramStr = paramStr + "        String " + Util.getVariableName(pIds[0]) + " = " + pIds[1] + ";\n";
                continue;
            }
            if (Util.isContains(p, filterParams)) continue;
            paramStr = paramStr + "        String " + Util.getVariableName(p.getName()) + " = ";
            if (p.getFixed() != null) {
                paramStr = paramStr + "\"" + p.getFixed() + "\";\n";
                continue;
            }
            if (p.getType() == Date.class) {
                paramStr = paramStr + "conn.getDate();\n";
                continue;
            }
            if (p.getType() == SaasBean.Time.class) {
                paramStr = paramStr + "String.valueOf(System.currentTimeMillis());\n";
                continue;
            }
            if (p.getType() == Constants.HttpMethodType.class) {
                paramStr = paramStr + "\"" + bean.getHttpMethod().value() + "\";\n";
                continue;
            }
            if (p.isRequired()) {
                if (p.getDefaultValue() != null) {
                    paramStr = paramStr + Util.getQuotedValue(p.getDefaultValue().toString()) + ";\n";
                    continue;
                }
                paramStr = paramStr + "\"\";\n";
                continue;
            }
            if (p.getDefaultValue() != null) {
                paramStr = paramStr + Util.getQuotedValue(p.getDefaultValue().toString()) + ";\n";
                continue;
            }
            paramStr = paramStr + "null;\n";
        }
        paramStr = paramStr + "\n";
        return paramStr;
    }

    public static boolean isContains(ParameterInfo pInfo, List<ParameterInfo> params) {
        String name = Util.getVariableName(pInfo.getName());
        for (ParameterInfo p : params) {
            if (!name.equals(Util.getVariableName(p.getName()))) continue;
            return true;
        }
        return false;
    }

    public static String getQuotedValue(String value) {
        String normalized = value;
        if (normalized.startsWith("\"")) {
            normalized = normalized.substring(1);
        }
        if (normalized.endsWith("\"")) {
            normalized = normalized.substring(0, normalized.length() - 1);
        }
        return "\"" + normalized + "\"";
    }

    public static String[] getGetParamNames(List<ParameterInfo> queryParams) {
        ArrayList<String> params = new ArrayList<String>();
        params.addAll(Arrays.asList(Util.getParamNames(queryParams)));
        return params.toArray(new String[params.size()]);
    }

    public static String[] getGetParamTypes(List<ParameterInfo> queryParams) {
        ArrayList<String> types = new ArrayList<String>();
        types.addAll(Arrays.asList(Util.getParamTypeNames(queryParams)));
        return types.toArray(new String[types.size()]);
    }

    public static List<ParameterInfo> getRestClientMethodParameters(RestClientSaasBean bean) {
        List<ParameterInfo> params = bean.filterParametersByAuth(bean.filterParameters(new ParameterInfo.ParamFilter[]{ParameterInfo.ParamFilter.FIXED}));
        Util.getRestClientPutPostParameters(bean, params);
        return params;
    }

    public static List<ParameterInfo> getRestClientPutPostParameters(RestClientSaasBean bean, List<ParameterInfo> params) {
        Constants.HttpMethodType httpMethod = bean.getHttpMethod();
        if (httpMethod == Constants.HttpMethodType.PUT || httpMethod == Constants.HttpMethodType.POST) {
            ParameterInfo contentTypeParam = Util.findParameter(bean.getInputParameters(), "Content-Type");
            Class contentType = InputStream.class;
            if (contentTypeParam != null) {
                if (!contentTypeParam.isFixed() && !params.contains(contentTypeParam)) {
                    params.add(contentTypeParam);
                } else {
                    String value = Util.findParamValue(contentTypeParam);
                    if (value.equals("text/plain") || value.equals("application/xml") || value.equals("text/xml")) {
                        contentType = String.class;
                    }
                }
            }
            if (Util.hasInputRepresentations(bean) && !Util.isPutPostFormParams(bean)) {
                params.add(new ParameterInfo("content", contentType));
            }
        }
        return params;
    }

    public static boolean isPutPostFormParams(RestClientSaasBean bean) {
        Constants.HttpMethodType httpMethod = bean.getHttpMethod();
        if (httpMethod == Constants.HttpMethodType.PUT || httpMethod == Constants.HttpMethodType.POST) {
            List<RepresentationType> reps = RestClientSaasBean.findInputRepresentations(bean.getMethod());
            for (RepresentationType rep : reps) {
                if (rep.getParam() == null || rep.getParam().size() <= 0) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean hasInputRepresentations(RestClientSaasBean bean) {
        List<RepresentationType> reps = RestClientSaasBean.findInputRepresentations(bean.getMethod());
        return reps != null && reps.size() != 0;
    }

    public static Document getDocument(FileObject f) throws IOException {
        try {
            DataObject d = DataObject.find((FileObject)f);
            EditorCookie ec = (EditorCookie)d.getCookie(EditorCookie.class);
            StyledDocument doc = ec.openDocument();
            if (doc == null) {
                throw new IOException("Document cannot be opened for : " + f.getPath());
            }
            return doc;
        }
        catch (DataObjectNotFoundException ex) {
            throw new IOException("DataObject does not exist for : " + f.getPath());
        }
    }

    public static boolean isRPCEncoded(WSDLModel wsdlModel) {
        Definitions definitions = wsdlModel.getDefinitions();
        Collection bindings = definitions.getBindings();
        for (Binding binding : bindings) {
            List soapBindings = binding.getExtensibilityElements(SOAPBinding.class);
            for (SOAPBinding soapBinding : soapBindings) {
                if (soapBinding.getStyle() != SOAPBinding.Style.RPC) continue;
                Collection bindingOperations = binding.getBindingOperations();
                for (BindingOperation bindingOperation : bindingOperations) {
                    SOAPBody soapBody;
                    List soapBodies;
                    BindingInput bindingInput = bindingOperation.getBindingInput();
                    if (bindingInput == null || (soapBodies = bindingInput.getExtensibilityElements(SOAPBody.class)) == null || soapBodies.size() <= 0 || (soapBody = (SOAPBody)soapBodies.get(0)).getUse() != SOAPMessageBase.Use.ENCODED) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public static boolean showDialog(String displayName, List<ParameterInfo> allParams, Document targetDoc) {
        if (!allParams.isEmpty()) {
            Object response;
            boolean showParamTypes = Util.isJava(targetDoc) || Util.isJsp(targetDoc);
            CodeSetupPanel panel = new CodeSetupPanel(allParams, showParamTypes);
            DialogDescriptor desc = new DialogDescriptor((Object)panel, NbBundle.getMessage(CodeSetupPanel.class, (String)"LBL_CustomizeSaasService", (Object)displayName));
            Dialog d = DialogDisplayer.getDefault().createDialog(desc);
            panel.setDialog(d);
            d.setVisible(true);
            Object object = response = desc.getValue() != null ? desc.getValue() : NotifyDescriptor.CLOSED_OPTION;
            if (response.equals(NotifyDescriptor.CANCEL_OPTION) || response.equals(NotifyDescriptor.CLOSED_OPTION)) {
                return false;
            }
        }
        return true;
    }

    public static void doGenerateCode(SaasClientCodeGenerator codegen, ProgressDialog progress, List<Exception> errors) {
        block2: {
            try {
                codegen.initProgressReporting(progress.getProgressHandle());
                codegen.generate();
            }
            catch (IOException ex) {
                if (ex.getMessage().equals(SCANNING_IN_PROGRESS)) break block2;
                errors.add(ex);
            }
        }
    }
}

