/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.debugger.gdb.proxy;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import org.netbeans.modules.cnd.debugger.gdb.GdbDebugger;
import org.netbeans.modules.cnd.debugger.gdb.proxy.GdbConsoleWindow;
import org.netbeans.modules.cnd.debugger.gdb.proxy.GdbProxy;

public class GdbLogger {
    private GdbConsoleWindow gdbConsoleWindow = null;
    private FileWriter logFile;

    public GdbLogger(GdbDebugger debugger, GdbProxy gdbProxy) {
        try {
            File tmpfile;
            if (!GdbDebugger.isUnitTest()) {
                tmpfile = File.createTempFile("gdb-cmds", ".log");
                if (!Boolean.getBoolean("gdb.console.savelog")) {
                    tmpfile.deleteOnExit();
                }
            } else {
                tmpfile = File.createTempFile("gdb-unit_test", ".log");
            }
            this.logFile = new FileWriter(tmpfile);
        }
        catch (IOException ex) {
            this.logFile = null;
        }
        if (Boolean.getBoolean("gdb.console.window")) {
            this.gdbConsoleWindow = new GdbConsoleWindow(debugger, gdbProxy);
            this.gdbConsoleWindow.openConsole();
        }
    }

    public void logMessage(String message) {
        if (message != null && message.length() > 0) {
            if (this.logFile != null) {
                try {
                    this.logFile.write(message);
                    if (message.charAt(message.length() - 1) != '\n') {
                        this.logFile.write(10);
                    }
                    this.logFile.flush();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            if (this.gdbConsoleWindow != null) {
                this.gdbConsoleWindow.add(message);
            }
        }
    }
}

