/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.debugger.gdb.breakpoints;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import org.netbeans.modules.cnd.debugger.common.breakpoints.CndBreakpoint;
import org.netbeans.modules.cnd.debugger.common.breakpoints.FunctionBreakpoint;
import org.netbeans.modules.cnd.debugger.gdb.GdbDebugger;
import org.netbeans.modules.cnd.debugger.gdb.breakpoints.LineBreakpointImpl;
import org.netbeans.modules.cnd.debugger.gdb.proxy.MICommand;

public abstract class BreakpointImpl<B extends CndBreakpoint>
implements PropertyChangeListener {
    protected final GdbDebugger debugger;
    private final B breakpoint;
    private State state = State.UNVALIDATED;
    protected String err = null;
    private boolean runWhenValidated = false;
    private int breakpointNumber = -1;
    private String address;
    private String fullname;
    private int line = -1;

    protected BreakpointImpl(B breakpoint, GdbDebugger debugger) {
        this.debugger = debugger;
        this.breakpoint = breakpoint;
    }

    public final void completeValidation(Map<String, String> map) {
        String number;
        if (this.state == State.DELETED) {
            return;
        }
        String string = number = map != null ? map.get("number") : null;
        if (number != null) {
            int skipCount;
            String condition;
            String implPath = map.get("fullname");
            if (this instanceof LineBreakpointImpl && implPath != null) {
                String path = this.getBreakpoint().getPath();
                implPath = this.debugger.getOSPath(implPath);
                if (this.debugger.getHostExecutionEnvironment().isLocal()) {
                    path = BreakpointImpl.canonicalPath(path);
                    implPath = BreakpointImpl.canonicalPath(implPath);
                }
                if (this.debugger.getPlatform() == 4) {
                    path = path.toLowerCase();
                    implPath = implPath.toLowerCase();
                }
                if (!this.debugger.comparePaths(path = this.debugger.getPathMap().getRemotePath(path, true), implPath)) {
                    this.debugger.getGdbProxy().getLogger().logMessage("IDE: incorrect breakpoint file: requested " + path + " found " + implPath);
                    this.debugger.getGdbProxy().break_deleteCMD(number).send();
                    this.breakpoint.setInvalid(this.err);
                    this.setState(State.VALIDATION_FAILED);
                    return;
                }
            }
            this.breakpointNumber = Integer.parseInt(number);
            this.setState(State.VALIDATED);
            this.address = map.get("addr");
            this.fullname = this.debugger.getOSPath(map.get("fullname"));
            try {
                this.line = Integer.parseInt(map.get("line"));
            }
            catch (Exception ex) {
                this.line = -1;
            }
            if (!this.breakpoint.isEnabled()) {
                MICommand command = this.enableCMD(false);
                if (this.isRunWhenValidated()) {
                    this.debugger.addRunAfterToken(command.getToken());
                }
                command.send();
            }
            if ((condition = this.breakpoint.getCondition()).length() > 0) {
                MICommand command = this.conditionCMD(condition);
                if (this.isRunWhenValidated()) {
                    this.debugger.addRunAfterToken(command.getToken());
                }
                command.send();
            }
            if ((skipCount = this.breakpoint.getSkipCount()) > 0) {
                MICommand command = this.breakAfterCMD(skipCount);
                if (this.isRunWhenValidated()) {
                    this.debugger.addRunAfterToken(command.getToken());
                }
                command.send();
            }
            this.debugger.getBreakpointList().put(this.breakpointNumber, this);
            this.breakpoint.setValid();
            this.breakpoint.validityChanged();
            this.setRunWhenValidated(false);
        } else if (this.alternateSourceRootAvailable()) {
            this.setState(State.UNVALIDATED);
            this.setRequests();
        } else {
            this.breakpoint.setInvalid(this.err);
            this.setState(State.VALIDATION_FAILED);
        }
    }

    public String getAddress() {
        return this.address;
    }

    public String getFullname() {
        return this.fullname;
    }

    public int getLine() {
        return this.line;
    }

    private static String canonicalPath(String path) {
        try {
            return new File(path).getCanonicalPath();
        }
        catch (IOException iOException) {
            return path;
        }
    }

    protected boolean alternateSourceRootAvailable() {
        return false;
    }

    public void addError(String err) {
        this.err = this.err != null ? this.err + err : err;
    }

    private void setState(State state) {
        this.state = state;
        if (state == State.UNVALIDATED) {
            this.breakpointNumber = -1;
        }
    }

    protected final void set() {
        this.breakpoint.addPropertyChangeListener((PropertyChangeListener)this);
        this.update();
    }

    protected abstract String getBreakpointCommand();

    private void setRequests() {
        if (this.state == State.UNVALIDATED || this.state == State.REVALIDATE) {
            if (this.debugger.getState() == GdbDebugger.State.RUNNING) {
                this.setRunWhenValidated(true);
            }
            if (this.state == State.REVALIDATE && this.breakpointNumber > 0) {
                this.send(this.deleteCMD());
            }
            this.setState(State.VALIDATION_PENDING);
            String bpcmd = this.getBreakpointCommand();
            if (bpcmd != null) {
                MICommand command = this.debugger.getGdbProxy().break_insertCMD(this.getBreakpoint().getSuspend(), this.getBreakpoint().isTemporary(), bpcmd, this.getBreakpoint().getThreadID(), true);
                this.debugger.addPendingBreakpoint(command.getToken(), this);
                this.send(command);
            } else {
                this.breakpoint.setInvalid(this.err);
                this.setState(State.VALIDATION_FAILED);
            }
        }
    }

    private MICommand enableCMD(boolean enable) {
        if (enable) {
            return this.debugger.getGdbProxy().break_enableCMD(this.breakpointNumber);
        }
        return this.debugger.getGdbProxy().break_disableCMD(this.breakpointNumber);
    }

    void revalidate() {
        this.setState(State.REVALIDATE);
        this.update();
    }

    private void update() {
        if (this.debugger.getState() != GdbDebugger.State.EXITED) {
            this.setRequests();
        }
    }

    private void send(MICommand command) {
        if (this.debugger.getState() == GdbDebugger.State.RUNNING) {
            this.debugger.addRunAfterToken(command.getToken());
            this.debugger.setSilentStop();
        }
        command.send();
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String pname = evt.getPropertyName();
        if (pname.equals("condition")) {
            if (this.breakpointNumber > 0) {
                this.send(this.conditionCMD(evt.getNewValue().toString()));
            }
        } else if (pname.equals("skipCount")) {
            if (this.breakpointNumber > 0) {
                this.send(this.breakAfterCMD((Integer)evt.getNewValue()));
            }
        } else if (pname.equals("enabled")) {
            if (this.breakpointNumber > 0) {
                this.send(this.enableCMD(this.breakpoint.isEnabled()));
            }
        } else if (pname.equals("suspend")) {
            this.revalidate();
        } else if (pname.equals("lineNumber") && this.state == State.VALIDATED && !(this.getBreakpoint() instanceof FunctionBreakpoint) && evt.getOldValue() != null) {
            this.revalidate();
        } else if (pname.equals("functionName") && this.state == State.VALIDATED) {
            this.revalidate();
        } else if (pname.equals("address") && this.state == State.VALIDATED) {
            this.revalidate();
        }
    }

    private MICommand conditionCMD(String condition) {
        return this.debugger.getGdbProxy().break_conditionCMD(this.breakpointNumber, condition);
    }

    private MICommand breakAfterCMD(int skipCount) {
        return this.debugger.getGdbProxy().break_afterCMD(this.breakpointNumber, skipCount);
    }

    private MICommand deleteCMD() {
        return this.debugger.getGdbProxy().break_deleteCMD(this.breakpointNumber);
    }

    final void remove() {
        this.breakpoint.removePropertyChangeListener((PropertyChangeListener)this);
        this.setState(State.DELETED);
        if (this.breakpointNumber > 0) {
            this.debugger.getBreakpointList().remove(this.breakpointNumber);
            this.send(this.deleteCMD());
        }
    }

    public B getBreakpoint() {
        return this.breakpoint;
    }

    private void setRunWhenValidated(boolean runWhenValidated) {
        this.runWhenValidated = runWhenValidated;
    }

    private boolean isRunWhenValidated() {
        return this.runWhenValidated;
    }

    private static enum State {
        UNVALIDATED,
        REVALIDATE,
        VALIDATION_PENDING,
        VALIDATION_FAILED,
        VALIDATED,
        DELETED;

    }
}

