/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.debugger.gdb.actions;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashSet;
import java.util.Set;
import org.netbeans.modules.cnd.debugger.gdb.GdbDebugger;
import org.netbeans.spi.debugger.ActionsProviderSupport;
import org.netbeans.spi.debugger.ContextProvider;
import org.openide.util.WeakSet;

abstract class GdbDebuggerActionProvider
extends ActionsProviderSupport
implements PropertyChangeListener {
    private final GdbDebugger debugger;
    private static Set<GdbDebuggerActionProvider> providersToDisableOnLazyActions = new WeakSet();
    private volatile boolean disabled;

    GdbDebuggerActionProvider(ContextProvider lookupProvider) {
        this.debugger = (GdbDebugger)lookupProvider.lookupFirst(null, GdbDebugger.class);
        this.debugger.addPropertyChangeListener(this);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String pname = evt.getPropertyName();
        if (pname.equals("state") || pname.equals("currentCallStackFrame") || pname.equals("currentThread")) {
            this.checkEnabled(this.debugger.getState());
        }
    }

    protected abstract void checkEnabled(GdbDebugger.State var1);

    public boolean isEnabled(Object action) {
        if (!this.disabled) {
            this.checkEnabled(this.debugger.getState());
        }
        return super.isEnabled(action);
    }

    GdbDebugger getDebugger() {
        return this.debugger;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void setProviderToDisableOnLazyAction(GdbDebuggerActionProvider provider) {
        Class<GdbDebuggerActionProvider> clazz = GdbDebuggerActionProvider.class;
        synchronized (GdbDebuggerActionProvider.class) {
            providersToDisableOnLazyActions.add(provider);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void doLazyAction(final Runnable run) {
        Class<GdbDebuggerActionProvider> clazz = GdbDebuggerActionProvider.class;
        synchronized (GdbDebuggerActionProvider.class) {
            final HashSet<GdbDebuggerActionProvider> disabledActions = new HashSet<GdbDebuggerActionProvider>(providersToDisableOnLazyActions);
            // ** MonitorExit[var3_2] (shouldn't be in output)
            for (GdbDebuggerActionProvider ap : disabledActions) {
                Set actions = ap.getActions();
                ap.disabled = true;
                for (Object action : actions) {
                    ap.setEnabled(action, false);
                }
            }
            this.debugger.getRequestProcessor().post(new Runnable(){

                @Override
                public void run() {
                    run.run();
                    for (GdbDebuggerActionProvider ap : disabledActions) {
                        Set actions = ap.getActions();
                        ap.disabled = false;
                        ap.checkEnabled(GdbDebuggerActionProvider.this.debugger.getState());
                    }
                }
            });
            return;
        }
    }
}

