/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.debugger.gdb;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import org.netbeans.api.debugger.Breakpoint;
import org.netbeans.api.debugger.DebuggerEngine;
import org.netbeans.api.debugger.DebuggerInfo;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.api.debugger.Properties;
import org.netbeans.api.debugger.Session;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectInformation;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.modules.cnd.api.model.CsmFunction;
import org.netbeans.modules.cnd.api.project.NativeProject;
import org.netbeans.modules.cnd.api.remote.HostInfoProvider;
import org.netbeans.modules.cnd.api.remote.PathMap;
import org.netbeans.modules.cnd.api.toolchain.CompilerSetUtils;
import org.netbeans.modules.cnd.debugger.common.CallStackFrame;
import org.netbeans.modules.cnd.debugger.common.EditorContextBridge;
import org.netbeans.modules.cnd.debugger.common.breakpoints.AddressBreakpoint;
import org.netbeans.modules.cnd.debugger.common.breakpoints.CndBreakpoint;
import org.netbeans.modules.cnd.debugger.common.breakpoints.CndBreakpointEvent;
import org.netbeans.modules.cnd.debugger.common.breakpoints.LineBreakpoint;
import org.netbeans.modules.cnd.debugger.common.utils.IOProxy;
import org.netbeans.modules.cnd.debugger.gdb.DebuggerStartException;
import org.netbeans.modules.cnd.debugger.gdb.GdbCallStackFrame;
import org.netbeans.modules.cnd.debugger.gdb.GdbContext;
import org.netbeans.modules.cnd.debugger.gdb.GdbEngineProvider;
import org.netbeans.modules.cnd.debugger.gdb.GdbErrorException;
import org.netbeans.modules.cnd.debugger.gdb.GdbVariable;
import org.netbeans.modules.cnd.debugger.gdb.GdbVersionPeculiarity;
import org.netbeans.modules.cnd.debugger.gdb.Signal;
import org.netbeans.modules.cnd.debugger.gdb.actions.GdbActionHandler;
import org.netbeans.modules.cnd.debugger.gdb.attach.AttachTarget;
import org.netbeans.modules.cnd.debugger.gdb.breakpoints.BreakpointImpl;
import org.netbeans.modules.cnd.debugger.gdb.disassembly.Disassembly;
import org.netbeans.modules.cnd.debugger.gdb.profiles.GdbProfile;
import org.netbeans.modules.cnd.debugger.gdb.proxy.CommandBuffer;
import org.netbeans.modules.cnd.debugger.gdb.proxy.ExternalTerminal;
import org.netbeans.modules.cnd.debugger.gdb.proxy.GdbProxy;
import org.netbeans.modules.cnd.debugger.gdb.proxy.GdbProxyEngine;
import org.netbeans.modules.cnd.debugger.gdb.timer.GdbTimer;
import org.netbeans.modules.cnd.debugger.gdb.utils.GdbUtils;
import org.netbeans.modules.cnd.makeproject.api.ProjectActionEvent;
import org.netbeans.modules.cnd.makeproject.api.ProjectActionSupport;
import org.netbeans.modules.cnd.makeproject.api.configurations.CompilerSet2Configuration;
import org.netbeans.modules.cnd.makeproject.api.configurations.ConfigurationDescriptorProvider;
import org.netbeans.modules.cnd.makeproject.api.configurations.DevelopmentHostConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfigurationDescriptor;
import org.netbeans.modules.cnd.makeproject.api.runprofiles.RunProfile;
import org.netbeans.modules.cnd.utils.cache.CndFileUtils;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironmentFactory;
import org.netbeans.modules.nativeexecution.api.NativeProcessBuilder;
import org.netbeans.modules.nativeexecution.api.pty.Pty;
import org.netbeans.modules.nativeexecution.api.pty.PtySupport;
import org.netbeans.modules.nativeexecution.api.util.HostInfoUtils;
import org.netbeans.modules.nativeexecution.api.util.MacroMap;
import org.netbeans.modules.nativeexecution.api.util.PathUtils;
import org.netbeans.modules.nativeexecution.api.util.ProcessUtils;
import org.netbeans.modules.nativeexecution.api.util.UnbufferSupport;
import org.netbeans.modules.nativeexecution.api.util.WindowsSupport;
import org.netbeans.spi.debugger.ContextProvider;
import org.netbeans.spi.debugger.DebuggerEngineProvider;
import org.netbeans.spi.project.ProjectConfiguration;
import org.netbeans.spi.project.ProjectConfigurationProvider;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.modules.InstalledFileLocator;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.windows.InputOutput;

public class GdbDebugger
implements PropertyChangeListener {
    public static final String PROP_STATE = "state";
    public static final String PROP_CURRENT_THREAD = "currentThread";
    public static final String PROP_CURRENT_CALL_STACK_FRAME = "currentCallStackFrame";
    public static final String PROP_KILLTERM = "killTerm";
    public static final String PROP_SHARED_LIB_LOADED = "sharedLibLoaded";
    public static final String PROP_VALUE_CHANGED = "valueChanged";
    public static final String PROP_LOCALS_REFRESH = "localsRefresh";
    public static final String DONE_PREFIX = "^done";
    public static final String RUNNING_PREFIX = "^running";
    public static final String CONNECTED_PREFIX = "^connected";
    private LastGoState lastGo;
    private String lastStop;
    private static final ProjectActionEvent.Type DEBUG_ATTACH = ProjectActionEvent.PredefinedType.CHECK_EXECUTABLE;
    public static final String ENGINE_ID = "netbeans-cnd-GdbSession/C";
    public static final String SESSION_ID = "netbeans-cnd-GdbSession";
    public static final String SESSION_PROVIDER_ID = "netbeans-cnd-GdbSessionProvider";
    public static final String DIS_UPDATE = "dis_update";
    private static final String MSG_BREAKPOINT_ERROR = "Cannot insert breakpoint";
    private GdbProxy gdb;
    private final ContextProvider lookupProvider;
    protected State state = State.NONE;
    private final PropertyChangeSupport pcs;
    private String runDirectory;
    private String baseDir;
    private final List<GdbCallStackFrame> callstack = Collections.synchronizedList(new ArrayList());
    private final GdbEngineProvider gdbEngineProvider;
    private GdbCallStackFrame currentCallStackFrame;
    private long programPID = 0L;
    private double gdbVersion = 6.4;
    private boolean continueAfterFirstStop = true;
    private final List<GdbVariable> localVariables = new ArrayList<GdbVariable>();
    private final Map<Integer, BreakpointImpl<?>> pendingBreakpointMap = new HashMap();
    private final Map<Integer, BreakpointImpl<?>> breakpointList = Collections.synchronizedMap(new HashMap());
    private final List<String> temporaryBreakpoints = new ArrayList<String>();
    private final Set<Integer> runAfterTokens = Collections.synchronizedSet(new HashSet());
    private static final Logger log = Logger.getLogger("gdb.logger");
    private static final Logger tlog = Logger.getLogger("gdb.testlogger");
    private int currentToken = 0;
    private String currentThreadID = "1";
    private static final String[] emptyThreadsList = new String[0];
    private String[] threadsList = emptyThreadsList;
    private Timer startupTimer = null;
    private boolean cygwin = false;
    private boolean mingw = false;
    private boolean cplusplus = false;
    private String firstBPfullname;
    private String firstBPfile;
    private String firstBPline;
    private InputOutput iotab;
    private boolean firstOutput = true;
    private boolean dlopenPending = false;
    private int shareToken;
    private final Disassembly disassembly;
    private CndBreakpoint currentBreakpoint = null;
    private ExecutionEnvironment execEnv;
    private int platform;
    private PathMap pathMap;
    private Map<String, ShareInfo> shareTab;
    private String sig = null;
    private IOProxy ioProxy = null;
    private GdbVersionPeculiarity versionPeculiarity = null;
    private boolean core = false;
    private boolean skipSignal = false;
    private Pty pty = null;
    private static final int PRINT_REPEAT = Integer.getInteger("gdb.print.repeat", 0);
    private static final int STACK_MAX_DEPTH = Integer.getInteger("gdb.stack.maxdepth", 1024);
    private final Object finishLock = new String("GDB debugger finish lock");
    private final Object LV_LOCK = new String("Locals lock");
    private static final String CONSOLE_MSG_END = "\\n";
    private static final String KILL_PATH1 = "/usr/bin/kill";
    private static final String KILL_PATH2 = "/bin/kill";
    private String untilBptId = null;
    private CndBreakpoint rtcBreakpoint = null;
    private static final String VALUE_PREFIX = "value=";

    public GdbDebugger(ContextProvider lookupProvider) {
        this.lookupProvider = lookupProvider;
        this.pcs = new PropertyChangeSupport(this);
        this.addPropertyChangeListener(this);
        GdbEngineProvider dep = null;
        List l = lookupProvider.lookup(null, DebuggerEngineProvider.class);
        for (DebuggerEngineProvider curDep : l) {
            if (!(curDep instanceof GdbEngineProvider)) continue;
            dep = (GdbEngineProvider)curDep;
        }
        if (dep == null && !GdbDebugger.isUnitTest()) {
            throw new IllegalArgumentException("GdbEngineProvider must be used to start GdbDebugger!");
        }
        this.gdbEngineProvider = dep;
        this.threadsViewInit();
        this.disassembly = new Disassembly(this);
        this.shareTab = null;
        this.execEnv = ExecutionEnvironmentFactory.getLocal();
    }

    public ContextProvider getLookup() {
        return this.lookupProvider;
    }

    public RequestProcessor getRequestProcessor() {
        return this.gdbEngineProvider.getRequestProcessor();
    }

    public void startDebugger() {
        block61: {
            GdbTimer.getTimer("Startup").start("Startup1");
            GdbTimer.getTimer("Stop").start("Stop1");
            this.setStarting();
            try {
                CommandBuffer cb;
                String gdbCommand;
                ProjectActionEvent pae = (ProjectActionEvent)this.lookupProvider.lookupFirst(null, ProjectActionEvent.class);
                this.execEnv = pae.getConfiguration().getDevelopmentHost().getExecutionEnvironment();
                this.pathMap = HostInfoProvider.getMapper((ExecutionEnvironment)this.execEnv);
                this.iotab = (InputOutput)this.lookupProvider.lookupFirst(null, InputOutput.class);
                if (this.iotab != null) {
                    this.iotab.setErrSeparated(false);
                }
                this.runDirectory = this.pathMap.getRemotePath(pae.getProfile().getRunDirectory().replace("\\", "/") + "/", true);
                this.baseDir = pae.getConfiguration().getBaseDir().replace("\\", "/");
                GdbProfile profile = (GdbProfile)pae.getConfiguration().getAuxObject("gdbdebugger");
                int conType = pae.getProfile().getConsoleType().getValue();
                if (conType == 0) {
                    conType = RunProfile.getDefaultConsoleType();
                }
                if (this.execEnv.isRemote() && conType == 1) {
                    conType = 2;
                }
                this.platform = pae.getConfiguration().getPlatformInfo().getPlatform();
                if (!Boolean.getBoolean("gdb.suppress.timeout")) {
                    this.startupTimer = new Timer("GDB Startup Timer Thread");
                    this.startupTimer.schedule(new TimerTask(){

                        @Override
                        public void run() {
                            DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(GdbDebugger.class, (String)"ERR_StartupTimeout")));
                            GdbDebugger.this.finish(true);
                        }
                    }, 30000L);
                }
                if ((gdbCommand = profile.getGdbPath(pae.getConfiguration(), false)) == null) {
                    throw new GdbErrorException("Gdb command is empty, exiting");
                }
                if (gdbCommand.toLowerCase().contains("cygwin")) {
                    this.cygwin = true;
                } else if (gdbCommand.toLowerCase().contains("mingw")) {
                    this.mingw = true;
                }
                String tty = null;
                if (pae.getType() != DEBUG_ATTACH) {
                    if (this.platform != 3 && conType == 1) {
                        String termpath = pae.getProfile().getTerminalPath();
                        if (termpath != null) {
                            tty = ExternalTerminal.create(this, termpath, new String[0]);
                        }
                    } else if (conType == 3) {
                        this.pty = PtySupport.allocate((ExecutionEnvironment)this.execEnv);
                        PtySupport.connect((InputOutput)this.iotab, (Pty)this.pty);
                        tty = this.pty.getSlaveName();
                    }
                }
                MacroMap debuggerEnvMap = MacroMap.forExecEnv((ExecutionEnvironment)this.execEnv);
                debuggerEnvMap.putAll(pae.getProfile().getEnvironment().getenvAsMap());
                if (conType == 2) {
                    UnbufferSupport.initUnbuffer((ExecutionEnvironment)this.execEnv, (MacroMap)debuggerEnvMap);
                }
                String cspath = this.getCompilerSetPath(pae);
                this.gdb = new GdbProxy(this, gdbCommand, this.platform == 3 && pae.getType() != DEBUG_ATTACH ? debuggerEnvMap : null, this.runDirectory, tty, cspath);
                this.initGdbVersion();
                this.checkGdbVersion();
                this.gdb.environment_directory(this.runDirectory);
                this.gdb.gdb_show("language");
                this.gdb.gdb_set("print repeat", PRINT_REPEAT);
                this.gdb.gdb_set("backtrace limit", STACK_MAX_DEPTH);
                if (pae.getType() == DEBUG_ATTACH) {
                    String pgm = null;
                    boolean isSharedLibrary = false;
                    String path = this.getFullPath(this.baseDir, pae.getExecutable());
                    this.gdb.getLogger().logMessage("IDE: project executable: " + path);
                    AttachTarget attachTarget = (AttachTarget)this.lookupProvider.lookupFirst(null, AttachTarget.class);
                    if (attachTarget == null) {
                        throw new IllegalStateException("No AttachTarget during attach");
                    }
                    if (attachTarget instanceof AttachTarget.PidAttach) {
                        this.programPID = ((AttachTarget.PidAttach)attachTarget).pid;
                    } else if (attachTarget instanceof AttachTarget.CoreAttach) {
                        this.core = true;
                        this.continueAfterFirstStop = false;
                    } else if (!(attachTarget instanceof AttachTarget.GdbServerAttach)) {
                        throw new IllegalStateException("Unknown attach target " + attachTarget);
                    }
                    if (pae.getConfiguration().isDynamicLibraryConfiguration()) {
                        if (this.platform != 3) {
                            pgm = PathUtils.getExePath((long)this.programPID, (ExecutionEnvironment)this.execEnv);
                            this.gdb.file_exec_and_symbols(pgm);
                        }
                        isSharedLibrary = true;
                    } else {
                        this.gdb.file_symbol_file(path);
                    }
                    CommandBuffer cb2 = this.getAttachCommand(attachTarget);
                    String err = cb2.getError();
                    if (err != null || cb2.isTimedOut()) {
                        String msg = err == null ? NbBundle.getMessage(GdbDebugger.class, (String)"ERR_AttachTimeout") : (err.toLowerCase().contains("no such process") || err.toLowerCase().contains("couldn't open /proc file for process ") ? NbBundle.getMessage(GdbDebugger.class, (String)"ERR_NoSuchProcess") : NbBundle.getMessage(GdbDebugger.class, (String)"ERR_CantAttach"));
                        this.warn(true, msg);
                        return;
                    }
                    String resp = cb2.getResponse();
                    if (this.platform == 3 && resp.startsWith("Attaching to process")) {
                        try {
                            long oldPid = this.programPID;
                            int endline = resp.indexOf(CONSOLE_MSG_END);
                            this.programPID = Long.parseLong(resp.substring(21, endline).trim());
                            if (this.programPID != oldPid) {
                                log.info("Pid changed from " + oldPid + " to " + this.programPID);
                            }
                        }
                        catch (Exception ex) {
                            // empty catch block
                        }
                    }
                    if (isSharedLibrary) {
                        if (this.platform == 4 && pgm == null) {
                            pgm = this.getMacExePath();
                        }
                        if (pgm != null) {
                            this.gdb.file_symbol_file(pgm);
                        }
                    }
                    if (!this.symbolsRead(resp, path)) {
                        if (!this.core && this.validAttachViaSlashProc(this.programPID, path)) {
                            if (this.isSolaris()) {
                                this.gdb.file_symbol_file(path);
                            }
                        } else if (isSharedLibrary && this.platform == 4) {
                            String addr = this.getMacDylibAddress(path, this.gdb.info_share(true).getResponse());
                            if (addr != null) {
                                this.gdb.addSymbolFile(path, addr);
                            } else {
                                this.warn(false, NbBundle.getMessage(GdbDebugger.class, (String)"ERR_AttachValidationFailure"));
                            }
                        } else if (!this.symbolsReadFromInfoFiles(this.gdb.info_files().getResponse(), path)) {
                            this.warn(false, NbBundle.getMessage(GdbDebugger.class, (String)"ERR_AttachValidationFailure"));
                        }
                    }
                    this.gdb.up_silently(1024);
                    this.setLoading();
                    break block61;
                }
                this.gdb.file_exec_and_symbols(this.pathMap.getRemotePath(pae.getExecutable().replace("\\", "/"), true));
                if (conType == 2 && this.platform != 3 && !GdbDebugger.isUnitTest()) {
                    this.ioProxy = IOProxy.create((ExecutionEnvironment)this.execEnv, (InputOutput)this.iotab);
                }
                for (Map.Entry entry : debuggerEnvMap.entrySet()) {
                    this.gdb.gdb_set("environment", (String)entry.getKey() + '=' + (String)entry.getValue());
                }
                if (this.platform == 3 && conType == 1) {
                    this.gdb.set_new_console();
                }
                if (pae.getType() == ProjectActionEvent.PredefinedType.DEBUG_STEPINTO) {
                    this.continueAfterFirstStop = false;
                }
                boolean mainSet = false;
                if (this.platform == 3) {
                    mainSet = this.gdb.break_insert_temporaryEx("WinMain", false).isOK();
                }
                if (!mainSet) {
                    this.gdb.break_insert_temporary("main");
                }
                String inRedir = "";
                if (this.ioProxy != null) {
                    String shell;
                    String inFile = this.ioProxy.getInFilename();
                    String outFile = this.ioProxy.getOutFilename();
                    if (this.platform == 3) {
                        inFile = this.win2UnixPath(inFile);
                        outFile = this.win2UnixPath(outFile);
                    }
                    inRedir = this.platform == 4 ? " < " + inFile + " > " + outFile + " 2> " + outFile : ((shell = (String)HostInfoProvider.getEnv((ExecutionEnvironment)this.execEnv).get("SHELL")) != null && shell.endsWith("csh") ? " < " + inFile + " >& " + outFile : " < " + inFile + " > " + outFile + " 2>&1");
                }
                if ((cb = this.gdb.exec_run(pae.getProfile().getArgsFlat() + inRedir)).isError()) {
                    throw new Exception(NbBundle.getMessage(GdbDebugger.class, (String)"ERR_ApplicationFailed"));
                }
                if (this.platform == 3) {
                    int pos2;
                    String msg = this.gdb.info_threads().getResponse();
                    int pos1 = msg.toLowerCase().indexOf("* 1 thread ");
                    if (pos1 >= 0 && (pos2 = msg.indexOf(46, pos1)) > 0) {
                        try {
                            this.programPID = Long.valueOf(msg.substring(pos1 + 11, pos2));
                        }
                        catch (NumberFormatException ex) {
                            log.warning("Failed to get PID from \"info threads\"");
                        }
                    }
                } else if (this.platform != 4) {
                    this.gdb.info_proc();
                }
            }
            catch (Exception ex) {
                String msg;
                log.log(Level.INFO, "GdbDebugger.startDebugger: Exception during start: ", ex);
                if (this.startupTimer != null) {
                    this.startupTimer.cancel();
                }
                if ((msg = ex.getLocalizedMessage()) == null || msg.length() == 0) {
                    msg = ex.getMessage();
                }
                if (msg == null || msg.length() == 0) {
                    msg = NbBundle.getMessage(GdbDebugger.class, (String)"ERR_UnSpecifiedStartError");
                }
                this.warn(true, msg);
            }
        }
    }

    private CommandBuffer getAttachCommand(AttachTarget target) {
        if (target instanceof AttachTarget.CoreAttach) {
            return this.gdb.core(((AttachTarget.CoreAttach)target).path);
        }
        if (target instanceof AttachTarget.PidAttach) {
            return this.gdb.attach(((AttachTarget.PidAttach)target).pid);
        }
        if (target instanceof AttachTarget.GdbServerAttach) {
            return this.gdb.attachRemote(((AttachTarget.GdbServerAttach)target).target);
        }
        throw new IllegalStateException("Unknown attach target " + target);
    }

    private void warn(final boolean finish, final String msg) {
        log.warning(msg);
        if (!GdbDebugger.isUnitTest()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)msg));
                    if (finish) {
                        GdbDebugger.this.finish(false);
                    }
                }
            });
        } else {
            tlog.warning(msg);
        }
    }

    private final void initGdbVersion() throws GdbErrorException {
        CommandBuffer res = this.gdb.gdb_version();
        if (res.isOK()) {
            String message = res.getResponse();
            if (this.startupTimer != null) {
                this.startupTimer.cancel();
                this.startupTimer = null;
            }
            this.gdbVersion = this.parseVersionString(message);
            this.versionPeculiarity = GdbVersionPeculiarity.create(this.gdbVersion, this.platform);
            if (message.contains("cygwin")) {
                this.cygwin = true;
            }
        } else {
            throw new GdbErrorException("gdb version check failed, exiting");
        }
    }

    private double parseVersionString(String msg) {
        double ver = 0.0;
        try {
            ver = GdbUtils.parseVersionString(msg);
        }
        catch (Exception ex) {
            log.warning("GdbDebugger: Failed to parse version string (" + msg + ") [" + ex.getClass().getName() + "]");
            if (msg.contains("6.5")) {
                ver = 6.5;
            } else if (msg.contains("6.6")) {
                ver = 6.6;
            } else if (msg.contains("6.7")) {
                ver = 6.7;
            } else if (msg.contains("6.8")) {
                ver = 6.8;
            } else if (msg.contains("7.0")) {
                ver = 7.0;
            } else {
                log.warning("GdbDebugger: Failed to guess version string");
            }
            log.warning("GdbDebugger: guessed version: " + ver);
        }
        return ver;
    }

    private final void checkGdbVersion() {
        if (!this.versionPeculiarity.isSupported()) {
            this.warn(false, NbBundle.getMessage(GdbDebugger.class, (String)"ERR_UnsupportedVersion", (Object)this.gdbVersion));
        }
    }

    public double getGdbVersion() {
        return this.gdbVersion;
    }

    public void testSuiteInit(GdbProxy gdb) throws GdbErrorException {
        if (!GdbDebugger.isUnitTest()) {
            throw new IllegalStateException(NbBundle.getMessage(GdbDebugger.class, (String)"Cannot call testSuiteInit outside of a testsuite!"));
        }
        log.setLevel(Level.OFF);
        tlog.setLevel(Level.FINE);
        this.gdb = gdb;
        this.initGdbVersion();
        this.execEnv = ExecutionEnvironmentFactory.getLocal();
        this.pathMap = HostInfoProvider.getMapper((ExecutionEnvironment)this.execEnv);
    }

    public static boolean isUnitTest() {
        return System.getProperty("gdb.testsuite") != null;
    }

    public String win2UnixPath(String path) {
        if (this.isCygwin()) {
            return WindowsSupport.getInstance().convertToCygwinPath(path);
        }
        if (this.isMinGW()) {
            return WindowsSupport.getInstance().convertToMSysPath(path);
        }
        return path.replace('\\', '/');
    }

    public ExecutionEnvironment getHostExecutionEnvironment() {
        return this.execEnv;
    }

    public int getPlatform() {
        return this.platform;
    }

    public PathMap getPathMap() {
        return this.pathMap;
    }

    public static GdbDebugger getGdbDebugger() {
        DebuggerEngine currentEngine = DebuggerManager.getDebuggerManager().getCurrentEngine();
        if (currentEngine == null) {
            return null;
        }
        return (GdbDebugger)currentEngine.lookupFirst(null, GdbDebugger.class);
    }

    private String getCompilerSetPath(ProjectActionEvent pae) {
        String msysBase;
        CompilerSet2Configuration cs = pae.getConfiguration().getCompilerSet();
        String csname = cs.getOption();
        String csdirs = cs.getCompilerSetManager().getCompilerSet(csname).getDirectory();
        if (cs.getCompilerSetManager().getCompilerSet(csname).getCompilerFlavor().isMinGWCompiler() && (msysBase = CompilerSetUtils.getCommandFolder(null)) != null && msysBase.length() > 0) {
            csdirs = csdirs + File.pathSeparator + msysBase;
        }
        return csdirs;
    }

    public String getSignal() {
        return this.sig;
    }

    public GdbVersionPeculiarity getVersionPeculiarity() {
        return this.versionPeculiarity;
    }

    private String getFullPath(String base, String path) {
        if (this.platform == 3 && Character.isLetter(path.charAt(0)) && path.charAt(1) == ':') {
            return path;
        }
        if (path.charAt(0) == '/') {
            return path;
        }
        return base + '/' + path;
    }

    public void showCurrentSource(boolean dis) {
        final GdbCallStackFrame csf = this.getCurrentCallStackFrame();
        if (csf == null) {
            return;
        }
        if (!dis) {
            dis = this.currentBreakpoint == null ? Disassembly.isInDisasm() : this.currentBreakpoint instanceof AddressBreakpoint;
        }
        final boolean inDis = dis;
        if (!GdbDebugger.isUnitTest()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    EditorContextBridge.showSource((CallStackFrame)csf, (boolean)inDis);
                }
            });
        }
    }

    public String[] getThreadsList() {
        if (this.state == State.STOPPED) {
            if (this.threadsList == emptyThreadsList) {
                while (this.gdb == null) {
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException ex) {}
                }
                String results = this.gdb.info_threads().getResponse();
                if (results.length() > 0) {
                    ArrayList<String> list = new ArrayList<String>();
                    if (results.startsWith("threadno")) {
                        for (String line : results.split("threadn")) {
                            Map<String, String> map = this.createMapFromString(line);
                            if (map.isEmpty()) continue;
                            list.add(map.get("o") + " " + map.get("target_tid"));
                        }
                    } else {
                        StringBuilder sb = new StringBuilder();
                        for (String line : results.split("\\\\n")) {
                            char ch;
                            if (line.startsWith("    ")) {
                                sb.append(" " + line.replace(CONSOLE_MSG_END, "").trim());
                                continue;
                            }
                            if (sb.length() > 0) {
                                list.add(sb.toString());
                                sb.delete(0, sb.length());
                            }
                            if ((ch = (line = line.trim()).charAt(0)) != '*' && !Character.isDigit(ch)) continue;
                            sb.append(line);
                        }
                        if (sb.length() > 0) {
                            list.add(sb.toString());
                        }
                    }
                    this.threadsList = list.toArray(new String[list.size()]);
                    return this.threadsList;
                }
            }
        } else {
            return new String[]{NbBundle.getMessage(GdbDebugger.class, (String)"CTL_NoThreadInfoWhileRunning")};
        }
        return this.threadsList;
    }

    private void resetThreadInfo() {
        this.threadsList = emptyThreadsList;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals(PROP_STATE)) {
            if (evt.getNewValue() == State.LOADING) {
                this.shareToken = this.gdb.info_share(false).getID();
            } else if (evt.getNewValue() == State.READY) {
                this.gdb.data_list_register_names("");
                if (this.platform == 3) {
                    this.gdb.break_insert("dlopen");
                } else {
                    this.setStopOnSolibEvents(true);
                }
                if (this.continueAfterFirstStop) {
                    this.continueAfterFirstStop = false;
                    this.setRunning();
                } else {
                    this.gdb.stack_list_frames();
                    this.setStopped();
                }
            } else if (evt.getNewValue() == State.STOPPED) {
                this.updateLocalVariables(0);
                GdbContext.getInstance().gdbStep();
            } else if (evt.getNewValue() == State.SILENT_STOP) {
                this.interrupt();
            } else if (evt.getNewValue() == State.RUNNING && (evt.getOldValue() == State.SILENT_STOP || evt.getOldValue() == State.READY)) {
                this.gdb.exec_continue();
            } else if (evt.getNewValue() == State.EXITED) {
                this.finish(false);
            }
        } else if (evt.getPropertyName().equals(PROP_CURRENT_THREAD)) {
            this.updateCurrentCallStack();
            this.updateLocalVariables(0);
            GdbContext.getInstance().gdbStep();
        }
    }

    private boolean symbolsRead(String results, String exepath) {
        for (String line : results.split("\\\\n")) {
            if (!(line.contains("Reading symbols from ") || this.platform == 4 && line.contains("Symbols from ") ? this.compareExePaths(line = line.substring(21, line.length() - 8), exepath) : line.contains("Loaded symbols for ") && this.comparePaths(exepath, line.substring(19)))) continue;
            return true;
        }
        return false;
    }

    public boolean comparePaths(String path1, String path2) {
        if ((path1 = path1.trim()).equals(path2 = path2.trim())) {
            return true;
        }
        if (this.platform == 3) {
            if ((path1 = path1.toLowerCase()).equals(path2 = path2.toLowerCase())) {
                return true;
            }
            if (this.cygwin) {
                path1 = WindowsSupport.getInstance().convertToCygwinPath(path1).toLowerCase();
                path2 = WindowsSupport.getInstance().convertToCygwinPath(path2).toLowerCase();
            } else if (this.mingw) {
                path1 = WindowsSupport.getInstance().convertToMSysPath(path1).toLowerCase();
                path2 = WindowsSupport.getInstance().convertToMSysPath(path2).toLowerCase();
            }
            if (path1.equals(path2)) {
                return true;
            }
        }
        return GdbUtils.compareUnixPaths(path1, path2);
    }

    private boolean compareExePaths(String exe1, String exe2) {
        if ((exe1 = exe1.trim()).equals(exe2 = exe2.trim())) {
            return true;
        }
        if (this.platform == 3) {
            exe1 = GdbUtils.removeExe(exe1);
            exe2 = GdbUtils.removeExe(exe2);
        } else if (this.platform == 4) {
            exe1 = exe1.toLowerCase();
            exe2 = exe2.toLowerCase();
        }
        return this.comparePaths(exe1, exe2);
    }

    private boolean symbolsReadFromInfoFiles(String results, String exepath) {
        for (String line : results.split("\\\\n")) {
            if (!line.contains("Symbols from ")) continue;
            return this.compareExePaths(line.substring(15, line.length() - 3), exepath);
        }
        return false;
    }

    private boolean validAttachViaSlashProc(long pid, String exepath) {
        String path;
        if (this.platform != 3 && (path = PathUtils.getExePath((long)pid, (ExecutionEnvironment)this.execEnv)) != null) {
            try {
                if (HostInfoUtils.fileExists((ExecutionEnvironment)this.execEnv, (String)exepath) && this.comparePaths(path, exepath)) {
                    return true;
                }
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            catch (InterruptedException ex) {
                // empty catch block
            }
        }
        return false;
    }

    private String getMacExePath() {
        String info = this.gdb.info_files().getResponse();
        for (String line : info.split("\\\\n")) {
            if (!line.contains("Symbols from ")) continue;
            return line.substring(15, line.length() - 3);
        }
        return null;
    }

    private String getMacDylibAddress(String path, String info) {
        String line;
        int start = info.startsWith("shlib-info=") ? 11 : 0;
        int next = info.indexOf(",shlib-info=");
        while ((line = info.substring(start, next > 0 ? next : info.length())) != null) {
            if (line.contains(path)) {
                return GdbDebugger.parseMacDylibAddress(line, this.getCharSetEncoding());
            }
            start = next + 12;
            next = info.indexOf(",shlib-info=", start);
        }
        return null;
    }

    private static String parseMacDylibAddress(String line, String encoding) {
        Map<String, String> map;
        int pos1 = GdbUtils.findMatchingCurly(line, 0);
        if (pos1 != -1 && (map = GdbUtils.createMapFromString(line.substring(1, pos1), encoding)).containsKey("loaded_addr")) {
            return map.get("loaded_addr");
        }
        return null;
    }

    public GdbProxy getGdbProxy() {
        return this.gdb;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finish(boolean killTerm) {
        Object object = this.finishLock;
        synchronized (object) {
            if (GdbDebugger.isUnitTest()) {
                this.setExited();
            } else if (this.state != State.NONE && this.state != State.EXITED) {
                if (killTerm) {
                    this.firePropertyChange(PROP_KILLTERM, true, false);
                }
                if (this.gdb != null) {
                    ProjectActionEvent.Type type = ((ProjectActionEvent)this.lookupProvider.lookupFirst(null, ProjectActionEvent.class)).getType();
                    if (this.state == State.RUNNING) {
                        this.interrupt();
                        if (type != DEBUG_ATTACH) {
                            this.gdb.exec_abort();
                        }
                    }
                    if (type == DEBUG_ATTACH) {
                        this.gdb.target_detach();
                    }
                    this.gdb.gdb_exit();
                    this.gdb.getProxyEngine().finish();
                    if (type != DEBUG_ATTACH && !this.gdb.getProxyEngine().isInferiorTty() && this.ioProxy == null) {
                        this.gdb.getProxyEngine().kill();
                    }
                }
                this.stackUpdate(new ArrayList<String>());
                this.setExited();
                this.programPID = 0L;
                this.removeTempBreakpoints();
                this.gdbEngineProvider.getDestructor().killEngine();
                GdbActionHandler gah = (GdbActionHandler)((Object)this.lookupProvider.lookupFirst(null, GdbActionHandler.class));
                if (gah != null) {
                    gah.executionFinished(0);
                }
                Disassembly.close();
                if (this.pty != null) {
                    try {
                        this.pty.close();
                    }
                    catch (IOException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                }
                if (this.ioProxy != null) {
                    this.ioProxy.stop();
                }
                if (this.iotab != null) {
                    this.iotab.getOut().close();
                }
                GdbContext.getInstance().gdbExit();
                GdbTimer.getTimer("Step").reset();
            }
        }
    }

    private void finish_from_main() {
        this.gdb.break_insert_temporary("exit");
        this.gdb.exec_continue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateLocalVariables(int frame) {
        Object object = this.LV_LOCK;
        synchronized (object) {
            List<GdbVariable> list = this.localVariables;
            synchronized (list) {
                this.localVariables.clear();
            }
            this.gdb.stack_select_frame(frame);
            this.gdb.stack_list_locals("--all-values");
            this.gdb.stack_list_arguments(1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateGdbVariable(String name, String value) {
        List<GdbVariable> list = this.localVariables;
        synchronized (list) {
            for (GdbVariable var : this.localVariables) {
                if (!name.equals(var.getName())) continue;
                var.setValue(value);
            }
        }
    }

    public void fireLocalsRefresh(Object node) {
        this.firePropertyChange(PROP_LOCALS_REFRESH, 0, node);
    }

    private void updateCurrentCallStack() {
        this.gdb.stack_list_frames();
    }

    public void addRunAfterToken(int token) {
        this.runAfterTokens.add(token);
    }

    public void resultRecord(int token, String msg) {
        CommandBuffer cb;
        this.currentToken = token + 1;
        if ((msg.startsWith(DONE_PREFIX) || msg.startsWith(RUNNING_PREFIX) || msg.startsWith(CONNECTED_PREFIX)) && (cb = this.gdb.getCommandBuffer(token)) != null) {
            if (msg.length() > DONE_PREFIX.length()) {
                cb.append(msg.substring(DONE_PREFIX.length() + 1));
            }
            cb.done();
        }
        if (msg.startsWith(DONE_PREFIX)) {
            if (msg.startsWith("^done,bkpt=")) {
                msg = msg.substring(12, msg.length() - 1);
                Map<String, String> map = this.createMapFromString(msg);
                this.validateBreakpoint(token, map);
            } else if (msg.startsWith("^done,stack=")) {
                if (this.state == State.STOPPED) {
                    this.stackUpdate(this.createListFromString(msg.substring(13, msg.length() - 1)));
                }
            } else if (msg.startsWith("^done,locals=")) {
                if (this.state == State.STOPPED) {
                    this.addLocalsToLocalVariables(msg.substring(13));
                } else {
                    log.finest("GD.resultRecord: Skipping results from -stack-list-locals (not stopped)");
                }
            } else if (msg.startsWith("^done,stack-args=")) {
                if (this.state == State.STOPPED) {
                    this.addArgsToLocalVariables(msg.substring(17));
                } else {
                    log.finest("GD.resultRecord: Skipping results from -stack-list-arguments (not stopped)");
                }
            } else if (msg.startsWith("^done,new-thread-id=")) {
                String tid = msg.substring(21, msg.indexOf(34, 22));
                if (!tid.equals(this.currentThreadID)) {
                    String otid = this.currentThreadID;
                    this.currentThreadID = tid;
                    log.finest("GD.resultRecord: Thread change, firing PROP_CURRENT_THREAD");
                    this.firePropertyChange(PROP_CURRENT_THREAD, otid, this.currentThreadID);
                }
            } else if (msg.startsWith("^done,value=") && msg.contains("auto; currently c")) {
                if (msg.contains("auto; currently c++")) {
                    this.cplusplus = true;
                    DebuggerManager.getDebuggerManager().getCurrentSession().setCurrentLanguage("C++");
                }
            } else if (msg.startsWith("^done,asm_insns=")) {
                this.disassembly.update(msg);
            } else if (msg.startsWith("^done,register-names=")) {
                this.disassembly.updateRegNames(msg);
            } else if (msg.startsWith("^done,register-values=")) {
                this.disassembly.updateRegValues(msg);
            } else if (msg.startsWith("^done,changed-registers=")) {
                this.disassembly.updateRegModified(msg);
                GdbContext.getInstance().setProperty("Registers", this.disassembly.getRegisterValues());
            } else {
                cb = this.gdb.getCommandBuffer(token);
                if (cb != null) {
                    if (token == this.shareToken) {
                        this.shareTab = this.createShareTab(cb.getResponse());
                    }
                } else if (this.pendingBreakpointMap.containsKey(token)) {
                    this.breakpointValidation(token, null);
                }
            }
            if (this.runAfterTokens.remove(token) && this.runAfterTokens.isEmpty() && this.state == State.SILENT_STOP) {
                this.setRunning();
            }
        } else if (msg.startsWith(RUNNING_PREFIX) && this.isStopped()) {
            this.setRunning();
        } else if (msg.startsWith("^error,msg=")) {
            msg = msg.substring(11);
            cb = this.gdb.getCommandBuffer(token);
            if (cb != null) {
                cb.error(msg);
            } else if (msg.equals("\"Can't attach to process.\"")) {
                DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(GdbDebugger.class, (String)"ERR_CantAttach")));
                this.killSession();
            } else if (msg.startsWith("\"No symbol ") && msg.endsWith(" in current context.\"")) {
                String type = msg.substring(13, msg.length() - 23);
                log.warning("Failed type lookup for " + type);
            } else if (msg.equals("\"\\\"finish\\\" not meaningful in the outermost frame.\"")) {
                this.finish_from_main();
            } else if (msg.contains("(corrupt stack?)") && this.gdbVersion > 6.3) {
                DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(GdbDebugger.class, (String)"ERR_CorruptedStack")));
                this.killSession();
            } else if (msg.contains("error reading line numbers")) {
                DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(GdbDebugger.class, (String)"ERR_CantReadLineNumbers")));
            } else if (msg.contains("No symbol table is loaded")) {
                DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(GdbDebugger.class, (String)"ERR_NoSymbolTable")));
                this.killSession();
            } else if (msg.contains("\"You can't do that without a process to debug.\"")) {
                DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(GdbDebugger.class, (String)"ERR_ApplicationCrashed")));
                this.killSession();
            } else if (!(msg.contains("Cannot access memory at address") || msg.contains("mi_cmd_break_insert: Garbage following <location>") || msg.contains("Undefined mi command: ") && msg.contains("(missing implementation"))) {
                if (msg.contains(MSG_BREAKPOINT_ERROR)) {
                    String breakpoinIdx;
                    BreakpointImpl<?> breakpoint;
                    this.setStopped();
                    int start = msg.indexOf(MSG_BREAKPOINT_ERROR) + MSG_BREAKPOINT_ERROR.length();
                    int end = msg.indexOf(46, start);
                    if (end != -1 && (breakpoint = this.findBreakpoint(breakpoinIdx = msg.substring(start, end).trim())) != null) {
                        DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(GdbDebugger.class, (String)"ERR_InvalidBreakpoint", breakpoint.getBreakpoint())));
                        breakpoint.getBreakpoint().disable();
                    }
                } else if (this.pendingBreakpointMap.containsKey(token)) {
                    BreakpointImpl<?> breakpoint = this.pendingBreakpointMap.remove(token);
                    if (breakpoint != null) {
                        breakpoint.addError(msg);
                        breakpoint.completeValidation(null);
                    }
                    if (this.pendingBreakpointMap.isEmpty() && this.state == State.LOADING) {
                        this.setReady();
                    }
                } else if (this.state != State.NONE) {
                    log.warning("Unexpected gdb error: " + msg);
                }
            }
        }
    }

    private void validateBreakpoint(int token, Map<String, String> map) {
        boolean checked = this.breakpointValidation(token, map);
        if (!checked && this.state == State.SILENT_STOP && this.pendingBreakpointMap.isEmpty()) {
            this.setRunning();
        }
    }

    public void fireDisUpdate(boolean open) {
        this.firePropertyChange(DIS_UPDATE, open, !open);
    }

    public void execAsyncOutput(int token, String msg) {
        if (msg.startsWith("*stopped")) {
            Map<Object, Object> map = msg.length() > 9 ? this.createMapFromString(msg.substring(9)) : new HashMap();
            this.stopped(token, map);
        }
    }

    public void consoleStreamOutput(int token, String omsg) {
        String msg = omsg.endsWith(CONSOLE_MSG_END) ? omsg.substring(0, omsg.length() - 2) : (omsg = omsg + CONSOLE_MSG_END);
        CommandBuffer cb = this.gdb.getCommandBuffer(token);
        if (cb != null) {
            cb.append(omsg);
        } else if (msg.toLowerCase().contains("mingw")) {
            this.mingw = true;
        } else if (msg.startsWith("Breakpoint ") && msg.contains(" at 0x")) {
            int pos = msg.indexOf(32, 12);
            String num = msg.substring(11, pos);
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("number", num);
            this.validateBreakpoint(token, map);
        } else if (msg.contains("(no debugging symbols found)") && this.state == State.STARTING && !this.isAttaching()) {
            DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(GdbDebugger.class, (String)"ERR_NoDebuggingSymbolsFound")));
            this.finish(false);
        } else if (!(msg.startsWith("Copyright ") || msg.startsWith("GDB is free software,") || msg.startsWith("welcome to change it and") || msg.contains("show copying") || msg.startsWith("There is absolutely no warranty for GDB") || msg.startsWith("Source directories searched: ") || msg.contains("LC_SEGMENT.__TEXT_addr = ") || msg.startsWith("This GDB was configured as"))) {
            if (this.programPID == 0L && msg.startsWith("process ")) {
                int pos = msg.indexOf(32, 8);
                String text = pos > 0 ? msg.substring(8, pos) : msg.substring(8);
                try {
                    this.programPID = Long.parseLong(text);
                }
                catch (NumberFormatException ex) {
                    log.warning("Failed to get PID from \"info proc\"");
                }
            } else if (this.programPID == 0L) {
                if (msg.startsWith("* 1 thread ")) {
                    int pos = msg.indexOf(46);
                    if (pos > 0) {
                        try {
                            this.programPID = Long.valueOf(msg.substring(11, pos));
                        }
                        catch (NumberFormatException ex) {
                            log.warning("Failed to get PID from \"info threads\"");
                        }
                    }
                } else if (msg.startsWith("[Switching to process ")) {
                    try {
                        int end = 22;
                        while (Character.isDigit(msg.charAt(end))) {
                            ++end;
                        }
                        this.programPID = Long.valueOf(msg.substring(22, end));
                    }
                    catch (NumberFormatException ex) {}
                }
            } else if (msg.startsWith("Stopped due to shared library event")) {
                this.dlopenPending = true;
            }
        }
    }

    public void logStreamOutput(String msg) {
        if (msg.startsWith("&\"No source file named ")) {
            this.breakpointValidation(this.currentToken, msg.substring(2, msg.length() - 3));
        } else if (msg.startsWith("&\"Function ") && msg.endsWith("not defined.\\n\"")) {
            this.breakpointValidation(this.currentToken, msg.substring(2, msg.length() - 3));
        } else if (!(msg.startsWith("&\"info proc") || msg.startsWith("&\"info threads") || msg.startsWith("&\"directory ") || msg.startsWith("&\"set new-console") || msg.startsWith("&\"whatis ") || msg.startsWith("&\"warning: Temporarily disabling breakpoints for unloaded shared library") || msg.contains("/usr/lib/ld.so"))) {
            log.finest("GD.logStreamOutput: " + msg);
        }
    }

    public void statusAsyncOutput(int token, String msg) {
        log.finest("GD.statusAsyncOutput[" + token + "]: " + msg);
    }

    public void notifyAsyncOutput(int token, String msg) {
        log.finest("GD.notifyAsyncOutput[" + token + "]: " + msg);
    }

    public void targetStreamOutput(String msg) {
        log.finest("GD.targetStreamOutput: " + msg);
    }

    public void output(String msg) {
        if (this.iotab != null) {
            if (msg.contains("PR_SYSEXIT")) {
                DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(GdbDebugger.class, (String)"ERR_ExitedFromSYSEXIT")));
                this.finish(true);
            }
            if (!(this.firstOutput && this.isSolaris() && msg.startsWith("PR_"))) {
                this.firstOutput = false;
                this.iotab.getOut().println(msg);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addArgsToLocalVariables(String info) {
        List<String> frames = this.createListFromString(info);
        GdbCallStackFrame curFrame = this.getCurrentCallStackFrame();
        for (String frame : frames) {
            int level;
            Map<String, String> frameMap = this.createMapFromString(frame);
            try {
                level = Integer.parseInt(frameMap.get("level"));
            }
            catch (Exception e) {
                log.log(Level.INFO, "Unable to parse level number for frame: " + frame, e);
                continue;
            }
            String args = frameMap.get("args");
            List<GdbVariable> vars = GdbUtils.createLocalsList(args);
            List<Object> list = this.callstack;
            synchronized (list) {
                if (level < this.callstack.size()) {
                    this.callstack.get(level).setArguments(vars);
                } else {
                    log.info("GD.addArgsToLocalVariables: args for unknown level " + level);
                }
            }
            if (curFrame == null || level != curFrame.getFrameNumber() || vars.isEmpty()) continue;
            log.finest("GD.addArgsToLocalVariables: Starting to add Args to localVariables");
            list = this.localVariables;
            synchronized (list) {
                for (GdbVariable var : vars) {
                    if (this.localVariables.contains(var)) continue;
                    this.localVariables.add(var);
                }
            }
            log.finest("GD.addArgsToLocalVariables: Added " + vars.size() + " args");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addLocalsToLocalVariables(String info) {
        List<GdbVariable> vars = GdbUtils.createLocalsList(info.substring(1, info.length() - 1));
        if (!vars.isEmpty()) {
            log.finest("GD.addLocalsToLocalVariables: Starting to add locals to localVariables");
            List<GdbVariable> list = this.localVariables;
            synchronized (list) {
                this.localVariables.addAll(vars);
            }
            log.finest("GD.addLocalsToLocalVariables: Added " + vars.size() + " locals");
        }
    }

    public String updateVariable(String name, String value) {
        return this.evaluate(name + '=' + value);
    }

    public void variableChanged(Object var) {
        this.firePropertyChange(PROP_VALUE_CHANGED, null, var);
    }

    public void suspend() {
        this.setState(State.STOPPED);
    }

    public void interrupt() {
        if (this.state == State.RUNNING || this.state == State.SILENT_STOP) {
            if (GdbProxyEngine.ENGINE_PTY && !this.gdb.getProxyEngine().isInferiorTty()) {
                this.skipSignal = true;
                this.gdb.getProxyEngine().interrupt();
            }
            if (this.getPlatform() == 4) {
                this.kill(Signal.TRAP);
            } else {
                this.kill(Signal.INT);
            }
        }
    }

    public void kill(Signal signal) {
        if (this.programPID > 0L) {
            this.kill(signal, this.programPID);
        }
    }

    public void kill(Signal signal, long pid) {
        if (pid > 0L) {
            ArrayList<String> killcmd = new ArrayList<String>();
            if (this.platform == 3) {
                File f = InstalledFileLocator.getDefault().locate("bin/GdbKillProc.exe", null, false);
                if (f.exists()) {
                    killcmd.add(f.getAbsolutePath());
                }
            } else {
                try {
                    if (HostInfoUtils.fileExists((ExecutionEnvironment)this.execEnv, (String)KILL_PATH1)) {
                        killcmd.add(KILL_PATH1);
                    } else if (HostInfoUtils.fileExists((ExecutionEnvironment)this.execEnv, (String)KILL_PATH2)) {
                        killcmd.add(KILL_PATH2);
                    }
                }
                catch (InterruptedException ex) {
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
            if (!killcmd.isEmpty()) {
                killcmd.add("-s");
                killcmd.add(signal.toString());
                killcmd.add(Long.toString(pid));
                String[] args = killcmd.subList(1, killcmd.size()).toArray(new String[killcmd.size() - 1]);
                NativeProcessBuilder npb = NativeProcessBuilder.newProcessBuilder((ExecutionEnvironment)this.execEnv);
                npb.setExecutable((String)killcmd.get(0)).setArguments(args);
                if (signal == Signal.INT || signal == Signal.TRAP) {
                    this.skipSignal = true;
                }
                try {
                    npb.call();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                this.gdb.getLogger().logMessage("External Command: " + killcmd.toString());
            }
        }
    }

    public void resume() {
        this.setState(State.RUNNING);
        this.gdb.exec_continue();
    }

    public void stepInto() {
        GdbTimer.getTimer("Step").start("Step1", 10);
        this.setState(State.RUNNING);
        this.gdb.exec_step();
    }

    private String setUntilBpt(String loc) {
        Map<String, String> map;
        String id;
        String response;
        CommandBuffer res = this.gdb.break_insert_temporaryEx(loc, true);
        if (res.isOK() && (response = res.getResponse()).length() >= 6 && (id = (map = this.createMapFromString(response.substring(6))).get("number")) != null) {
            return id;
        }
        return null;
    }

    public void until(CsmFunction function) {
        String id;
        if (this.untilBptId != null) {
            this.gdb.break_deleteCMD(this.untilBptId).send();
        }
        if ((id = this.setUntilBpt(((Object)function.getSignature()).toString())) == null) {
            id = this.setUntilBpt(((Object)function.getName()).toString());
        }
        if (id == null) {
            this.stepInto();
        } else {
            this.untilBptId = id;
            this.stepOver();
        }
    }

    public void stepOver() {
        this.setState(State.RUNNING);
        this.gdb.exec_next();
    }

    public void stepI() {
        this.setState(State.RUNNING);
        this.gdb.exec_step_instruction();
    }

    public void stepOverInstr() {
        this.setState(State.RUNNING);
        this.gdb.exec_next_instruction();
    }

    public void stepOut() {
        if (!this.callstack.isEmpty() || this.callstack.get(1).isValid()) {
            this.setState(State.RUNNING);
            this.gdb.stack_select_frame(0);
            this.gdb.exec_finish();
        } else {
            DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(GdbDebugger.class, (String)"ERR_InvalidCallStackFrame")));
        }
    }

    public void runToCursor() {
        String file = EditorContextBridge.getContext().getCurrentURL();
        if (file.length() == 0) {
            return;
        }
        int line = EditorContextBridge.getContext().getCurrentLineNumber();
        if (line < 0) {
            return;
        }
        if (this.rtcBreakpoint != null) {
            DebuggerManager.getDebuggerManager().removeBreakpoint((Breakpoint)this.rtcBreakpoint);
            this.rtcBreakpoint = null;
        }
        if (Disassembly.isInDisasm()) {
            String address = Disassembly.getCurrent().getLineAddress(line);
            if (address.isEmpty()) {
                return;
            }
            this.rtcBreakpoint = AddressBreakpoint.create((String)address);
        } else {
            this.rtcBreakpoint = LineBreakpoint.create((String)file, (int)line);
        }
        this.rtcBreakpoint.setTemporary();
        this.rtcBreakpoint.setHidden(true);
        DebuggerManager.getDebuggerManager().addBreakpoint((Breakpoint)this.rtcBreakpoint);
        this.resume();
    }

    private void removeTempBreakpoints() {
        for (Breakpoint b : DebuggerManager.getDebuggerManager().getBreakpoints()) {
            if (!(b instanceof CndBreakpoint) || !((CndBreakpoint)b).isTemporary()) continue;
            DebuggerManager.getDebuggerManager().removeBreakpoint(b);
        }
    }

    public State getState() {
        return this.state;
    }

    private void setState(State state) {
        State oldState = this.state;
        if (state == oldState) {
            return;
        }
        this.state = state;
        this.firePropertyChange(PROP_STATE, (Object)oldState, (Object)state);
    }

    private void setStarting() {
        this.setState(State.STARTING);
    }

    private void setLoading() {
        this.setState(State.LOADING);
    }

    public void setReady() {
        this.setState(State.READY);
    }

    public void setRunning() {
        this.setState(State.RUNNING);
    }

    private void setStopped() {
        this.setState(State.STOPPED);
    }

    public void setSilentStop() {
        this.setState(State.SILENT_STOP);
    }

    private void setExited() {
        this.setState(State.EXITED);
    }

    public boolean isStopped() {
        return this.state == State.STOPPED;
    }

    private static void fireBreakpointEvent(CndBreakpoint breakpoint, CndBreakpointEvent event) {
        breakpoint.fireCndBreakpointChange(event);
    }

    private void stopped(int token, Map<String, String> map) {
        String reason = map.get("reason");
        if ("exited-signalled".equals(reason)) {
            String signal = map.get("signal-name");
            DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(GdbDebugger.class, (String)"ERR_ExitedFromSignal", (Object)signal)));
            this.finish(false);
            return;
        }
        if (this.state == State.STARTING) {
            String frame = map.get("frame");
            if (frame != null) {
                map = this.createMapFromString(frame);
                this.updateLastStop(map);
            }
            if (!this.isAttaching()) {
                this.setLoading();
            }
            return;
        }
        if (this.state != State.RUNNING) {
            if (GdbDebugger.isUnitTest()) {
                if (this.state == State.NONE && reason == null) {
                    this.state = State.STOPPED;
                    this.tlog("GdbDebugger.stopped: Initial stop (main). Setting state to STOPPED");
                } else {
                    this.tlog("GdbDebugger.stopped: Stopped with state " + (Object)((Object)this.state) + " and reason " + reason);
                }
            } else if (!"signal-received".equals(reason)) {
                log.warning("GdbDebugger.stopped: Ignoring stop while in state " + (Object)((Object)this.state));
            }
            return;
        }
        log.finest("GD.stopped[" + GdbUtils.threadId() + "]: Reason is " + reason);
        this.tlog("GD.stopped: Reason is " + reason);
        this.resetThreadInfo();
        if (reason != null) {
            this.setCurrentCallStackFrameNoFire(null);
            if (reason.equals("exited-normally")) {
                this.finish(false);
            } else if (reason.equals("breakpoint-hit")) {
                String frame;
                BreakpointImpl<?> impl;
                String tid = map.get("thread-id");
                this.lastStop = null;
                if (tid != null && !tid.equals(this.currentThreadID)) {
                    this.currentThreadID = tid;
                }
                if ((impl = this.findBreakpoint(map.get("bkptno"))) == null) {
                    String frame2;
                    int idx = this.temporaryBreakpoints.indexOf(map.get("bkptno"));
                    if (idx >= 0) {
                        this.temporaryBreakpoints.remove(idx);
                        if (this.platform == 4) {
                            this.updateCurrentCallStack();
                            this.setStopped();
                        }
                    } else {
                        log.warning("GD.stopped: Stopped at unknown breakpoint");
                        this.gdb.exec_continue();
                    }
                    if ((frame2 = map.get("frame")) != null && frame2.contains("func=\"dlopen\"")) {
                        this.dlopenPending = true;
                        LastGoState saveLastGo = this.lastGo;
                        this.gdb.exec_finish();
                        this.setLastGo(saveLastGo);
                        return;
                    }
                } else {
                    Object breakpoint = impl.getBreakpoint();
                    if (breakpoint.getSuspend() == 0 && this.lastGo == LastGoState.CONTINUE) {
                        GdbDebugger.fireBreakpointEvent(breakpoint, new CndBreakpointEvent(breakpoint, (Object)this, 0));
                        this.gdb.exec_continue();
                    } else {
                        this.updateCurrentCallStack();
                        GdbDebugger.fireBreakpointEvent(breakpoint, new CndBreakpointEvent(breakpoint, (Object)this, 0));
                        this.setStopped();
                    }
                }
                if (this.dlopenPending) {
                    this.dlopenPending = false;
                    this.checkSharedLibs();
                }
                if ((frame = map.get("frame")) != null) {
                    map = this.createMapFromString(frame);
                    this.updateLastStop(map);
                }
                GdbTimer.getTimer("Startup").stop("Startup1");
                GdbTimer.getTimer("Startup").report("Startup1");
                GdbTimer.getTimer("Startup").free();
                GdbTimer.getTimer("Stop").mark("Stop1");
            } else if (reason.equals("end-stepping-range")) {
                this.lastStop = null;
                this.updateCurrentCallStack();
                this.setStopped();
                String frame = map.get("frame");
                if (frame != null) {
                    map = this.createMapFromString(frame);
                    this.updateLastStop(map);
                }
                if (GdbTimer.getTimer("Step").getSkipCount() == 0) {
                    GdbTimer.getTimer("Step").stop("Step1");
                    GdbTimer.getTimer("Step").report("Step1");
                }
            } else if (reason.equals("shlib-event")) {
                this.checkSharedLibs();
            } else if (reason.equals("signal-received")) {
                this.signalReceived(map);
            } else if (reason.equals("function-finished") && this.dlopenPending) {
                this.dlopenPending = false;
                this.checkSharedLibs();
            } else if (!reason.startsWith("exited")) {
                this.gdb.stack_list_frames();
                this.setStopped();
            } else {
                this.setStopped();
                this.finish(false);
            }
        } else if (this.dlopenPending) {
            this.dlopenPending = false;
            this.checkSharedLibs();
        } else {
            this.gdb.stack_list_frames();
            this.setStopped();
        }
    }

    private void updateLastStop(Map<String, String> map) {
        String fullname = map.get("fullname");
        String line = map.get("line");
        if (fullname != null && line != null) {
            this.lastStop = fullname + ":" + line;
        }
    }

    private void signalReceived(Map<String, String> map) {
        String signal = map.get("signal-name");
        if (this.skipSignal) {
            if ("SIGCONT".equals(signal)) {
                this.skipSignal = false;
                this.resume();
                return;
            }
            if ("SIGINT".equals(signal)) {
                this.gdb.stack_list_frames();
                this.setStopped();
                return;
            }
            if ("SIGTRAP".equals(signal) && (this.platform == 3 || this.platform == 4)) {
                this.skipSignal = false;
                this.gdb.stack_list_frames();
                this.setStopped();
                return;
            }
        }
        this.skipSignal = false;
        if (this.state == State.RUNNING) {
            String tid = map.get("thread-id");
            if (tid != null && !tid.equals(this.currentThreadID)) {
                this.currentThreadID = tid;
            }
            this.sig = signal;
            String STOP = NbBundle.getMessage(GdbDebugger.class, (String)"TXT_DISCARD_STOP");
            String CONTINUE = NbBundle.getMessage(GdbDebugger.class, (String)"TXT_DISCARD_CONTINUE");
            String PASS = NbBundle.getMessage(GdbDebugger.class, (String)"TXT_PASS_CONTINUE");
            NotifyDescriptor nd = new NotifyDescriptor((Object)NbBundle.getMessage(GdbDebugger.class, (String)"ERR_SignalReceived", (Object)map.get("signal-name"), (Object)map.get("signal-meaning")), NbBundle.getMessage(GdbDebugger.class, (String)"LBL_SignalReceived"), -1, 1, (Object[])new String[]{STOP, CONTINUE, PASS}, (Object)STOP);
            Object res = DialogDisplayer.getDefault().notify(nd);
            if (res == STOP) {
                this.gdb.handle(signal, GdbProxy.HandleAction.nopass);
                this.gdb.stack_list_frames();
                this.setStopped();
            } else if (res == CONTINUE) {
                this.gdb.handle(signal, GdbProxy.HandleAction.nopass);
                this.gdb.exec_continue();
            } else if (res == PASS) {
                this.gdb.handle(signal, GdbProxy.HandleAction.pass);
                this.gdb.exec_continue();
            }
        }
    }

    private Map<String, ShareInfo> createShareTab(String info) {
        HashMap<String, ShareInfo> shtab = new HashMap<String, ShareInfo>();
        if (this.platform == 4) {
            String addr;
            String path;
            Map<String, String> map;
            int next;
            int start = 0;
            while ((next = info.indexOf("shlib-info=", start + 1)) > 0) {
                map = this.createMapFromString(info.substring(start + 12, next - 2));
                path = map.get("path");
                addr = map.get("dyld-addr");
                if (path != null && addr != null) {
                    shtab.put(path, new ShareInfo(path, addr));
                }
                start = next;
            }
            map = this.createMapFromString(info.substring(start + 12, info.length() - 1));
            path = map.get("path");
            addr = map.get("dyld-addr");
            if (path != null && addr != null) {
                shtab.put(path, new ShareInfo(path, addr));
            }
        } else {
            for (String line : info.split("\\\\n")) {
                if (line.length() <= 0 || line.charAt(0) != '0') continue;
                String[] s = line.split("\\s+", 4);
                shtab.put(s[3], new ShareInfo(s[3], s[0]));
            }
        }
        return shtab;
    }

    private void checkSharedLibs() {
        this.getRequestProcessor().post(new Runnable(){

            @Override
            public void run() {
                String share = GdbDebugger.this.gdb.info_share(true).getResponse();
                Map nuTab = GdbDebugger.this.createShareTab(share);
                if (nuTab.size() > GdbDebugger.this.shareTab.size()) {
                    log.fine("GD.checkSharedLibs: Added a shared library");
                    ShareInfo si = GdbDebugger.this.getNewShareInfo(nuTab);
                    if (si.isMatchingProject()) {
                        GdbDebugger.this.gdb.environment_directory(si.getSourceDirectories());
                    }
                    GdbDebugger.this.firePropertyChange(GdbDebugger.PROP_SHARED_LIB_LOADED, null, si.getPath());
                } else {
                    log.fine("GD.checkSharedLibs: Closed a shared library");
                }
                GdbDebugger.this.shareTab = nuTab;
                if (GdbDebugger.this.lastGo == LastGoState.CONTINUE) {
                    GdbDebugger.this.gdb.exec_continue();
                } else {
                    GdbDebugger.this.stepOutOfDlopen();
                }
            }
        });
    }

    private ShareInfo getNewShareInfo(Map<String, ShareInfo> map) {
        for (Map.Entry<String, ShareInfo> entry : map.entrySet()) {
            if (this.shareTab.containsKey(entry.getKey())) continue;
            return entry.getValue();
        }
        assert (false) : "No new shared library found";
        return null;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void stepOutOfDlopen() {
        State oldState = this.state;
        this.setSilentStop();
        String msg = this.gdb.stack_list_framesEx().getResponse();
        msg = msg.substring(7, msg.length() - 1);
        int i = 0;
        boolean valid = true;
        boolean checkNextFrame = false;
        for (String frame : this.createListFromString(msg)) {
            Map<String, String> map = this.createMapFromString(frame);
            String func = map.get("func");
            if (func != null && func.equals("dlopen") && !checkNextFrame) {
                if (this.platform != 4) {
                    this.gdb.stack_select_frame(i);
                    this.setStopOnSolibEvents(false);
                    this.gdb.exec_finish();
                    this.setStopOnSolibEvents(true);
                    this.gdb.exec_next();
                    this.state = oldState;
                    return;
                }
                checkNextFrame = true;
            } else {
                String fullname = map.get("fullname");
                if (fullname != null) {
                    String line;
                    File file = new File(this.getOSPath(fullname));
                    boolean bl = valid = file != null && file.exists();
                    if (valid && checkNextFrame && (line = map.get("line")) != null) {
                        int lnum = Integer.parseInt(line) + 1;
                        this.gdb.break_insert_temporary(fullname + ":" + lnum);
                        this.gdb.exec_continue();
                        return;
                    }
                } else {
                    valid = false;
                }
            }
            ++i;
        }
        if (valid) {
            this.gdb.exec_next();
        } else if (this.lastStop != null) {
            int pos = this.lastStop.lastIndexOf(58);
            int lnum = Integer.parseInt(this.lastStop.substring(pos + 1)) + 1;
            this.gdb.break_insert_temporary(this.lastStop.substring(0, pos + 1) + lnum);
            this.gdb.exec_continue();
        }
        this.state = oldState;
    }

    private void setStopOnSolibEvents(boolean enable) {
        if (this.gdbVersion < 6.8) {
            this.gdb.gdb_set("stop-on-solib-event", enable ? "1" : "0");
        }
    }

    public String getOSPath(String path) {
        if (path == null) {
            return null;
        }
        if (this.platform == 3) {
            if (this.isCygwin()) {
                return WindowsSupport.getInstance().convertFromCygwinPath(path);
            }
            if (this.isMinGW()) {
                return WindowsSupport.getInstance().convertFromMSysPath(path);
            }
        }
        return path;
    }

    private void threadsViewInit() {
        Properties props = Properties.getDefault().getProperties("debugger").getProperties("views");
        props.getProperties("ThreadState").setBoolean("visible", false);
        props.getProperties("ThreadSuspended").setBoolean("visible", false);
    }

    public void addPendingBreakpoint(int token, BreakpointImpl<?> impl) {
        this.pendingBreakpointMap.put(token, impl);
    }

    private boolean breakpointValidation(int token, Object o) {
        BreakpointImpl<?> impl = this.pendingBreakpointMap.get(token);
        if (impl != null) {
            if (o instanceof String) {
                impl.addError((String)o);
            } else if (o instanceof Map || o == null) {
                this.pendingBreakpointMap.remove(token);
                Map map = (Map)o;
                impl.completeValidation(map);
                if (map != null && impl.getBreakpoint().getValidity() == Breakpoint.VALIDITY.VALID && impl.getBreakpoint().isEnabled()) {
                    String fullname = (String)map.get("fullname");
                    String file = (String)map.get("file");
                    String line = (String)map.get("line");
                    if (this.firstBPfullname != null && this.firstBPfullname.equals(fullname) && this.firstBPline != null && this.firstBPline.equals(line)) {
                        this.continueAfterFirstStop = false;
                    } else if (this.platform == 4 && this.firstBPfile != null && this.firstBPfile.equals(file) && this.firstBPline != null && this.firstBPline.equals(line)) {
                        this.continueAfterFirstStop = false;
                    }
                }
            }
            if (this.pendingBreakpointMap.isEmpty() && this.state == State.LOADING) {
                this.setReady();
            }
            return true;
        }
        if (o instanceof Map) {
            Map map = (Map)o;
            String number = (String)map.get("number");
            String fullname = (String)map.get("fullname");
            String file = (String)map.get("file");
            String line = (String)map.get("line");
            if ("1".equals(number)) {
                this.firstBPfullname = fullname;
                this.firstBPfile = file;
                this.firstBPline = line;
            }
            this.temporaryBreakpoints.add(number);
        }
        return false;
    }

    public static void debugCore(String corePath, ProjectInformation pinfo) throws DebuggerStartException {
        GdbDebugger.attach2Target(new AttachTarget.CoreAttach(corePath), pinfo, ExecutionEnvironmentFactory.getLocal());
    }

    public static void attachGdbServer(String target, ProjectInformation pinfo) throws DebuggerStartException {
        GdbDebugger.attach2Target(new AttachTarget.GdbServerAttach(target), pinfo, ExecutionEnvironmentFactory.getLocal());
    }

    public static void attach(int pid, ProjectInformation pinfo, ExecutionEnvironment exEnv) throws DebuggerStartException {
        GdbDebugger.attach2Target(new AttachTarget.PidAttach(pid), pinfo, exEnv);
    }

    private static void attach2Target(AttachTarget target, ProjectInformation pinfo, ExecutionEnvironment exEnv) throws DebuggerStartException {
        Project project = pinfo.getProject();
        ConfigurationDescriptorProvider cdp = (ConfigurationDescriptorProvider)project.getLookup().lookup(ConfigurationDescriptorProvider.class);
        MakeConfigurationDescriptor mcd = cdp.getConfigurationDescriptor();
        if (mcd != null) {
            MakeConfiguration conf = mcd.getActiveConfiguration();
            conf = (MakeConfiguration)conf.cloneConf();
            conf.setDevelopmentHost(new DevelopmentHostConfiguration(exEnv));
            String path = GdbDebugger.getBuildResult(pinfo, conf);
            if (target.checkExecutable() && !GdbDebugger.isExecutableOrSharedLibrary(conf, path)) {
                path = null;
            }
            if (path != null) {
                ProjectActionEvent pae = new ProjectActionEvent(project, (ProjectActionEvent.Type)ProjectActionEvent.PredefinedType.CHECK_EXECUTABLE, path, conf, null, false);
                DebuggerEngine[] es = DebuggerManager.getDebuggerManager().startDebugging(DebuggerInfo.create((String)SESSION_PROVIDER_ID, (Object[])new Object[]{pae, target}));
                if (es == null) {
                    throw new DebuggerStartException(new InternalError());
                }
            } else {
                String buildResult = conf.getMakefileConfiguration().getOutput().getValue();
                String msg = buildResult.length() > 0 ? (GdbDebugger.isAbsolute(conf, buildResult) ? NbBundle.getMessage(GdbDebugger.class, (String)"ERR_InvalidBuildResult", (Object)buildResult) : NbBundle.getMessage(GdbDebugger.class, (String)"ERR_RelativePathInBuildResult")) : NbBundle.getMessage(GdbDebugger.class, (String)"ERR_NoBuildResult");
                DialogDisplayer.getDefault().notifyLater((NotifyDescriptor)new NotifyDescriptor.Message((Object)msg));
            }
        }
    }

    private static String getBuildResult(ProjectInformation pinfo, MakeConfiguration conf) {
        String path = conf.getAbsoluteOutputValue().replace("\\", "/");
        ExecutionEnvironment execEnv = conf.getDevelopmentHost().getExecutionEnvironment();
        PathMap mapper = HostInfoProvider.getMapper((ExecutionEnvironment)execEnv);
        path = mapper.getRemotePath(path, true);
        if (path.length() == 0) {
            ProjectActionEvent pae = new ProjectActionEvent(pinfo.getProject(), (ProjectActionEvent.Type)ProjectActionEvent.PredefinedType.CHECK_EXECUTABLE, path, conf, null, false);
            ProjectActionSupport.getInstance().fireActionPerformed(new ProjectActionEvent[]{pae});
            path = conf.getAbsoluteOutputValue().replace("\\", "/");
        }
        return path;
    }

    private static boolean isAbsolute(MakeConfiguration conf, String path) {
        if (GdbDebugger.getDevelopmentHostPlatform(conf) == 3) {
            return path.length() > 2 && path.charAt(1) == ':' && path.charAt(2) == '/';
        }
        return path.length() > 0 && path.charAt(0) == '/';
    }

    private static int getDevelopmentHostPlatform(MakeConfiguration conf) {
        return conf.getPlatformInfo().getPlatform();
    }

    private static boolean isExecutableOrSharedLibrary(MakeConfiguration conf, String path) {
        ExecutionEnvironment execEnv = conf.getDevelopmentHost().getExecutionEnvironment();
        if (conf.isApplicationConfiguration() || conf.isDynamicLibraryConfiguration()) {
            return true;
        }
        if (conf.isMakefileConfiguration()) {
            if (GdbDebugger.getDevelopmentHostPlatform(conf) == 3) {
                if (path.endsWith(".dll")) {
                    return false;
                }
                if (!path.endsWith(".exe")) {
                    path = path + ".exe";
                }
            }
            try {
                if (!HostInfoUtils.fileExists((ExecutionEnvironment)execEnv, (String)path)) {
                    return false;
                }
                if (execEnv.isLocal()) {
                    File file = new File(path);
                    assert (file.exists());
                    String mime_type = FileUtil.getMIMEType((FileObject)FileUtil.toFileObject((File)CndFileUtils.normalizeFile((File)file)));
                    if (mime_type != null && mime_type.startsWith("application/x-exe")) {
                        return true;
                    }
                }
                return true;
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stackUpdate(List<String> stack) {
        List<GdbCallStackFrame> list = this.callstack;
        synchronized (list) {
            for (GdbCallStackFrame frame : this.callstack) {
                frame.destroy();
            }
            this.callstack.clear();
            for (int i = 0; i < stack.size(); ++i) {
                String line = stack.get(i);
                Map<String, String> map = this.createMapFromString(line);
                String func = map.get("func");
                String file = map.get("file");
                String fullname = map.get("fullname");
                String lnum = map.get("line");
                String addr = map.get("addr");
                String from = map.get("from");
                if (fullname == null && file != null) {
                    if (file.charAt(0) == '/') {
                        fullname = file;
                        log.finest("GD.stackUpdate: Setting fullname from file");
                    } else {
                        fullname = this.runDirectory + file;
                        log.finest("GD.stackUpdate: Setting fullname from runDirectory + file");
                    }
                }
                this.callstack.add(i, new GdbCallStackFrame(this, func, file, fullname, lnum, addr, i, from));
            }
        }
        if (!stack.isEmpty()) {
            this.pcs.firePropertyChange(PROP_CURRENT_CALL_STACK_FRAME, 0, 1);
        }
    }

    public void setCurrentThread(String tline) {
        int idx;
        if (tline.length() > 0 && Character.isDigit(tline.charAt(0)) && (idx = tline.indexOf(32)) > 0) {
            this.resetThreadInfo();
            this.gdb.thread_select(tline.substring(0, idx));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<GdbVariable> getLocalVariables() {
        assert (!Thread.currentThread().getName().equals("GdbReaderRP"));
        List<GdbVariable> list = this.localVariables;
        synchronized (list) {
            return new ArrayList<GdbVariable>(this.localVariables);
        }
    }

    public String evaluate(String expression) {
        int pos;
        boolean suspendAll;
        if (this.gdb == null) {
            return null;
        }
        if (!this.isStopped()) {
            return null;
        }
        boolean bl = suspendAll = expression.indexOf(40) != -1;
        if (suspendAll) {
            this.suspendBreakpointsAndSignals();
        }
        CommandBuffer cb = this.gdb.data_evaluate_expressionEx('\"' + expression + '\"');
        if (suspendAll) {
            this.restoreBreakpointsAndSignals();
        }
        if (cb.isError()) {
            String err = cb.getError();
            if (err.startsWith("\"The program being debugged was signaled while in a function called from GDB")) {
                err = NbBundle.getMessage(GdbDebugger.class, (String)"ERR_WatchedFunctionAborted");
            }
            return err;
        }
        String response = cb.getResponse();
        if (response.startsWith(VALUE_PREFIX)) {
            response = response.substring(VALUE_PREFIX.length() + 1, response.length() - 1);
        } else {
            log.severe("GDBDebugger.evaluate: unexpected response " + response + " for expression " + expression);
        }
        if (response.startsWith("@0x") && (response = (cb = this.gdb.print(expression)).getResponse()).length() > 0 && response.charAt(0) == '$' && (pos = response.indexOf(61)) != -1 && pos + 2 < response.length()) {
            response = response.substring(pos + 2, response.length()).replace(CONSOLE_MSG_END, "").trim();
        }
        if (this.getPlatform() == 4) {
            response = GdbUtils.mackHack(response);
        }
        return response.length() > 0 ? response : null;
    }

    public String requestValue(String name) {
        try {
            return this.requestValueEx(name);
        }
        catch (Exception e) {
            return e.getMessage();
        }
    }

    public String requestValueEx(String name) throws GdbErrorException {
        assert (!Thread.currentThread().getName().equals("GdbReaderRP"));
        if (this.state == State.STOPPED) {
            CommandBuffer cb = this.gdb.data_evaluate_expressionEx(name);
            String info = cb.getResponse();
            if (info.length() == 0 || !cb.isOK()) {
                if (cb.isError()) {
                    log.fine("GD.requestValue Error[" + cb + "]");
                    throw new GdbErrorException('>' + cb.getError() + '<');
                }
                log.fine("GD.requestValue Failure[" + cb + "]");
                return "";
            }
            return info.substring(7, info.length() - 1);
        }
        return null;
    }

    public String requestWhatis(String name) {
        assert (!Thread.currentThread().getName().equals("GdbReaderRP"));
        if (this.state == State.STOPPED && name != null && name.length() > 0) {
            CommandBuffer cb = this.gdb.whatis(name);
            String info = cb.getResponse();
            if (info.length() == 0 || !cb.isOK()) {
                if (cb.isError()) {
                    log.fine("GD.requestWhatis Error[" + cb + "]");
                    return "";
                }
                log.fine("GD.requestWhatis Failure[" + cb + "]");
                return "";
            }
            return info.substring(7, info.length() - 2);
        }
        return null;
    }

    public String requestBaseClassType(String type) {
        assert (!Thread.currentThread().getName().equals("GdbReaderRP"));
        if (this.state == State.STOPPED && type != null && type.length() > 0) {
            CommandBuffer cb = this.gdb.symbol_type("class " + type);
            String info = cb.getResponse();
            if (info.length() == 0 || !cb.isOK()) {
                if (cb.isError()) {
                    log.fine("GD.requestSymbolType Error[" + cb + "]");
                    return "";
                }
                log.fine("GD.requestSymbolType Failure[" + cb + "]. Returning original type");
                return type;
            }
            log.fine("GD.requestSymbolType[" + cb + "]: " + type + " --> [" + info + "]");
            return info.substring(7, info.length() - 2);
        }
        return null;
    }

    public String requestSymbolTypeFromName(String name) {
        assert (!Thread.currentThread().getName().equals("GdbReaderRP"));
        if (this.state == State.STOPPED && name != null && name.length() > 0) {
            CommandBuffer cb = this.gdb.symbol_type(name);
            String info = cb.getResponse();
            if (info.length() == 0 || !cb.isOK()) {
                if (cb.isError()) {
                    log.fine("GD.requestSymbolTypeFromName Error[" + cb + "]");
                    return "";
                }
                log.fine("GD.requestSymbolTypeFromName Failure[" + cb + "]. Returning original type");
                return "";
            }
            log.fine("GD.requestSymbolTypeFromName[" + cb + "]: " + name + " --> [" + info + "]");
            return info.substring(7, info.length() - 2);
        }
        return null;
    }

    private void suspendBreakpointsAndSignals() {
        this.gdb.break_disableCMD(new Integer[0]).send();
        this.gdb.set_unwindonsignal("on");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void restoreBreakpointsAndSignals() {
        this.gdb.set_unwindonsignal("off");
        ArrayList<Integer> ids = new ArrayList<Integer>();
        Map<Integer, BreakpointImpl<?>> map = this.breakpointList;
        synchronized (map) {
            for (Map.Entry<Integer, BreakpointImpl<?>> entry : this.breakpointList.entrySet()) {
                if (!entry.getValue().getBreakpoint().isEnabled()) continue;
                ids.add(entry.getKey());
            }
        }
        this.gdb.break_enableCMD(ids.toArray(new Integer[ids.size()])).send();
    }

    public List<GdbCallStackFrame> getCallStack() {
        return this.callstack;
    }

    public int getStackDepth() {
        return this.callstack.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GdbCallStackFrame getCurrentCallStackFrame() {
        List<GdbCallStackFrame> list = this.callstack;
        synchronized (list) {
            if (this.currentCallStackFrame != null) {
                return this.currentCallStackFrame;
            }
            if (!this.callstack.isEmpty()) {
                return this.callstack.get(0);
            }
            return null;
        }
    }

    public void setCurrentCallStackFrame(GdbCallStackFrame callStackFrame) {
        if (callStackFrame.isValid()) {
            GdbCallStackFrame old = this.setCurrentCallStackFrameNoFire(callStackFrame);
            this.updateLocalVariables(callStackFrame.getFrameNumber());
            if (old == callStackFrame) {
                return;
            }
            this.pcs.firePropertyChange(PROP_CURRENT_CALL_STACK_FRAME, (Object)old, (Object)callStackFrame);
        } else {
            DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(GdbDebugger.class, (String)"ERR_InvalidCallStackFrame")));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private GdbCallStackFrame setCurrentCallStackFrameNoFire(GdbCallStackFrame callStackFrame) {
        GdbCallStackFrame old;
        List<GdbCallStackFrame> list = this.callstack;
        synchronized (list) {
            old = this.getCurrentCallStackFrame();
            if (callStackFrame == old) {
                return callStackFrame;
            }
            this.currentCallStackFrame = callStackFrame;
        }
        return old;
    }

    public void popTopmostCall() {
        if (!this.callstack.isEmpty() && this.callstack.get(1).isValid()) {
            this.gdb.stack_select_frame(0);
            this.gdb.exec_finish();
        } else {
            DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(GdbDebugger.class, (String)"ERR_InvalidCallStackFrame")));
        }
    }

    public Map<Integer, BreakpointImpl<?>> getBreakpointList() {
        return this.breakpointList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BreakpointImpl<?> getBreakpointImpl(Breakpoint b) {
        GdbDebugger debugger = GdbDebugger.getGdbDebugger();
        if (debugger != null) {
            Map<Integer, BreakpointImpl<?>> map = debugger.breakpointList;
            synchronized (map) {
                for (BreakpointImpl<?> bptImpl : debugger.breakpointList.values()) {
                    if (bptImpl.getBreakpoint() != b) continue;
                    return bptImpl;
                }
            }
        }
        return null;
    }

    private BreakpointImpl<?> findBreakpoint(String id) {
        try {
            return this.breakpointList.get(Integer.valueOf(id));
        }
        catch (NumberFormatException nfe) {
            return null;
        }
    }

    public String getBestPath(String path) {
        if ((path = this.pathMap.getRemotePath(path, true)).startsWith(this.baseDir + '/')) {
            return path.substring(this.baseDir.length() + 1);
        }
        int pos = path.lastIndexOf(47);
        if (pos != -1) {
            return path.substring(pos + 1);
        }
        return path;
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener l) {
        this.pcs.addPropertyChangeListener(propertyName, l);
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.pcs.addPropertyChangeListener(l);
    }

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener l) {
        this.pcs.removePropertyChangeListener(propertyName, l);
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.pcs.removePropertyChangeListener(l);
    }

    private void firePropertyChange(String name, Object o, Object n) {
        this.pcs.firePropertyChange(name, o, n);
    }

    public boolean isCygwin() {
        return this.cygwin;
    }

    private boolean isMinGW() {
        return this.mingw;
    }

    private boolean isSolaris() {
        return this.platform == 1 || this.platform == 0;
    }

    public boolean isCplusPlus() {
        return this.cplusplus;
    }

    public Disassembly getDisassembly() {
        return this.disassembly;
    }

    public void setCurrentBreakpoint(CndBreakpoint currentBreakpoint) {
        this.currentBreakpoint = currentBreakpoint;
    }

    public void setLastGo(LastGoState lastGo) {
        this.lastGo = lastGo;
    }

    private boolean isAttaching() {
        ProjectActionEvent pae = (ProjectActionEvent)this.lookupProvider.lookupFirst(null, ProjectActionEvent.class);
        return pae.getType() == DEBUG_ATTACH;
    }

    private void killSession() {
        ((Session)this.lookupProvider.lookupFirst(null, Session.class)).kill();
    }

    private void tlog(String msg) {
        if (GdbDebugger.isUnitTest() && tlog.isLoggable(Level.WARNING)) {
            System.out.println("    " + msg);
        }
    }

    public String getCharSetEncoding() {
        String encoding = this.execEnv.isRemote() ? ProcessUtils.getRemoteCharSet() : Charset.defaultCharset().name();
        return encoding;
    }

    public Map<String, String> createMapFromString(String info) {
        return GdbUtils.createMapFromString(info, this.getCharSetEncoding());
    }

    public List<String> createListFromString(String info) {
        return GdbUtils.createListFromString(info, this.getCharSetEncoding());
    }

    private static class ShareInfo {
        private final String path;
        private final String addr;
        private List<String> sourceDirs;
        private Project project;

        public ShareInfo(String path, String addr) {
            this.path = path;
            this.addr = addr;
            this.sourceDirs = null;
            this.project = null;
        }

        public String getPath() {
            return this.path;
        }

        public String getAddress() {
            return this.addr;
        }

        public List<String> getSourceDirectories() {
            if (this.sourceDirs == null) {
                NativeProject nativeProject;
                this.sourceDirs = new ArrayList<String>();
                if (this.project != null && (nativeProject = (NativeProject)this.project.getLookup().lookup(NativeProject.class)) != null) {
                    this.sourceDirs.add(nativeProject.getProjectRoot());
                    for (String dir : nativeProject.getSourceRoots()) {
                        this.sourceDirs.add(dir);
                    }
                }
            }
            return this.sourceDirs;
        }

        public boolean isMatchingProject() {
            for (Project proj : OpenProjects.getDefault().getOpenProjects()) {
                MakeConfiguration conf;
                ProjectConfiguration o;
                ProjectConfigurationProvider pcp = (ProjectConfigurationProvider)proj.getLookup().lookup(ProjectConfigurationProvider.class);
                if (pcp == null || !((o = pcp.getActiveConfiguration()) instanceof MakeConfiguration) || !(conf = (MakeConfiguration)o).isDynamicLibraryConfiguration()) continue;
                String proot = FileUtil.getFileDisplayName((FileObject)proj.getProjectDirectory());
                String output = proot + "/" + conf.getOutputValue();
                if (!(output = conf.expandMacros(output)).equals(this.path)) continue;
                this.project = proj;
                return true;
            }
            return false;
        }
    }

    public static enum LastGoState {
        CONTINUE,
        FINISH,
        STEP,
        NEXT;

    }

    public static enum State {
        NONE,
        STARTING,
        LOADING,
        READY,
        RUNNING,
        STOPPED,
        SILENT_STOP,
        EXITED;

    }
}

