/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.spi.mobility.project.support;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.api.java.platform.JavaPlatformManager;
import org.netbeans.api.project.ant.AntArtifact;
import org.netbeans.api.project.libraries.Library;
import org.netbeans.api.project.libraries.LibraryManager;
import org.netbeans.mobility.antext.preprocessor.CommentingPreProcessor;
import org.netbeans.modules.mobility.project.ui.customizer.J2MEProjectProperties;
import org.netbeans.modules.mobility.project.ui.customizer.VisualClassPathItem;
import org.netbeans.spi.mobility.deployment.DeploymentPlugin;
import org.netbeans.spi.mobility.project.PropertyParser;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.netbeans.spi.project.support.ant.ReferenceHelper;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class DefaultPropertyParsers {
    public static final PropertyParser STRING_PARSER = new StringParser();
    public static final PropertyParser BOOLEAN_PARSER = new BooleanParser();
    public static final PropertyParser INVERSE_BOOLEAN_PARSER = new InverseBooleanParser();
    public static final PropertyParser PATH_PARSER = new PathParser();
    public static final PropertyParser PLATFORM_PARSER = new PlatformParser();
    public static final PropertyParser INTEGER_PARSER = new IntegerParser();
    public static final PropertyParser MANIFEST_PROPERTY_PARSER = new ManifestPropertyParser();
    public static final PropertyParser FILE_REFERENCE_PARSER = new FileReferenceParser();
    public static final PropertyParser ABILITIES_PARSER = new AbilitiesParser();
    public static final PropertyParser DEPLOYMENT_TYPE_PARSER = new DeploymentTypeParser();
    public static final PropertyParser DEBUG_LEVEL_PARSER = new DebugLevelParser();

    private static class AbilitiesParser
    implements PropertyParser {
        private AbilitiesParser() {
        }

        @Override
        public Object decode(String raw, AntProjectHelper antProjectHelper, ReferenceHelper refHelper) {
            return CommentingPreProcessor.decodeAbilitiesMap((String)raw);
        }

        @Override
        public String encode(Object value, AntProjectHelper antProjectHelper, ReferenceHelper refHelper) {
            return CommentingPreProcessor.encodeAbilitiesMap((Map)((Map)value));
        }
    }

    private static class ManifestPropertyParser
    implements PropertyParser {
        private ManifestPropertyParser() {
        }

        @Override
        public Object decode(String raw, AntProjectHelper antProjectHelper, ReferenceHelper refHelper) {
            try {
                String line;
                if (raw == null) {
                    return null;
                }
                BufferedReader br = new BufferedReader(new StringReader(raw));
                HashMap<String, String> map = new HashMap<String, String>();
                while ((line = br.readLine()) != null) {
                    int i = line.indexOf(58);
                    if (i < 0) continue;
                    map.put(line.substring(0, i), line.substring(i + 1).trim());
                }
                return map;
            }
            catch (IOException ioe) {
                assert (false) : ioe;
                return null;
            }
        }

        @Override
        public String encode(Object val, AntProjectHelper antProjectHelper, ReferenceHelper refHelper) {
            HashMap map = (HashMap)val;
            if (map == null) {
                return null;
            }
            StringBuffer buffer = new StringBuffer();
            for (String key : map.keySet()) {
                String value;
                if (key == null || (value = (String)map.get(key)) == null) continue;
                buffer.append(key).append(": ").append(value).append('\n');
            }
            return buffer.toString();
        }
    }

    private static class DeploymentTypeParser
    implements PropertyParser {
        private DeploymentTypeParser() {
        }

        @Override
        public Object decode(String raw, AntProjectHelper antProjectHelper, ReferenceHelper refHelper) {
            for (DeploymentPlugin p : Lookup.getDefault().lookup(new Lookup.Template(DeploymentPlugin.class)).allInstances()) {
                if (!p.getDeploymentMethodName().equals(raw)) continue;
                return p.getDeploymentMethodDisplayName();
            }
            return "";
        }

        @Override
        public String encode(Object value, AntProjectHelper antProjectHelper, ReferenceHelper refHelper) {
            for (DeploymentPlugin p : Lookup.getDefault().lookup(new Lookup.Template(DeploymentPlugin.class)).allInstances()) {
                if (!p.getDeploymentMethodDisplayName().equals(value)) continue;
                return p.getDeploymentMethodName();
            }
            return null;
        }
    }

    private static class PlatformParser
    implements PropertyParser {
        private PlatformParser() {
        }

        @Override
        public Object decode(String raw, AntProjectHelper antProjectHelper, ReferenceHelper refHelper) {
            JavaPlatform[] platforms = JavaPlatformManager.getDefault().getInstalledPlatforms();
            for (int i = 0; i < platforms.length; ++i) {
                String normalizedName = (String)platforms[i].getProperties().get("platform.ant.name");
                if (normalizedName == null || !normalizedName.equals(raw)) continue;
                return platforms[i].getDisplayName();
            }
            return JavaPlatformManager.getDefault().getDefaultPlatform().getDisplayName();
        }

        @Override
        public String encode(Object value, AntProjectHelper antProjectHelper, ReferenceHelper refHelper) {
            JavaPlatform[] platforms = JavaPlatformManager.getDefault().getPlatforms((String)value, null);
            if (platforms.length == 0) {
                return null;
            }
            return (String)platforms[0].getProperties().get("platform.ant.name");
        }
    }

    private static class PathParser
    implements PropertyParser {
        private static final String LIBRARY_PREFIX = "${libs.";
        private static final String ARTIFACT_PREFIX = "${reference.";
        private static final String[][] WELL_KNOWN_PATHS = new String[][]{{"libs.classpath", NbBundle.getMessage(J2MEProjectProperties.class, (String)"LBL_JavacClasspath_DisplayName")}};

        private PathParser() {
        }

        @Override
        public List<VisualClassPathItem> decode(String raw, AntProjectHelper antProjectHelper, ReferenceHelper refHelper) {
            String[] pe = PropertyUtils.tokenizePath((String)raw);
            ArrayList<VisualClassPathItem> cpItems = new ArrayList<VisualClassPathItem>(pe.length);
            for (String pei : pe) {
                File f;
                VisualClassPathItem cpItem = null;
                int wellKnownPathIndex = -1;
                for (int j = 0; j < WELL_KNOWN_PATHS.length; ++j) {
                    if (!WELL_KNOWN_PATHS[j][0].equals(PathParser.getAntPropertyName(pei))) continue;
                    wellKnownPathIndex = j;
                    break;
                }
                if (wellKnownPathIndex != -1) {
                    cpItem = new VisualClassPathItem(pei, 3, pei, WELL_KNOWN_PATHS[wellKnownPathIndex][1]);
                } else if (pei.startsWith(LIBRARY_PREFIX)) {
                    String eval = pei.substring(LIBRARY_PREFIX.length(), pei.lastIndexOf(46));
                    Library lib = LibraryManager.getDefault().getLibrary(eval);
                    String dName = lib != null ? lib.getDisplayName() : eval;
                    cpItem = new VisualClassPathItem(lib, 1, pei, dName);
                } else if (pei.startsWith(ARTIFACT_PREFIX)) {
                    String eval;
                    Object[] o = refHelper.findArtifactAndLocation(pei);
                    f = null;
                    if (o[0] != null && o[1] != null && (eval = antProjectHelper.getStandardPropertyEvaluator().getProperty(PathParser.getAntPropertyName(pei))) != null) {
                        f = FileUtil.normalizeFile((File)antProjectHelper.resolveFile(eval));
                    }
                    cpItem = new VisualClassPathItem((AntArtifact)o[0], (URI)o[1], 2, pei, f != null ? f.getPath() : pei.substring(ARTIFACT_PREFIX.length(), pei.lastIndexOf(46)));
                } else {
                    String eval = antProjectHelper.getStandardPropertyEvaluator().getProperty(PathParser.getAntPropertyName(pei));
                    f = null;
                    if (eval != null) {
                        f = FileUtil.normalizeFile((File)antProjectHelper.resolveFile(eval));
                    }
                    String name = f != null ? f.getName() : PathParser.getAntPropertyName(pei);
                    String displayName = f != null ? f.getPath() : name;
                    cpItem = new VisualClassPathItem(f, this.isJar(name) ? 0 : 4, pei, displayName);
                }
                cpItems.add(cpItem);
            }
            return cpItems;
        }

        private boolean isJar(String s) {
            if (s == null) {
                return false;
            }
            return (s = s.toLowerCase()).endsWith(".jar") || s.endsWith(".zip");
        }

        @Override
        public String encode(Object value, AntProjectHelper helper, ReferenceHelper refHelper) {
            Iterator it = ((List)value).iterator();
            StringBuffer sb = new StringBuffer();
            while (it.hasNext()) {
                VisualClassPathItem vcpi = (VisualClassPathItem)it.next();
                if (vcpi.getElement() == null) {
                    if (vcpi.getRawText() == null) continue;
                    sb.append(vcpi.getRawText());
                    if (!it.hasNext()) continue;
                    sb.append(File.pathSeparatorChar);
                    continue;
                }
                switch (vcpi.getType()) {
                    case 0: 
                    case 4: {
                        File f = (File)vcpi.getElement();
                        String reference = refHelper.createForeignFileReference(f, "jar");
                        sb.append(reference);
                        break;
                    }
                    case 1: {
                        sb.append(vcpi.getRawText());
                        break;
                    }
                    case 2: {
                        AntArtifact aa = (AntArtifact)vcpi.getElement();
                        URI u = vcpi.getURI();
                        String reference = refHelper.addReference(aa, u);
                        sb.append(reference);
                        break;
                    }
                    case 3: {
                        sb.append((String)vcpi.getElement());
                    }
                }
                if (!it.hasNext()) continue;
                sb.append(File.pathSeparatorChar);
            }
            return sb.toString();
        }

        static String getAntPropertyName(String property) {
            if (property != null && property.startsWith("${") && property.endsWith("}")) {
                return property.substring(2, property.length() - 1);
            }
            return property;
        }
    }

    private static class InverseBooleanParser
    extends BooleanParser {
        private InverseBooleanParser() {
        }

        @Override
        public Object decode(String raw, AntProjectHelper antProjectHelper, ReferenceHelper refHelper) {
            return (Boolean)super.decode(raw, antProjectHelper, refHelper) != false ? Boolean.FALSE : Boolean.TRUE;
        }

        @Override
        public String encode(Object value, AntProjectHelper antProjectHelper, ReferenceHelper refHelper) {
            return super.encode((Boolean)value != false ? Boolean.FALSE : Boolean.TRUE, antProjectHelper, refHelper);
        }
    }

    private static class IntegerParser
    implements PropertyParser {
        private IntegerParser() {
        }

        @Override
        public Object decode(String raw, AntProjectHelper antProjectHelper, ReferenceHelper refHelper) {
            try {
                return Integer.decode(raw);
            }
            catch (NumberFormatException e) {
                return Integer.parseInt(raw.trim());
            }
        }

        @Override
        public String encode(Object value, AntProjectHelper antProjectHelper, ReferenceHelper refHelper) {
            return value.toString();
        }
    }

    private static class BooleanParser
    implements PropertyParser {
        private BooleanParser() {
        }

        @Override
        public Object decode(String raw, AntProjectHelper antProjectHelper, ReferenceHelper refHelper) {
            String lowecaseRaw;
            if (raw != null && ("true".equals(lowecaseRaw = raw.toLowerCase()) || "yes".equals(lowecaseRaw) || "enabled".equals(lowecaseRaw))) {
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        }

        @Override
        public String encode(Object value, AntProjectHelper antProjectHelper, ReferenceHelper refHelper) {
            return value.toString();
        }
    }

    private static class FileReferenceParser
    implements PropertyParser {
        private FileReferenceParser() {
        }

        @Override
        public Object decode(String raw, AntProjectHelper antProjectHelper, ReferenceHelper refHelper) {
            if (raw == null || !raw.startsWith("${") || !raw.endsWith("}")) {
                return raw;
            }
            String ref = raw.substring(2, raw.length() - 1);
            String val = antProjectHelper.getProperties("nbproject/project.properties").getProperty(ref);
            if (val == null) {
                val = antProjectHelper.getProperties("nbproject/private/private.properties").getProperty(ref);
            }
            if (val == null) {
                return raw;
            }
            File f = new File(val);
            return FileUtil.normalizeFile((File)(f.isAbsolute() ? f : new File(FileUtil.toFile((FileObject)antProjectHelper.getProjectDirectory()), val))).getAbsolutePath();
        }

        @Override
        public String encode(Object value, AntProjectHelper antProjectHelper, ReferenceHelper refHelper) {
            File f = new File((String)value);
            return refHelper.createForeignFileReference(FileUtil.normalizeFile((File)(f.isAbsolute() ? f : new File(FileUtil.toFile((FileObject)antProjectHelper.getProjectDirectory()), (String)value))), "anyfile");
        }
    }

    private static class DebugLevelParser
    implements PropertyParser {
        private DebugLevelParser() {
        }

        @Override
        public Object decode(String raw, AntProjectHelper antProjectHelper, ReferenceHelper refHelper) {
            return raw == null || raw.trim().length() == 0 ? "debug" : raw.trim();
        }

        @Override
        public String encode(Object value, AntProjectHelper antProjectHelper, ReferenceHelper refHelper) {
            String s = ((String)value).trim();
            return s.length() == 0 ? "debug" : s;
        }
    }

    private static class StringParser
    implements PropertyParser {
        private StringParser() {
        }

        @Override
        public Object decode(String raw, AntProjectHelper antProjectHelper, ReferenceHelper refHelper) {
            return raw;
        }

        @Override
        public String encode(Object value, AntProjectHelper antProjectHelper, ReferenceHelper refHelper) {
            return value.toString();
        }
    }
}

