/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mobility.project.ui.wizard;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.openide.util.Lookup;
import org.openide.util.RequestProcessor;

public final class ClassPreloader
implements Runnable {
    private static volatile boolean done;
    private static final String[] TO_PRELOAD;

    private ClassPreloader() {
    }

    static void start() {
        RequestProcessor.getDefault().post((Runnable)new ClassPreloader(), 0, 1);
    }

    public static void stop() {
        done = true;
    }

    @Override
    public void run() {
        ClassLoader systemLoader = (ClassLoader)Lookup.getDefault().lookup(ClassLoader.class);
        assert (systemLoader != null);
        Logger logger = Logger.getLogger(ClassPreloader.class.getName());
        int ix = 0;
        boolean logDetails = logger.isLoggable(Level.FINEST);
        for (String type : TO_PRELOAD) {
            block6: {
                try {
                    Class<?> o = Class.forName(type, true, systemLoader);
                    if (logDetails) {
                        logger.log(Level.FINEST, "Preloaded " + type);
                    }
                    if (ix++ % 5 == 0) {
                        Thread.yield();
                    }
                }
                catch (ClassNotFoundException ex) {
                    if (!logger.isLoggable(Level.INFO)) break block6;
                    logger.log(Level.INFO, "Could not preload " + type);
                }
            }
            if (!done) continue;
            if (!logDetails) break;
            logger.log(Level.FINEST, "Exit preload early");
            break;
        }
    }

    static {
        TO_PRELOAD = new String[]{"org.netbeans.modules.mobility.project.J2MEProjectGenerator", "org.netbeans.spi.project.support.ant.ProjectGenerator", "javax.xml.transform.TransformerFactory", "javax.xml.transform.FactoryFinder", "com.sun.org.apache.xalan.internal.xsltc.compiler.RelativePathPattern", "com.sun.org.apache.bcel.internal.classfile.Node", "com.sun.org.apache.bcel.internal.classfile.Constant", "com.sun.org.apache.bcel.internal.classfile.Attribute", "com.sun.org.apache.bcel.internal.classfile.SourceFile", "org.netbeans.api.queries.FileEncodingQuery", "com.sun.org.apache.xalan.internal.xsltc.compiler.Comment", "com.sun.org.apache.xalan.internal.xsltc.compiler.XslAttribute", "com.sun.org.apache.xalan.internal.xsltc.compiler.ValueOf", "com.sun.org.apache.xml.internal.utils.SystemIDResolver", "javax.script.ScriptEngine", "javax.script.ScriptEngineManager", "javax.script.Bindings", "javax.script.SimpleBindings", "javax.script.ScriptEngineManager$1", "javax.script.ScriptEngineFactory", "com.sun.script.javascript.RhinoScriptEngineFactory", "org.netbeans.libs.freemarker.FreemarkerFactory", "javax.script.AbstractScriptEngine", "org.netbeans.libs.freemarker.FreemarkerEngine", "javax.script.ScriptContext", "javax.script.SimpleScriptContext", "org.openide.loaders.CreateFromTemplateAttributesProvider", "org.netbeans.modules.project.uiapi.ProjectTemplateAttributesProvider", "org.netbeans.modules.projectapi.ProjectFileEncodingQueryImplementation", "org.netbeans.modules.diff.DiffFileEncodingQueryImplementation", "org.netbeans.spi.java.project.support.ui.PackageView", "org.netbeans.spi.java.project.support.ui.PackageRootNode", "org.netbeans.modules.editor.SimpleIndentEngine", "org.netbeans.modules.mobility.project.ui.actions.Actions", "org.netbeans.modules.mobility.project.ui.actions.AntAction", "org.netbeans.modules.mobility.project.ui.actions.BuildConfigurationAction", "org.netbeans.modules.mobility.project.ui.actions.CleanAndBuildConfigurationAction", "org.netbeans.modules.mobility.project.ui.actions.CleanConfigurationAction", "org.netbeans.modules.mobility.project.ui.actions.DeployConfigurationAction", "org.netbeans.modules.mobility.project.ui.actions.SetConfigurationAction", "org.netbeans.modules.mobility.project.ui.actions.AddConfigurationAction", "freemarker.template.TemplateScalarModel", "freemarker.template.TemplateSequenceModel", "freemarker.template.TemplateHashModelEx", "freemarker.template.TemplateMethodModel", "freemarker.template.TemplateMethodModelEx", "freemarker.template.GeneralPurposeNothing", "freemarker.template.TemplateCollectionModel", "freemarker.template.WrappingTemplateModel", "com.sun.tools.javac.api.JavacTool", "javax.tools.Diagnostic", "java.beans.MethodDescriptor", "java.beans.GenericBeanInfo", "javax.lang.model.type.TypeMirror", "javax.lang.model.type.PrimitiveType", "org.netbeans.modules.editor.guards.GuardedWriter", "org.netbeans.modules.editor.guards.GuardedReader", "org.netbeans.api.editor.guards.GuardedSectionManager", "org.netbeans.modules.vmd.api.model.VersionDescriptor", "org.netbeans.modules.vmd.midp.components.MidpVersionDescriptor", "org.netbeans.modules.palette.ui.AutoscrollSupport", "org.apache.lucene.index.IndexCommitPoint", "org.netbeans.modules.mobility.deployment.ricoh.RicohDeploymentProperties", "org.netbeans.modules.xml.text.indent.DTDFormatter", "org.netbeans.editor.TokenItem", "org.netbeans.modules.mobility.project.ui.customizer.J2MEProjectProperties$PropertyInfo", "org.netbeans.modules.mobility.project.ui.customizer.CustomizerAbilities", "org.netbeans.modules.profiler.HistoryListener", "org.netbeans.modules.profiler.SaveViewAction$ViewProvider", "org.netbeans.modules.profiler.LiveResultsWindow", "org.netbeans.lib.profiler.ui.memory.MemoryResUserActionsHandler", "org.netbeans.lib.profiler.ui.cpu.CPUResUserActionsHandler", "org.netbeans.lib.profiler.ui.LiveResultsPanel", "org.netbeans.api.visual.widget.Widget", "org.netbeans.api.visual.widget.Scene", "org.netbeans.api.visual.model.ObjectScene", "org.netbeans.api.visual.graph.GraphPinScene", "org.netbeans.modules.vmd.api.flow.visual.FlowScene", "org.netbeans.modules.visual.widget.WidgetAccessibleContext", "org.netbeans.api.visual.action.TwoStateHoverProvider", "org.netbeans.modules.debugger.jpda.projects.BreakpointAnnotationProvider", "java.awt.TexturePaint", "org.netbeans.modules.visual.widget.SatelliteComponent", "org.netbeans.api.visual.widget.SceneComponent", "org.netbeans.api.visual.action.SelectProvider", "org.netbeans.api.visual.action.HoverProvider", "org.netbeans.api.visual.widget.LayerWidget", "org.netbeans.api.visual.action.MoveProvider", "org.netbeans.api.visual.action.AcceptProvider", "org.netbeans.api.visual.action.ConnectDecorator", "org.netbeans.api.visual.action.ConnectProvider", "org.netbeans.api.visual.action.ReconnectDecorator", "org.netbeans.api.visual.action.ReconnectProvider", "org.netbeans.api.visual.action.TextFieldInplaceEditor", "org.netbeans.api.visual.action.EditProvider", "org.netbeans.api.visual.action.PopupMenuProvider", "org.netbeans.api.visual.action.WidgetAction", "org.netbeans.api.visual.router.ConnectionWidgetCollisionsCollector", "org.netbeans.api.visual.graph.layout.GraphLayout", "org.netbeans.api.visual.graph.layout.GridGraphLayout", "org.netbeans.api.visual.model.ObjectSceneListener", "org.netbeans.api.visual.model.ObjectState", "org.netbeans.api.visual.action.WidgetAction$Chain", "org.netbeans.api.visual.border.BorderFactory", "org.netbeans.api.visual.border.Border", "org.netbeans.modules.visual.router.DirectRouter", "org.netbeans.modules.visual.router.FreeRouter", "org.netbeans.modules.visual.router.OrthogonalSearchRouter", "org.netbeans.modules.visual.action.MouseCenteredZoomAction", "org.netbeans.modules.visual.action.DefaultRectangularSelectDecorator", "org.netbeans.modules.visual.action.ObjectSceneRectangularSelectProvider", "org.netbeans.modules.visual.action.RectangularSelectAction", "org.netbeans.modules.visual.anchor.FreeRectangularAnchor", "org.netbeans.modules.visual.anchor.RectangularAnchor", "org.netbeans.modules.visual.anchor.CircularAnchor", "org.netbeans.modules.visual.anchor.DirectionalAnchor", "org.netbeans.modules.visual.anchor.ProxyAnchor", "org.netbeans.modules.visual.anchor.FixedAnchor", "org.netbeans.modules.visual.anchor.CenterAnchor", "org.netbeans.modules.visual.action.MouseHoverAction", "org.netbeans.modules.visual.router.OrthogonalSearchRouterCore", "org.netbeans.modules.visual.action.ForwardKeyEventsAction", "org.netbeans.api.visual.model.StateModel", "org.netbeans.modules.vmd.api.model.presenters.InfoPresenter", "org.netbeans.modules.vmd.api.model.PresenterListener", "org.netbeans.modules.vmd.api.screen.display.DeviceBorder", "org.netbeans.modules.vmd.api.screen.display.ScreenDeviceInfoPresenter", "org.netbeans.modules.vmd.midp.components.sources.EventSourceSupport", "org.apache.lucene.store.AlreadyClosedException", "org.apache.lucene.index.DirectoryIndexReader", "org.apache.lucene.index.SegmentInfos", "org.apache.lucene.index.CorruptIndexException", "org.apache.lucene.index.IndexFileNameFilter", "org.apache.lucene.index.IndexFileNames", "org.apache.lucene.search.HitCollector", "org.netbeans.modules.vmd.api.model.TransactionManager", "org.netbeans.modules.vmd.game.integration.components.GamePrimitiveDescriptor", "org.netbeans.modules.vmd.midp.components.MidpVersionDescriptor", "org.netbeans.modules.vmd.inspector.InspectorUI", "org.netbeans.modules.vmd.inspector.InspectorFolderNode", "org.netbeans.modules.vmd.inspector.InspectorBeanTreeView", "org.netbeans.api.visual.anchor.Anchor", "org.netbeans.api.visual.vmd.VMDNodeAnchor", "org.netbeans.api.visual.widget.ImageWidget", "org.netbeans.api.visual.vmd.VMDGlyphSetWidget", "org.netbeans.api.visual.widget.SeparatorWidget", "org.netbeans.api.visual.vmd.VMDFactory", "org.netbeans.api.visual.vmd.VMDColorScheme", "org.netbeans.modules.visual.vmd.VMDOriginalColorScheme", "org.netbeans.modules.visual.vmd.VMDNetBeans60ColorScheme", "org.netbeans.api.visual.vmd.VMDNodeBorder", "org.netbeans.api.visual.anchor.PointShapeFactory", "org.netbeans.api.visual.anchor.PointShape", "org.netbeans.modules.visual.anchor.ImagePointShape", "org.netbeans.modules.visual.border.CompositeBorder", "org.netbeans.modules.java.source.usages.fcs.FileChangeSupport", "org.openide.nodes.Sheet", "org.openide.explorer.propertysheet.ButtonPanel", "org.netbeans.modules.java.source.JavaFileFilterQuery", "org.netbeans.modules.java.source.parsing.FileObjects", "org.netbeans.modules.java.source.parsing.FolderArchive", "org.netbeans.modules.java.source.parsing.CachingArchive", "com.sun.javadoc.Doc", "com.sun.javadoc.ProgramElementDoc", "com.sun.javadoc.Type", "com.sun.javadoc.ClassDoc", "com.sun.javadoc.AnnotationTypeDoc", "com.sun.javadoc.DocErrorReporter", "com.sun.tools.javadoc.Messager", "com.sun.tools.javadoc.DocImpl", "com.sun.tools.javadoc.ProgramElementDocImpl", "com.sun.tools.javadoc.ClassDocImpl", "com.sun.tools.javadoc.AnnotationTypeDocImpl", "com.sun.javadoc.MemberDoc", "com.sun.javadoc.ExecutableMemberDoc", "com.sun.javadoc.MethodDoc", "org.openide.loaders.DataLdrActions", "org.openide.actions.OpenAction", "org.netbeans.core.ui.options.filetypes.OpenAsAction", "org.netbeans.core.ui.sysopen.SystemOpenAction", "org.openide.actions.RenameAction", "org.openide.actions.FileSystemAction", "org.openide.actions.FileSystemAction$Menu", "org.openide.actions.SaveAsTemplateAction", "org.openide.nodes.NodeAcceptor"};
    }
}

