/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.spring.api;

import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.project.libraries.Library;
import org.netbeans.api.project.libraries.LibraryManager;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.JarFileSystem;
import org.openide.util.Exceptions;

public final class SpringUtilities {
    public static final String SPRING_CLASS_NAME = "org.springframework.core.SpringVersion";
    private static final String JSTL_CLASS_NAME = "javax.servlet.jsp.jstl.core.Config";
    private static final String SPRING_WEBMVC_CLASS_NAME = "org.springframework.web.servlet.DispatcherServlet";

    private SpringUtilities() {
    }

    public static Library findSpringLibrary() {
        return SpringUtilities.getLibrary(SPRING_CLASS_NAME);
    }

    public static Library findJSTLibrary() {
        for (Library library : LibraryManager.getDefault().getLibraries()) {
            if (!library.getName().startsWith("jstl")) continue;
            return library;
        }
        return SpringUtilities.getLibrary(JSTL_CLASS_NAME);
    }

    public static Library findSpringWebMVCLibrary() {
        return SpringUtilities.getLibrary(SPRING_WEBMVC_CLASS_NAME);
    }

    public static Library findSpringWebMVCLibrary(String version) {
        for (Library library : LibraryManager.getDefault().getLibraries()) {
            if (!SpringUtilities.containsClass(library, SPRING_WEBMVC_CLASS_NAME) || !version.equalsIgnoreCase(SpringUtilities.getSpringWebMVCLibraryVersion(library))) continue;
            return library;
        }
        return null;
    }

    public static boolean isSpringLibrary(Library library) {
        return SpringUtilities.containsClass(library, SPRING_CLASS_NAME);
    }

    public static boolean isSpringWebMVCLibrary(Library library) {
        return SpringUtilities.containsClass(library, SPRING_WEBMVC_CLASS_NAME);
    }

    public static String getSpringLibraryVersion(Library library) {
        return SpringUtilities.getLibraryVersion(library, SPRING_CLASS_NAME);
    }

    private static String getSpringWebMVCLibraryVersion(Library library) {
        return SpringUtilities.getLibraryVersion(library, SPRING_WEBMVC_CLASS_NAME);
    }

    private static String getLibraryVersion(Library library, String className) {
        List urls = library.getContent("classpath");
        ClassPath cp = SpringUtilities.createClassPath(urls);
        try {
            FileObject resource = cp.findResource(className.replace('.', '/') + ".class");
            if (resource == null) {
                return null;
            }
            FileObject ownerRoot = cp.findOwnerRoot(resource);
            if (ownerRoot != null && ownerRoot.getFileSystem() instanceof JarFileSystem) {
                JarFileSystem jarFileSystem = (JarFileSystem)ownerRoot.getFileSystem();
                return SpringUtilities.getImplementationVersion(jarFileSystem);
            }
        }
        catch (FileStateInvalidException e) {
            Exceptions.printStackTrace((Throwable)e);
        }
        return null;
    }

    public static String getImplementationVersion(JarFileSystem jarFile) {
        Manifest manifest = jarFile.getManifest();
        Attributes attributes = manifest.getMainAttributes();
        return attributes.getValue(Attributes.Name.IMPLEMENTATION_VERSION);
    }

    public static boolean containsSpring(ClassPath cp) {
        return SpringUtilities.containsClass(cp, SPRING_CLASS_NAME);
    }

    private static Library getLibrary(String className) {
        for (Library library : LibraryManager.getDefault().getLibraries()) {
            if (!SpringUtilities.containsClass(library, className)) continue;
            return library;
        }
        return null;
    }

    private static boolean containsClass(Library library, String className) {
        List urls = library.getContent("classpath");
        return SpringUtilities.containsClass(SpringUtilities.createClassPath(urls), className);
    }

    private static boolean containsClass(ClassPath classPath, String className) {
        String classRelativePath = className.replace('.', '/') + ".class";
        return classPath.findResource(classRelativePath) != null;
    }

    private static ClassPath createClassPath(List<URL> roots) {
        ArrayList<URL> jarRootURLs = new ArrayList<URL>();
        for (URL url : roots) {
            if (FileUtil.getArchiveFile((URL)url) == null) {
                url = FileUtil.getArchiveRoot((URL)url);
            }
            jarRootURLs.add(url);
        }
        return ClassPathSupport.createClassPath((URL[])jarRootURLs.toArray(new URL[jarRootURLs.size()]));
    }
}

