/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.languages.features;

import java.awt.Color;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import javax.swing.SwingUtilities;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import org.netbeans.api.languages.ASTItem;
import org.netbeans.api.languages.ASTNode;
import org.netbeans.api.languages.Highlighting;
import org.netbeans.api.languages.ParserManager;
import org.netbeans.api.languages.database.DatabaseContext;
import org.netbeans.api.languages.database.DatabaseDefinition;
import org.netbeans.api.languages.database.DatabaseItem;
import org.netbeans.api.languages.database.DatabaseUsage;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Utilities;
import org.netbeans.modules.editor.NbEditorDocument;
import org.netbeans.modules.languages.ParserManagerImpl;
import org.netbeans.modules.languages.features.AnnotationManager;
import org.netbeans.modules.languages.features.DatabaseManager;
import org.openide.text.Annotation;
import org.openide.util.RequestProcessor;

public class MarkOccurrencesSupport
implements CaretListener {
    private static Map<JTextComponent, WeakReference<MarkOccurrencesSupport>> editorToMOS = new WeakHashMap<JTextComponent, WeakReference<MarkOccurrencesSupport>>();
    private JTextComponent editor;
    private RequestProcessor.Task parsingTask;
    private List<Highlighting.Highlight> highlights;
    private List<AnnotationManager.LanguagesAnnotation> annotations;
    private static AttributeSet highlightAS = null;

    public MarkOccurrencesSupport(JTextComponent editor) {
        this.editor = editor;
        editorToMOS.put(editor, new WeakReference<MarkOccurrencesSupport>(this));
    }

    @Override
    public void caretUpdate(final CaretEvent e) {
        if (this.parsingTask != null) {
            this.parsingTask.cancel();
        }
        this.parsingTask = RequestProcessor.getDefault().post(new Runnable(){

            @Override
            public void run() {
                MarkOccurrencesSupport.this.refresh(e.getDot());
            }
        }, 1000);
    }

    private void refresh(int offset) {
        ParserManagerImpl parserManager = ParserManagerImpl.getImpl(this.editor.getDocument());
        if (parserManager.getState() == ParserManager.State.PARSING) {
            return;
        }
        ASTNode node = parserManager.getAST();
        DatabaseContext root = DatabaseManager.getRoot(node);
        if (root == null) {
            return;
        }
        DatabaseItem item = root.getDatabaseItem(offset);
        if (item == null) {
            item = root.getDatabaseItem(offset - 1);
        }
        if (item == null) {
            return;
        }
        this.removeHighlights();
        this.addHighlights(MarkOccurrencesSupport.getUsages(item, node));
    }

    private void addHighlights(final List<ASTItem> ussages) {
        if (ussages.isEmpty()) {
            return;
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    NbEditorDocument doc = (NbEditorDocument)MarkOccurrencesSupport.this.editor.getDocument();
                    Highlighting highlighting = Highlighting.getHighlighting((Document)doc);
                    MarkOccurrencesSupport.this.annotations = new ArrayList();
                    MarkOccurrencesSupport.this.highlights = new ArrayList();
                    Iterator it = ussages.iterator();
                    HashSet<Integer> lines = new HashSet<Integer>();
                    while (it.hasNext()) {
                        ASTItem i = (ASTItem)it.next();
                        Highlighting.Highlight h = highlighting.highlight(i.getOffset(), i.getEndOffset(), MarkOccurrencesSupport.getHighlightAS());
                        if (h == null) continue;
                        MarkOccurrencesSupport.this.highlights.add(h);
                        int lineNumber = Utilities.getLineOffset((BaseDocument)doc, (int)i.getOffset());
                        if (lines.contains(lineNumber)) continue;
                        AnnotationManager.LanguagesAnnotation la = new AnnotationManager.LanguagesAnnotation("Usage", "...");
                        doc.addAnnotation(doc.createPosition(i.getOffset()), i.getLength(), (Annotation)la);
                        lines.add(lineNumber);
                        MarkOccurrencesSupport.this.annotations.add(la);
                    }
                }
                catch (BadLocationException ex) {
                    ex.printStackTrace();
                }
            }
        });
    }

    static List<ASTItem> getUsages(DatabaseItem item, ASTNode root) {
        ArrayList<ASTItem> result = new ArrayList<ASTItem>();
        DatabaseDefinition definition = null;
        definition = item instanceof DatabaseDefinition ? (DatabaseDefinition)item : ((DatabaseUsage)item).getDefinition();
        if (definition.getSourceFileUrl() == null) {
            result.add(root.findPath(definition.getOffset()).getLeaf());
        }
        for (DatabaseUsage databaseUsage : definition.getUsages()) {
            result.add(root.findPath(databaseUsage.getOffset()).getLeaf());
        }
        return result;
    }

    static void removeHighlights(JTextComponent editor) {
        WeakReference<MarkOccurrencesSupport> wr = editorToMOS.get(editor);
        if (wr == null) {
            return;
        }
        MarkOccurrencesSupport mos = (MarkOccurrencesSupport)wr.get();
        if (mos == null) {
            return;
        }
        mos.removeHighlights();
    }

    private void removeHighlights() {
        if (this.highlights == null) {
            return;
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (MarkOccurrencesSupport.this.highlights == null) {
                    return;
                }
                NbEditorDocument doc = (NbEditorDocument)MarkOccurrencesSupport.this.editor.getDocument();
                Iterator it = MarkOccurrencesSupport.this.highlights.iterator();
                while (it.hasNext()) {
                    ((Highlighting.Highlight)it.next()).remove();
                }
                Iterator it2 = MarkOccurrencesSupport.this.annotations.iterator();
                while (it2.hasNext()) {
                    doc.removeAnnotation((Annotation)it2.next());
                }
                MarkOccurrencesSupport.this.highlights = null;
                MarkOccurrencesSupport.this.annotations = null;
            }
        });
    }

    private static AttributeSet getHighlightAS() {
        if (highlightAS == null) {
            SimpleAttributeSet as = new SimpleAttributeSet();
            as.addAttribute(StyleConstants.Background, new Color(236, 235, 163));
            highlightAS = as;
        }
        return highlightAS;
    }
}

