/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.languages;

import java.awt.Point;
import java.lang.ref.WeakReference;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import javax.swing.text.Document;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenSequence;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.util.Lookup;
import org.openide.util.RequestProcessor;

public class Utils {
    private static Logger logger = Logger.getLogger("org.netbeans.modules.languages");
    private static Map<String, WeakReference> collections;

    public static void notify(String message) {
        logger.log(Level.WARNING, message);
    }

    public static void message(final String message) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)message));
            }
        });
    }

    public static void notify(Exception exception) {
        logger.log(Level.WARNING, null, exception);
    }

    public static void notify(String message, Exception exception) {
        logger.log(Level.WARNING, message, exception);
    }

    public static void startTest(String name, Collection c) {
        if (collections == null) {
            collections = new HashMap<String, WeakReference>();
            Utils.start();
        }
        collections.put(name, new WeakReference<Collection>(c));
    }

    public static void startTest(String name, Map m) {
        if (collections == null) {
            collections = new HashMap<String, WeakReference>();
            Utils.start();
        }
        collections.put(name, new WeakReference<Map>(m));
    }

    private static void start() {
        RequestProcessor.getDefault().post(new Runnable(){

            @Override
            public void run() {
                HashMap cs = new HashMap(collections);
                for (String name : cs.keySet()) {
                    Object o = ((WeakReference)cs.get(name)).get();
                    if (o == null) {
                        collections.remove(name);
                        continue;
                    }
                    System.out.println(":" + name + " " + Utils.size(o));
                }
                Utils.start();
            }
        }, 5000);
    }

    private static int size(Object o) {
        if (o instanceof Collection) {
            Collection c = (Collection)o;
            int s = c.size();
            for (Object item : c) {
                if (!(item instanceof Collection) && !(item instanceof Map)) continue;
                s += Utils.size(item);
            }
            return s;
        }
        Map m = (Map)o;
        int s = m.size();
        for (Object key : m.keySet()) {
            Object value;
            if (key instanceof Collection || key instanceof Map) {
                s += Utils.size(key);
            }
            if (!((value = m.get(key)) instanceof Collection) && !(value instanceof Map)) continue;
            s += Utils.size(value);
        }
        return s;
    }

    public static Point findPosition(String text, int offset) {
        int current = 0;
        int next = text.indexOf(10, current);
        int lineNumber = 1;
        while (next >= 0) {
            if (next > offset) {
                return new Point(lineNumber, offset - current + 1);
            }
            ++lineNumber;
            current = next + 1;
            next = text.indexOf(10, current);
        }
        throw new ArrayIndexOutOfBoundsException();
    }

    public static TokenSequence getTokenSequence(Document document, int offset) {
        TokenHierarchy tokenHierarchy = TokenHierarchy.get((Document)document);
        if (tokenHierarchy == null) {
            return null;
        }
        TokenSequence tokenSequence = tokenHierarchy.tokenSequence();
        if (tokenSequence == null) {
            return null;
        }
        while (true) {
            tokenSequence.move(offset);
            if (!tokenSequence.moveNext()) {
                return tokenSequence;
            }
            TokenSequence tokenSequence2 = tokenSequence.embedded();
            if (tokenSequence2 == null) {
                return tokenSequence;
            }
            tokenSequence = tokenSequence2;
        }
    }

    public static boolean isOfProjectType(FileObject projectFile, String projectType) {
        try {
            ClassLoader cl = (ClassLoader)Lookup.getDefault().lookup(ClassLoader.class);
            Class<?> foqClz = cl.loadClass("org.netbeans.api.project.FileOwnerQuery");
            Class<?> apClz = cl.loadClass("org.netbeans.api.project.ActionProvider");
            Method getOwnerMethod = foqClz.getMethod("getOwner", FileObject.class);
            Lookup.Provider project = (Lookup.Provider)getOwnerMethod.invoke(foqClz, projectFile);
            Object apInst = project.getLookup().lookup(apClz);
            if (apInst != null) {
                return apInst.getClass().getName().contains(projectType);
            }
        }
        catch (IllegalAccessException ex) {
            logger.log(Level.FINE, "Accessing project by reflection", ex);
        }
        catch (IllegalArgumentException ex) {
            logger.log(Level.FINE, "Accessing project by reflection", ex);
        }
        catch (InvocationTargetException ex) {
            logger.log(Level.FINE, "Accessing project by reflection", ex);
        }
        catch (NoSuchMethodException ex) {
            logger.log(Level.FINE, "Accessing project by reflection", ex);
        }
        catch (SecurityException ex) {
            logger.log(Level.FINE, "Accessing project by reflection", ex);
        }
        catch (ClassNotFoundException ex) {
            logger.log(Level.FINE, "Accessing project by reflection", ex);
        }
        return false;
    }

    public static FileObject getProjectRoot(FileObject projectFile) {
        try {
            ClassLoader cl = (ClassLoader)Lookup.getDefault().lookup(ClassLoader.class);
            Class<?> foqClz = cl.loadClass("org.netbeans.api.project.FileOwnerQuery");
            Class<?> projectClz = cl.loadClass("org.netbeans.api.project.Project");
            Method getOwnerMethod = foqClz.getMethod("getOwner", FileObject.class);
            Lookup.Provider project = (Lookup.Provider)getOwnerMethod.invoke(foqClz, projectFile);
            Method getProjDirMethod = projectClz.getMethod("getProjectDirectory", new Class[0]);
            if (project == null) {
                return null;
            }
            return (FileObject)getProjDirMethod.invoke((Object)project, new Object[0]);
        }
        catch (IllegalAccessException ex) {
            logger.log(Level.FINE, "Accessing project by reflection", ex);
        }
        catch (IllegalArgumentException ex) {
            logger.log(Level.FINE, "Accessing project by reflection", ex);
        }
        catch (InvocationTargetException ex) {
            logger.log(Level.FINE, "Accessing project by reflection", ex);
        }
        catch (NoSuchMethodException ex) {
            logger.log(Level.FINE, "Accessing project by reflection", ex);
        }
        catch (SecurityException ex) {
            logger.log(Level.FINE, "Accessing project by reflection", ex);
        }
        catch (ClassNotFoundException ex) {
            logger.log(Level.FINE, "Accessing project by reflection", ex);
        }
        return null;
    }
}

