/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.io;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Collection;
import java.util.HashSet;
import org.netbeans.modules.vmd.api.io.DataObjectContext;
import org.netbeans.modules.vmd.api.io.DataSerializer;
import org.netbeans.modules.vmd.api.io.ProjectTypeInfo;
import org.netbeans.modules.vmd.api.io.providers.IOSupport;
import org.netbeans.modules.vmd.api.model.ComponentDescriptor;
import org.netbeans.modules.vmd.api.model.Debug;
import org.netbeans.modules.vmd.api.model.DesignComponent;
import org.netbeans.modules.vmd.api.model.DesignDocument;
import org.netbeans.modules.vmd.api.model.PropertyDescriptor;
import org.netbeans.modules.vmd.api.model.PropertyValue;
import org.openide.ErrorManager;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.util.Lookup;
import org.openide.xml.XMLUtil;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class DocumentSave {
    static final Lookup.Result<DataSerializer> customDataSerializers = Lookup.getDefault().lookupResult(DataSerializer.class);
    static final String XML_ROOT_NODE = "VisualDesign";
    static final String PROP_PROJECT_TYPE = "projectType";
    static final String DOCUMENT_NODE = "Document";
    static final String VERSION_ATTR = "version";
    static final String COMPONENT_NODE = "Component";
    static final String PROPERTY_NODE = "Property";
    static final String COMPONENTID_ATTR = "componentID";
    static final String TYPEID_ATTR = "typeID";
    static final String NAME_ATTR = "name";
    static final String VALUE_ATTR = "value";
    static final String VERSION_VALUE_1 = "1";
    static Object sync = new Object();

    public static void save(DataObjectContext context, DesignDocument savingDocument) {
        Document xml = XMLUtil.createDocument((String)XML_ROOT_NODE, null, null, null);
        Node xmlRootNode = xml.getFirstChild();
        DocumentSave.setAttribute(xml, xmlRootNode, VERSION_ATTR, VERSION_VALUE_1);
        String projectType = savingDocument.getDocumentInterface().getProjectType();
        DocumentSave.setAttribute(xml, xmlRootNode, PROP_PROJECT_TYPE, projectType);
        Element node = xml.createElement(DOCUMENT_NODE);
        DocumentSave.setAttribute(xml, node, VERSION_ATTR, ProjectTypeInfo.getProjectTypeInfoFor(projectType).getDocumentVersion());
        DocumentSave.checkDocumentValidity(savingDocument);
        DocumentSave.saveComponent(xml, node, savingDocument.getRootComponent());
        xmlRootNode.appendChild(node);
        for (DataSerializer serializer : customDataSerializers.allInstances()) {
            Node data = serializer.serializeData(context, savingDocument, xml);
            if (data == null) continue;
            xml.getFirstChild().appendChild(data);
        }
        try {
            DocumentSave.writeDocument(IOSupport.getDesignFile(context), xml);
        }
        catch (IOException e) {
            throw Debug.error((Object[])new Object[]{e});
        }
    }

    private static void checkDocumentValidity(DesignDocument savingDocument) {
        HashSet<DesignComponent> componentsInTree = new HashSet<DesignComponent>();
        HashSet<DesignComponent> referencedComponents = new HashSet<DesignComponent>();
        DocumentSave.collectComponentsInTree(componentsInTree, savingDocument.getRootComponent());
        for (DesignComponent component : componentsInTree) {
            DocumentSave.collectUsedReferences(referencedComponents, component);
        }
        for (DesignComponent component : referencedComponents) {
            if (componentsInTree.contains(component)) continue;
            Debug.warning((Object[])new Object[]{"Saving", "Referenced component is not in the tree", component});
        }
    }

    private static void saveComponent(Document xml, Node parentNode, DesignComponent component) {
        ComponentDescriptor descriptor = component.getComponentDescriptor();
        Element node = xml.createElement(COMPONENT_NODE);
        parentNode.appendChild(node);
        DocumentSave.setAttribute(xml, node, COMPONENTID_ATTR, Long.toString(component.getComponentID()));
        DocumentSave.setAttribute(xml, node, TYPEID_ATTR, component.getType().getEncoded());
        Collection propertyDescriptors = descriptor.getPropertyDescriptors();
        for (PropertyDescriptor propertyDescriptor : propertyDescriptors) {
            String propertyName;
            if (!propertyDescriptor.isUseForSerialization() || component.isDefaultValue(propertyName = propertyDescriptor.getName())) continue;
            PropertyValue propertyValue = component.readProperty(propertyName);
            String serialized = propertyValue.serialize();
            Element propertyNode = xml.createElement(PROPERTY_NODE);
            node.appendChild(propertyNode);
            DocumentSave.setAttribute(xml, propertyNode, NAME_ATTR, propertyDescriptor.getName());
            DocumentSave.setAttribute(xml, propertyNode, TYPEID_ATTR, propertyDescriptor.getType().getEncoded());
            DocumentSave.setAttribute(xml, propertyNode, VALUE_ATTR, serialized);
        }
        for (DesignComponent child : component.getComponents()) {
            DocumentSave.saveComponent(xml, node, child);
        }
    }

    private static void collectComponentsInTree(HashSet<DesignComponent> componentsInTree, DesignComponent component) {
        componentsInTree.add(component);
        for (DesignComponent child : component.getComponents()) {
            DocumentSave.collectComponentsInTree(componentsInTree, child);
        }
    }

    private static void collectUsedReferences(HashSet<DesignComponent> referencedComponents, DesignComponent component) {
        ComponentDescriptor descriptor = component.getComponentDescriptor();
        Collection propertyDescriptors = descriptor.getPropertyDescriptors();
        for (PropertyDescriptor propertyDescriptor : propertyDescriptors) {
            if (!propertyDescriptor.isUseForSerialization()) continue;
            PropertyValue propertyValue = component.readProperty(propertyDescriptor.getName());
            Debug.collectAllComponentReferences((PropertyValue)propertyValue, referencedComponents);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeDocument(final FileObject file, final Document doc) throws IOException {
        Object object = sync;
        synchronized (object) {
            file.getFileSystem().runAtomicAction(new FileSystem.AtomicAction(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() throws IOException {
                    OutputStream os = null;
                    FileLock lock = null;
                    try {
                        lock = file.lock();
                        os = file.getOutputStream(lock);
                        XMLUtil.write((Document)doc, (OutputStream)os, (String)"UTF-8");
                    }
                    finally {
                        if (os != null) {
                            try {
                                os.close();
                            }
                            catch (IOException e) {
                                ErrorManager.getDefault().notify((Throwable)e);
                            }
                        }
                        if (lock != null) {
                            lock.releaseLock();
                        }
                    }
                }
            });
        }
    }

    private static void setAttribute(Document xml, Node node, String name, String value) {
        NamedNodeMap map = node.getAttributes();
        Attr attribute = xml.createAttribute(name);
        attribute.setValue(value);
        map.setNamedItem(attribute);
    }
}

