/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.project.ui;

import java.beans.PropertyChangeListener;
import java.util.concurrent.Future;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ui.OpenProjectsListener;
import org.netbeans.modules.project.uiapi.OpenProjectsTrampoline;
import org.netbeans.modules.project.uiapi.Utilities;

public final class OpenProjects {
    public static final String PROPERTY_OPEN_PROJECTS = "openProjects";
    public static final String PROPERTY_MAIN_PROJECT = "MainProject";
    private static OpenProjects INSTANCE = new OpenProjects();
    private OpenProjectsTrampoline trampoline = Utilities.getOpenProjectsTrampoline();

    private OpenProjects() {
        this.addPropertyChangeListener(new OpenProjectsListener());
    }

    public static OpenProjects getDefault() {
        return INSTANCE;
    }

    public Project[] getOpenProjects() {
        return this.trampoline.getOpenProjectsAPI();
    }

    public Future<Project[]> openProjects() {
        return this.trampoline.openProjectsAPI();
    }

    public void open(Project[] projects, boolean openSubprojects) {
        this.trampoline.openAPI(projects, openSubprojects, false);
    }

    public void open(Project[] projects, boolean openSubprojects, boolean showProgress) {
        this.trampoline.openAPI(projects, openSubprojects, showProgress);
    }

    public boolean isProjectOpen(Project p) {
        if (p == null) {
            return false;
        }
        for (Project real : this.getOpenProjects()) {
            if (!p.equals(real) && !real.equals(p)) continue;
            return true;
        }
        return false;
    }

    public void close(Project[] projects) {
        this.trampoline.closeAPI(projects);
    }

    public Project getMainProject() {
        return this.trampoline.getMainProject();
    }

    public void setMainProject(Project project) throws IllegalArgumentException {
        this.trampoline.setMainProject(project);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.trampoline.addPropertyChangeListenerAPI(listener, this);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.trampoline.removePropertyChangeListenerAPI(listener);
    }
}

