/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.project.ui.actions;

import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.modules.php.project.PhpProject;
import org.netbeans.modules.php.project.ProjectPropertiesSupport;
import org.netbeans.modules.php.project.ProjectSettings;
import org.netbeans.modules.php.project.connections.RemoteClient;
import org.netbeans.modules.php.project.connections.RemoteException;
import org.netbeans.modules.php.project.connections.TransferFile;
import org.netbeans.modules.php.project.connections.TransferInfo;
import org.netbeans.modules.php.project.connections.ui.transfer.TransferFilesChooser;
import org.netbeans.modules.php.project.ui.actions.RemoteCommand;
import org.netbeans.modules.php.project.ui.actions.support.CommandUtils;
import org.netbeans.modules.php.project.ui.actions.support.Displayable;
import org.openide.awt.StatusDisplayer;
import org.openide.filesystems.FileObject;
import org.openide.util.Cancellable;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.windows.InputOutput;

public class DownloadCommand
extends RemoteCommand
implements Displayable {
    public static final String ID = "download";
    public static final String DISPLAY_NAME = NbBundle.getMessage(DownloadCommand.class, (String)"LBL_DownloadCommand");

    public DownloadCommand(PhpProject project) {
        super(project);
    }

    @Override
    public String getCommandId() {
        return ID;
    }

    @Override
    protected Runnable getContextRunnable(final Lookup context) {
        return new Runnable(){

            @Override
            public void run() {
                DownloadCommand.this.invokeActionImpl(context);
            }
        };
    }

    void invokeActionImpl(Lookup context) {
        FileObject[] selectedFiles = CommandUtils.filesForContextOrSelectedNodes(context);
        if (selectedFiles.length == 0) {
            return;
        }
        FileObject sources = ProjectPropertiesSupport.getSourcesDirectory(this.getProject());
        if (!this.sourcesFilesOnly(sources, selectedFiles)) {
            return;
        }
        InputOutput remoteLog = DownloadCommand.getRemoteLog(this.getRemoteConfiguration().getDisplayName());
        RemoteCommand.DefaultOperationMonitor downloadOperationMonitor = new RemoteCommand.DefaultOperationMonitor("LBL_Downloading");
        RemoteClient remoteClient = this.getRemoteClient(remoteLog, downloadOperationMonitor);
        String projectName = this.getProject().getName();
        DownloadCommand.download(remoteClient, remoteLog, downloadOperationMonitor, projectName, true, sources, selectedFiles, null, this.getProject());
    }

    @Override
    public String getDisplayName() {
        return DISPLAY_NAME;
    }

    public static void download(RemoteClient remoteClient, InputOutput remoteLog, RemoteCommand.DefaultOperationMonitor operationMonitor, String projectName, FileObject sources, Set<TransferFile> forDownload) {
        DownloadCommand.download(remoteClient, remoteLog, operationMonitor, projectName, false, sources, null, forDownload, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void download(RemoteClient remoteClient, InputOutput remoteLog, RemoteCommand.DefaultOperationMonitor operationMonitor, String projectName, boolean showDownloadDialog, FileObject sources, FileObject[] filesToDownload, Set<TransferFile> transferFilesToDownload, PhpProject project) {
        String progressTitle = NbBundle.getMessage(DownloadCommand.class, (String)"MSG_DownloadingFiles", (Object)projectName);
        ProgressHandle progressHandle = ProgressHandleFactory.createHandle((String)progressTitle, (Cancellable)remoteClient);
        TransferInfo transferInfo = null;
        try {
            Set<TransferFile> forDownload;
            progressHandle.start();
            Set<TransferFile> set = forDownload = transferFilesToDownload != null ? transferFilesToDownload : remoteClient.prepareDownload(sources, filesToDownload);
            if (showDownloadDialog) {
                remoteClient.disconnect();
                long timestamp = project != null ? ProjectSettings.getLastDownload(project) : -1L;
                forDownload = TransferFilesChooser.forDownload(forDownload, timestamp).showDialog();
            }
            if (forDownload.size() > 0) {
                progressHandle.finish();
                operationMonitor.progressHandle = progressHandle = ProgressHandleFactory.createHandle((String)progressTitle, (Cancellable)remoteClient);
                int workUnits = DownloadCommand.getWorkUnits(forDownload);
                if (workUnits > 0) {
                    progressHandle.start(workUnits);
                } else {
                    progressHandle.start();
                }
                transferInfo = remoteClient.download(sources, forDownload);
                StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage(DownloadCommand.class, (String)"MSG_DownloadFinished", (Object)projectName));
                if (project != null && !remoteClient.isCancelled() && transferInfo.hasAnyTransfered()) {
                    DownloadCommand.rememberLastDownload(project, sources, filesToDownload);
                }
            }
        }
        catch (RemoteException ex) {
            DownloadCommand.processRemoteException(ex);
        }
        finally {
            try {
                remoteClient.disconnect();
            }
            catch (RemoteException ex) {
                DownloadCommand.processRemoteException(ex);
            }
            if (transferInfo != null) {
                DownloadCommand.processTransferInfo(transferInfo, remoteLog);
            }
            progressHandle.finish();
        }
    }

    private static void rememberLastDownload(PhpProject project, FileObject sources, FileObject[] selectedFiles) {
        for (FileObject fo : selectedFiles) {
            if (!sources.equals(fo)) continue;
            ProjectSettings.setLastDownload(project, TimeUnit.SECONDS.convert(System.currentTimeMillis(), TimeUnit.MILLISECONDS));
            return;
        }
    }
}

