/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.project.phpunit;

import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.FocusTraversalPolicy;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.UIManager;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.modules.php.api.util.UiUtils;
import org.netbeans.modules.php.project.environment.PhpEnvironment;
import org.netbeans.modules.php.project.ui.Utils;
import org.openide.awt.HtmlBrowser;
import org.openide.awt.Mnemonics;
import org.openide.util.ChangeSupport;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public class PhpUnitOptionsPanel
extends JPanel {
    private static final long serialVersionUID = 1284325558169934603L;
    private final ChangeSupport changeSupport = new ChangeSupport((Object)this);
    private JLabel errorLabel;
    private JLabel installationInfoLabel;
    private JLabel learnMoreLabel;
    private JLabel noteLabel;
    private JButton phpUnitBrowseButton;
    private JLabel phpUnitInfoLabel;
    private JLabel phpUnitLabel;
    private JLabel phpUnitPhp53InfoLabel;
    private JButton phpUnitSearchButton;
    private JTextField phpUnitTextField;
    private JLabel scriptInfoLabel;

    public PhpUnitOptionsPanel() {
        this.initComponents();
        this.errorLabel.setText(" ");
        this.scriptInfoLabel.setText(NbBundle.getMessage(PhpUnitOptionsPanel.class, (String)"LBL_PhpUnitScriptInfo", (Object)(Utilities.isWindows() ? "bat" : "sh")));
        this.phpUnitTextField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.processUpdate();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.processUpdate();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                this.processUpdate();
            }

            private void processUpdate() {
                PhpUnitOptionsPanel.this.fireChange();
            }
        });
    }

    public String getPhpUnit() {
        return this.phpUnitTextField.getText();
    }

    public void setPhpUnit(String phpUnit) {
        this.phpUnitTextField.setText(phpUnit);
    }

    public void setError(String message) {
        this.errorLabel.setText(" ");
        this.errorLabel.setForeground(UIManager.getColor("nb.errorForeground"));
        this.errorLabel.setText(message);
    }

    public void setWarning(String message) {
        this.errorLabel.setText(" ");
        this.errorLabel.setForeground(UIManager.getColor("nb.warningForeground"));
        this.errorLabel.setText(message);
    }

    public void addChangeListener(ChangeListener listener) {
        this.changeSupport.addChangeListener(listener);
    }

    public void removeChangeListener(ChangeListener listener) {
        this.changeSupport.removeChangeListener(listener);
    }

    void fireChange() {
        this.changeSupport.fireChange();
    }

    private void initComponents() {
        this.phpUnitLabel = new JLabel();
        this.phpUnitTextField = new JTextField();
        this.phpUnitBrowseButton = new JButton();
        this.phpUnitSearchButton = new JButton();
        this.scriptInfoLabel = new JLabel();
        this.noteLabel = new JLabel();
        this.phpUnitInfoLabel = new JLabel();
        this.phpUnitPhp53InfoLabel = new JLabel();
        this.installationInfoLabel = new JLabel();
        this.learnMoreLabel = new JLabel();
        this.errorLabel = new JLabel();
        this.setFocusTraversalPolicy(new FocusTraversalPolicy(){

            @Override
            public Component getDefaultComponent(Container focusCycleRoot) {
                return PhpUnitOptionsPanel.this.phpUnitBrowseButton;
            }

            @Override
            public Component getFirstComponent(Container focusCycleRoot) {
                return PhpUnitOptionsPanel.this.phpUnitBrowseButton;
            }

            @Override
            public Component getLastComponent(Container focusCycleRoot) {
                return PhpUnitOptionsPanel.this.phpUnitSearchButton;
            }

            @Override
            public Component getComponentAfter(Container focusCycleRoot, Component aComponent) {
                if (aComponent == PhpUnitOptionsPanel.this.phpUnitBrowseButton) {
                    return PhpUnitOptionsPanel.this.phpUnitSearchButton;
                }
                if (aComponent == PhpUnitOptionsPanel.this.phpUnitTextField) {
                    return PhpUnitOptionsPanel.this.phpUnitBrowseButton;
                }
                return PhpUnitOptionsPanel.this.phpUnitBrowseButton;
            }

            @Override
            public Component getComponentBefore(Container focusCycleRoot, Component aComponent) {
                if (aComponent == PhpUnitOptionsPanel.this.phpUnitSearchButton) {
                    return PhpUnitOptionsPanel.this.phpUnitBrowseButton;
                }
                if (aComponent == PhpUnitOptionsPanel.this.phpUnitBrowseButton) {
                    return PhpUnitOptionsPanel.this.phpUnitTextField;
                }
                return PhpUnitOptionsPanel.this.phpUnitSearchButton;
            }
        });
        this.phpUnitLabel.setLabelFor(this.phpUnitBrowseButton);
        Mnemonics.setLocalizedText((JLabel)this.phpUnitLabel, (String)NbBundle.getMessage(PhpUnitOptionsPanel.class, (String)"PhpUnitOptionsPanel.phpUnitLabel.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.phpUnitBrowseButton, (String)NbBundle.getMessage(PhpUnitOptionsPanel.class, (String)"PhpUnitOptionsPanel.phpUnitBrowseButton.text"));
        this.phpUnitBrowseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PhpUnitOptionsPanel.this.phpUnitBrowseButtonActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.phpUnitSearchButton, (String)NbBundle.getMessage(PhpUnitOptionsPanel.class, (String)"PhpUnitOptionsPanel.phpUnitSearchButton.text"));
        this.phpUnitSearchButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PhpUnitOptionsPanel.this.phpUnitSearchButtonActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((JLabel)this.scriptInfoLabel, (String)"HINT");
        Mnemonics.setLocalizedText((JLabel)this.noteLabel, (String)NbBundle.getMessage(PhpUnitOptionsPanel.class, (String)"PhpUnitOptionsPanel.noteLabel.text"));
        Mnemonics.setLocalizedText((JLabel)this.phpUnitInfoLabel, (String)NbBundle.getMessage(PhpUnitOptionsPanel.class, (String)"PhpUnitOptionsPanel.phpUnitInfoLabel.text"));
        Mnemonics.setLocalizedText((JLabel)this.phpUnitPhp53InfoLabel, (String)NbBundle.getMessage(PhpUnitOptionsPanel.class, (String)"PhpUnitOptionsPanel.phpUnitPhp53InfoLabel.text"));
        Mnemonics.setLocalizedText((JLabel)this.installationInfoLabel, (String)NbBundle.getMessage(PhpUnitOptionsPanel.class, (String)"PhpUnitOptionsPanel.installationInfoLabel.text"));
        Mnemonics.setLocalizedText((JLabel)this.learnMoreLabel, (String)NbBundle.getMessage(PhpUnitOptionsPanel.class, (String)"PhpUnitOptionsPanel.learnMoreLabel.text"));
        this.learnMoreLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent evt) {
                PhpUnitOptionsPanel.this.learnMoreLabelMouseEntered(evt);
            }

            @Override
            public void mousePressed(MouseEvent evt) {
                PhpUnitOptionsPanel.this.learnMoreLabelMousePressed(evt);
            }
        });
        Mnemonics.setLocalizedText((JLabel)this.errorLabel, (String)"ERROR");
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(0, 0, 0).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.errorLabel).addComponent(this.noteLabel, -2, -1, -2).addGroup(layout.createSequentialGroup().addComponent(this.phpUnitLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.scriptInfoLabel).addGroup(layout.createSequentialGroup().addComponent(this.phpUnitTextField, -1, 209, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.phpUnitBrowseButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.phpUnitSearchButton)))))).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.phpUnitInfoLabel, -2, -1, -2)).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.phpUnitPhp53InfoLabel)).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.installationInfoLabel)).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.learnMoreLabel, -2, -1, -2))).addGap(0, 0, 0)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.phpUnitLabel).addComponent(this.phpUnitTextField, -2, -1, -2).addComponent(this.phpUnitSearchButton).addComponent(this.phpUnitBrowseButton)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.scriptInfoLabel).addGap(18, 18, 18).addComponent(this.noteLabel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.phpUnitInfoLabel, -2, -1, -2).addGap(18, 18, 18).addComponent(this.phpUnitPhp53InfoLabel).addGap(18, 18, 18).addComponent(this.installationInfoLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.learnMoreLabel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 34, Short.MAX_VALUE).addComponent(this.errorLabel).addGap(0, 0, 0)));
        this.phpUnitLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(PhpUnitOptionsPanel.class, (String)"PhpUnitOptionsPanel.phpUnitLabel.AccessibleContext.accessibleName_1"));
        this.phpUnitLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PhpUnitOptionsPanel.class, (String)"PhpUnitOptionsPanel.phpUnitLabel.AccessibleContext.accessibleDescription_1"));
        this.phpUnitTextField.getAccessibleContext().setAccessibleName(NbBundle.getMessage(PhpUnitOptionsPanel.class, (String)"PhpUnitOptionsPanel.phpUnitTextField.AccessibleContext.accessibleName_1"));
        this.phpUnitTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PhpUnitOptionsPanel.class, (String)"PhpUnitOptionsPanel.phpUnitTextField.AccessibleContext.accessibleDescription_1"));
        this.phpUnitBrowseButton.getAccessibleContext().setAccessibleName(NbBundle.getMessage(PhpUnitOptionsPanel.class, (String)"PhpUnitOptionsPanel.phpUnitBrowseButton.AccessibleContext.accessibleName_1"));
        this.phpUnitBrowseButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PhpUnitOptionsPanel.class, (String)"PhpUnitOptionsPanel.phpUnitBrowseButton.AccessibleContext.accessibleDescription_1"));
        this.phpUnitSearchButton.getAccessibleContext().setAccessibleName(NbBundle.getMessage(PhpUnitOptionsPanel.class, (String)"PhpUnitOptionsPanel.phpUnitSearchButton.AccessibleContext.accessibleName_1"));
        this.phpUnitSearchButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PhpUnitOptionsPanel.class, (String)"PhpUnitOptionsPanel.phpUnitSearchButton.AccessibleContext.accessibleDescription_1"));
        this.scriptInfoLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(PhpUnitOptionsPanel.class, (String)"PhpUnitOptionsPanel.scriptInfoLabel.AccessibleContext.accessibleName"));
        this.scriptInfoLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PhpUnitOptionsPanel.class, (String)"PhpUnitOptionsPanel.scriptInfoLabel.AccessibleContext.accessibleDescription"));
        this.noteLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(PhpUnitOptionsPanel.class, (String)"PhpUnitOptionsPanel.noteLabel.AccessibleContext.accessibleName"));
        this.noteLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PhpUnitOptionsPanel.class, (String)"PhpUnitOptionsPanel.noteLabel.AccessibleContext.accessibleDescription"));
        this.phpUnitInfoLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(PhpUnitOptionsPanel.class, (String)"PhpUnitOptionsPanel.phpUnitInfoLabel.AccessibleContext.accessibleName"));
        this.phpUnitInfoLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PhpUnitOptionsPanel.class, (String)"PhpUnitOptionsPanel.phpUnitInfoLabel.AccessibleContext.accessibleDescription"));
        this.phpUnitPhp53InfoLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(PhpUnitOptionsPanel.class, (String)"PhpUnitOptionsPanel.phpUnitPhp53InfoLabel.AccessibleContext.accessibleName"));
        this.phpUnitPhp53InfoLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PhpUnitOptionsPanel.class, (String)"PhpUnitOptionsPanel.phpUnitPhp53InfoLabel.AccessibleContext.accessibleDescription"));
        this.installationInfoLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(PhpUnitOptionsPanel.class, (String)"PhpUnitOptionsPanel.installationInfoLabel.AccessibleContext.accessibleName"));
        this.installationInfoLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PhpUnitOptionsPanel.class, (String)"PhpUnitOptionsPanel.installationInfoLabel.AccessibleContext.accessibleDescription"));
        this.learnMoreLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(PhpUnitOptionsPanel.class, (String)"PhpUnitOptionsPanel.learnMoreLabel.AccessibleContext.accessibleName"));
        this.learnMoreLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PhpUnitOptionsPanel.class, (String)"PhpUnitOptionsPanel.learnMoreLabel.AccessibleContext.accessibleDescription"));
        this.errorLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(PhpUnitOptionsPanel.class, (String)"PhpUnitOptionsPanel.errorLabel.AccessibleContext.accessibleName"));
        this.errorLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PhpUnitOptionsPanel.class, (String)"PhpUnitOptionsPanel.errorLabel.AccessibleContext.accessibleDescription"));
        this.getAccessibleContext().setAccessibleName(NbBundle.getMessage(PhpUnitOptionsPanel.class, (String)"PhpUnitOptionsPanel.AccessibleContext.accessibleName"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PhpUnitOptionsPanel.class, (String)"PhpUnitOptionsPanel.AccessibleContext.accessibleDescription"));
    }

    private void phpUnitBrowseButtonActionPerformed(ActionEvent evt) {
        Utils.browsePhpUnit(this, this.phpUnitTextField);
    }

    private void phpUnitSearchButtonActionPerformed(ActionEvent evt) {
        String phpUnit = UiUtils.SearchWindow.search((UiUtils.SearchWindow.SearchWindowSupport)new UiUtils.SearchWindow.SearchWindowSupport(){

            public List<String> detect() {
                return PhpEnvironment.get().getAllPhpUnits();
            }

            public String getWindowTitle() {
                return NbBundle.getMessage(PhpUnitOptionsPanel.class, (String)"LBL_PhpUnitsTitle");
            }

            public String getListTitle() {
                return NbBundle.getMessage(PhpUnitOptionsPanel.class, (String)"LBL_PhpUnits");
            }

            public String getPleaseWaitPart() {
                return NbBundle.getMessage(PhpUnitOptionsPanel.class, (String)"LBL_PhpUnitsPleaseWaitPart");
            }

            public String getNoItemsFound() {
                return NbBundle.getMessage(PhpUnitOptionsPanel.class, (String)"LBL_NoPhpUnitsFound");
            }
        });
        if (phpUnit != null) {
            this.phpUnitTextField.setText(phpUnit);
        }
    }

    private void learnMoreLabelMouseEntered(MouseEvent evt) {
        evt.getComponent().setCursor(Cursor.getPredefinedCursor(12));
    }

    private void learnMoreLabelMousePressed(MouseEvent evt) {
        try {
            URL url = new URL("http://www.phpunit.de/manual/current/en/installation.html");
            HtmlBrowser.URLDisplayer.getDefault().showURL(url);
        }
        catch (MalformedURLException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }
}

