/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.project.classpath;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.php.project.PhpProject;
import org.netbeans.modules.php.project.ProjectPropertiesSupport;
import org.netbeans.modules.php.project.SourceRoots;
import org.netbeans.spi.java.classpath.ClassPathImplementation;
import org.netbeans.spi.java.classpath.FilteringPathResourceImplementation;
import org.netbeans.spi.java.classpath.PathResourceImplementation;
import org.netbeans.spi.project.support.ant.PathMatcher;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.WeakListeners;

final class SourcePathImplementation
implements ClassPathImplementation,
PropertyChangeListener {
    private final PropertyChangeSupport support = new PropertyChangeSupport(this);
    private final PhpProject project;
    private final PropertyEvaluator evaluator;
    private List<PathResourceImplementation> resources;
    private final SourceRoots sources;
    private SourceRoots tests;
    private SourceRoots selenium;

    public SourcePathImplementation(PhpProject project, SourceRoots sources) {
        this(project, sources, null, null);
    }

    public SourcePathImplementation(PhpProject project, SourceRoots sources, SourceRoots tests, SourceRoots selenium) {
        assert (project != null);
        assert (sources != null);
        this.project = project;
        this.evaluator = ProjectPropertiesSupport.getPropertyEvaluator(project);
        this.sources = sources;
        sources.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)sources));
        this.tests = tests;
        this.selenium = selenium;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<PathResourceImplementation> getResources() {
        SourcePathImplementation sourcePathImplementation = this;
        synchronized (sourcePathImplementation) {
            if (this.resources != null) {
                return this.resources;
            }
        }
        URL[] urls = this.sources.getRootURLs();
        SourcePathImplementation sourcePathImplementation2 = this;
        synchronized (sourcePathImplementation2) {
            if (this.resources == null) {
                ArrayList<FilteringPathResource> result = new ArrayList<FilteringPathResource>(urls.length);
                for (URL root : urls) {
                    result.add(new FilteringPathResource(this.project, root));
                }
                this.resources = Collections.unmodifiableList(result);
            }
            return this.resources;
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.support.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.support.removePropertyChangeListener(listener);
    }

    @Override
    public synchronized void propertyChange(PropertyChangeEvent evt) {
        if (SourceRoots.PROP_ROOTS.equals(evt.getPropertyName())) {
            this.invalidate();
        } else if (evt.getSource() == this.evaluator && evt.getPropertyName() == null) {
            this.invalidate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void invalidate() {
        SourcePathImplementation sourcePathImplementation = this;
        synchronized (sourcePathImplementation) {
            this.resources = null;
        }
        this.support.firePropertyChange("resources", null, null);
    }

    String computeExcludes(File root) {
        StringBuilder buffer = new StringBuilder(100);
        for (File file : this.project.getIgnoredFiles()) {
            String relPath = PropertyUtils.relativizeFile((File)root, (File)file);
            if (!this.isUnderneath(relPath)) continue;
            String pattern = relPath;
            if (file.isDirectory()) {
                pattern = pattern + "/";
            }
            if (buffer.length() > 0) {
                buffer.append(",");
            }
            buffer.append(pattern);
        }
        this.ignoreTests(buffer, root, this.tests);
        this.ignoreTests(buffer, root, this.selenium);
        return buffer.toString();
    }

    private void ignoreTests(StringBuilder buffer, File root, SourceRoots tests) {
        if (tests == null) {
            return;
        }
        assert (tests.isTest()) : "Not test source roots provided";
        for (FileObject fo : tests.getRoots()) {
            File test = FileUtil.toFile((FileObject)fo);
            if (test == null) continue;
            assert (test.isDirectory());
            String relPath = PropertyUtils.relativizeFile((File)root, (File)test);
            if (!this.isUnderneath(relPath)) continue;
            String pattern = relPath + "/";
            if (buffer.length() > 0) {
                buffer.append(",");
            }
            buffer.append(pattern);
        }
    }

    private boolean isUnderneath(String relativePath) {
        return relativePath != null && !relativePath.equals(".") && !relativePath.startsWith("../");
    }

    private final class FilteringPathResource
    implements FilteringPathResourceImplementation,
    PropertyChangeListener,
    ChangeListener {
        final PropertyChangeSupport pcs = new PropertyChangeSupport(this);
        volatile PathMatcher matcher;
        private final URL root;

        FilteringPathResource(PhpProject project, URL root) {
            assert (project != null);
            assert (root != null);
            this.root = root;
            ProjectPropertiesSupport.addWeakPropertyEvaluatorListener(project, this);
            ProjectPropertiesSupport.addWeakIgnoredFilesListener(project, this);
        }

        public URL[] getRoots() {
            return new URL[]{this.root};
        }

        public boolean includes(URL root, String resource) {
            if (this.matcher == null) {
                File rootFile = new File(URI.create(root.toExternalForm()));
                this.matcher = new PathMatcher(null, SourcePathImplementation.this.computeExcludes(rootFile), rootFile);
            }
            return this.matcher.matches(resource, true);
        }

        public ClassPathImplementation getContent() {
            return null;
        }

        public void addPropertyChangeListener(PropertyChangeListener listener) {
            this.pcs.addPropertyChangeListener(listener);
        }

        public void removePropertyChangeListener(PropertyChangeListener listener) {
            this.pcs.removePropertyChangeListener(listener);
        }

        @Override
        public void propertyChange(PropertyChangeEvent ev) {
            String prop = ev.getPropertyName();
            if (prop == null || prop.equals("ignore.path") || prop.equals("test.src.dir") || prop.equals("selenium.src.dir")) {
                this.fireChange(ev);
            }
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            this.fireChange(null);
        }

        private void fireChange(PropertyChangeEvent event) {
            this.matcher = null;
            PropertyChangeEvent ev = new PropertyChangeEvent(this, "includes", null, null);
            if (event != null) {
                ev.setPropagationId(event);
            }
            this.pcs.firePropertyChange(ev);
        }
    }
}

