/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.project.classpath;

import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.netbeans.modules.php.project.api.PhpSourcePath;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;

public final class CommonPhpSourcePath {
    private static List<FileObject> internalFolders = null;

    private CommonPhpSourcePath() {
    }

    public static synchronized List<FileObject> getInternalPath() {
        if (internalFolders == null) {
            internalFolders = CommonPhpSourcePath.getInternalFolders();
        }
        return internalFolders;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<FileObject> getInternalFolders() {
        assert (Thread.holdsLock(CommonPhpSourcePath.class));
        FileObject sfsFolder = FileUtil.getConfigFile((String)"PHP/RuntimeLibraries");
        for (FileObject fo : sfsFolder.getChildren()) {
            if (FileUtil.toFile((FileObject)fo) != null) continue;
            InputStream is = null;
            ByteArrayOutputStream bos = null;
            try {
                is = fo.getInputStream();
                bos = new ByteArrayOutputStream();
                FileUtil.copy((InputStream)is, (OutputStream)bos);
            }
            catch (IOException exc) {
                try {
                    Exceptions.printStackTrace((Throwable)exc);
                }
                catch (Throwable throwable) {
                    CommonPhpSourcePath.closeStreams(is);
                    throw throwable;
                }
                CommonPhpSourcePath.closeStreams(is);
            }
            CommonPhpSourcePath.closeStreams(is);
            OutputStream os = null;
            try {
                os = fo.getOutputStream();
                os.write(bos.toByteArray());
            }
            catch (IOException exc) {
                try {
                    Exceptions.printStackTrace((Throwable)exc);
                }
                catch (Throwable throwable) {
                    CommonPhpSourcePath.closeStreams(os, bos);
                    throw throwable;
                }
                CommonPhpSourcePath.closeStreams(os, bos);
                continue;
            }
            CommonPhpSourcePath.closeStreams(os, bos);
        }
        File file = FileUtil.toFile((FileObject)sfsFolder);
        ArrayList<FileObject> folders = new ArrayList<FileObject>();
        folders.add(sfsFolder);
        folders.addAll(PhpSourcePath.getPreindexedFolders());
        return folders;
    }

    private static void closeStreams(Closeable ... streams) {
        for (Closeable stream : streams) {
            try {
                if (stream == null) continue;
                stream.close();
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }
}

