/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.beans.api.model.support;

import java.io.IOException;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import javax.lang.model.element.Element;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.modules.j2ee.metadata.model.api.MetadataModel;
import org.netbeans.modules.j2ee.metadata.model.api.MetadataModelAction;
import org.netbeans.modules.j2ee.metadata.model.api.MetadataModelException;
import org.netbeans.modules.web.api.webmodule.WebModule;
import org.netbeans.modules.web.beans.api.model.ModelUnit;
import org.netbeans.modules.web.beans.api.model.WebBeansModel;
import org.netbeans.spi.java.classpath.ClassPathProvider;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;

public final class WebBeansModelSupport {
    private WebBeansModelSupport() {
    }

    public static List<WebBean> getNamedBeans(MetadataModel<WebBeansModel> metadataModel) {
        try {
            return (List)metadataModel.runReadAction((MetadataModelAction)new MetadataModelAction<WebBeansModel, List<WebBean>>(){

                public List<WebBean> run(WebBeansModel webBeansModel) throws Exception {
                    List<Element> list = webBeansModel.getNamedElements();
                    LinkedList<WebBean> linkedList = new LinkedList<WebBean>();
                    for (Element element : list) {
                        if (element == null) continue;
                        linkedList.add(new WebBean(element, webBeansModel.getName(element)));
                    }
                    return linkedList;
                }
            });
        }
        catch (MetadataModelException metadataModelException) {
            Exceptions.printStackTrace((Throwable)metadataModelException);
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
        }
        return Collections.emptyList();
    }

    public static ModelUnit getModelUnit(WebModule webModule) {
        if (webModule == null) {
            return null;
        }
        FileObject fileObject = WebBeansModelSupport.getFileObject(webModule);
        Project project = FileOwnerQuery.getOwner((FileObject)fileObject);
        if (project == null) {
            return null;
        }
        ClassPath classPath = WebBeansModelSupport.getClassPath(project, "classpath/boot");
        ClassPath classPath2 = WebBeansModelSupport.getClassPath(project, "classpath/compile");
        ClassPath classPath3 = WebBeansModelSupport.getClassPath(project, "classpath/source");
        return ModelUnit.create(classPath, classPath2, classPath3);
    }

    private static ClassPath getClassPath(Project project, String string) {
        ClassPathProvider classPathProvider = (ClassPathProvider)project.getLookup().lookup(ClassPathProvider.class);
        if (classPathProvider == null) {
            return null;
        }
        Sources sources = (Sources)project.getLookup().lookup(Sources.class);
        if (sources == null) {
            return null;
        }
        SourceGroup[] sourceGroupArray = sources.getSourceGroups("java");
        ClassPath[] classPathArray = new ClassPath[sourceGroupArray.length];
        int n = 0;
        for (SourceGroup sourceGroup : sourceGroupArray) {
            FileObject fileObject = sourceGroup.getRootFolder();
            classPathArray[n] = classPathProvider.findClassPath(fileObject, string);
        }
        return ClassPathSupport.createProxyClassPath((ClassPath[])classPathArray);
    }

    private static FileObject getFileObject(WebModule webModule) {
        FileObject fileObject = webModule.getDocumentBase();
        if (fileObject != null) {
            return fileObject;
        }
        fileObject = webModule.getDeploymentDescriptor();
        if (fileObject != null) {
            return fileObject;
        }
        fileObject = webModule.getWebInf();
        if (fileObject != null) {
            return fileObject;
        }
        FileObject[] fileObjectArray = webModule.getJavaSources();
        if (fileObjectArray != null) {
            for (FileObject fileObject2 : fileObjectArray) {
                if (fileObject2 == null) continue;
                return fileObject2;
            }
        }
        return null;
    }

    public static final class WebBean {
        private Element element;
        private String name;

        private WebBean(Element element, String string) {
            this.element = element;
            this.name = string;
        }

        private Element getElement() {
            return this.element;
        }

        public String getBeanClassName() {
            return ((Object)this.getElement().asType()).toString();
        }

        public String getName() {
            return this.name;
        }
    }
}

