/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.platform.gems;

import java.awt.Component;
import java.awt.EventQueue;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.ruby.platform.RubyPlatform;
import org.netbeans.api.ruby.platform.RubyPlatformManager;
import org.netbeans.modules.ruby.platform.Util;
import org.netbeans.modules.ruby.platform.gems.Gem;
import org.netbeans.modules.ruby.platform.gems.GemFilesParser;
import org.netbeans.modules.ruby.platform.gems.GemInfo;
import org.netbeans.modules.ruby.platform.gems.GemInstallInfo;
import org.netbeans.modules.ruby.platform.gems.GemListParser;
import org.netbeans.modules.ruby.platform.gems.GemPanel;
import org.netbeans.modules.ruby.platform.gems.GemRunner;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.Parameters;
import org.openide.util.Utilities;

public final class GemManager {
    private static final Logger LOGGER = Logger.getLogger(GemManager.class.getName());
    private static final String[] TOP_LEVEL_REPO_DIRS = new String[]{"cache", "specifications", "gems", "doc"};
    private static final String SPECIFICATIONS = "specifications";
    private static final boolean SKIP_INDEX_LIBS = System.getProperty("ruby.index.nolibs") != null;
    private static final boolean SKIP_INDEX_GEMS = System.getProperty("ruby.index.nogems") != null;
    private static final String DOT_GEM_SPEC = ".gemspec";
    private Map<String, List<GemInfo>> localGems;
    private Map<String, String> gemVersions;
    private Map<String, URL> gemUrls;
    private Set<URL> nonGemUrls;
    public static String TEST_GEM_HOME;
    private List<Gem> local;
    private List<Gem> remote;
    private String gemHomeUrl;
    private final RubyPlatform platform;
    private final Lock runnerLocalLock;
    private final Lock runnerRemoteLock;
    private static final ExecutorService RELOAD_EXECUTOR;

    public GemManager(RubyPlatform platform) {
        assert (platform.hasRubyGemsInstalled()) : "called when RubyGems installed";
        this.platform = platform;
        this.runnerLocalLock = new ReentrantLock(true);
        this.runnerRemoteLock = new ReentrantLock(true);
    }

    String getRubyGemsVersion() {
        return this.platform.getInfo().getGemVersion();
    }

    boolean hasAncientRubyGemsVersion() {
        return Util.compareVersions("1.0", this.getRubyGemsVersion()) > 0;
    }

    boolean hasOldRubyGemsVersion() {
        return Util.compareVersions("1.2", this.getRubyGemsVersion()) > 0;
    }

    boolean isGemHomeWritable() {
        return this.getGemHomeF().canWrite();
    }

    private boolean checkGemHomePermissions() {
        String gksu;
        if (!this.isGemHomeWritable() && (gksu = Util.findOnPath("gksu")) == null) {
            NotifyDescriptor.Message nd = new NotifyDescriptor.Message((Object)NbBundle.getMessage(GemManager.class, (String)"GemManager.GemNotWritable", (Object)this.getGemHome()), 0);
            DialogDisplayer.getDefault().notifyLater((NotifyDescriptor)nd);
            return false;
        }
        return true;
    }

    public static void initializeRepository(File gemRepo) throws IOException {
        if (!gemRepo.exists()) {
            gemRepo.mkdirs();
        }
        GemManager.initializeRepository(FileUtil.toFileObject((File)gemRepo));
    }

    public static void initializeRepository(FileObject gemRepo) throws IOException {
        for (String dir : TOP_LEVEL_REPO_DIRS) {
            gemRepo.createFolder(dir);
        }
    }

    public String getGemHome() {
        return this.platform.getInfo().getGemHome();
    }

    public File getGemHomeF() {
        return FileUtil.normalizeFile((File)new File(this.platform.getInfo().getGemHome()));
    }

    public FileObject getGemHomeFO() {
        return FileUtil.toFileObject((File)this.getGemHomeF());
    }

    public synchronized String getGemHomeUrl() {
        String gemHome;
        if (this.gemHomeUrl == null && (gemHome = this.getGemHome()) != null) {
            try {
                File r = new File(gemHome);
                if (r != null) {
                    this.gemHomeUrl = r.toURI().toURL().toExternalForm();
                }
            }
            catch (MalformedURLException mue) {
                Exceptions.printStackTrace((Throwable)mue);
            }
        }
        return this.gemHomeUrl;
    }

    public Set<? extends File> getRepositories() {
        Set<File> repos = this.getGemPath();
        repos.add(this.getGemHomeF());
        return repos;
    }

    public Set<File> getGemPath() {
        LinkedHashSet<File> repos = new LinkedHashSet<File>();
        StringTokenizer st = new StringTokenizer(this.platform.getInfo().getGemPath(), File.pathSeparator);
        while (st.hasMoreTokens()) {
            repos.add(new File(st.nextToken()));
        }
        return repos;
    }

    public boolean addGemPath(File path) {
        boolean result;
        Set<File> gemPath = this.getGemPath();
        try {
            result = gemPath.add(path.getCanonicalFile());
        }
        catch (IOException ioe) {
            LOGGER.log(Level.SEVERE, ioe.getLocalizedMessage(), ioe);
            result = false;
        }
        if (result) {
            this.storeGemPath(gemPath);
        }
        return result;
    }

    public void removeGemPath(File path) {
        Set<File> gemPath = this.getGemPath();
        gemPath.remove(path);
        this.storeGemPath(gemPath);
    }

    private void storeGemPath(Set<File> gemPath) {
        StringBuilder pathSB = new StringBuilder();
        for (File token : gemPath) {
            if (pathSB.length() != 0) {
                pathSB.append(File.pathSeparator);
            }
            pathSB.append(token.getAbsolutePath());
        }
        this.platform.getInfo().setGemPath(pathSB.toString());
        try {
            RubyPlatformManager.storePlatform(this.platform);
        }
        catch (IOException ioe) {
            LOGGER.log(Level.SEVERE, ioe.getLocalizedMessage(), ioe);
        }
        this.resetLocal();
    }

    public boolean isGemInstalled(String gemName) {
        return !this.getVersions(gemName).isEmpty();
    }

    public boolean isGemInstalledForPlatform(String gemName, VersionPredicate predicate) {
        for (GemInfo gemInfo : this.getVersions(gemName)) {
            String specName = gemInfo.getSpecFile().getName();
            if (!this.platform.isJRuby() && specName.endsWith("-java.gemspec")) continue;
            if (specName.startsWith("ruby-debug-base-")) {
                boolean forJavaPlaf = specName.endsWith("-java.gemspec");
                if (this.platform.isJRuby() && !forJavaPlaf || !this.platform.isJRuby() && forJavaPlaf) continue;
            }
            if (!predicate.isRight(gemInfo.getVersion())) continue;
            return true;
        }
        return false;
    }

    public boolean isGemInstalled(String gemName, String version) {
        String currVersion = this.getLatestVersion(gemName);
        return this.isRightVersion(currVersion, version, false);
    }

    public boolean isGemInstalledForPlatform(String gemName, final String expectedVersion, final boolean exact) {
        VersionPredicate predicate = new VersionPredicate(){

            @Override
            public boolean isRight(String version) {
                return GemManager.this.isRightVersion(version, expectedVersion, exact);
            }
        };
        return this.isGemInstalledForPlatform(gemName, predicate);
    }

    private boolean isRightVersion(String currVersion, String version, boolean exact) {
        boolean isInstalled = false;
        if (currVersion != null) {
            int result = Util.compareVersions(version, currVersion);
            isInstalled = exact ? result == 0 : result <= 0;
        }
        return isInstalled;
    }

    public boolean isGemInstalledForPlatform(String gemName, String version) {
        return this.isGemInstalledForPlatform(gemName, version, false);
    }

    public String getLatestVersion(String gemName) {
        this.initGemList();
        List<GemInfo> versions = this.getVersions(gemName);
        return versions.isEmpty() ? null : versions.get(0).getVersion();
    }

    public List<GemInfo> getVersions(String gemName) {
        this.initGemList();
        List<GemInfo> versions = this.localGems.get(gemName);
        if (versions == null || versions.isEmpty()) {
            return Collections.emptyList();
        }
        Collections.sort(versions);
        return versions;
    }

    private void logGems(Level level) {
        if (!LOGGER.isLoggable(level)) {
            return;
        }
        if (this.localGems == null) {
            LOGGER.log(level, "No gems found, gemFiles is null");
            return;
        }
        LOGGER.log(level, "Found " + this.localGems.size() + " gems.");
        for (String key : this.localGems.keySet()) {
            List<GemInfo> versions = this.getVersions(key);
            LOGGER.log(level, key + " has " + versions.size() + " version(s):");
            for (GemInfo version : versions) {
                LOGGER.log(level, version + " at " + version.getSpecFile());
            }
        }
    }

    private synchronized void initGemList() {
        if (this.localGems == null) {
            assert (this.platform.hasRubyGemsInstalled()) : "asking for gems only when RubyGems are installed";
            this.localGems = new HashMap<String, List<GemInfo>>();
            HashSet<File> allSpecFiles = new HashSet<File>(100);
            for (File file : this.getRepositories()) {
                File specDir = new File(file, SPECIFICATIONS);
                if (specDir.exists()) {
                    LOGGER.finer("Initializing \"" + file + "\" repository");
                    File[] specFiles = specDir.listFiles();
                    if (specFiles == null) continue;
                    allSpecFiles.addAll(Arrays.asList(specFiles));
                    continue;
                }
                LOGGER.finer("Cannot find Gems repository. \"" + file + "\" does not exist or is not a directory.");
            }
            Map<String, List<GemInfo>> namesToInfos = GemFilesParser.getGemInfos(allSpecFiles);
            for (Map.Entry<String, List<GemInfo>> nameToInfos : namesToInfos.entrySet()) {
                String name = nameToInfos.getKey();
                this.localGems.put(name, nameToInfos.getValue());
            }
            this.logGems(Level.FINEST);
        }
    }

    public synchronized Set<String> getInstalledGemsFiles() {
        this.initGemList();
        return this.localGems.keySet();
    }

    public synchronized void reset() {
        this.resetRemote();
        this.resetLocal();
        this.gemHomeUrl = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetRemote() {
        if (this.runnerRemoteLock.tryLock()) {
            try {
                this.remote = null;
            }
            finally {
                this.runnerRemoteLock.unlock();
            }
        } else {
            LOGGER.finer("resetRemote() ignored");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetLocal() {
        if (this.runnerLocalLock.tryLock()) {
            try {
                this.local = null;
                this.localGems = null;
                this.platform.fireGemsChanged();
            }
            finally {
                this.runnerLocalLock.unlock();
            }
        } else {
            LOGGER.finer("resetLocal() ignored");
        }
    }

    public List<Gem> getInstalledGems(List<? super String> errors) {
        List<? super String> c = errors;
        c.addAll(this.reloadLocalIfNeeded());
        return this.getLocalGems();
    }

    public List<Gem> getRemoteGems(List<? super String> errors) {
        List<? super String> c = errors;
        c.addAll(this.reloadRemoteIfNeeded());
        return this.getRemoteGems();
    }

    public synchronized List<Gem> getLocalGems() {
        return this.local != null ? this.local : Collections.emptyList();
    }

    public synchronized List<Gem> getRemoteGems() {
        return this.remote != null ? this.remote : Collections.emptyList();
    }

    synchronized boolean needsLocalReload() {
        return this.local == null;
    }

    synchronized boolean needsRemoteReload() {
        return this.remote == null;
    }

    synchronized boolean needsReload() {
        return this.needsLocalReload() || this.needsRemoteReload();
    }

    public void reloadLocalGems(final boolean force) {
        RELOAD_EXECUTOR.submit(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    int timeout = 10;
                    if (GemManager.this.runnerLocalLock.tryLock(10L, TimeUnit.SECONDS)) {
                        if (force) {
                            GemManager.this.resetLocal();
                        }
                        GemManager.this.reloadLocalIfNeeded();
                    } else {
                        LOGGER.info("Could not retrieve lock for reloading gems in 10 secs, skipping reload");
                    }
                }
                catch (InterruptedException ex) {
                    LOGGER.log(Level.INFO, null, ex);
                }
                finally {
                    GemManager.this.runnerLocalLock.unlock();
                }
            }
        });
    }

    public void reloadIfNeeded(List<? super String> errors) {
        assert (!EventQueue.isDispatchThread()) : "do not call from EDT!";
        if (!this.platform.checkAndReportRubyGemsProblems()) {
            return;
        }
        List<? super String> c = errors;
        c.addAll(this.reloadLocalIfNeeded());
        if (errors.isEmpty()) {
            c.addAll(this.reloadRemoteIfNeeded());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<String> reloadLocalIfNeeded() {
        if (!this.platform.checkAndReportRubyGemsProblems()) {
            return Collections.emptyList();
        }
        ArrayList<String> errors = new ArrayList<String>();
        this.runnerLocalLock.lock();
        try {
            if (this.local == null) {
                GemRunner gemRunner = new GemRunner(this.platform);
                if (gemRunner.fetchLocal()) {
                    this.local = GemListParser.parseLocal(gemRunner.getOutput());
                    Collections.sort(this.local);
                } else {
                    ArrayList<String> c = errors;
                    c.addAll(gemRunner.getOutput());
                }
            }
        }
        finally {
            this.runnerLocalLock.unlock();
        }
        return errors;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<String> reloadRemoteIfNeeded() {
        if (!this.platform.checkAndReportRubyGemsProblems()) {
            return Collections.emptyList();
        }
        ArrayList<String> errors = new ArrayList<String>();
        this.runnerRemoteLock.lock();
        try {
            if (this.remote == null) {
                GemRunner gemRunner = new GemRunner(this.platform);
                if (gemRunner.fetchRemote()) {
                    this.remote = GemListParser.parseRemote(gemRunner.getOutput());
                    Collections.sort(this.remote);
                } else {
                    errors.addAll(gemRunner.getOutput());
                }
            }
        }
        finally {
            this.runnerRemoteLock.unlock();
        }
        return errors;
    }

    public void installGem(String gem, boolean rdoc, boolean ri, String version) {
        if (!this.checkGemHomePermissions()) {
            return;
        }
        Gem[] gems = new Gem[]{new Gem(gem, null, null)};
        Runnable installationComplete = new Runnable(){

            @Override
            public void run() {
                GemManager.this.platform.recomputeRoots();
            }
        };
        this.install(gems, null, rdoc, ri, version, true, true, installationComplete);
    }

    public void installGem(String gem, boolean rdoc, boolean ri) {
        this.installGem(gem, rdoc, ri, null);
    }

    public boolean install(Gem[] gems, Component parent, boolean rdoc, boolean ri, String version, boolean includeDeps, boolean asynchronous, Runnable asyncCompletionTask) {
        if (!this.checkGemHomePermissions()) {
            return false;
        }
        List<String> gemNames = this.mapToGemNames(gems);
        GemRunner gemRunner = new GemRunner(this.platform);
        if (asynchronous) {
            gemRunner.installAsynchronously(gemNames, rdoc, ri, includeDeps, version, this.resetCompletionTask(asyncCompletionTask), parent);
            return false;
        }
        boolean ok = gemRunner.install(gemNames, rdoc, ri, includeDeps, version);
        this.resetLocal();
        return ok;
    }

    boolean installLocal(File gem, GemPanel parent, boolean rdoc, boolean ri, boolean asynchronous, Runnable asyncCompletionTask) {
        if (!this.checkGemHomePermissions()) {
            return false;
        }
        GemRunner gemRunner = new GemRunner(this.platform);
        if (asynchronous) {
            gemRunner.installLocalAsynchronously(gem, rdoc, ri, this.resetCompletionTask(asyncCompletionTask), parent);
            return false;
        }
        boolean ok = gemRunner.installLocal(gem, rdoc, ri);
        this.resetLocal();
        return ok;
    }

    boolean uninstall(List<GemInstallInfo> gems, Component parent, boolean asynchronous, Runnable asyncCompletionTask) {
        if (!this.checkGemHomePermissions()) {
            return false;
        }
        GemRunner gemRunner = new GemRunner(this.platform);
        if (asynchronous) {
            gemRunner.uninstallAsynchronously(gems, this.resetCompletionTask(asyncCompletionTask), parent);
            return false;
        }
        boolean ok = gemRunner.uninstall(gems);
        this.resetLocal();
        return ok;
    }

    public boolean update(Gem[] gems, Component parent, boolean rdoc, boolean ri, boolean includeDependencies, boolean asynchronous, Runnable asyncCompletionTask) {
        if (!this.checkGemHomePermissions()) {
            return false;
        }
        List<String> gemNames = gems == null ? null : this.mapToGemNames(gems);
        GemRunner gemRunner = new GemRunner(this.platform);
        if (asynchronous) {
            gemRunner.updateAsynchronously(gemNames, rdoc, ri, includeDependencies, this.resetCompletionTask(asyncCompletionTask), parent);
            return false;
        }
        boolean ok = gemRunner.update(gemNames, rdoc, ri, includeDependencies);
        this.resetLocal();
        return ok;
    }

    public synchronized Set<URL> getNonGemLoadPath() {
        if (this.nonGemUrls == null) {
            this.initializeUrlMaps();
        }
        return this.nonGemUrls;
    }

    public synchronized Map<String, String> getGemVersions() {
        if (this.gemVersions == null) {
            this.initializeUrlMaps();
        }
        return this.gemVersions;
    }

    public synchronized Map<String, URL> getGemUrls() {
        if (this.gemUrls == null) {
            this.initializeUrlMaps();
        }
        return this.gemUrls;
    }

    private void initializeUrlMaps() {
        File rubyHome = this.platform.getHome();
        if (rubyHome == null || !rubyHome.exists()) {
            this.gemVersions = Collections.emptyMap();
            this.gemUrls = Collections.emptyMap();
            this.nonGemUrls = Collections.emptySet();
            return;
        }
        try {
            File siteruby;
            String rubyLibSiteDir;
            String rubyLibDir;
            this.gemUrls = new HashMap<String, URL>(60);
            this.gemVersions = new HashMap<String, String>(60);
            this.nonGemUrls = new HashSet<URL>(12);
            if (!SKIP_INDEX_LIBS && (rubyLibDir = this.platform.getVersionLibDir()) != null) {
                File libs = new File(rubyLibDir);
                assert (libs.exists() && libs.isDirectory());
                this.nonGemUrls.add(libs.toURI().toURL());
            }
            if (!SKIP_INDEX_GEMS) {
                this.initGemList();
                if (RubyPlatformManager.PREINDEXING) {
                    String gemDir = this.getGemHome();
                    File specDir = new File(gemDir, "gems");
                    if (specDir.exists()) {
                        File[] gems;
                        for (File f : gems = specDir.listFiles()) {
                            File lib;
                            if (f.getName().indexOf(45) == -1 || !(lib = new File(f, "lib")).exists() || !lib.isDirectory() || lib.list().length <= 0) continue;
                            URL url = lib.toURI().toURL();
                            this.nonGemUrls.add(url);
                        }
                    }
                } else if (this.localGems != null) {
                    Set<String> gems = this.localGems.keySet();
                    for (String name : gems) {
                        List<GemInfo> versions = this.localGems.get(name);
                        assert (!versions.isEmpty());
                        GemInfo newestVersion = versions.get(0);
                        File f = newestVersion.getSpecFile();
                        assert (f.getName().endsWith(DOT_GEM_SPEC));
                        String filename = f.getName().substring(0, f.getName().length() - DOT_GEM_SPEC.length());
                        File lib = new File(f.getParentFile().getParentFile(), "gems" + File.separator + filename + File.separator + "lib");
                        if (!lib.exists() || !lib.isDirectory()) continue;
                        URL url = lib.toURI().toURL();
                        this.gemUrls.put(name, url);
                        String version = newestVersion.getVersion();
                        this.gemVersions.put(name, version);
                    }
                }
            }
            if (!SKIP_INDEX_LIBS && (rubyLibSiteDir = this.platform.getRubyLibSiteDir()) != null && (siteruby = new File(rubyLibSiteDir)).exists() && siteruby.isDirectory()) {
                this.nonGemUrls.add(siteruby.toURI().toURL());
            }
            this.gemUrls = Collections.unmodifiableMap(this.gemUrls);
            this.gemVersions = Collections.unmodifiableMap(this.gemVersions);
            this.nonGemUrls = Collections.unmodifiableSet(this.nonGemUrls);
        }
        catch (MalformedURLException mue) {
            Exceptions.printStackTrace((Throwable)mue);
        }
    }

    private List<String> mapToGemNames(Gem[] gems) {
        ArrayList<String> gemNames = new ArrayList<String>();
        for (Gem gem : gems) {
            gemNames.add(gem.getName());
        }
        return gemNames;
    }

    private Runnable resetCompletionTask(final Runnable origTask) {
        return new Runnable(){

            @Override
            public void run() {
                GemManager.this.resetLocal();
                origTask.run();
            }
        };
    }

    public static String getNotInstalledMessage() {
        return NbBundle.getMessage(GemManager.class, (String)"GemManager.rubyGemsNotInstalled");
    }

    static boolean isValidGemHome(File gemHomeF) {
        Parameters.notNull((CharSequence)"gemHomeF", (Object)gemHomeF);
        boolean valid = gemHomeF.isDirectory();
        for (int i = 0; valid && i < TOP_LEVEL_REPO_DIRS.length; ++i) {
            String dir = TOP_LEVEL_REPO_DIRS[i];
            File dirF = new File(gemHomeF, dir);
            LOGGER.finer("Checking: " + dirF);
            LOGGER.finer("valid: " + (valid &= dirF.isDirectory()));
        }
        return valid;
    }

    public static void adjustEnvironment(RubyPlatform platform, Map<String, String> env) {
        if (platform.hasRubyGemsInstalled()) {
            String gemHome = GemManager.adjustGemPath(platform.getGemManager().getGemHome());
            String gemPath = GemManager.adjustGemPath(platform.getInfo().getGemPath());
            env.put("GEM_HOME", gemHome);
            env.put("GEM_PATH", gemPath);
        }
    }

    private static String adjustGemPath(String origPath) {
        return Utilities.isWindows() ? origPath.replace('\\', '/') : origPath;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        GemManager other = (GemManager)obj;
        return this.platform == other.platform || this.platform != null && this.platform.equals(other.platform);
    }

    public int hashCode() {
        int hash = 3;
        hash = 53 * hash + (this.platform != null ? this.platform.hashCode() : 0);
        return hash;
    }

    public String toString() {
        return "GemManager[platform:" + this.platform + "]";
    }

    static {
        RELOAD_EXECUTOR = Executors.newCachedThreadPool();
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                RELOAD_EXECUTOR.shutdownNow();
            }
        });
    }

    public static interface VersionPredicate {
        public boolean isRight(String var1);
    }
}

