/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.versioning.util;

import java.lang.reflect.Array;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.netbeans.modules.versioning.util.IdentityHashSet;

public final class CollectionUtils {
    private CollectionUtils() {
    }

    public static <T, U extends T> int findInArray(T[] array, U itemToFind) {
        if (array == null) {
            throw new IllegalArgumentException("null array");
        }
        for (int i = 0; i < array.length; ++i) {
            if (array[i] != itemToFind) continue;
            return i;
        }
        return -1;
    }

    public static <T> T[] appendItem(T[] array, T itemToAppend) {
        if (array == null) {
            throw new IllegalArgumentException("null array");
        }
        T[] result = CollectionUtils.makeArray(array, array.length + 1);
        if (array.length != 0) {
            System.arraycopy(array, 0, result, 0, array.length);
        }
        result[array.length] = itemToAppend;
        return result;
    }

    public static <T, U extends T> T[] removeItem(T[] array, U itemToRemove) {
        if (array == null) {
            throw new IllegalArgumentException("null");
        }
        int index = CollectionUtils.findInArray(array, itemToRemove);
        return index == -1 ? array : CollectionUtils.removeItem(array, index);
    }

    public static <T> T[] removeItem(T[] array, int index) {
        if (array == null) {
            throw new IllegalArgumentException("null");
        }
        if (index < 0) {
            throw new IllegalArgumentException("negative index: " + index);
        }
        if (index >= array.length) {
            throw new IllegalArgumentException("index out of bounds (array length: " + array.length + ", index: " + index + ')');
        }
        T[] result = CollectionUtils.makeArray(array, array.length - 1);
        if (index != 0) {
            System.arraycopy(array, 0, result, 0, index);
        }
        if (index != array.length - 1) {
            System.arraycopy(array, index + 1, result, index, array.length - index - 1);
        }
        return result;
    }

    public static <T> T[] removeDuplicates(T[] array) {
        int i;
        if (array == null) {
            throw new IllegalArgumentException("null");
        }
        if (array.length < 2) {
            return array;
        }
        boolean nullItemFound = false;
        int mainTopBound = array.length - 1;
        for (i = 0; i < mainTopBound; ++i) {
            int j;
            T item = array[i];
            boolean isDuplicate = false;
            if (item == null) {
                nullItemFound = true;
                for (j = i + 1; j < array.length; ++j) {
                    if (array[j] != null) continue;
                    isDuplicate = true;
                    break;
                }
            } else {
                for (j = i + 1; j < array.length; ++j) {
                    if (!CollectionUtils.equal(item, array[j])) continue;
                    isDuplicate = true;
                    array[j] = null;
                }
            }
            if (isDuplicate) break;
        }
        if (i == mainTopBound) {
            return array;
        }
        Object[] proResult = (Object[])Array.newInstance(array.getClass().getComponentType(), array.length - 1);
        int count = i;
        if (count != 0) {
            System.arraycopy(array, 0, proResult, 0, count);
        }
        ++i;
        while (i < mainTopBound) {
            T item = array[i];
            if (item == null) {
                if (!nullItemFound) {
                    nullItemFound = true;
                    proResult[count++] = null;
                }
            } else {
                boolean isDuplicate = false;
                for (int j = i + 1; j < array.length; ++j) {
                    if (!CollectionUtils.equal(item, array[j])) continue;
                    isDuplicate = true;
                    array[j] = null;
                }
                if (!isDuplicate) {
                    proResult[count++] = array[i];
                }
            }
            ++i;
        }
        proResult[count++] = array[mainTopBound];
        return CollectionUtils.shortenArray(proResult, count);
    }

    public static <T> T[] removeNulls(T[] array) {
        if (array == null) {
            throw new IllegalArgumentException("null");
        }
        int i = 0;
        for (i = 0; i < array.length && array[i] != null; ++i) {
        }
        if (i == array.length) {
            return array;
        }
        Object[] proResult = (Object[])Array.newInstance(array.getClass().getComponentType(), array.length - 1);
        int count = i;
        if (count != 0) {
            System.arraycopy(array, 0, proResult, 0, count);
        }
        ++i;
        while (i < array.length) {
            if (array[i] != null) {
                proResult[count++] = array[i];
            }
            ++i;
        }
        return CollectionUtils.shortenArray(proResult, count);
    }

    public static <T> T[] stripTrailingNulls(T[] array) {
        int resultSize;
        if (array == null) {
            throw new IllegalArgumentException("null");
        }
        for (resultSize = array.length; resultSize > 0 && array[resultSize - 1] == null; --resultSize) {
        }
        return CollectionUtils.shortenArray(array, resultSize);
    }

    public static <T> T[] shortenArray(T[] array, int requestedLength) {
        if (array == null) {
            throw new IllegalArgumentException("null");
        }
        if (requestedLength < 0) {
            throw new IllegalArgumentException("negative requested length (" + requestedLength + ')');
        }
        if (requestedLength > array.length) {
            throw new IllegalArgumentException("requested length (" + requestedLength + ") is greater than the current length (" + array.length + ')');
        }
        if (requestedLength == array.length) {
            return array;
        }
        T[] result = CollectionUtils.makeArray(array, requestedLength);
        if (requestedLength != 0) {
            System.arraycopy(array, 0, result, 0, requestedLength);
        }
        return result;
    }

    public static <T> T[] copyArray(T[] source) {
        if (source == null) {
            throw new IllegalArgumentException("null");
        }
        T[] result = CollectionUtils.makeArray(source, source.length);
        System.arraycopy(source, 0, result, 0, source.length);
        return result;
    }

    public static <T> T[] makeArray(T[] typeTemplate, int length) {
        if (typeTemplate == null) {
            throw new IllegalArgumentException("null");
        }
        if (length < 0) {
            throw new IllegalArgumentException("negative length");
        }
        return (Object[])Array.newInstance(typeTemplate.getClass().getComponentType(), length);
    }

    public static boolean containSameObjects(Object[] a, Object[] b) {
        int lengthB;
        int lengthA = a != null ? a.length : 0;
        int n = lengthB = b != null ? b.length : 0;
        if (lengthA != lengthB) {
            return false;
        }
        int length = lengthA;
        if (length == 0) {
            return true;
        }
        if (length == 1) {
            return a[0] == b[0];
        }
        if (length == 2) {
            return a[0] == b[0] && a[1] == b[1] || a[0] == b[1] && a[1] == b[0];
        }
        return CollectionUtils.compareArrays(a, b, length, new IdentityHashMap<Object, Counter>(length));
    }

    public static boolean containEqualObjects(Object[] a, Object[] b) {
        int lengthB;
        int lengthA = a != null ? a.length : 0;
        int n = lengthB = b != null ? b.length : 0;
        if (lengthA != lengthB) {
            return false;
        }
        int length = lengthA;
        if (length == 0) {
            return true;
        }
        if (length == 1) {
            return CollectionUtils.equal(a[0], b[0]);
        }
        if (length == 2) {
            return CollectionUtils.equal(a[0], b[0]) && CollectionUtils.equal(a[1], b[1]) || CollectionUtils.equal(a[0], b[1]) && CollectionUtils.equal(a[1], b[0]);
        }
        return CollectionUtils.compareArrays(a, b, length, new HashMap<Object, Counter>((length * 4 + 2) / 3, 0.75f));
    }

    private static boolean compareArrays(Object[] a, Object[] b, int length, Map<Object, Counter> comparatorMap) {
        int i;
        Counter newCounter = new Counter();
        for (i = 0; i < length; ++i) {
            Counter previousCounter = comparatorMap.put(a[i], newCounter);
            newCounter = previousCounter != null ? previousCounter.passIncrementedValueTo(newCounter) : new Counter();
        }
        for (i = 0; i < length; ++i) {
            Counter counter = comparatorMap.get(b[i]);
            if (counter == null) {
                return false;
            }
            if (!counter.dec().isNegative()) continue;
            return false;
        }
        return true;
    }

    public static <A, B> A[] retainAll(A[] a, B[] b) {
        if (a.length == 0) {
            return a;
        }
        if (b.length == 0) {
            return CollectionUtils.makeArray(a, 0);
        }
        HashSet<A> setA = new HashSet<A>(Arrays.asList(a));
        HashSet<B> setB = new HashSet<B>(Arrays.asList(b));
        setA.retainAll(setB);
        return setA.isEmpty() ? CollectionUtils.makeArray(a, 0) : setA.toArray(CollectionUtils.makeArray(a, setA.size()));
    }

    public static <A, B> A[] retainAllByIdentity(A[] a, B[] b) {
        if (a.length == 0) {
            return a;
        }
        if (b.length == 0) {
            return CollectionUtils.makeArray(a, 0);
        }
        IdentityHashSet<A> setA = new IdentityHashSet<A>(a);
        IdentityHashSet<B> setB = new IdentityHashSet<B>(b);
        setA.retainAll(setB);
        return setA.isEmpty() ? CollectionUtils.makeArray(a, 0) : setA.toArray(CollectionUtils.makeArray(a, setA.size()));
    }

    static boolean equal(Object a, Object b) {
        return a == null ? b == null : a.equals(b);
    }

    public static <T> List<T> unmodifiableList(T ... items) {
        if (items == null) {
            throw new IllegalArgumentException("null");
        }
        if (items.length == 0) {
            return Collections.emptyList();
        }
        if (items.length == 1) {
            return Collections.singletonList(items[0]);
        }
        ArrayList<T> result = new ArrayList<T>(items.length);
        for (int i = 0; i < items.length; ++i) {
            result.add(items[i]);
        }
        return Collections.unmodifiableList(result);
    }

    public static <T> Set<T> unmodifiableSet(T ... items) {
        if (items == null) {
            throw new IllegalArgumentException("null");
        }
        if ((items = CollectionUtils.removeDuplicates(items)).length == 0) {
            return Collections.emptySet();
        }
        if (items.length == 1) {
            return Collections.singleton(items[0]);
        }
        return new UnmodifiableArraySet<T>(items);
    }

    static class ArrayListIterator<T>
    implements ListIterator<T> {
        private final T[] array;
        private int index = 0;

        public ArrayListIterator(T[] array) {
            if (array == null) {
                throw new IllegalArgumentException("null");
            }
            this.array = array;
        }

        @Override
        public boolean hasNext() {
            return this.index < this.array.length;
        }

        @Override
        public T next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            return this.array[this.index++];
        }

        @Override
        public boolean hasPrevious() {
            return this.index > 0;
        }

        @Override
        public T previous() {
            if (!this.hasPrevious()) {
                throw new NoSuchElementException();
            }
            return this.array[--this.index];
        }

        @Override
        public int nextIndex() {
            return this.index;
        }

        @Override
        public int previousIndex() {
            return this.index - 1;
        }

        @Override
        public void add(T o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void set(T o) {
            throw new UnsupportedOperationException();
        }
    }

    static class UnmodifiableArraySet<E>
    extends AbstractSet<E> {
        private final E[] content;

        public UnmodifiableArraySet(E[] items) {
            if (items == null) {
                throw new IllegalArgumentException("null");
            }
            this.content = items;
        }

        @Override
        public boolean contains(Object o) {
            if (this.isEmpty()) {
                return false;
            }
            for (E element : this.content) {
                if (!CollectionUtils.equal(element, o)) continue;
                return true;
            }
            return false;
        }

        @Override
        public boolean containsAll(Collection<?> c) {
            AbstractSet m;
            if (c.isEmpty()) {
                return true;
            }
            if (this.isEmpty()) {
                return false;
            }
            if (c instanceof UnmodifiableArraySet && ((UnmodifiableArraySet)(m = (UnmodifiableArraySet)c)).size() > this.size()) {
                return false;
            }
            if (c.getClass() == HashSet.class && ((HashSet)(m = (HashSet)c)).size() > this.size()) {
                return false;
            }
            return super.containsAll(c);
        }

        @Override
        public Iterator<E> iterator() {
            return this.content.length == 0 ? Collections.emptySet().iterator() : new ArrayListIterator<E>(this.content);
        }

        @Override
        public int size() {
            return this.content.length;
        }

        @Override
        public <T> T[] toArray(T[] a) {
            if (a == null) {
                throw new NullPointerException();
            }
            if (a.length < this.content.length) {
                a = CollectionUtils.makeArray(a, this.content.length);
            }
            System.arraycopy(this.content, 0, a, 0, this.content.length);
            if (a.length > this.content.length) {
                a[this.content.length] = null;
            }
            return a;
        }

        @Override
        public Object[] toArray() {
            Object[] result = new Object[this.content.length];
            if (result.length != 0) {
                System.arraycopy(this.content, 0, result, 0, this.content.length);
            }
            return result;
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean remove(Object o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            throw new UnsupportedOperationException();
        }
    }

    static final class IdentityComparator
    implements Comparator {
        IdentityComparator() {
        }

        public int compare(Object o1, Object o2) {
            if (o1 == null) {
                return o2 == null ? 0 : 1;
            }
            return o2 != null ? System.identityHashCode(o2) - System.identityHashCode(o1) : -1;
        }
    }

    static class Counter {
        private int number;

        Counter() {
            this.reset();
        }

        Counter reset() {
            this.number = 1;
            return this;
        }

        Counter passIncrementedValueTo(Counter counter) {
            counter.number = this.number + 1;
            this.reset();
            return this;
        }

        Counter dec() {
            --this.number;
            return this;
        }

        boolean isNegative() {
            return this.number < 0;
        }
    }
}

