/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.apisupport;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.netbeans.api.project.Project;
import org.netbeans.modules.maven.api.NbMavenProject;
import org.netbeans.modules.maven.apisupport.AccessQueryImpl;
import org.netbeans.modules.maven.apisupport.ApisupportRecoPrivTemplates;
import org.netbeans.modules.maven.apisupport.ExecutionChecker;
import org.netbeans.modules.maven.apisupport.MavenNbModuleImpl;
import org.netbeans.spi.project.LookupProvider;
import org.openide.util.Lookup;
import org.openide.util.lookup.AbstractLookup;
import org.openide.util.lookup.InstanceContent;

public class MavenApisupportLookupProvider
implements LookupProvider {
    public Lookup createAdditionalLookup(Lookup lookup) {
        Project project = (Project)lookup.lookup(Project.class);
        assert (project != null);
        InstanceContent instanceContent = new InstanceContent();
        instanceContent.add((Object)new ApisupportRecoPrivTemplates(project));
        instanceContent.add((Object)new ExecutionChecker(project));
        return new Provider(project, instanceContent);
    }

    private static class Provider
    extends AbstractLookup
    implements PropertyChangeListener {
        private Project project;
        private InstanceContent content;
        private String lastType = "jar";
        private MavenNbModuleImpl lastInstance = null;
        private AccessQueryImpl lastAccess = null;

        public Provider(Project project, InstanceContent instanceContent) {
            super((AbstractLookup.Content)instanceContent);
            this.project = project;
            this.content = instanceContent;
            this.checkNbm();
            NbMavenProject.addPropertyChangeListener((Project)this.project, (PropertyChangeListener)this);
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if ("MavenProject".equals(propertyChangeEvent.getPropertyName())) {
                this.checkNbm();
            }
        }

        private void checkNbm() {
            NbMavenProject nbMavenProject = (NbMavenProject)this.project.getLookup().lookup(NbMavenProject.class);
            String string = nbMavenProject.getPackagingType();
            if (string == null) {
                string = "jar";
            }
            if ("nbm".equals(string) && !this.lastType.equals(string)) {
                if (this.lastInstance == null) {
                    this.lastInstance = new MavenNbModuleImpl(this.project);
                }
                this.content.add((Object)this.lastInstance);
                if (this.lastAccess == null) {
                    this.lastAccess = new AccessQueryImpl(this.project);
                }
                this.content.add((Object)this.lastAccess);
            } else if (this.lastInstance != null && !"nbm".equals(string)) {
                this.content.remove((Object)this.lastInstance);
                this.content.remove((Object)this.lastAccess);
            }
            this.lastType = string;
        }
    }
}

