/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.source.ui;

import java.awt.Toolkit;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeElement;
import javax.swing.Icon;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.SourceUtils;
import org.netbeans.api.java.source.ui.ElementOpen;
import org.netbeans.modules.java.source.ui.JavaTypeProvider;
import org.netbeans.modules.java.ui.Icons;
import org.netbeans.spi.jumpto.type.TypeDescriptor;
import org.openide.awt.StatusDisplayer;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

public class JavaTypeDescription
extends TypeDescriptor {
    private static final String EMPTY_STRING = "";
    private Icon icon;
    private final JavaTypeProvider.CacheItem cacheItem;
    private final ElementHandle<TypeElement> handle;
    private String simpleName;
    private String outerName;
    private String packageName;

    public JavaTypeDescription(JavaTypeProvider.CacheItem cacheItem, ElementHandle<TypeElement> elementHandle) {
        this.cacheItem = cacheItem;
        this.handle = elementHandle;
        this.init();
    }

    public void open() {
        FileObject fileObject = this.cacheItem.getRoot();
        if (fileObject == null) {
            String string = NbBundle.getMessage(JavaTypeDescription.class, (String)"LBL_JavaTypeDescription_nosource", (Object)this.handle.getQualifiedName());
            StatusDisplayer.getDefault().setStatusText(string);
            Toolkit.getDefaultToolkit().beep();
            return;
        }
        ClasspathInfo classpathInfo = ClasspathInfo.create((FileObject)fileObject);
        if (this.cacheItem.isBinary()) {
            ElementHandle<TypeElement> elementHandle = this.handle;
            if (!ElementOpen.open(classpathInfo, elementHandle)) {
                String string = NbBundle.getMessage(JavaTypeDescription.class, (String)"LBL_JavaTypeDescription_nosource", (Object)elementHandle.getQualifiedName());
                StatusDisplayer.getDefault().setStatusText(string);
                Toolkit.getDefaultToolkit().beep();
            }
        } else {
            FileObject fileObject2 = SourceUtils.getFile(this.handle, (ClasspathInfo)classpathInfo);
            boolean bl = false;
            if (fileObject2 != null) {
                bl = ElementOpen.open(fileObject2, this.handle);
            }
            if (!bl) {
                StringBuilder stringBuilder = new StringBuilder();
                if (this.packageName != null) {
                    stringBuilder.append(this.packageName);
                    stringBuilder.append('.');
                }
                if (this.outerName != null) {
                    stringBuilder.append(this.outerName);
                } else {
                    stringBuilder.append(this.simpleName);
                }
                String string = NbBundle.getMessage(JavaTypeDescription.class, (String)"LBL_JavaTypeDescription_nosource", (Object)stringBuilder.toString());
                StatusDisplayer.getDefault().setStatusText(string);
                Toolkit.getDefaultToolkit().beep();
            }
        }
    }

    public String getSimpleName() {
        return this.simpleName;
    }

    public String getOuterName() {
        return this.outerName;
    }

    public FileObject getFileObject() {
        return this.cacheItem.getRoot();
    }

    public String getTypeName() {
        StringBuilder stringBuilder = new StringBuilder(this.simpleName);
        if (this.outerName != null) {
            stringBuilder.append(" in ").append(this.outerName);
        }
        return stringBuilder.toString();
    }

    public String getContextName() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(" (").append(this.packageName == null ? "Default Package" : this.packageName).append(")");
        return stringBuilder.toString();
    }

    public String getProjectName() {
        String string = this.cacheItem.getProjectName();
        return string == null ? EMPTY_STRING : string;
    }

    public Icon getProjectIcon() {
        return this.cacheItem.getProjectIcon();
    }

    public ElementHandle<TypeElement> getHandle() {
        return this.handle;
    }

    private void init() {
        String string = this.handle.getBinaryName();
        int n = string.lastIndexOf(46);
        int n2 = string.lastIndexOf(36);
        if (n == -1) {
            if (n2 == -1) {
                this.simpleName = string;
            } else {
                this.simpleName = string.substring(n2 + 1);
                this.outerName = string.substring(0, n2).replace('$', '.');
            }
        } else {
            this.packageName = string.substring(0, n);
            if (n2 == -1) {
                this.simpleName = string.substring(n + 1).replace('$', '.');
            } else {
                this.simpleName = string.substring(n2 + 1);
                this.outerName = string.substring(n + 1, n2).replace('$', '.');
            }
        }
        this.icon = Icons.getElementIcon((ElementKind)this.handle.getKind(), null);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(this.simpleName);
        if (this.outerName != null) {
            stringBuilder.append(" in ").append(this.outerName);
        }
        stringBuilder.append(" (").append(this.packageName == null ? "Default Package" : this.packageName).append(")");
        if (this.cacheItem.getProjectName() != null) {
            stringBuilder.append(" [").append(this.cacheItem.getProjectName()).append("]");
        }
        return stringBuilder.toString();
    }

    public synchronized Icon getIcon() {
        return this.icon;
    }

    public int getOffset() {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

