/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sanselan.formats.pnm;

import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;
import org.apache.sanselan.ImageWriteException;
import org.apache.sanselan.formats.pnm.PNMConstants;
import org.apache.sanselan.formats.pnm.PNMWriter;

public class PGMWriter
extends PNMWriter
implements PNMConstants {
    public PGMWriter(boolean RAWBITS) {
        super(RAWBITS);
    }

    @Override
    public void writeImage(BufferedImage src, OutputStream os, Map params) throws ImageWriteException, IOException {
        os.write(80);
        os.write(this.RAWBITS ? 53 : 50);
        os.write(32);
        int width = src.getWidth();
        int height = src.getHeight();
        os.write(("" + width).getBytes());
        os.write(32);
        os.write(("" + height).getBytes());
        os.write(32);
        os.write("255".getBytes());
        os.write(10);
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                int argb = src.getRGB(x, y);
                int red = 0xFF & argb >> 16;
                int green = 0xFF & argb >> 8;
                int blue = 0xFF & argb >> 0;
                int sample = (red + green + blue) / 3;
                if (this.RAWBITS) {
                    os.write((byte)sample);
                    continue;
                }
                os.write(("" + sample).getBytes());
                os.write(32);
            }
        }
    }
}

