/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.diagnostics.error;

import com.android.tools.idea.diagnostics.error.Feedback;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class FeedbackSerializer {
    private static final String UNKNOWN_PROTO_VALUE = "unknown";

    private static Feedback.CommonData getCommonData(Map<String, String> map, String string, String string2, String string3) {
        return Feedback.CommonData.newBuilder().setDescription(FeedbackSerializer.isNotEmpty(string) ? string : string2).setProductVersion(string3).addAllProductSpecificData(FeedbackSerializer.getProductSpecificData(map)).build();
    }

    static byte[] serializeToMobileReport(String string, String string2, Throwable throwable, Map<String, String> map, String string3, String string4, String string5) {
        Feedback.CommonData commonData = FeedbackSerializer.getCommonData(map, string3, string4, string5);
        Feedback.SystemData systemData = Feedback.SystemData.newBuilder().setTimestamp(System.currentTimeMillis()).build();
        Feedback.PackageData packageData = Feedback.PackageData.newBuilder().setPackageName(string2).setInstallerPackageName(string).setProcessName(string).build();
        Feedback.BuildData buildData = Feedback.BuildData.newBuilder().setDevice(UNKNOWN_PROTO_VALUE).setBuildId(string5).setRelease(string5).setBuildType(UNKNOWN_PROTO_VALUE).setModel(UNKNOWN_PROTO_VALUE).setProduct(string).build();
        StackTraceElement[] stackTraceElementArray = throwable != null ? throwable.getStackTrace() : null;
        StackTraceElement stackTraceElement = null;
        if (stackTraceElementArray != null && stackTraceElementArray.length > 0) {
            stackTraceElement = stackTraceElementArray[0];
        }
        Feedback.CrashData crashData = Feedback.CrashData.newBuilder().setExceptionClassName(throwable != null ? throwable.toString() : UNKNOWN_PROTO_VALUE).setExceptionMessage(map.get("error.message")).setThrowFileName(stackTraceElement != null ? stackTraceElement.getFileName() : UNKNOWN_PROTO_VALUE).setThrowLineNumber(stackTraceElement != null ? stackTraceElement.getLineNumber() : 0).setThrowClassName(stackTraceElement != null ? stackTraceElement.getClassName() : UNKNOWN_PROTO_VALUE).setThrowMethodName(stackTraceElement != null ? stackTraceElement.getMethodName() : UNKNOWN_PROTO_VALUE).setStackTrace(map.get("error.stacktrace")).build();
        Feedback.MobileData mobileData = Feedback.MobileData.newBuilder().setSystemData(systemData).setPackageData(packageData).setBuildData(buildData).setCrashData(crashData).setReportType(1).build();
        return Feedback.MobileBugReport.newBuilder().setCommonData(commonData).setMobileData(mobileData).build().toByteArray();
    }

    private static List<Feedback.ProductSpecificData> getProductSpecificData(Map<String, String> map) {
        ArrayList<Feedback.ProductSpecificData> arrayList = new ArrayList<Feedback.ProductSpecificData>(map.size());
        for (Map.Entry<String, String> entry : map.entrySet()) {
            arrayList.add(FeedbackSerializer.psd(entry.getKey(), entry.getValue()));
        }
        return arrayList;
    }

    private static Feedback.ProductSpecificData psd(String string, String string2) {
        return Feedback.ProductSpecificData.newBuilder().setKey(string).setValue(string2 == null ? "" : string2).build();
    }

    private static boolean isNotEmpty(String string) {
        return string != null && !string.isEmpty();
    }
}

